/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.controls.drag_drop;

import com.spss.java_client.ui.dialogs.common.IVarMoveHandler;
import com.spss.uitools.controls.drag_drop.DragDropAdapter;
import com.spss.uitools.controls.drag_drop.DragPane;
import com.spss.uitools.controls.drag_drop.DropEvent;
import com.spss.uitools.controls.drag_drop.IDropListener;
import java.awt.Cursor;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.Scrollable;
import javax.swing.SwingUtilities;
import javax.swing.Timer;

public abstract class AbstractDropListener
implements IDropListener,
ActionListener {
    private static final int AUTOSCROLL_INSET = 10;
    protected JComponent mDropTarget = null;
    protected Timer mTimer = null;
    protected Point mLastPosition = null;
    private Rectangle mOuterRect = new Rectangle();
    private Rectangle mInnerRect = new Rectangle();
    private int mHysteresis = 10;
    protected boolean mCanImport = false;
    protected IVarMoveHandler mVarMoveHandler;
    protected boolean mSwapFlag = false;

    public AbstractDropListener(JComponent jComponent) {
        this.mDropTarget = jComponent;
    }

    public AbstractDropListener(JComponent jComponent, IVarMoveHandler iVarMoveHandler) {
        this.mDropTarget = jComponent;
        this.mVarMoveHandler = iVarMoveHandler;
    }

    public JComponent getTarget() {
        return this.mDropTarget;
    }

    public Cursor dragItemOver(Point point, DragDropAdapter dragDropAdapter) {
        Cursor cursor = null;
        Point point2 = (Point)point.clone();
        SwingUtilities.convertPointFromScreen(point2, this.mDropTarget);
        boolean bl = false;
        if (this.contains(point) || this.mDropTarget instanceof JTable && ((JTable)this.mDropTarget).getRowCount() == 0) {
            this.mCanImport = this.canDrop(dragDropAdapter);
            if (this.mCanImport) {
                bl = true;
                this.showDropFeedback(point2);
                cursor = Cursor.getPredefinedCursor(12);
            } else {
                this.showDropFeedback(null);
                cursor = DragPane.getNoDropCursor();
            }
        } else {
            this.showDropFeedback(null);
        }
        this.setHighlightBorder(bl);
        if (this.mCanImport) {
            this.checkAutoScroll(point2);
        }
        return cursor;
    }

    public boolean contains(Point point) {
        Point point2 = (Point)point.clone();
        SwingUtilities.convertPointFromScreen(point2, this.mDropTarget);
        return this.mDropTarget.getVisibleRect().contains(point2);
    }

    @Override
    public synchronized void actionPerformed(ActionEvent actionEvent) {
        this.updateAutoscrollRegion(this.mDropTarget);
        Rectangle rectangle = (Rectangle)this.mInnerRect.clone();
        rectangle.grow(-this.mHysteresis, -this.mHysteresis);
        if (this.mLastPosition != null && this.pointWithin(this.mLastPosition, this.mOuterRect) && !this.pointWithin(this.mLastPosition, rectangle)) {
            this.autoscroll(this.mDropTarget, this.mLastPosition);
        }
    }

    public abstract boolean canDrop(DragDropAdapter var1);

    protected abstract void showDropFeedback(Point var1);

    protected abstract void setHighlightBorder(boolean var1);

    public abstract void itemDropped(DropEvent var1);

    protected abstract void importData(Object var1, JComponent var2, int var3);

    protected abstract void finish(JComponent var1, int var2, int[] var3, int var4);

    private boolean pointWithin(Point point, Rectangle rectangle) {
        return point.x > rectangle.x && point.y > rectangle.y && point.x < rectangle.width && point.y < rectangle.height;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkAutoScroll(Point point) {
        if (!this.mDropTarget.getAutoscrolls()) {
            return;
        }
        if (this.mLastPosition == null) {
            if (this.mDropTarget.contains(point)) {
                this.mLastPosition = point.getLocation();
                this.updateAutoscrollRegion(this.mDropTarget);
                this.initPropertiesIfNecessary();
            }
        } else {
            AbstractDropListener abstractDropListener = this;
            synchronized (abstractDropListener) {
                if (Math.abs(point.x - this.mLastPosition.x) > this.mHysteresis || Math.abs(point.y - this.mLastPosition.y) > this.mHysteresis) {
                    if (this.mTimer.isRunning()) {
                        this.mTimer.stop();
                    }
                    this.mLastPosition = null;
                } else {
                    if (!this.mTimer.isRunning()) {
                        this.mTimer.start();
                    }
                    this.mLastPosition = point;
                }
            }
        }
    }

    void updateAutoscrollRegion(JComponent jComponent) {
        int n;
        Rectangle rectangle = jComponent.getVisibleRect();
        this.mInnerRect.setBounds(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        Insets insets = new Insets(0, 0, 0, 0);
        if (jComponent instanceof Scrollable) {
            n = 20;
            if (rectangle.width >= n) {
                insets.right = 10;
                insets.left = 10;
            }
            if (rectangle.height >= n) {
                insets.bottom = 10;
                insets.top = 10;
            }
        }
        n = rectangle.x;
        int n2 = rectangle.y;
        this.mOuterRect.setBounds(rectangle.x - insets.left, rectangle.y - insets.top, n + rectangle.width + insets.right, n2 + rectangle.height + insets.bottom);
    }

    void autoscroll(JComponent jComponent, Point point) {
        if (jComponent instanceof Scrollable) {
            int n;
            Rectangle rectangle;
            Scrollable scrollable = (Scrollable)((Object)jComponent);
            if (point.y < this.mInnerRect.y + this.mHysteresis) {
                rectangle = this.mDropTarget.getVisibleRect();
                n = scrollable.getScrollableUnitIncrement(rectangle, 1, -1);
                Rectangle rectangle2 = new Rectangle(rectangle.x, rectangle.y - n, rectangle.width, n);
                jComponent.scrollRectToVisible(rectangle2);
                this.mLastPosition.y -= n;
            } else if (point.y > this.mInnerRect.y + this.mInnerRect.height - this.mHysteresis) {
                rectangle = this.mDropTarget.getVisibleRect();
                n = scrollable.getScrollableUnitIncrement(rectangle, 1, 1);
                Rectangle rectangle3 = new Rectangle(rectangle.x, rectangle.y + rectangle.height, rectangle.width, n);
                jComponent.scrollRectToVisible(rectangle3);
                this.mLastPosition.y += n;
            }
            if (point.x < this.mInnerRect.x) {
                int n2 = scrollable.getScrollableUnitIncrement(this.mInnerRect, 0, -1);
                Rectangle rectangle4 = new Rectangle(this.mInnerRect.x - n2, this.mInnerRect.y, n2, this.mInnerRect.height);
                jComponent.scrollRectToVisible(rectangle4);
                this.mLastPosition.x -= n2;
            } else if (point.x > this.mInnerRect.x + this.mInnerRect.width) {
                int n3 = scrollable.getScrollableUnitIncrement(this.mInnerRect, 0, 1);
                Rectangle rectangle5 = new Rectangle(this.mInnerRect.x + this.mInnerRect.width, this.mInnerRect.y, n3, this.mInnerRect.height);
                jComponent.scrollRectToVisible(rectangle5);
                this.mLastPosition.x += n3;
            }
        }
    }

    private void initPropertiesIfNecessary() {
        if (this.mTimer == null) {
            Integer n = 100;
            Integer n2 = 100;
            this.mTimer = new Timer(n2, this);
            this.mTimer.setCoalesce(true);
            this.mTimer.setInitialDelay(n);
        }
    }
}

