/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.controls.double_slider;

import com.spss.java_client.ui.controls.double_slider.BoxDecoration;
import com.spss.vis.util.SubAttributedCharacterIterator;
import java.awt.Font;
import java.awt.font.FontRenderContext;
import java.awt.font.TextAttribute;
import java.awt.font.TextLayout;
import java.awt.geom.Rectangle2D;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.WeakHashMap;

public class TextContext
implements Cloneable {
    private final Locale locale;
    private FontRenderContext fontRenderContext;
    private BoxDecoration decoration;
    private Font font;
    private String ellipsis;
    private boolean measureWhitespace = false;
    private Rectangle2D maxCharBounds;
    private Map<Font, Rectangle2D> knownSizes = new HashMap<Font, Rectangle2D>();
    private static final Map<ACIKey, Float> known = new WeakHashMap<ACIKey, Float>();

    public TextContext(Font font, Locale locale, FontRenderContext fontRenderContext) {
        this(font, locale, new BoxDecoration(), fontRenderContext);
    }

    public TextContext(Font font, Locale locale, BoxDecoration boxDecoration, FontRenderContext fontRenderContext) {
        this.decoration = boxDecoration;
        this.locale = locale == null ? Locale.getDefault() : locale;
        this.fontRenderContext = fontRenderContext;
        assert (font != null);
        this.setFont(font);
    }

    public void setFontRenderContext(FontRenderContext fontRenderContext) {
        if (fontRenderContext != null) {
            this.fontRenderContext = fontRenderContext;
        }
    }

    public final synchronized void setFont(Font font) {
        this.font = font;
        this.maxCharBounds = null;
        this.ellipsis = font.canDisplay('\u2026') ? "\u2026" : "...";
    }

    public BoxDecoration getDecoration() {
        return this.decoration;
    }

    public String getEllipsis() {
        return this.ellipsis;
    }

    public synchronized Font getFont() {
        return this.font;
    }

    public FontRenderContext getFontRenderContext() {
        return this.fontRenderContext;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void setMeasureWhitespace(boolean bl) {
        this.measureWhitespace = bl;
    }

    public boolean getMeasureWhitespace() {
        return this.measureWhitespace;
    }

    public synchronized Rectangle2D getMaxCharBounds() {
        if (this.maxCharBounds == null) {
            this.maxCharBounds = this.font.getMaxCharBounds(this.fontRenderContext);
            this.knownSizes.put(this.font, this.maxCharBounds);
        }
        return this.maxCharBounds;
    }

    public synchronized AttributedCharacterIterator getAttributeIterator(String string, Font font) {
        AttributedString attributedString = new AttributedString(string);
        attributedString.addAttribute(TextAttribute.FONT, font);
        return attributedString.getIterator();
    }

    public synchronized Rectangle2D getMaxCharBounds(AttributedCharacterIterator attributedCharacterIterator) {
        Rectangle2D rectangle2D = null;
        Font font = this.font;
        attributedCharacterIterator.first();
        boolean bl = false;
        while (attributedCharacterIterator.getIndex() < attributedCharacterIterator.getEndIndex()) {
            Font font2 = font.deriveFont(attributedCharacterIterator.getAttributes());
            Rectangle2D rectangle2D2 = this.knownSizes.get(font2);
            if (rectangle2D2 == null) {
                rectangle2D2 = font2.getMaxCharBounds(this.fontRenderContext);
                this.knownSizes.put(font2, rectangle2D2);
            }
            rectangle2D = rectangle2D != null ? rectangle2D.createUnion(rectangle2D2) : rectangle2D2;
            char c = attributedCharacterIterator.setIndex(attributedCharacterIterator.getRunLimit());
            if (c != '\uffff') continue;
            break;
        }
        if (rectangle2D == null) {
            return this.getMaxCharBounds();
        }
        return rectangle2D;
    }

    public synchronized float measureWidth(String string) {
        return new TextLayout(string, this.font, this.fontRenderContext).getAdvance();
    }

    public float measureWidth(AttributedCharacterIterator attributedCharacterIterator) {
        return this.measureWidth(attributedCharacterIterator, attributedCharacterIterator.getBeginIndex(), attributedCharacterIterator.getEndIndex());
    }

    public synchronized float measureWidth(AttributedCharacterIterator attributedCharacterIterator, int n, int n2) {
        int n3;
        int n4 = n;
        if (!this.measureWhitespace) {
            for (n3 = n2; n3 > n4 && Character.isWhitespace(attributedCharacterIterator.setIndex(n3 - 1)); --n3) {
            }
        }
        if (n3 == n4) {
            return 0.0f;
        }
        float f = 0.0f;
        while (n4 < n3) {
            attributedCharacterIterator.setIndex(n4);
            int n5 = Math.min(n3, attributedCharacterIterator.getRunLimit(TextAttribute.SUPERSCRIPT));
            if (n5 == 0) break;
            double d = this.fastMeasureWidth(attributedCharacterIterator, n4, n5);
            f = (float)((double)f + d);
            n4 = n5;
        }
        return f;
    }

    private float fastMeasureWidth(AttributedCharacterIterator attributedCharacterIterator, int n, int n2) {
        if (n == n2) {
            return 0.0f;
        }
        ACIKey aCIKey = new ACIKey(attributedCharacterIterator, n, n2, this.font);
        Float f = known.get(aCIKey);
        if (f != null) {
            return f.floatValue();
        }
        if (n != attributedCharacterIterator.getBeginIndex() || n2 != attributedCharacterIterator.getEndIndex()) {
            attributedCharacterIterator = new SubAttributedCharacterIterator(attributedCharacterIterator, n, n2);
        }
        float f2 = new TextLayout(attributedCharacterIterator, this.fontRenderContext).getAdvance();
        known.put(aCIKey, Float.valueOf(f2));
        return f2;
    }

    public void setDecoration(BoxDecoration boxDecoration) {
        this.decoration = boxDecoration == null ? new BoxDecoration() : boxDecoration;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    private static final class ACIKey {
        private final char[] chars;
        private final Font font;

        public ACIKey(AttributedCharacterIterator attributedCharacterIterator, int n, int n2, Font font) {
            attributedCharacterIterator.setIndex(n);
            this.font = attributedCharacterIterator.getAttribute(TextAttribute.FONT) == null ? font : (Font)attributedCharacterIterator.getAttribute(TextAttribute.FONT);
            this.chars = new char[n2 - n];
            if (n2 - n > 0) {
                int n3 = 0;
                this.chars[n3++] = attributedCharacterIterator.current();
                while (n3 < this.chars.length) {
                    this.chars[n3++] = attributedCharacterIterator.next();
                }
            }
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            ACIKey aCIKey = (ACIKey)object;
            if (!Arrays.equals(this.chars, aCIKey.chars)) {
                return false;
            }
            return this.font.equals(aCIKey.font);
        }

        public int hashCode() {
            int n = Arrays.hashCode(this.chars);
            n = 31 * n + this.font.hashCode();
            return n;
        }
    }
}

