/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.controls.double_slider;

import com.spss.java_client.ui.controls.double_slider.BoxDecoration;
import com.spss.java_client.ui.controls.double_slider.TextContext;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.font.TextAttribute;
import java.awt.geom.AffineTransform;
import java.awt.geom.Dimension2D;
import java.awt.geom.Line2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.text.AttributedCharacterIterator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class PositionedText {
    private final AttributedCharacterIterator text;
    private TextContext context;
    private final Shape[] boundaries;
    private TextRun[] runs;
    private int visibleCharacters;
    private Shape shape;

    private PositionedText(AttributedCharacterIterator attributedCharacterIterator, TextContext textContext) {
        assert (attributedCharacterIterator.first() == '\uffff' || attributedCharacterIterator.getAttribute(TextAttribute.FONT) != null) : "Iter passed to PositionedText did not have a defined font ";
        this.text = attributedCharacterIterator;
        this.context = textContext;
        this.boundaries = new Shape[3];
    }

    public TextContext getContext() {
        return this.context;
    }

    public int getVisibleCharacterCount() {
        return this.visibleCharacters;
    }

    public Shape getShape() {
        return this.shape;
    }

    public void draw(Graphics2D graphics2D, Paint paint) {
        BoxDecoration boxDecoration = this.context.getDecoration();
        if (boxDecoration != null) {
            this.drawDecoration(graphics2D, boxDecoration);
        }
        this.drawText(graphics2D, paint);
    }

    private void drawDecoration(Graphics2D graphics2D, BoxDecoration boxDecoration) {
        Shape shape = this.getBoundary(BoundaryOption.LOGICAL.ordinal());
        if (shape == null) {
            return;
        }
        graphics2D.setPaint(boxDecoration.getFillPaint());
        graphics2D.fill(shape);
        graphics2D.setPaint(boxDecoration.getBorderColor());
        graphics2D.setStroke(boxDecoration.getBorderStroke());
        graphics2D.draw(shape);
        graphics2D.setStroke(new BasicStroke());
    }

    private void drawText(Graphics2D graphics2D, Paint paint) {
        graphics2D.setPaint(paint);
        graphics2D.setFont(this.context.getFont());
        for (TextRun textRun : this.runs) {
            if (textRun.iter.getAllAttributeKeys().contains(TextAttribute.FOREGROUND)) {
                textRun.iter.first();
                graphics2D.setPaint((Color)textRun.iter.getAttribute(TextAttribute.FOREGROUND));
            } else {
                graphics2D.setPaint(paint);
            }
            graphics2D.drawString(textRun.iter, textRun.x, textRun.y);
            graphics2D.setPaint(paint);
        }
    }

    public void centerAt(Point2D point2D) {
        Rectangle2D rectangle2D = this.getBoundary(BoundaryOption.LOGICAL.ordinal()).getBounds2D();
        AffineTransform affineTransform = AffineTransform.getRotateInstance(0.0);
        Point2D point2D2 = affineTransform.transform(new Point2D.Double(rectangle2D.getCenterX(), rectangle2D.getCenterY()), null);
        Point2D point2D3 = affineTransform.transform(point2D, null);
        double d = point2D3.getX() - point2D2.getX();
        double d2 = point2D3.getY() - point2D2.getY();
        for (TextRun textRun : this.runs) {
            textRun.setLocation((double)textRun.getX() + d, (double)textRun.getY() + d2);
        }
        this.boundaries[BoundaryOption.UNTRANSFORMED.ordinal()] = null;
        this.boundaries[BoundaryOption.LOGICAL.ordinal()] = null;
        this.boundaries[BoundaryOption.LOGICAL_WITH_MARGINS.ordinal()] = null;
    }

    public Shape getBoundary(int n) {
        if (this.boundaries[BoundaryOption.UNTRANSFORMED.ordinal()] == null) {
            this.boundaries[BoundaryOption.UNTRANSFORMED.ordinal()] = this.makeUntransformedBoundary(0, Integer.MAX_VALUE, true);
        }
        if (this.boundaries[n] == null) {
            Rectangle2D rectangle2D = (Rectangle2D)this.boundaries[BoundaryOption.UNTRANSFORMED.ordinal()];
            BoxDecoration boxDecoration = this.context.getDecoration();
            if (n == BoundaryOption.LOGICAL.ordinal()) {
                rectangle2D = boxDecoration.expandToBorder(rectangle2D);
            } else if (n == BoundaryOption.LOGICAL_WITH_MARGINS.ordinal()) {
                rectangle2D = boxDecoration.expandToMargin(rectangle2D);
            }
            this.boundaries[n] = rectangle2D;
        }
        return this.boundaries[n];
    }

    private TextContext getContextWithFontUsed() {
        if (this.text == null) {
            return this.context;
        }
        this.text.setIndex(0);
        Font font = PositionedText.getMaximumFont(this.text);
        if (font == null) {
            return this.context;
        }
        TextContext textContext = (TextContext)this.context.clone();
        textContext.setFont(font);
        return textContext;
    }

    public Rectangle2D makeUntransformedBoundary(int n, int n2, boolean bl) {
        double d = Double.POSITIVE_INFINITY;
        double d2 = Double.NEGATIVE_INFINITY;
        TextContext textContext = this.getContextWithFontUsed();
        Rectangle2D rectangle2D = textContext.getMaxCharBounds(this.text);
        int n3 = 0;
        int n4 = -1;
        int n5 = -1;
        for (int i = 0; i < this.runs.length; ++i) {
            int n6;
            TextRun textRun = this.runs[i];
            int n7 = textRun.length();
            int n8 = n6 = bl ? 0 : 1;
            if (n <= n3 + n7 - n6 && n2 >= n3 + n6) {
                if (n4 < 0) {
                    n4 = i;
                }
                n5 = i;
                d = Math.min(d, (double)textRun.getX());
                d2 = Math.max(d2, (double)(textRun.getX() + this.context.measureWidth(textRun.getIterator())));
            }
            n3 += n7;
        }
        double d3 = this.runs[n4].getY();
        double d4 = this.runs[n5].getY();
        double d5 = Math.min(d3, d4) + rectangle2D.getY();
        double d6 = Math.max(d3, d4) + rectangle2D.getMaxY();
        return new Rectangle2D.Double(d, d5, d2 - d, d6 - d5);
    }

    private Rectangle2D positionInside(Shape shape) {
        LinkedList<TextRun> linkedList;
        Rectangle2D rectangle2D = PositionedText.getMaximalRectangleInside(shape);
        Rectangle2D rectangle2D2 = this.context.getDecoration().shrinkByMargin(rectangle2D);
        Rectangle2D rectangle2D3 = this.context.getMaxCharBounds();
        float f = (float)(-rectangle2D3.getY());
        float f2 = this.context.getFont().getSize2D();
        float f3 = (float)rectangle2D2.getWidth();
        double d = rectangle2D2.getHeight();
        this.visibleCharacters = 0;
        LinkedList<TextRun> linkedList2 = linkedList = this.makeUnindentedRuns(f3, d, f2, f);
        for (TextRun textRun : this.runs = linkedList2.toArray(new TextRun[linkedList2.size()])) {
            this.visibleCharacters += textRun.length();
        }
        return rectangle2D2;
    }

    private LinkedList<TextRun> makeUnindentedRuns(float f, double d, float f2, float f3) {
        LinkedList<TextRun> linkedList = new LinkedList<TextRun>();
        List<AttributedCharacterIterator> list = Collections.singletonList(this.text);
        LinkedList<AttributedCharacterIterator> linkedList2 = new LinkedList<AttributedCharacterIterator>();
        AttributedCharacterIterator[] attributedCharacterIteratorArray = list.iterator();
        while (attributedCharacterIteratorArray.hasNext() && linkedList2.size() <= 1) {
            AttributedCharacterIterator attributedCharacterIterator = attributedCharacterIteratorArray.next();
            linkedList2.add(attributedCharacterIterator);
        }
        attributedCharacterIteratorArray = linkedList2.toArray(new AttributedCharacterIterator[linkedList2.size()]);
        this.makeRuns(attributedCharacterIteratorArray, linkedList, f, d, f2, f3, 0.0f, 0.0f);
        return linkedList;
    }

    private float makeRuns(AttributedCharacterIterator[] attributedCharacterIteratorArray, LinkedList<TextRun> linkedList, float f, double d, float f2, float f3, float f4, float f5) {
        float f6 = 0.0f;
        for (AttributedCharacterIterator attributedCharacterIterator : attributedCharacterIteratorArray) {
            if ((double)(f5 + f2) < d + 0.05) {
                this.makeHorizontalRunInside(attributedCharacterIterator, f5 + f3, f, linkedList, f4);
            } else if (f5 == 0.0f) {
                this.makeHorizontalRunInside(attributedCharacterIterator, f5 + f3, f, linkedList, f4);
                this.visibleCharacters -= attributedCharacterIterator.getEndIndex() - attributedCharacterIterator.getBeginIndex();
            } else {
                this.makeHorizontalRunInside(attributedCharacterIterator, f5 + f3, f, linkedList, f4);
            }
            f5 += f2 + f6;
        }
        return f5 - f6;
    }

    private void makeHorizontalRunInside(AttributedCharacterIterator attributedCharacterIterator, float f, float f2, LinkedList<TextRun> linkedList, float f3) {
        float f4;
        int n = attributedCharacterIterator.getEndIndex();
        attributedCharacterIterator.first();
        ArrayList<Float> arrayList = new ArrayList<Float>();
        ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
        int n2 = attributedCharacterIterator.getIndex();
        int n3 = attributedCharacterIterator.getRunLimit();
        boolean bl = this.context.getMeasureWhitespace();
        if (n3 < n) {
            this.context.setMeasureWhitespace(true);
        }
        float f5 = f4 = this.context.measureWidth(attributedCharacterIterator, n2, n3);
        arrayList.add(Float.valueOf(f4));
        while (n3 < n) {
            if (attributedCharacterIterator.getRunLimit() == n) {
                this.context.setMeasureWhitespace(false);
            }
            arrayList2.add(n2);
            n2 = n3;
            attributedCharacterIterator.setIndex(n3);
            n3 = attributedCharacterIterator.getRunLimit();
            f4 = this.context.measureWidth(attributedCharacterIterator, n2, n3);
            f5 += f4;
            arrayList.add(Float.valueOf(f4));
        }
        this.context.setMeasureWhitespace(bl);
        arrayList2.add(n2);
        f3 += (f2 - f5) / 2.0f;
        int n4 = arrayList.size();
        if (n4 == 1) {
            linkedList.add(new TextRun(attributedCharacterIterator, f3, f));
        }
    }

    public static PositionedText makeAroundShape(AttributedCharacterIterator attributedCharacterIterator, TextContext textContext, Dimension2D dimension2D, Shape shape) {
        if (dimension2D == null) {
            dimension2D = new Dimension(10000, 10000);
        }
        Rectangle2D.Double double_ = new Rectangle2D.Double(0.0, 0.0, dimension2D.getWidth(), dimension2D.getHeight());
        AffineTransform affineTransform = AffineTransform.getRotateInstance(0.0);
        Shape shape2 = affineTransform.createTransformedShape(double_);
        PositionedText positionedText = new PositionedText(attributedCharacterIterator, textContext);
        positionedText.positionInside(shape2);
        Rectangle2D rectangle2D = positionedText.getBoundary(BoundaryOption.LOGICAL_WITH_MARGINS.ordinal()).getBounds2D();
        Point2D point2D = PositionedText.placeRotatedRectangleOutsideShape(rectangle2D, -1.5707963267948966, shape);
        positionedText.centerAt(point2D);
        positionedText.shape = shape;
        return positionedText;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List getPoints(Shape shape) {
        float[] fArray = new float[6];
        LinkedList<Point2D> linkedList = new LinkedList<Point2D>();
        PathIterator pathIterator = shape.getPathIterator(null, 1.0);
        float f = Float.NaN;
        float f2 = Float.NaN;
        Object object = fArray;
        synchronized (fArray) {
            while (!pathIterator.isDone()) {
                Point2D point2D;
                int n = pathIterator.currentSegment(fArray);
                if (n == 0) {
                    f = fArray[0];
                    f2 = fArray[1];
                    linkedList.add(new Point2D.Float(f, f2));
                } else if (n == 1) {
                    linkedList.add(new Point2D.Float(fArray[0], fArray[1]));
                } else if (n == 4 && (point2D = (Point2D)linkedList.getLast()).getX() != (double)f && point2D.getY() != (double)f2) {
                    linkedList.add(new Point2D.Float(f, f2));
                }
                pathIterator.next();
            }
            // ** MonitorExit[var6_6] (shouldn't be in output)
            if (linkedList.size() == 0) {
                object = shape.getBounds2D();
                linkedList.add(new Point2D.Double(((RectangularShape)object).getCenterX(), ((RectangularShape)object).getCenterY()));
            }
            if (!linkedList.getLast().equals(linkedList.getFirst())) {
                linkedList.add((Point2D)linkedList.getFirst());
            }
            return linkedList;
        }
    }

    private static Point2D placeRotatedRectangleOutsideShape(Rectangle2D rectangle2D, double d, Shape shape) {
        Rectangle2D.Double double_;
        double d2 = rectangle2D.getWidth();
        double d3 = rectangle2D.getHeight();
        double d4 = Math.cos(d);
        double d5 = Math.sin(d);
        Rectangle2D rectangle2D2 = shape.getBounds2D();
        double d6 = rectangle2D2.getCenterX() - d2 / 2.0;
        double d7 = rectangle2D2.getCenterY() - d3 / 2.0;
        double d8 = Double.POSITIVE_INFINITY;
        double d9 = Double.POSITIVE_INFINITY;
        if (Math.abs(d4) > 0.001) {
            d8 = d2 / 2.0 / Math.abs(d4);
            d9 = (d2 + rectangle2D2.getWidth()) / 2.0 / Math.abs(d4);
        }
        if (Math.abs(d5) > 0.001) {
            d8 = Math.min(d8, d3 / 2.0 / Math.abs(d5));
            d9 = Math.min(d9, (d3 + rectangle2D2.getHeight()) / 2.0 / Math.abs(d5));
        }
        if (!shape.intersects(double_ = new Rectangle2D.Double(d6 + (d9 - 0.25) * d4, d7 + (d9 - 0.25) * d5, d2, d3))) {
            for (int i = 0; i < 20 && d9 - d8 > 0.5; ++i) {
                double d10 = (d8 + d9) / 2.0;
                ((Rectangle2D)double_).setRect(d6 + d10 * d4, d7 + d10 * d5, d2, d3);
                if (shape.intersects(double_)) {
                    d8 = d10;
                    continue;
                }
                d9 = d10;
            }
        }
        return new Point2D.Double(d6 + d9 * d4 + d2 / 2.0, d7 + d9 * d5 + d3 / 2.0);
    }

    private static Font getMaximumFont(AttributedCharacterIterator attributedCharacterIterator) {
        if (attributedCharacterIterator == null) {
            return null;
        }
        attributedCharacterIterator.first();
        Font font = (Font)attributedCharacterIterator.getAttribute(TextAttribute.FONT);
        attributedCharacterIterator.next();
        while (attributedCharacterIterator.getIndex() < attributedCharacterIterator.getEndIndex()) {
            Font font2 = (Font)attributedCharacterIterator.getAttribute(TextAttribute.FONT);
            if (font2 == null) {
                return null;
            }
            if (font2.getSize() > font.getSize()) {
                font = font2;
            }
            attributedCharacterIterator.setIndex(attributedCharacterIterator.getRunLimit());
        }
        return font;
    }

    private static Rectangle2D getMaximalRectangleInside(Shape shape) {
        if (shape instanceof Rectangle2D) {
            return (Rectangle2D)shape;
        }
        Rectangle2D rectangle2D = shape.getBounds2D();
        if (rectangle2D.getWidth() < 0.1 || rectangle2D.getHeight() < 0.1) {
            return rectangle2D;
        }
        if (shape.contains(PositionedText.expand(rectangle2D, -0.1, -0.1))) {
            return rectangle2D;
        }
        List list = PositionedText.getPoints(shape);
        Point2D point2D = PositionedText.getCentroid(list);
        if (!shape.contains(point2D)) {
            point2D = PositionedText.getInsidePoint(point2D, shape, rectangle2D);
        }
        double d = Double.POSITIVE_INFINITY;
        double d2 = 0.0;
        Iterator iterator = list.iterator();
        Point2D point2D2 = (Point2D)iterator.next();
        double d3 = point2D.getX();
        double d4 = point2D.getY();
        while (iterator.hasNext()) {
            Point2D point2D3 = (Point2D)iterator.next();
            double d5 = Line2D.ptSegDistSq(point2D3.getX(), point2D3.getY(), point2D2.getX(), point2D2.getY(), d3, d4);
            d = Math.min(d, d5);
            d2 = Math.max(point2D.distanceSq(point2D3), d5);
            point2D2 = point2D3;
        }
        double d6 = Math.sqrt(d);
        d = Math.sqrt(d / 2.0);
        d2 = Math.sqrt(d2);
        if (d < 2.0) {
            return new Rectangle2D.Double(d3 - 1.0, d4 - 1.0, 2.0, 2.0);
        }
        Rectangle2D.Double double_ = new Rectangle2D.Double(point2D.getX() - d, point2D.getY() - d, d * 2.0, d * 2.0);
        Rectangle2D.Double double_2 = new Rectangle2D.Double();
        for (double d7 = (d6 - d) / 2.0; d7 > 1.0; d7 /= 2.0) {
            ((Rectangle2D)double_2).setRect(((RectangularShape)double_).getX() - d7, ((RectangularShape)double_).getY() - d7, ((RectangularShape)double_).getWidth() + 2.0 * d7, ((RectangularShape)double_).getWidth() + 2.0 * d7);
            if (!shape.contains(double_2)) continue;
            ((Rectangle2D)double_).setRect(double_2);
            d += d7;
        }
        Rectangle2D.Double double_3 = new Rectangle2D.Double();
        ((Rectangle2D)double_3).setRect(double_);
        PositionedText.adjustToFit(double_3, double_2, shape);
        double d8 = ((RectangularShape)double_).getWidth() / 2.0;
        ((Rectangle2D)double_).setRect(point2D.getX() - d8 / 2.0, point2D.getY() - d8 / 2.0, d8, d8);
        PositionedText.adjustToFit(double_, double_2, shape);
        if (((RectangularShape)double_).getWidth() * ((RectangularShape)double_).getHeight() > ((RectangularShape)double_3).getWidth() * ((RectangularShape)double_3).getHeight()) {
            return double_;
        }
        return double_3;
    }

    private static Rectangle2D expand(Rectangle2D rectangle2D, double d, double d2) {
        if (rectangle2D == null) {
            return null;
        }
        return new Rectangle2D.Double(rectangle2D.getMinX() - d, rectangle2D.getMinY() - d2, rectangle2D.getWidth() + 2.0 * d, rectangle2D.getHeight() + 2.0 * d2);
    }

    private static Point2D.Double getCentroid(List list) {
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        Iterator iterator = list.iterator();
        Point2D point2D = (Point2D)iterator.next();
        double d4 = point2D.getX();
        double d5 = point2D.getY();
        while (iterator.hasNext()) {
            point2D = (Point2D)iterator.next();
            double d6 = point2D.getX();
            double d7 = point2D.getY();
            double d8 = d4 * d7 - d6 * d5;
            d += d8;
            d2 += (d4 + d6) * d8;
            d3 += (d5 + d7) * d8;
            d4 = d6;
            d5 = d7;
        }
        if (Math.abs(d) < 1.0) {
            return PositionedText.getInterRangeCenter(list);
        }
        return new Point2D.Double(d2 /= 6.0 * (d /= 2.0), d3 /= 6.0 * d);
    }

    private static Point2D.Double getInterRangeCenter(List list) {
        double d = Double.POSITIVE_INFINITY;
        double d2 = Double.POSITIVE_INFINITY;
        double d3 = Double.NEGATIVE_INFINITY;
        double d4 = Double.NEGATIVE_INFINITY;
        for (Point2D point2D : list) {
            d = Math.min(d, point2D.getX());
            d2 = Math.min(d2, point2D.getY());
            d3 = Math.max(d3, point2D.getX());
            d4 = Math.max(d4, point2D.getY());
        }
        return new Point2D.Double((d + d3) / 2.0, (d2 + d4) / 2.0);
    }

    private static Point2D getInsidePoint(Point2D point2D, Shape shape, Rectangle2D rectangle2D) {
        if (rectangle2D.getWidth() < 0.1 || rectangle2D.getHeight() < 0.1) {
            return point2D;
        }
        for (int n : new int[]{5, 19, 91}) {
            Point2D.Double double_ = null;
            for (int i = -n + 1; i < n; ++i) {
                double d = rectangle2D.getMinX() + rectangle2D.getWidth() * (double)i / (double)n / 2.0;
                for (int j = -n + 1; j < n; ++j) {
                    double d2 = rectangle2D.getMinY() + rectangle2D.getHeight() * (double)j / (double)n / 2.0;
                    if (!shape.contains(d, d2) || double_ != null && !(point2D.distanceSq(double_) > point2D.distanceSq(d, d2))) continue;
                    double_ = new Point2D.Double(d, d2);
                }
            }
            if (double_ == null) continue;
            return double_;
        }
        return point2D;
    }

    private static void adjustToFit(Rectangle2D rectangle2D, Rectangle2D rectangle2D2, Shape shape) {
        int n = 8;
        boolean bl = true;
        while (bl || n > 0) {
            bl = false;
            rectangle2D2.setRect(rectangle2D.getX() - (double)n, rectangle2D.getY(), rectangle2D.getWidth() + (double)n, rectangle2D.getHeight());
            if (shape.contains(rectangle2D2)) {
                rectangle2D.setRect(rectangle2D2);
                bl = true;
            }
            rectangle2D2.setRect(rectangle2D.getX(), rectangle2D.getY(), rectangle2D.getWidth() + (double)n, rectangle2D.getHeight());
            if (shape.contains(rectangle2D2)) {
                rectangle2D.setRect(rectangle2D2);
                bl = true;
            }
            rectangle2D2.setRect(rectangle2D.getX(), rectangle2D.getY() - (double)n, rectangle2D.getWidth(), rectangle2D.getHeight() + (double)n);
            if (shape.contains(rectangle2D2)) {
                rectangle2D.setRect(rectangle2D2);
                bl = true;
            }
            rectangle2D2.setRect(rectangle2D.getX(), rectangle2D.getY(), rectangle2D.getWidth(), rectangle2D.getHeight() + (double)n);
            if (shape.contains(rectangle2D2)) {
                rectangle2D.setRect(rectangle2D2);
                bl = true;
            }
            if (bl) continue;
            n /= 2;
        }
    }

    class TextRun {
        private float x;
        private float y;
        private AttributedCharacterIterator iter;

        public TextRun(AttributedCharacterIterator attributedCharacterIterator, float f, float f2) {
            this.iter = attributedCharacterIterator;
            this.iter.first();
            this.x = f;
            this.y = f2;
        }

        public String getText() {
            StringBuilder stringBuilder = new StringBuilder();
            char c = this.iter.first();
            while (c != '\uffff') {
                stringBuilder.append(c);
                c = this.iter.next();
            }
            return stringBuilder.toString();
        }

        public float getX() {
            return this.x;
        }

        public float getY() {
            return this.y;
        }

        private void setLocation(double d, double d2) {
            this.x = (float)d;
            this.y = (float)d2;
        }

        public int length() {
            return this.iter.getEndIndex() - this.iter.getBeginIndex();
        }

        public AttributedCharacterIterator getIterator() {
            return this.iter;
        }
    }

    static enum BoundaryOption {
        UNTRANSFORMED,
        LOGICAL,
        LOGICAL_WITH_MARGINS;

    }
}

