/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.controls.double_slider;

import com.spss.java_client.ui.controls.double_slider.BoxDecoration;
import com.spss.java_client.ui.controls.double_slider.DoubleSlider;
import com.spss.java_client.ui.controls.double_slider.PositionedText;
import com.spss.java_client.ui.controls.double_slider.TextContext;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseEvent;
import java.awt.font.FontRenderContext;
import java.awt.geom.Rectangle2D;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JSlider;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.plaf.basic.BasicGraphicsUtils;
import javax.swing.plaf.basic.BasicSliderUI;

public class DoubleSliderUI
extends BasicSliderUI {
    private static final int SIZE = 13;
    private static final Color THUMB_FILLCOLOR = new Color(164, 207, 255);
    boolean higherThumbFocused = false;
    boolean noThumbFocused = true;
    boolean isRangeFixed = false;
    private Rectangle higherThumbRect;

    public DoubleSliderUI(JSlider jSlider) {
        super(jSlider);
    }

    @Override
    public void installUI(JComponent jComponent) {
        this.higherThumbRect = new Rectangle();
        super.installUI(jComponent);
    }

    public void setRangeFixed(boolean bl) {
        this.isRangeFixed = bl;
    }

    @Override
    protected void installDefaults(JSlider jSlider) {
        super.installDefaults(jSlider);
        jSlider.setPaintTrack(true);
        jSlider.setPaintTicks(true);
        jSlider.setOrientation(0);
        jSlider.setFont(new JLabel().getFont().deriveFont(10.0f));
        jSlider.setOpaque(true);
    }

    @Override
    protected void installListeners(final JSlider jSlider) {
        this.trackListener = new DoubleSliderTrackListener();
        super.installListeners(jSlider);
        if (UIManager.getLookAndFeel().getName().contains("CobaltLookAndFeel")) {
            jSlider.getActionMap().put("leftarrow", new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    DoubleSliderUI.this.scrollByUnit(-1);
                }
            });
            jSlider.getInputMap(0).put(KeyStroke.getKeyStroke(37, 0), "leftarrow");
            jSlider.getActionMap().put("rightarrow", new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    DoubleSliderUI.this.scrollByUnit(1);
                }
            });
            jSlider.getInputMap(0).put(KeyStroke.getKeyStroke(39, 0), "rightarrow");
        }
        jSlider.getActionMap().put("left", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DoubleSliderUI.this.moveFocus(false);
                jSlider.repaint();
            }
        });
        jSlider.getInputMap(0).put(KeyStroke.getKeyStroke(37, 64), "left");
        jSlider.getActionMap().put("right", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DoubleSliderUI.this.moveFocus(true);
                jSlider.repaint();
            }
        });
        jSlider.getInputMap(0).put(KeyStroke.getKeyStroke(39, 64), "right");
        jSlider.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent componentEvent) {
                DoubleSliderUI.this.calculateGeometry();
                jSlider.repaint();
            }
        });
    }

    @Override
    public void paintTicks(Graphics graphics) {
        int n;
        Rectangle rectangle = this.tickRect;
        if (this.slider.isEnabled()) {
            graphics.setColor(Color.black);
        } else {
            graphics.setColor(this.slider.getBackground().darker());
        }
        graphics.translate(0, rectangle.y);
        int n2 = 0;
        if (this.slider.getMinorTickSpacing() > 0) {
            for (n = this.slider.getMinimum(); n <= this.slider.getMaximum(); n += this.slider.getMinorTickSpacing()) {
                n2 = this.xPositionForValue(n);
                this.paintMinorTickForHorizSlider(graphics, rectangle, n2);
            }
        }
        if (this.slider.getMajorTickSpacing() > 0) {
            for (n = this.slider.getMinimum(); n <= this.slider.getMaximum(); n += this.slider.getMajorTickSpacing()) {
                n2 = this.xPositionForValue(n);
                this.paintMajorTickForHorizSlider(graphics, rectangle, n2);
            }
        }
        graphics.translate(0, -rectangle.y);
    }

    @Override
    protected void calculateTrackBuffer() {
        Component component = this.getHighestValueLabel();
        Component component2 = this.getLowestValueLabel();
        if (component2 != null && component != null) {
            this.trackBuffer = Math.max(component.getBounds().width, component2.getBounds().width) / 2;
        }
        this.trackBuffer = Math.max(this.trackBuffer, 13);
    }

    @Override
    protected void calculateThumbSize() {
        super.calculateThumbSize();
        this.higherThumbRect.setSize(this.thumbRect.width, this.thumbRect.height);
    }

    @Override
    protected void calculateThumbLocation() {
        super.calculateThumbLocation();
        this.thumbRect.x = this.xPositionForValue(this.slider.getValue()) - 6;
        this.thumbRect.y = this.trackRect.y;
        if (this.slider.getOrientation() == 0) {
            int n = this.xPositionForValue(this.slider.getValue() + this.slider.getExtent());
            this.higherThumbRect.x = n - this.higherThumbRect.width / 2;
            this.higherThumbRect.y = this.trackRect.y;
        } else {
            int n = this.yPositionForValue(this.slider.getValue() + this.slider.getExtent());
            this.higherThumbRect.x = this.trackRect.x;
            this.higherThumbRect.y = n - this.higherThumbRect.height / 2;
        }
    }

    @Override
    protected Dimension getThumbSize() {
        int n = this.xPositionForValue(this.slider.getValue());
        int n2 = this.xPositionForValue(this.slider.getValue() + this.slider.getExtent());
        return new Dimension(n2 - n + 13, 13);
    }

    @Override
    protected Color getShadowColor() {
        return super.getShadowColor() == null ? new Color(153, 153, 153) : super.getShadowColor();
    }

    @Override
    protected Color getHighlightColor() {
        return super.getHighlightColor() == null ? new Color(255, 255, 255) : super.getHighlightColor();
    }

    @Override
    public void paintTrack(Graphics graphics) {
        super.paintTrack(graphics);
        if (this.slider.isEnabled()) {
            graphics.setColor(new Color(0, 0, 255, 180));
        } else {
            graphics.setColor(this.slider.getBackground().darker());
        }
        int n = this.trackRect.y + this.trackRect.height / 2;
        graphics.fillRect(this.thumbRect.x, n, this.thumbRect.width, 2);
    }

    @Override
    public void paint(Graphics graphics, JComponent jComponent) {
        this.calculateGeometry();
        super.paint(graphics, jComponent);
    }

    @Override
    public void paintThumb(Graphics graphics) {
        String string = null;
        Rectangle rectangle = this.thumbRect;
        int n = this.slider.getExtent();
        if (n > 0) {
            this.thumbRect = new Rectangle(rectangle.x + rectangle.width - 13, rectangle.y, 13, rectangle.height);
            string = this.doPaintThumb((Graphics2D)graphics, this.slider.getValue() + n, true);
        }
        this.thumbRect = new Rectangle(rectangle.x, rectangle.y, 13, rectangle.height);
        String string2 = this.doPaintThumb((Graphics2D)graphics, this.slider.getValue(), false);
        this.thumbRect = rectangle;
        this.setToolTipAndAccessibleDescription(string2, string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void scrollByUnit(int n) {
        JSlider jSlider = this.slider;
        synchronized (jSlider) {
            int n2 = n > 0 ? 1 : -1;
            int n3 = this.slider.getValue();
            if (!this.isRangeFixed && !this.noThumbFocused) {
                if (this.higherThumbFocused) {
                    int n4 = this.slider.getExtent();
                    this.slider.setExtent(n4 + n2);
                } else if (this.slider.getExtent() + n3 == this.slider.getMaximum() && n == 1) {
                    this.slider.setExtent(this.slider.getExtent() - n2);
                    this.slider.setValue(n3 + n2);
                } else {
                    this.slider.setValue(n3 + n2);
                    this.slider.setExtent(this.slider.getExtent() - n2);
                }
            } else {
                super.scrollByUnit(n);
            }
        }
    }

    private void setToolTipAndAccessibleDescription(String string, String string2) {
        StringBuilder stringBuilder = new StringBuilder(string);
        if (string2 != null) {
            stringBuilder.append(" - ").append(string2);
        }
        if (stringBuilder.toString().length() > 0) {
            this.slider.getAccessibleContext().setAccessibleDescription(stringBuilder.toString());
            Font font = UIManager.getFont("ToolTip.font");
            FontRenderContext fontRenderContext = new FontRenderContext(null, false, false);
            Rectangle2D rectangle2D = font.getStringBounds(stringBuilder.toString(), fontRenderContext);
            int n = this.slider.getSize().width;
            if ((double)n < rectangle2D.getWidth()) {
                stringBuilder = this.makeMultiLineTooltip(font, n, string, string2, fontRenderContext);
                ((DoubleSlider)this.slider).updateLabelUIs();
            }
            this.slider.setToolTipText(stringBuilder.toString());
        }
    }

    private StringBuilder makeMultiLineTooltip(Font font, int n, String string, String string2, FontRenderContext fontRenderContext) {
        StringBuilder stringBuilder = new StringBuilder("<html>");
        double d = font.getStringBounds(string, fontRenderContext).getWidth();
        if (d < (double)n) {
            stringBuilder.append(d);
        } else {
            this.appendHtmlLinesForString(stringBuilder, string, n, font, fontRenderContext);
        }
        if (string2 != null) {
            String string3 = "- " + string2;
            double d2 = font.getStringBounds(string3, fontRenderContext).getWidth();
            if (d2 < (double)n) {
                stringBuilder.append(string3);
            } else {
                this.appendHtmlLinesForString(stringBuilder, string3, n, font, fontRenderContext);
            }
        }
        stringBuilder.append("</html>");
        return stringBuilder;
    }

    private void appendHtmlLinesForString(StringBuilder stringBuilder, String string, int n, Font font, FontRenderContext fontRenderContext) {
        StringBuilder stringBuilder2 = new StringBuilder();
        String[] stringArray = string.split("\\s");
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].length() < 1) continue;
            double d = font.getStringBounds(stringArray[i], fontRenderContext).getWidth();
            String string2 = stringBuilder2.toString();
            if (d < (double)n) {
                double d2 = font.getStringBounds(string2 + stringArray[i], fontRenderContext).getWidth();
                if (d2 < (double)n) {
                    stringBuilder2.append(stringArray[i]).append(" ");
                    continue;
                }
                stringBuilder.append(string2).append("<br>");
                stringBuilder2 = new StringBuilder(stringArray[i]);
                continue;
            }
            if (string2.length() > 0) {
                stringBuilder.append(string2).append("<br>");
            }
            int n2 = stringArray[i].length();
            int n3 = (int)Math.ceil(d / (double)n);
            int n4 = stringArray[i].length() / n3 + 1;
            int n5 = 0;
            int n6 = n4;
            for (int j = 0; j < n3; ++j) {
                if (n6 < n2) {
                    stringBuilder.append(stringArray[i].substring(n5, n6)).append("<br>");
                } else {
                    stringBuilder.append(stringArray[i].substring(n5)).append("<br>");
                }
                n5 = n6;
                n6 = n5 + n4;
            }
        }
    }

    @Override
    protected void calculateContentRect() {
        super.calculateContentRect();
        this.contentRect.y += 20;
        this.contentRect.height -= 20;
    }

    private String doPaintThumb(Graphics2D graphics2D, int n, boolean bl) {
        Color color = this.slider.getBackground();
        this.slider.setBackground(THUMB_FILLCOLOR);
        super.paintThumb(graphics2D);
        this.slider.setBackground(color);
        String string = ((DoubleSlider)this.slider).getLabelFor(n);
        BoxDecoration boxDecoration = new BoxDecoration();
        boxDecoration.setBorderColor(new Color(0, 0, 120));
        boxDecoration.setFillPaint(this.slider.getBackground());
        boxDecoration.setPadding(new float[]{2.0f, 1.0f, 2.0f, 1.0f});
        boxDecoration.setMargin(new float[]{0.0f, 2.0f, 0.0f, 2.0f});
        TextContext textContext = new TextContext(this.slider.getFont(), this.slider.getLocale(), boxDecoration, graphics2D.getFontRenderContext());
        Rectangle rectangle = new Rectangle(this.thumbRect);
        double d = this.slider.getFont().getStringBounds(string, graphics2D.getFontRenderContext()).getWidth() + 10.0;
        int n2 = this.slider.getSize().width;
        int n3 = n2 / 2;
        if (d > (double)n3) {
            d = n3;
        }
        rectangle.x = n == 0 ? ((double)rectangle.x - d / 2.0 < 0.0 ? 0 : rectangle.x - (int)d / 2) : (n == this.slider.getMaximum() ? ((double)rectangle.x + d / 2.0 > (double)n2 ? n2 - (int)d : rectangle.x - (int)d / 2) : ((double)rectangle.x - d / 2.0 < 0.0 ? 0 : ((double)rectangle.x + d / 2.0 > (double)n2 ? n2 - (int)d : (rectangle.x -= (int)d / 2))));
        rectangle.width = (int)d;
        PositionedText positionedText = PositionedText.makeAroundShape(textContext.getAttributeIterator(string, this.slider.getFont()), textContext, new Dimension(rectangle.width, rectangle.height), rectangle);
        Color color2 = this.getFocusColor();
        color2 = color2 == null ? Color.black : color2;
        positionedText.draw(graphics2D, color2);
        if (this.slider.hasFocus()) {
            Rectangle rectangle2 = null;
            if (this.higherThumbFocused && !this.noThumbFocused && bl) {
                rectangle2 = (Rectangle)this.higherThumbRect.clone();
                rectangle2.x = rectangle2.x + rectangle2.width / 2 - 6;
                rectangle2.width = 13;
            } else if (!(this.higherThumbFocused || this.noThumbFocused || bl)) {
                rectangle2 = (Rectangle)this.thumbRect.clone();
            }
            if (rectangle2 != null) {
                graphics2D.setColor(this.getFocusColor());
                BasicGraphicsUtils.drawDashedRect(graphics2D, rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height);
            }
        }
        return string;
    }

    private void moveFocus(boolean bl) {
        if (this.noThumbFocused) {
            this.higherThumbFocused = !bl;
            this.noThumbFocused = false;
        } else if (this.higherThumbFocused) {
            this.higherThumbFocused = false;
            this.noThumbFocused = bl;
        } else {
            this.higherThumbFocused = bl;
            this.noThumbFocused = !bl;
        }
    }

    private class DoubleSliderTrackListener
    extends BasicSliderUI.TrackListener {
        private int draggingWhat;
        private int originalExtent;
        private int originalDown;

        private DoubleSliderTrackListener() {
            super(DoubleSliderUI.this);
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
            if (!DoubleSliderUI.this.slider.isEnabled()) {
                return;
            }
            this.currentMouseX = mouseEvent.getX();
            this.currentMouseY = mouseEvent.getY();
            DoubleSliderUI.this.slider.setValueIsAdjusting(true);
            int n = 6;
            int n2 = mouseEvent.getX() - this.offset;
            int n3 = ((DoubleSliderUI)DoubleSliderUI.this).trackRect.x;
            int n4 = ((DoubleSliderUI)DoubleSliderUI.this).trackRect.x + (((DoubleSliderUI)DoubleSliderUI.this).trackRect.width - 1);
            n2 = Math.max(n2, n3 - n);
            n2 = Math.min(n2, n4 - n);
            int n5 = DoubleSliderUI.this.slider.getValue();
            if (!DoubleSliderUI.this.isRangeFixed) {
                if (this.draggingWhat == -1) {
                    DoubleSliderUI.this.setThumbLocation(n2, ((DoubleSliderUI)DoubleSliderUI.this).thumbRect.y);
                    int n6 = DoubleSliderUI.this.valueForXPosition(n2 + n);
                    System.out.println("newValue=" + n6);
                    if (n6 > n5) {
                        DoubleSliderUI.this.slider.setExtent(DoubleSliderUI.this.slider.getExtent() - n6 + n5);
                    } else if (n6 < n5) {
                        DoubleSliderUI.this.slider.setValue(n6);
                        DoubleSliderUI.this.slider.setExtent(DoubleSliderUI.this.slider.getExtent() - n6 + n5);
                    }
                    DoubleSliderUI.this.higherThumbFocused = false;
                } else if (this.draggingWhat == 1) {
                    int n7 = this.getDelta(mouseEvent.getX() - this.originalDown);
                    DoubleSliderUI.this.slider.setExtent(this.originalExtent + n7);
                    DoubleSliderUI.this.higherThumbFocused = true;
                } else {
                    DoubleSliderUI.this.setThumbLocation(n2, ((DoubleSliderUI)DoubleSliderUI.this).thumbRect.y);
                    DoubleSliderUI.this.slider.setValue(DoubleSliderUI.this.valueForXPosition(n2 + n));
                }
            } else {
                DoubleSliderUI.this.setThumbLocation(n2, ((DoubleSliderUI)DoubleSliderUI.this).thumbRect.y);
                DoubleSliderUI.this.slider.setValue(DoubleSliderUI.this.valueForXPosition(n2 + n));
            }
            DoubleSliderUI.this.calculateGeometry();
            DoubleSliderUI.this.slider.repaint();
        }

        public int getDelta(int n) {
            int n2 = DoubleSliderUI.this.slider.getMinimum();
            int n3 = DoubleSliderUI.this.slider.getMaximum();
            int n4 = ((DoubleSliderUI)DoubleSliderUI.this).trackRect.width;
            double d = (double)n3 - (double)n2;
            double d2 = d / (double)n4;
            return (int)(d2 * (double)n);
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            if (DoubleSliderUI.this.thumbRect.contains(mouseEvent.getX(), mouseEvent.getY())) {
                if (!DoubleSliderUI.this.slider.isEnabled()) {
                    return;
                }
                this.currentMouseX = mouseEvent.getX();
                this.currentMouseY = mouseEvent.getY();
                if (DoubleSliderUI.this.slider.isRequestFocusEnabled()) {
                    DoubleSliderUI.this.slider.requestFocus();
                }
                Rectangle rectangle = new Rectangle(((DoubleSliderUI)DoubleSliderUI.this).thumbRect.x, ((DoubleSliderUI)DoubleSliderUI.this).thumbRect.y, 13, ((DoubleSliderUI)DoubleSliderUI.this).thumbRect.height);
                Rectangle rectangle2 = new Rectangle(((DoubleSliderUI)DoubleSliderUI.this).thumbRect.x + ((DoubleSliderUI)DoubleSliderUI.this).thumbRect.width - 13, ((DoubleSliderUI)DoubleSliderUI.this).thumbRect.y, 13, ((DoubleSliderUI)DoubleSliderUI.this).thumbRect.height);
                if (rectangle.contains(this.currentMouseX, this.currentMouseY)) {
                    this.offset = this.currentMouseX - ((DoubleSliderUI)DoubleSliderUI.this).thumbRect.x;
                    this.draggingWhat = -1;
                    DoubleSliderUI.this.higherThumbFocused = false;
                    DoubleSliderUI.this.noThumbFocused = false;
                } else if (rectangle2.contains(this.currentMouseX, this.currentMouseY)) {
                    this.offset = this.currentMouseX - ((DoubleSliderUI)DoubleSliderUI.this).thumbRect.x;
                    this.originalExtent = DoubleSliderUI.this.slider.getExtent();
                    this.originalDown = mouseEvent.getX();
                    this.draggingWhat = 1;
                    DoubleSliderUI.this.higherThumbFocused = true;
                    DoubleSliderUI.this.noThumbFocused = false;
                } else {
                    this.draggingWhat = 0;
                    super.mousePressed(mouseEvent);
                }
            } else {
                super.mousePressed(mouseEvent);
            }
        }
    }
}

