/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.controls.double_slider;

import com.spss.java_client.ui.controls.double_slider.DoubleSliderUI;
import java.util.Collection;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JSlider;
import javax.swing.plaf.SliderUI;

public class DoubleSlider
extends JSlider {
    private final StringConverter converter;
    private Map<String, String> relabels;

    public DoubleSlider(List<String> list, Map<String, String> map) {
        this.converter = new StringConverter(list);
        int n = this.converter.getMax();
        int n2 = this.converter.getMajorSpacing();
        this.relabels = map;
        this.getModel().setRangeProperties(0, n2, 0, n, false);
        this.setMajorTickSpacing(n2);
        this.setLabelTable(this.makeLabelTable());
        this.setExtent(0);
    }

    public void setRangeFixed(boolean bl) {
        ((DoubleSliderUI)this.getUI()).setRangeFixed(bl);
    }

    private Dictionary<Integer, JLabel> makeLabelTable() {
        Hashtable<Integer, JLabel> hashtable = new Hashtable<Integer, JLabel>();
        for (int i = 0; i <= this.getMaximum(); i += this.getMajorTickSpacing()) {
            String string = this.getLabelFor(i);
            ((Dictionary)hashtable).put(i, new JLabel(string));
        }
        return hashtable;
    }

    @Override
    public void setUI(SliderUI sliderUI) {
        DoubleSliderUI doubleSliderUI = new DoubleSliderUI(this);
        super.setUI(doubleSliderUI);
    }

    @Override
    protected void updateLabelUIs() {
        if (this.getLabelTable() == null) {
            return;
        }
        Enumeration enumeration = this.getLabelTable().keys();
        while (enumeration.hasMoreElements()) {
            Object v = this.getLabelTable().get(enumeration.nextElement());
            if (!(v instanceof JComponent)) continue;
            JComponent jComponent = (JComponent)v;
            jComponent.updateUI();
            jComponent.setSize(jComponent.getPreferredSize());
            jComponent.setFont(this.getFont());
        }
    }

    public String getLabelFor(int n) {
        String string;
        String string2 = this.converter.toString(n);
        if (this.relabels != null && (string = this.relabels.get(string2)) != null) {
            string2 = string;
        }
        return string2;
    }

    public String getValueFor(int n) {
        return this.converter.toString(n);
    }

    public void setValues(int n, int n2) {
        if (n2 > this.getModel().getMaximum()) {
            n2 = this.getModel().getMaximum();
            this.setExtent(n2 - n);
            this.setValue(n);
        } else {
            this.setValue(n);
            this.setExtent(n2 - n);
        }
    }

    public int getLowValue() {
        return this.getValue();
    }

    public int getHighValue() {
        return this.getValue() + this.getExtent();
    }

    private class StringConverter {
        private String[] categories;

        StringConverter(Collection<String> collection) {
            this.categories = collection.toArray(new String[collection.size()]);
        }

        public int getIndex(String string) {
            if (string == null) {
                return this.categories.length;
            }
            for (int i = 0; i < this.categories.length; ++i) {
                String string2 = this.categories[i];
                if (!string.equals(string2)) continue;
                return i;
            }
            return -1;
        }

        public int getMajorSpacing() {
            return 1;
        }

        public String toString(int n) {
            return this.categories[n];
        }

        public int getMax() {
            return this.categories.length - 1;
        }
    }
}

