/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.controls.double_slider;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Paint;
import java.awt.geom.Rectangle2D;

public class BoxDecoration {
    private static final float[] NO_SIZE = new float[]{0.0f, 0.0f, 0.0f, 0.0f};
    private Paint fillPaint = null;
    private BasicStroke borderStroke = new BasicStroke(1.0f);
    private float[] margin = NO_SIZE;
    private float[] padding = NO_SIZE;
    private Color borderColor = null;
    private Color[] borderColors = null;

    public Color getBorderColor() {
        return this.borderColor;
    }

    public Color[] getBorderColors() {
        return this.borderColors;
    }

    public void setBorderColor(Color color) {
        this.borderColor = color;
    }

    public void setBorderColors(Color[] colorArray) {
        this.borderColors = colorArray;
    }

    public BasicStroke getBorderStroke() {
        return this.borderStroke;
    }

    public void setBorderStroke(BasicStroke basicStroke) {
        this.borderStroke = basicStroke;
    }

    public Paint getFillPaint() {
        return this.fillPaint;
    }

    public void setFillPaint(Paint paint) {
        this.fillPaint = paint;
    }

    public float[] getMargins() {
        return this.margin;
    }

    public void setMargin(float[] fArray) {
        this.margin = fArray;
    }

    public float[] getPadding() {
        return this.padding;
    }

    public void setPadding(float[] fArray) {
        this.padding = fArray;
    }

    public float getTotalHorizontalSizeToMargin() {
        return this.padding[0] + this.padding[2] + this.margin[0] + this.margin[2];
    }

    public float getTotalVerticalSizeToMargin() {
        return this.padding[1] + this.padding[3] + this.margin[1] + this.margin[3];
    }

    public boolean hasBorder() {
        if (this.borderColor != null && this.borderColor.getAlpha() > 0) {
            return true;
        }
        if (this.borderColors == null) {
            return false;
        }
        for (Color color : this.borderColors) {
            if (color == null || color.getAlpha() <= 0) continue;
            return true;
        }
        return false;
    }

    public Rectangle2D expandToBorder(Rectangle2D rectangle2D) {
        if (this.padding == NO_SIZE) {
            return rectangle2D;
        }
        return new Rectangle2D.Double(rectangle2D.getX() - (double)this.padding[0], rectangle2D.getY() - (double)this.padding[1], rectangle2D.getWidth() + (double)this.padding[0] + (double)this.padding[2], rectangle2D.getHeight() + (double)this.padding[1] + (double)this.padding[3]);
    }

    public Rectangle2D expandToMargin(Rectangle2D rectangle2D) {
        return new Rectangle2D.Double(rectangle2D.getX() - (double)this.padding[0] - (double)this.margin[0], rectangle2D.getY() - (double)this.padding[1] - (double)this.margin[1], rectangle2D.getWidth() + (double)this.padding[0] + (double)this.padding[2] + (double)this.margin[0] + (double)this.margin[2], rectangle2D.getHeight() + (double)this.padding[1] + (double)this.padding[3] + (double)this.margin[1] + (double)this.margin[3]);
    }

    public Rectangle2D shrinkByBorder(Rectangle2D rectangle2D) {
        return new Rectangle2D.Double(rectangle2D.getX() + (double)this.padding[0], rectangle2D.getY() + (double)this.padding[1], rectangle2D.getWidth() - (double)this.padding[0] - (double)this.padding[2], rectangle2D.getHeight() - (double)this.padding[1] - (double)this.padding[3]);
    }

    public Rectangle2D shrinkByMargin(Rectangle2D rectangle2D) {
        return new Rectangle2D.Double(rectangle2D.getX() + (double)this.padding[0] + (double)this.margin[0], rectangle2D.getY() + (double)this.padding[1] + (double)this.margin[1], rectangle2D.getWidth() - (double)this.padding[0] - (double)this.padding[2] - (double)this.margin[0] - (double)this.margin[2], rectangle2D.getHeight() - (double)this.padding[1] - (double)this.padding[3] - (double)this.margin[1] - (double)this.margin[3]);
    }

    public Rectangle2D shrinkByMarginToBorder(Rectangle2D rectangle2D) {
        if (this.margin == NO_SIZE) {
            return rectangle2D;
        }
        return new Rectangle2D.Double(rectangle2D.getX() + (double)this.margin[0], rectangle2D.getY() + (double)this.margin[1], rectangle2D.getWidth() - (double)this.margin[0] - (double)this.margin[2], rectangle2D.getHeight() - (double)this.margin[1] - (double)this.margin[3]);
    }
}

