/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.controls.data_tip;

import com.spss.java_client.ui.controls.data_tip.ListDataTip;
import com.spss.java_client.ui.controls.data_tip.ListTipCell;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseEvent;
import javax.swing.JList;
import javax.swing.SwingUtilities;
import javax.swing.event.MouseInputAdapter;

public class ListTipListener
extends MouseInputAdapter
implements ComponentListener {
    private ListDataTip mListTip = null;

    ListTipCell getTipCell(JList jList, Point point) {
        int n = jList.locationToIndex(point);
        if (n < 0) {
            return null;
        }
        return new ListTipCell(jList, n);
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        this.hideTip();
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
        this.processEvent(mouseEvent);
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
        this.processEvent(mouseEvent);
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        this.processEvent(mouseEvent);
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
        this.processEvent(mouseEvent);
    }

    private void processEvent(MouseEvent mouseEvent) {
        this.validateTipWindow((JList)mouseEvent.getSource(), mouseEvent.getPoint());
    }

    private void validateTipWindow(JList jList, Point point) {
        Window window = SwingUtilities.getWindowAncestor(jList);
        if (window == null || !window.isActive()) {
            this.hideTip();
            return;
        }
        ListTipCell listTipCell = this.getTipCell(jList, point);
        Rectangle rectangle = jList.getVisibleRect();
        if (!rectangle.contains(point)) {
            listTipCell = null;
        }
        ListTipCell listTipCell2 = this.getCurrentTipCell();
        if (listTipCell != null && listTipCell.equals(listTipCell2)) {
            return;
        }
        this.hideTip();
        if (listTipCell == null || !listTipCell.isInUse()) {
            return;
        }
        this.mListTip = this.createDataTipPopup(jList, point, listTipCell);
    }

    private ListTipCell getCurrentTipCell() {
        if (!this.isTipShown()) {
            return null;
        }
        return this.mListTip.getTipCell();
    }

    private ListDataTip createDataTipPopup(JList jList, Point point, ListTipCell listTipCell) {
        Rectangle rectangle;
        Rectangle rectangle2 = listTipCell.getCellBounds();
        Rectangle rectangle3 = rectangle2.intersection(rectangle = jList.getVisibleRect());
        if (!rectangle3.contains(point)) {
            return null;
        }
        Component component = listTipCell.getCellRenderer();
        Dimension dimension = component.getMinimumSize();
        Rectangle rectangle4 = new Rectangle(rectangle2.getLocation(), dimension);
        if (rectangle2.contains(rectangle4) && rectangle.contains(rectangle4)) {
            return null;
        }
        Dimension dimension2 = component.getPreferredSize();
        Point point2 = rectangle2.getLocation();
        int n = Math.max(rectangle2.width, dimension2.width);
        int n2 = Math.max(rectangle2.height, dimension2.height);
        Dimension dimension3 = new Dimension(n, n2);
        return new ListDataTip(jList, listTipCell, point2, dimension3);
    }

    private boolean isTipShown() {
        return this.mListTip != null && this.mListTip.isTipVisible();
    }

    private void hideTip() {
        if (this.mListTip != null) {
            this.mListTip.hideTip();
            this.mListTip = null;
        }
    }

    @Override
    public void componentResized(ComponentEvent componentEvent) {
        this.processEvent(componentEvent);
    }

    @Override
    public void componentMoved(ComponentEvent componentEvent) {
        this.processEvent(componentEvent);
    }

    @Override
    public void componentShown(ComponentEvent componentEvent) {
        this.processEvent(componentEvent);
    }

    @Override
    public void componentHidden(ComponentEvent componentEvent) {
        this.hideTip();
    }

    private void processEvent(ComponentEvent componentEvent) {
        Point point = MouseInfo.getPointerInfo().getLocation();
        if (point == null) {
            this.hideTip();
        } else {
            JList jList = (JList)componentEvent.getSource();
            SwingUtilities.convertPointFromScreen(point, jList);
            this.validateTipWindow(jList, point);
        }
    }
}

