/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.controls.data_tip;

import com.spss.java_client.ui.controls.data_tip.DataTip;
import com.spss.java_client.ui.controls.data_tip.DataTipController;
import com.spss.java_client.ui.controls.data_tip.ListTipCell;
import java.awt.Dimension;
import java.awt.GraphicsConfiguration;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import javax.swing.JList;
import javax.swing.Popup;
import javax.swing.PopupFactory;
import javax.swing.SwingUtilities;

public class ListDataTip {
    private Popup mPopup = null;
    private ListTipCell mTipCell = null;

    ListDataTip(JList jList, ListTipCell listTipCell, Point point, Dimension dimension) {
        this.mTipCell = listTipCell;
        Rectangle rectangle = jList.getVisibleRect();
        Rectangle rectangle2 = rectangle.intersection(new Rectangle(point, dimension));
        rectangle2.translate(-point.x, -point.y);
        DataTip dataTip = new DataTip(listTipCell, rectangle2, jList.getBackground());
        Dimension dimension2 = new Dimension(dimension.width, dimension.height);
        Window window = SwingUtilities.getWindowAncestor(jList);
        GraphicsConfiguration graphicsConfiguration = window.getGraphicsConfiguration();
        Rectangle rectangle3 = graphicsConfiguration.getBounds();
        Point point2 = new Point(point.x, point.y);
        SwingUtilities.convertPointToScreen(point2, jList);
        Point point3 = new Point();
        point3.x = Math.max(point2.x, rectangle3.x);
        point3.y = Math.max(point2.y, rectangle3.y);
        dimension2.width = Math.min(rectangle3.x + rectangle3.width - point3.x, dimension2.width);
        dimension2.height = Math.min(rectangle3.y + rectangle3.height - point3.y, dimension2.height);
        SwingUtilities.convertPointFromScreen(point3, jList);
        dataTip.setPreferredSize(dimension2);
        SwingUtilities.convertPointToScreen(point, jList);
        this.mPopup = PopupFactory.getSharedInstance().getPopup(jList, dataTip, point.x, point.y);
        this.mPopup.show();
        Window window2 = SwingUtilities.windowForComponent(jList);
        Window window3 = SwingUtilities.windowForComponent(dataTip);
        boolean bl = window3 != null && window3 != window2;
        dataTip.setHeavyWeight(bl);
        if (bl) {
            DataTipController.getInstance().associateTip(jList, window3);
        }
    }

    ListTipCell getTipCell() {
        return this.mTipCell;
    }

    void hideTip() {
        if (this.mPopup != null) {
            this.mPopup.hide();
            this.mPopup = null;
            DataTipController.getInstance().associateTip(null, null);
        }
    }

    public boolean isTipVisible() {
        return this.mPopup != null;
    }
}

