/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.controls.data_tip;

import com.spss.java_client.core.common.ComponentState;
import com.spss.java_client.ui.controls.data_tip.ListTipListener;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.AWTEventListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseWheelEvent;
import java.io.Serializable;
import javax.swing.JList;
import javax.swing.SwingUtilities;

public class DataTipController {
    private static DataTipController sController = null;
    private JList mParentList = null;
    private Window mTipWnd = null;
    private MouseEvent mLastEvent = null;
    private ListTipListener mTipListener = new ListTipListener();

    public static synchronized DataTipController getInstance() {
        if (sController == null) {
            sController = new DataTipController();
        }
        return sController;
    }

    private DataTipController() {
        try {
            long l = 131120L;
            Toolkit.getDefaultToolkit().addAWTEventListener(new GlobalMouseListener(), l);
        }
        catch (Exception exception) {
            ComponentState.trace1((String)"Unpriviledged action in DataTipController()", (int)15);
            exception.printStackTrace();
        }
    }

    public synchronized void addDataTips(JList jList) {
        MouseListener[] mouseListenerArray;
        boolean bl = false;
        for (MouseListener mouseListener : mouseListenerArray = jList.getMouseListeners()) {
            if (mouseListener != this.mTipListener) continue;
            bl = true;
            break;
        }
        if (!bl) {
            jList.addMouseListener(this.mTipListener);
            jList.addMouseMotionListener(this.mTipListener);
            jList.addComponentListener(this.mTipListener);
        }
    }

    public void removeDataTips(JList jList) {
        jList.removeMouseListener(this.mTipListener);
        jList.removeMouseMotionListener(this.mTipListener);
        jList.removeComponentListener(this.mTipListener);
    }

    void associateTip(JList jList, Window window) {
        this.mParentList = jList;
        this.mTipWnd = window;
    }

    void processTipComponentEvent(MouseEvent mouseEvent) {
        mouseEvent.consume();
        int n = mouseEvent.getID();
        if (n != 504) {
            MouseEvent mouseEvent2;
            Serializable serializable;
            int n2 = mouseEvent.getX();
            int n3 = mouseEvent.getY();
            Point point = SwingUtilities.convertPoint(mouseEvent.getComponent(), n2, n3, this.mParentList);
            if (n == 505 && this.mParentList.contains(point)) {
                return;
            }
            long l = mouseEvent.getWhen();
            int n4 = mouseEvent.getModifiers();
            int n5 = mouseEvent.getClickCount();
            boolean bl = mouseEvent.isPopupTrigger();
            if (n == 507) {
                serializable = (MouseWheelEvent)mouseEvent;
                int n6 = ((MouseWheelEvent)serializable).getScrollType();
                int n7 = ((MouseWheelEvent)serializable).getScrollAmount();
                int n8 = ((MouseWheelEvent)serializable).getWheelRotation();
                mouseEvent2 = new MouseWheelEvent((Component)this.mParentList, n, l, n4, point.x, point.y, n5, bl, n6, n7, n8);
            } else {
                mouseEvent2 = new MouseEvent(this.mParentList, n, l, n4, point.x, point.y, n5, bl);
            }
            serializable = this.mParentList;
            this.mParentList.dispatchEvent(mouseEvent2);
            if (this.mParentList == null && n == 501) {
                MouseEvent mouseEvent3 = new MouseEvent((Component)serializable, 501, l, n4, point.x, point.y, n5, bl);
                ((Component)serializable).dispatchEvent(mouseEvent3);
                mouseEvent3 = new MouseEvent((Component)serializable, 502, l, n4, point.x, point.y, n5, bl);
                ((Component)serializable).dispatchEvent(mouseEvent3);
            }
            if (this.mTipWnd != null && n != 503) {
                this.mTipWnd.repaint();
            }
        }
    }

    private boolean processComponentEvent(MouseEvent mouseEvent) {
        Point point;
        if (mouseEvent == this.mLastEvent) {
            return false;
        }
        if (mouseEvent.getSource() != this.mParentList) {
            return false;
        }
        int n = mouseEvent.getID();
        int n2 = mouseEvent.getX();
        int n3 = mouseEvent.getY();
        long l = mouseEvent.getWhen();
        int n4 = mouseEvent.getModifiers();
        int n5 = mouseEvent.getClickCount();
        boolean bl = mouseEvent.isPopupTrigger();
        if (n == 505 && this.mTipWnd.contains(point = SwingUtilities.convertPoint(this.mParentList, n2, n3, this.mTipWnd))) {
            MouseEvent mouseEvent2 = new MouseEvent(this.mParentList, 503, l, n4, n2, n3, n5, bl);
            this.mParentList.dispatchEvent(mouseEvent2);
            return this.mParentList != null;
        }
        return false;
    }

    private class GlobalMouseListener
    implements AWTEventListener {
        private GlobalMouseListener() {
        }

        @Override
        public void eventDispatched(AWTEvent aWTEvent) {
            if (DataTipController.this.mTipWnd == null) {
                return;
            }
            if (aWTEvent.getSource() == DataTipController.this.mParentList) {
                MouseEvent mouseEvent = (MouseEvent)aWTEvent;
                if (DataTipController.this.processComponentEvent(mouseEvent)) {
                    mouseEvent.consume();
                } else {
                    DataTipController.this.mLastEvent = mouseEvent;
                }
            }
        }
    }
}

