/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.controls.data_tip;

import com.spss.java_client.ui.controls.data_tip.DataTipController;
import com.spss.java_client.ui.controls.data_tip.ListTipCell;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import javax.swing.CellRendererPane;
import javax.swing.JToolTip;

public class DataTip
extends JToolTip {
    private ListTipCell mTipCell;
    private CellRendererPane mRenderPane;
    private Rectangle mBorderlessBounds;
    private Color mBkndColor;
    private boolean mIsHeavyWeight;

    DataTip(ListTipCell listTipCell, Rectangle rectangle, Color color) {
        this.mTipCell = listTipCell;
        this.mBorderlessBounds = rectangle;
        this.mBkndColor = color;
        this.mRenderPane = new CellRendererPane();
        this.add(this.mRenderPane);
        this.setFocusable(false);
        this.setBorder(null);
        this.enableEvents(131120L);
    }

    @Override
    public void updateUI() {
    }

    @Override
    public boolean contains(int n, int n2) {
        return this.mIsHeavyWeight;
    }

    @Override
    protected void processMouseEvent(MouseEvent mouseEvent) {
        DataTipController.getInstance().processTipComponentEvent(mouseEvent);
    }

    @Override
    protected void processMouseMotionEvent(MouseEvent mouseEvent) {
        DataTipController.getInstance().processTipComponentEvent(mouseEvent);
    }

    @Override
    protected void processMouseWheelEvent(MouseWheelEvent mouseWheelEvent) {
        DataTipController.getInstance().processTipComponentEvent(mouseWheelEvent);
    }

    @Override
    public void paintComponent(Graphics graphics) {
        Component component = this.mTipCell.getCellRenderer();
        graphics.setColor(this.mBkndColor);
        int n = this.getWidth();
        int n2 = this.getHeight();
        graphics.fillRect(0, 0, n, n2);
        graphics.setColor(Color.black);
        graphics.drawRect(0, 0, n - 1, n2 - 1);
        if (this.mBorderlessBounds != null) {
            Shape shape = graphics.getClip();
            graphics.setClip(this.mBorderlessBounds);
            graphics.setColor(this.mBkndColor);
            graphics.fillRect(0, 0, n, n2);
            graphics.setClip(shape);
        }
        graphics.setClip(1, 1, n - 2, n2 - 2);
        this.mRenderPane.paintComponent(graphics, component, this, 0, 0, n, n2);
        graphics.setClip(this.mBorderlessBounds);
        this.mRenderPane.paintComponent(graphics, component, this, 0, 0, n, n2);
    }

    public void setHeavyWeight(boolean bl) {
        this.mIsHeavyWeight = bl;
    }
}

