/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.controls;

import com.spss.java_client.core.common.CommandLine;
import com.spss.java_client.core.common.ComponentState;
import com.spss.java_client.core.documents.data.dictionary.ISpssVariable;
import com.spss.java_client.ui.controls.VariableList;
import com.spss.java_client.ui.dialogs.common.DialogDataModel;
import java.awt.Color;
import java.awt.Component;
import java.awt.image.BufferedImage;
import java.text.Bidi;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.border.Border;

public class VarlistCellRenderer
extends JLabel
implements ListCellRenderer {
    private VariableList variableList;

    public VarlistCellRenderer(VariableList variableList) {
        this.variableList = variableList;
    }

    public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
        boolean bl3 = object instanceof ISpssVariable;
        boolean bl4 = this.variableList.getShowVarLabels();
        boolean bl5 = false;
        if (bl3) {
            ISpssVariable iSpssVariable = (ISpssVariable)object;
            this.setIcon(this.variableList.mShowIcon ? this.variableList.getIcon((ISpssVariable)object) : null);
            String string = iSpssVariable.getName();
            String string2 = iSpssVariable.getLabel();
            if (!ComponentState.isBtdRtlOrLtr()) {
                if (bl4 && string2.length() > 0) {
                    this.setText(string2 + " [" + string + "]");
                } else {
                    this.setText(string);
                }
            } else if (bl4 && string2.length() > 0) {
                this.setText(this.concatLabelNameForBidiDispaly(string2, string));
            } else {
                this.setText(this.concatLabelNameForBidiDispaly(null, string));
            }
            if (iSpssVariable.getId().isNull() && CommandLine.isClementineCaller() && !DialogDataModel.isSpecialVariable(iSpssVariable)) {
                bl5 = true;
            }
        } else {
            this.setText(object != null ? object.toString() : "");
        }
        if (jList.isEnabled()) {
            this.setOpaque(true);
            if (bl) {
                if (this.variableList.hasFocus()) {
                    this.setBackground(jList.getSelectionBackground());
                    this.setForeground(jList.getSelectionForeground());
                } else {
                    this.setBackground(Color.lightGray);
                    this.setForeground(Color.black);
                }
            } else {
                this.setBackground(jList.getBackground());
                this.setForeground(jList.getForeground());
            }
            if (bl5) {
                this.setForeground(Color.RED);
            }
        } else {
            this.setOpaque(false);
        }
        this.setEnabled(jList.isEnabled());
        this.setFont(jList.getFont());
        this.handleBorder(jList, bl2);
        return this;
    }

    private String concatLabelNameForBidiDispaly(String string, String string2) {
        String string3 = null;
        if (string == null && string2 == null) {
            return string3;
        }
        string3 = string != null && string.length() > 0 ? (ComponentState.getBTD() == 1 && !new Bidi(Character.toString(string.charAt(0)), 1).isRightToLeft() ? '\u200f' + string + " [" + string2 + "]" : (ComponentState.getBTD() == 2 && new Bidi(Character.toString(string.charAt(0)), 1).isRightToLeft() ? '\u200e' + string + " [" + string2 + "]" : string + " [" + string2 + "]")) : (ComponentState.getBTD() == 1 && !new Bidi(Character.toString(string2.charAt(0)), 1).isRightToLeft() ? '\u200f' + string2 : (ComponentState.getBTD() == 2 && new Bidi(Character.toString(string2.charAt(0)), 1).isRightToLeft() ? '\u200e' + string2 : string2));
        return string3;
    }

    private void handleBorder(JList jList, boolean bl) {
        if (VariableList.sNoFocusBorder == null || VariableList.sFocusBorder == null) {
            this.createBorders();
        }
        Border border = bl && jList.isEnabled() ? VariableList.sFocusBorder : VariableList.sNoFocusBorder;
        this.setBorder(border);
    }

    private void createBorders() {
        Border border = BorderFactory.createEmptyBorder(0, 2, 0, 0);
        Border border2 = UIManager.getBorder("List.focusCellHighlightBorder");
        VariableList.sFocusBorder = BorderFactory.createCompoundBorder(border2, border);
        border2 = BorderFactory.createEmptyBorder(1, 1, 1, 1);
        VariableList.sNoFocusBorder = BorderFactory.createCompoundBorder(border2, border);
    }

    private BufferedImage createTransparentImage(int n, int n2) {
        return new BufferedImage(n, n2, 2);
    }

    private Icon createTransparentIcon(int n, int n2) {
        return new ImageIcon(this.createTransparentImage(n, n2));
    }
}

