/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.controls;

import com.spss.java_client.core.documents.data.dictionary.ISpssVariable;
import com.spss.java_client.core.documents.data.dictionary.MeasurementLevel;
import com.spss.java_client.ui.controls.MeasurementLevelButtonType;
import com.spss.java_client.ui.controls.SpssButtonGroup;
import com.spss.java_client.ui.controls.SrcVariableList;
import com.spss.java_client.ui.controls.VarListModel;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.java_client.ui.resources.ResUtil;
import com.spss.uitools.dialogs.BaseDialog;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import java.net.URL;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;

public class VariableSelectorPanel
extends JPanel
implements ActionListener {
    public static final MeasurementLevelButtonType[] ALL_MEASUREMENT_BUTTONS = new MeasurementLevelButtonType[]{MeasurementLevelButtonType.ALL_BUTTONS, MeasurementLevelButtonType.ALL_NOMINALS, MeasurementLevelButtonType.ALL_ORDINALS, MeasurementLevelButtonType.ALL_RANGES, MeasurementLevelButtonType.NONE};
    protected BaseDialog mParent;
    protected SrcVariableList mVariableSrcList;
    protected JButton mSelectAllButton;
    protected JButton mSelectAllNominalsButton;
    protected JButton mSelectAllOrdinalsButton;
    protected JButton mSelectAllRangesButton;
    protected JButton mSelectNoneButton;
    private String mNominalToolTip;
    private String mOrdinalToolTip;
    private String mScaleToolTip;
    private SpssButtonGroup mSelectGroup;
    private MeasurementLevelButtonType[] mMeasurementButtonsToShow;

    public VariableSelectorPanel(SrcVariableList srcVariableList, BaseDialog baseDialog, boolean bl) {
        MeasurementLevelButtonType[] measurementLevelButtonTypeArray;
        this.mVariableSrcList = srcVariableList;
        this.mParent = baseDialog;
        if (bl) {
            measurementLevelButtonTypeArray = ALL_MEASUREMENT_BUTTONS;
        } else {
            MeasurementLevelButtonType[] measurementLevelButtonTypeArray2 = new MeasurementLevelButtonType[4];
            measurementLevelButtonTypeArray2[0] = MeasurementLevelButtonType.ALL_BUTTONS;
            measurementLevelButtonTypeArray2[1] = MeasurementLevelButtonType.ALL_NOMINALS;
            measurementLevelButtonTypeArray2[2] = MeasurementLevelButtonType.ALL_ORDINALS;
            measurementLevelButtonTypeArray = measurementLevelButtonTypeArray2;
            measurementLevelButtonTypeArray2[3] = MeasurementLevelButtonType.ALL_RANGES;
        }
        this.mMeasurementButtonsToShow = measurementLevelButtonTypeArray;
        this.initVars();
        this.createSelectorPanel();
        this.initTooltips();
    }

    public VariableSelectorPanel(SrcVariableList srcVariableList, BaseDialog baseDialog, MeasurementLevelButtonType[] measurementLevelButtonTypeArray) {
        this.mVariableSrcList = srcVariableList;
        this.mParent = baseDialog;
        this.mMeasurementButtonsToShow = measurementLevelButtonTypeArray != null ? measurementLevelButtonTypeArray : ALL_MEASUREMENT_BUTTONS;
        this.initVars();
        this.createSelectorPanel();
        this.initTooltips();
    }

    private void initTooltips() {
        this.mSelectAllNominalsButton.setToolTipText(this.mNominalToolTip);
        this.mSelectAllOrdinalsButton.setToolTipText(this.mOrdinalToolTip);
        this.mSelectAllRangesButton.setToolTipText(this.mScaleToolTip);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (this.doMeasurementButtonType(MeasurementLevelButtonType.ALL_NOMINALS) && object == this.mSelectAllNominalsButton) {
            this.selectFields(MeasurementLevel.nominal, false);
        } else if (this.doMeasurementButtonType(MeasurementLevelButtonType.ALL_ORDINALS) && object == this.mSelectAllOrdinalsButton) {
            this.selectFields(MeasurementLevel.ordinal, false);
        } else if (this.doMeasurementButtonType(MeasurementLevelButtonType.ALL_RANGES) && object == this.mSelectAllRangesButton) {
            this.selectFields(MeasurementLevel.scale, false);
        } else if (this.doMeasurementButtonType(MeasurementLevelButtonType.ALL_BUTTONS) && object == this.mSelectAllButton) {
            this.selectFields(MeasurementLevel.unknown, true);
        } else if (this.doMeasurementButtonType(MeasurementLevelButtonType.NONE) && object == this.mSelectNoneButton) {
            this.mVariableSrcList.clearSelection();
        }
    }

    private boolean doMeasurementButtonType(MeasurementLevelButtonType measurementLevelButtonType) {
        boolean bl = false;
        for (MeasurementLevelButtonType measurementLevelButtonType2 : this.mMeasurementButtonsToShow) {
            if (measurementLevelButtonType2 != measurementLevelButtonType) continue;
            bl = true;
            break;
        }
        return bl;
    }

    public Vector<Object> getTabTraversalComponent() {
        Vector<Object> vector = new Vector<Object>();
        if (this.doMeasurementButtonType(MeasurementLevelButtonType.ALL_BUTTONS)) {
            vector.add(this.mSelectAllButton);
        }
        if (this.doMeasurementButtonType(MeasurementLevelButtonType.ALL_NOMINALS)) {
            vector.add(this.mSelectAllNominalsButton);
        }
        if (this.doMeasurementButtonType(MeasurementLevelButtonType.ALL_ORDINALS)) {
            vector.add(this.mSelectAllOrdinalsButton);
        }
        if (this.doMeasurementButtonType(MeasurementLevelButtonType.ALL_RANGES)) {
            vector.add(this.mSelectAllRangesButton);
        }
        if (this.doMeasurementButtonType(MeasurementLevelButtonType.NONE)) {
            vector.add(this.mSelectNoneButton);
        }
        return vector;
    }

    private void initVars() {
        Serializable serializable;
        this.mSelectGroup = new SpssButtonGroup();
        if (this.doMeasurementButtonType(MeasurementLevelButtonType.ALL_BUTTONS)) {
            serializable = new ToggleButtonAction("IDS_SOURCE_MEASURE_ALL");
            this.mSelectAllButton = new JButton((Action)((Object)serializable));
            this.mSelectAllButton.addActionListener(this);
            this.mSelectGroup.add(this.mSelectAllButton);
        }
        if (this.doMeasurementButtonType(MeasurementLevelButtonType.ALL_NOMINALS)) {
            serializable = ResUtil.getCommonDlgImageResource(ResUtil.getCommonDlgString("IDS_NOMINAL_VAR_IMAGE"));
            this.mSelectAllNominalsButton = DialogUtil.createButton(this.mParent, "", null);
            if (serializable != null) {
                this.mSelectAllNominalsButton.setIcon(new ImageIcon((URL)serializable));
            }
            this.mSelectAllNominalsButton.addActionListener(this);
            this.mSelectGroup.add(this.mSelectAllNominalsButton);
        }
        if (this.doMeasurementButtonType(MeasurementLevelButtonType.ALL_ORDINALS)) {
            serializable = ResUtil.getCommonDlgImageResource(ResUtil.getCommonDlgString("IDS_ORDINAL_VAR_IMAGE"));
            this.mSelectAllOrdinalsButton = DialogUtil.createButton(this.mParent, "", null);
            if (serializable != null) {
                this.mSelectAllOrdinalsButton.setIcon(new ImageIcon((URL)serializable));
            }
            this.mSelectAllOrdinalsButton.addActionListener(this);
            this.mSelectGroup.add(this.mSelectAllOrdinalsButton);
        }
        if (this.doMeasurementButtonType(MeasurementLevelButtonType.ALL_RANGES)) {
            serializable = ResUtil.getCommonDlgImageResource(ResUtil.getCommonDlgString("IDS_SCALE_VAR_IMAGE"));
            this.mSelectAllRangesButton = DialogUtil.createButton(this.mParent, "", null);
            if (serializable != null) {
                this.mSelectAllRangesButton.setIcon(new ImageIcon((URL)serializable));
            }
            this.mSelectAllRangesButton.addActionListener(this);
            this.mSelectGroup.add(this.mSelectAllRangesButton);
        }
        if (this.doMeasurementButtonType(MeasurementLevelButtonType.NONE)) {
            serializable = new ToggleButtonAction("IDS_SOURCE_SELECT_NONE");
            this.mSelectNoneButton = new JButton((Action)((Object)serializable));
            this.mSelectNoneButton.addActionListener(this);
            this.mSelectGroup.add(this.mSelectNoneButton);
        }
        this.mNominalToolTip = ResUtil.getCommonDlgString("IDS_SOURCE_MEASURE_NOMINAL_TOOLTIP");
        this.mOrdinalToolTip = ResUtil.getCommonDlgString("IDS_SOURCE_MEASURE_ORDINAL_TOOLTIP");
        this.mScaleToolTip = ResUtil.getCommonDlgString("IDS_SOURCE_MEASURE_SCALE_TOOLTIP");
    }

    private void selectFields(MeasurementLevel measurementLevel, boolean bl) {
        this.mVariableSrcList.clearSelection();
        int n = -1;
        VarListModel varListModel = this.mVariableSrcList.getModel();
        for (int i = varListModel.getSize() - 1; i >= 0; --i) {
            ISpssVariable iSpssVariable = varListModel.getElementAt(i);
            if (iSpssVariable.getMeasurementLevel() != measurementLevel && !bl) continue;
            this.mVariableSrcList.addSelectionInterval(i, i);
            if (i >= varListModel.getSize()) continue;
            n = i;
        }
        if (n > 0) {
            this.mVariableSrcList.requestFocusInWindow();
            this.mVariableSrcList.scrollRectToVisible(this.mVariableSrcList.getCellBounds(n, n));
        }
    }

    protected void createSelectorPanel() {
        this.setLayout(new FlowLayout(0));
        if (this.doMeasurementButtonType(MeasurementLevelButtonType.ALL_BUTTONS)) {
            this.add(this.mSelectAllButton);
        }
        if (this.doMeasurementButtonType(MeasurementLevelButtonType.ALL_NOMINALS)) {
            this.add(this.mSelectAllNominalsButton);
        }
        if (this.doMeasurementButtonType(MeasurementLevelButtonType.ALL_ORDINALS)) {
            this.add(this.mSelectAllOrdinalsButton);
        }
        if (this.doMeasurementButtonType(MeasurementLevelButtonType.ALL_RANGES)) {
            this.add(this.mSelectAllRangesButton);
        }
        if (this.doMeasurementButtonType(MeasurementLevelButtonType.NONE)) {
            this.add(this.mSelectNoneButton);
        }
        this.setBorder(new TitledBorder(""));
    }

    @Override
    public void setEnabled(boolean bl) {
        if (this.mSelectAllButton != null) {
            this.mSelectAllButton.setEnabled(bl);
        }
        if (this.mSelectAllNominalsButton != null) {
            this.mSelectAllNominalsButton.setEnabled(bl);
        }
        if (this.mSelectAllOrdinalsButton != null) {
            this.mSelectAllOrdinalsButton.setEnabled(bl);
        }
        if (this.mSelectAllRangesButton != null) {
            this.mSelectAllRangesButton.setEnabled(bl);
        }
        if (this.mSelectNoneButton != null) {
            this.mSelectNoneButton.setEnabled(bl);
        }
    }
}

