/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.controls;

import com.spss.java_client.core.common.ComponentState;
import com.spss.java_client.core.common.LocallyUniqueId;
import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.core.documents.data.DataMgr;
import com.spss.java_client.core.documents.data.dictionary.FormatType;
import com.spss.java_client.core.documents.data.dictionary.ISpssDataSrc;
import com.spss.java_client.core.documents.data.dictionary.ISpssVariable;
import com.spss.java_client.core.documents.data.dictionary.MeasurementLevel;
import com.spss.java_client.core.documents.data.dictionary.SpssCalculatedScaleVar;
import com.spss.java_client.core.documents.data.dictionary.SpssCovariateVariable;
import com.spss.java_client.core.documents.data.dictionary.SpssFactorVariable;
import com.spss.java_client.core.documents.data.dictionary.SpssMRVariable;
import com.spss.java_client.core.documents.data.dictionary.SpssRandomVariable;
import com.spss.java_client.core.documents.data.dictionary.SpssVariableSortType;
import com.spss.java_client.core.documents.data.dictionary.TimeDependentPredictors;
import com.spss.java_client.ui.controls.BaseDataList;
import com.spss.java_client.ui.controls.FocusHighlighter;
import com.spss.java_client.ui.controls.IDoubleClickListener;
import com.spss.java_client.ui.controls.IVarFilter;
import com.spss.java_client.ui.controls.VarListModel;
import com.spss.java_client.ui.controls.VarlistCellRenderer;
import com.spss.java_client.ui.dialogs.common.BaseProcedureDialog;
import com.spss.java_client.ui.dialogs.common.BaseSpssDialog;
import com.spss.java_client.ui.dialogs.common.BaseSubDialog;
import com.spss.java_client.ui.dialogs.common.BaseWizardDialog;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.ProcedureDlgMgr;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.dialogs.common.VariableInfoWindow;
import com.spss.java_client.ui.resources.ResUtil;
import com.spss.shared.core_tools.system.OSInfo;
import com.spss.uitools.dialogs.BaseDialog;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.ListModel;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;

public class VariableList
extends BaseDataList
implements PopupMenuListener {
    public static final int CONTEXT_MENU_VARIABLE_INFO = 1;
    public static final int CONTEXT_MENU_NAMES_LABELS = 2;
    public static final int CONTEXT_MENU_ITEM_SORT = 4;
    public static final int CONTEXT_MENU_MEASUREMENT_LEVEL = 8;
    protected static final int NUM_VAR_ICONS = 18;
    protected static final int MIN_LIST_ITEM_HEIGHT = 18;
    protected static Icon[] sVarIcons = new Icon[18];
    protected static Border sNoFocusBorder;
    protected static Border sFocusBorder;
    protected static HashMap<VariableList, VariableInfoWindow> sVarInfoDlgMap;
    public Vector<IVarFilter> mVarFilters;
    protected String mIdentifier;
    protected JPopupMenu mContextMenu;
    protected int mContextMenuFlags;
    protected VariableInfoAction mVarInfoAction;
    protected VarMoveType mDragType;
    protected int mDropFeedbackIndex;
    protected boolean mLockSelections;
    protected FocusHighlighter mFocusHighlighter;
    protected ContextEventListener mContextEventListener;
    protected SelectionAdapter mSelectionListener;
    protected boolean mShowIcon;
    protected boolean mLockTextDisplay;
    protected NamesLabelsAction mNamesAction;
    protected NamesLabelsAction mLabelsAction;
    protected ListSortAction mAlphaSortAction;
    protected ListSortAction mFileSortAction;
    protected ListSortAction mMeasurementSortAction;
    protected ItemMeasurementAction mOrdinalAction;
    protected ItemMeasurementAction mNominalAction;
    protected ItemMeasurementAction mScaleAction;
    protected JRadioButtonMenuItem mNamesItem;
    protected JRadioButtonMenuItem mLabelsItem;
    protected JRadioButtonMenuItem mAlphaSortItem;
    protected JRadioButtonMenuItem mFileSortItem;
    protected JRadioButtonMenuItem mMeasSortItem;
    protected JRadioButtonMenuItem mNominalItem;
    protected JRadioButtonMenuItem mOrdinalItem;
    protected JRadioButtonMenuItem mScaleItem;
    protected Component[] mAdditionalMenuItems;
    private boolean mLoadFromPersistent;
    private Vector<IDoubleClickListener> mDoubleClickListener;
    private boolean mDoubleClickEnabled;
    private boolean mDragSupported;
    public int mMaxLimitOfList;
    private VarlistCellRenderer mVarlistCellRenderer;

    public VariableList() {
        this(null, VarMoveType.eDoNothing);
    }

    public VariableList(VarMoveType varMoveType) {
        this(null, varMoveType);
    }

    public VariableList(VarListModel varListModel, VarMoveType varMoveType) {
        varListModel = varListModel == null ? new VarListModel(null) : varListModel;
        super((ListModel)varListModel);
        this.mVarFilters = new Vector(1);
        this.mIdentifier = "VarList";
        this.mContextMenu = null;
        this.mContextMenuFlags = 0;
        this.mVarInfoAction = null;
        this.mDragType = VarMoveType.eDoNothing;
        this.mDropFeedbackIndex = -1;
        this.mLockSelections = false;
        this.mFocusHighlighter = new FocusHighlighter(this);
        this.mContextEventListener = new ContextEventListener();
        this.mSelectionListener = new SelectionAdapter();
        this.mShowIcon = true;
        this.mLockTextDisplay = false;
        this.mNamesAction = null;
        this.mLabelsAction = null;
        this.mAlphaSortAction = null;
        this.mFileSortAction = null;
        this.mMeasurementSortAction = null;
        this.mOrdinalAction = null;
        this.mNominalAction = null;
        this.mScaleAction = null;
        this.mNamesItem = null;
        this.mLabelsItem = null;
        this.mAlphaSortItem = null;
        this.mFileSortItem = null;
        this.mMeasSortItem = null;
        this.mNominalItem = null;
        this.mOrdinalItem = null;
        this.mScaleItem = null;
        this.mAdditionalMenuItems = null;
        this.mLoadFromPersistent = true;
        this.mDoubleClickListener = new Vector();
        this.mDoubleClickEnabled = true;
        this.mDragSupported = true;
        this.mMaxLimitOfList = -1;
        this.init(varListModel);
        this.setDragType(varMoveType);
        this.addMouseListener(new DoubleClickHandler());
        Dimension dimension = new Dimension(DialogUtil.getVarListWidth(), 10);
        this.setMinimumSize(dimension);
    }

    @Override
    public void setEnabled(boolean bl) {
        JViewport jViewport;
        Container container;
        super.setEnabled(bl);
        this.setOpaque(bl);
        Container container2 = this.getParent();
        if (container2 instanceof JViewport && (container = (jViewport = (JViewport)container2).getParent()) instanceof JScrollPane) {
            JScrollPane jScrollPane = (JScrollPane)container;
            jScrollPane.getVerticalScrollBar().setEnabled(bl);
            jScrollPane.getHorizontalScrollBar().setEnabled(bl);
            jScrollPane.setWheelScrollingEnabled(bl);
        }
    }

    @Override
    public void setSelectedIndex(int n) {
        super.setSelectedIndex(n);
        this.ensureIndexIsVisible(n);
    }

    public String getIdentifier() {
        return this.mIdentifier;
    }

    public void setIdentifier(String string) {
        this.mIdentifier = string;
    }

    public void addVarFilter(IVarFilter iVarFilter) {
        this.mVarFilters.add(iVarFilter);
    }

    public void removeVarFilter(IVarFilter iVarFilter) {
        this.mVarFilters.remove(iVarFilter);
    }

    public void removeAllVarFilters() {
        if (this.mVarFilters != null) {
            this.mVarFilters.removeAllElements();
        }
    }

    public boolean canIncludeVariable(ISpssVariable iSpssVariable) {
        for (IVarFilter iVarFilter : this.mVarFilters) {
            if (iVarFilter == null || iVarFilter.canIncludeVariable(iSpssVariable)) continue;
            return false;
        }
        return true;
    }

    public final VarMoveType getDragType() {
        return this.mDragType;
    }

    public void setDragType(VarMoveType varMoveType) {
        this.mDragType = varMoveType;
        this.setDragEnabled(false);
    }

    public void setDragSupported(boolean bl) {
        this.mDragSupported = bl;
    }

    public boolean isDragSupported() {
        return this.mDragSupported;
    }

    public VarListModel getModel() {
        return (VarListModel)super.getModel();
    }

    public void setSelection(ISpssVariable[] iSpssVariableArray) {
        this.setSelection(iSpssVariableArray, false);
    }

    public void setSelection(ISpssVariable[] iSpssVariableArray, boolean bl) {
        this.clearSelection();
        int n = -1;
        VarListModel varListModel = this.getModel();
        for (ISpssVariable iSpssVariable : iSpssVariableArray) {
            int n2;
            Integer[] integerArray = bl ? varListModel.findElementIndexesByName(iSpssVariable.getName()) : ((n2 = varListModel.findElementIndex(iSpssVariable)) > -1 ? new Integer[]{n2} : new Integer[]{});
            Integer[] integerArray2 = integerArray;
            int n3 = integerArray2.length;
            for (int i = 0; i < n3; ++i) {
                int n4 = integerArray2[i];
                this.addSelectionInterval(n4, n4);
                if (n != -1) continue;
                n = n4;
            }
        }
        if (n > -1) {
            this.ensureIndexIsVisible(n);
        }
    }

    public int getContextMenuFlags() {
        return this.mContextMenuFlags;
    }

    public void setContextMenuFlags(int n) {
        this.mContextMenuFlags = n;
    }

    public JPopupMenu getContextMenu(int[] nArray) {
        boolean bl;
        if (nArray == null || nArray.length == 0) {
            return null;
        }
        if (this.mContextMenu == null || this.mVarInfoAction == null) {
            this.mContextMenu = this.buildPopupMenu();
        }
        if (this.mContextMenu == null) {
            return null;
        }
        int n = this.getContextMenuFlags();
        boolean bl2 = (n & 2) != 0;
        boolean bl3 = (n & 4) != 0;
        boolean bl4 = (n & 1) != 0;
        boolean bl5 = bl = (n & 8) != 0;
        if (bl4) {
            this.mVarInfoAction.setItemIndex(nArray[0]);
        }
        if (bl) {
            this.mNominalAction.setItemIndices(nArray);
            this.mOrdinalAction.setItemIndices(nArray);
            this.mScaleAction.setItemIndices(nArray);
        }
        if (bl2) {
            this.mLabelsItem.setSelected(this.getShowVarLabels());
            this.mNamesItem.setSelected(!this.getShowVarLabels());
        }
        if (bl3) {
            SpssVariableSortType spssVariableSortType = this.getModel().getSortType();
            this.mAlphaSortItem.setSelected(spssVariableSortType.equals((Object)SpssVariableSortType.alpha));
            this.mFileSortItem.setSelected(spssVariableSortType.equals((Object)SpssVariableSortType.file));
            this.mMeasSortItem.setSelected(spssVariableSortType.equals((Object)SpssVariableSortType.measurement));
        }
        boolean bl6 = true;
        boolean bl7 = true;
        if (bl) {
            ISpssVariable iSpssVariable = nArray.length > 0 ? this.getModel().getElementAt(nArray[0]) : null;
            MeasurementLevel measurementLevel = iSpssVariable == null ? MeasurementLevel.unknown : iSpssVariable.getDisplayMeasurementLevel();
            for (int n2 : nArray) {
                MeasurementLevel measurementLevel2;
                boolean bl8;
                boolean bl9 = bl8 = n2 > -1 && n2 < this.getModel().getSize();
                if (!bl8) continue;
                iSpssVariable = this.getModel().getElementAt(n2);
                if (iSpssVariable.getType() > 0) {
                    bl6 = false;
                }
                if (iSpssVariable instanceof SpssMRVariable) {
                    bl7 = false;
                    bl6 = false;
                }
                if (measurementLevel.equals((Object)(measurementLevel2 = iSpssVariable.getDisplayMeasurementLevel()))) continue;
                measurementLevel = MeasurementLevel.unknown;
                break;
            }
            this.mNominalItem.setSelected(measurementLevel.equals((Object)MeasurementLevel.nominal));
            this.mOrdinalItem.setSelected(measurementLevel.equals((Object)MeasurementLevel.ordinal));
            this.mScaleItem.setSelected(measurementLevel.equals((Object)MeasurementLevel.scale));
        }
        if (bl2) {
            this.mNamesAction.setEnabled(!this.getLockItemDisplay());
            this.mLabelsAction.setEnabled(!this.getLockItemDisplay());
        }
        if (bl3) {
            this.mAlphaSortAction.setEnabled(!this.getLockItemDisplay());
            this.mFileSortAction.setEnabled(!this.getLockItemDisplay());
            this.mMeasurementSortAction.setEnabled(!this.getLockItemDisplay());
        }
        if (bl4) {
            this.mVarInfoAction.setEnabled(nArray.length == 1);
        }
        if (bl) {
            this.mNominalAction.setEnabled(!this.getLockItemDisplay());
            this.mOrdinalAction.setEnabled(bl7 && !this.getLockItemDisplay());
            this.mScaleAction.setEnabled(bl6 && !this.getLockItemDisplay());
        }
        return this.mContextMenu;
    }

    public Icon getIcon(ISpssVariable iSpssVariable) {
        Icon icon = iSpssVariable.getCustomIcon();
        return icon != null ? icon : VariableList.getStandardIcon(iSpssVariable);
    }

    public static Icon getStandardIcon(ISpssVariable iSpssVariable) {
        Icon icon = null;
        if (iSpssVariable instanceof SpssFactorVariable) {
            icon = sVarIcons[VarImage.eFactor.ordinal()];
        } else if (iSpssVariable instanceof SpssCalculatedScaleVar) {
            icon = sVarIcons[VarImage.eCalculatedScale.ordinal()];
        } else if (iSpssVariable instanceof SpssCovariateVariable) {
            icon = sVarIcons[VarImage.eCovariate.ordinal()];
        } else if (iSpssVariable instanceof SpssRandomVariable) {
            icon = sVarIcons[VarImage.eRandom.ordinal()];
        } else if (iSpssVariable instanceof SpssMRVariable) {
            icon = ((SpssMRVariable)iSpssVariable).getMRVarType().equals((Object)SpssMRVariable.MRVarType.categories) ? sVarIcons[VarImage.eMCSetIdx.ordinal()] : sVarIcons[VarImage.eMDSetIdx.ordinal()];
        } else if (iSpssVariable instanceof TimeDependentPredictors) {
            icon = sVarIcons[VarImage.eTimeDependentIdx.ordinal()];
        } else {
            MeasurementLevel measurementLevel = iSpssVariable.getDisplayMeasurementLevel();
            FormatType formatType = iSpssVariable.getFormat().getFormatType();
            icon = formatType.equals((Object)FormatType.A) ? (measurementLevel.equals((Object)MeasurementLevel.ordinal) ? sVarIcons[VarImage.eStringOrdinalIdx.ordinal()] : (measurementLevel.equals((Object)MeasurementLevel.nominal) ? sVarIcons[VarImage.eStringNominalIdx.ordinal()] : sVarIcons[VarImage.eScaleIdx.ordinal()])) : (formatType.equals((Object)FormatType.DATE) || formatType.equals((Object)FormatType.ADATE) || formatType.equals((Object)FormatType.EDATE) || formatType.equals((Object)FormatType.JDATE) || formatType.equals((Object)FormatType.SDATE) || formatType.equals((Object)FormatType.QYR) || formatType.equals((Object)FormatType.MOYR) || formatType.equals((Object)FormatType.WKYR) ? (measurementLevel.equals((Object)MeasurementLevel.ordinal) ? sVarIcons[VarImage.eDateOrdinalIdx.ordinal()] : (measurementLevel.equals((Object)MeasurementLevel.nominal) ? sVarIcons[VarImage.eDateNominalIdx.ordinal()] : sVarIcons[VarImage.eDateScaleIdx.ordinal()])) : (formatType.equals((Object)FormatType.TIME) || formatType.equals((Object)FormatType.DTIME) || formatType.equals((Object)FormatType.DATETIME) || formatType.equals((Object)FormatType.MTIME) || formatType.equals((Object)FormatType.YMDHMS) ? (measurementLevel.equals((Object)MeasurementLevel.ordinal) ? sVarIcons[VarImage.eTimeOrdinalIdx.ordinal()] : (measurementLevel.equals((Object)MeasurementLevel.nominal) ? sVarIcons[VarImage.eTimeNominalIdx.ordinal()] : sVarIcons[VarImage.eTimeScaleIdx.ordinal()])) : (measurementLevel.equals((Object)MeasurementLevel.ordinal) ? (iSpssVariable.getType() > 0 ? sVarIcons[VarImage.eStringOrdinalIdx.ordinal()] : sVarIcons[VarImage.eOrdinalIdx.ordinal()]) : (measurementLevel.equals((Object)MeasurementLevel.nominal) ? (iSpssVariable.getType() > 0 ? sVarIcons[VarImage.eStringNominalIdx.ordinal()] : sVarIcons[VarImage.eNominalIdx.ordinal()]) : sVarIcons[VarImage.eScaleIdx.ordinal()]))));
        }
        return icon;
    }

    public ArrayList<ISpssVariable> getAllVariables() {
        ArrayList<ISpssVariable> arrayList = new ArrayList<ISpssVariable>();
        for (int i = 0; i < this.getModel().getSize(); ++i) {
            arrayList.add(this.getModel().getElementAt(i));
        }
        return arrayList;
    }

    public ISpssVariable[] getSelectedValues() {
        ListSelectionModel listSelectionModel = this.getSelectionModel();
        VarListModel varListModel = this.getModel();
        int n = listSelectionModel.getMinSelectionIndex();
        int n2 = listSelectionModel.getMaxSelectionIndex();
        if (n2 >= varListModel.getSize()) {
            n2 = varListModel.getSize() - 1;
        }
        if (n < 0 || n2 < 0) {
            return new ISpssVariable[0];
        }
        if (n > n2) {
            int n3 = n;
            n = n2;
            n2 = n3;
        }
        ISpssVariable[] iSpssVariableArray = new ISpssVariable[1 + (n2 - n)];
        int n4 = 0;
        for (int i = n; i <= n2 && i < varListModel.getSize(); ++i) {
            if (!listSelectionModel.isSelectedIndex(i)) continue;
            iSpssVariableArray[n4++] = (ISpssVariable)varListModel.getElementAt(i);
        }
        ISpssVariable[] iSpssVariableArray2 = new ISpssVariable[n4];
        System.arraycopy(iSpssVariableArray, 0, iSpssVariableArray2, 0, n4);
        return iSpssVariableArray2;
    }

    @Override
    public void removeAll() {
        this.getModel().removeAll();
        this.repaint();
    }

    @Override
    public void setSelectionInterval(int n, int n2) {
        if (this.mLockSelections) {
            return;
        }
        super.setSelectionInterval(n, n2);
    }

    @Override
    public void addSelectionInterval(int n, int n2) {
        if (this.mLockSelections) {
            return;
        }
        super.addSelectionInterval(n, n2);
    }

    @Override
    public void removeSelectionInterval(int n, int n2) {
        if (this.mLockSelections) {
            return;
        }
        super.removeSelectionInterval(n, n2);
    }

    public void setShowIcon(boolean bl) {
        this.mShowIcon = bl;
        if (this.isVisible()) {
            this.repaint();
        }
    }

    public boolean getShowIcon() {
        return this.mShowIcon;
    }

    public void setSortType(SpssVariableSortType spssVariableSortType) {
        this.getModel().setSortType(spssVariableSortType);
        if (this.isVisible()) {
            this.repaint();
        }
    }

    public SpssVariableSortType getSortType() {
        return this.getModel().getSortType();
    }

    public void setShowVarLabels(boolean bl, boolean bl2) {
        ISpssVariable iSpssVariable = null;
        int n = this.getLeadSelectionIndex();
        if (n > -1 && n < this.getModel().getSize()) {
            iSpssVariable = this.getModel().getElementAt(n);
        }
        this.getModel().setShowVarLabels(bl);
        this.mLockTextDisplay = bl2;
        if (this.isVisible()) {
            if (iSpssVariable != null) {
                this.ensureIndexIsVisible(this.getModel().findElementIndex(iSpssVariable));
            }
            this.repaint();
        }
    }

    public boolean containsAll(List list) {
        return this.getModel().containsAll(list);
    }

    public boolean getShowVarLabels() {
        return this.getModel().getShowVarLabels();
    }

    public boolean getLockItemDisplay() {
        return this.mLockTextDisplay;
    }

    public boolean getLockSelections() {
        return this.mLockSelections;
    }

    public void setLockSelections(boolean bl) {
        this.mLockSelections = bl;
    }

    public void showDropFeedback(Point point) {
        if (point != null && this.getModel().getSize() > 0) {
            int n = this.locationToIndex(point);
            if (!this.itemInUpperHalf(point)) {
                ++n;
            }
            if (n > -1) {
                if (n != this.mDropFeedbackIndex && this.mDropFeedbackIndex > -1) {
                    this.renderDropLine(this.mDropFeedbackIndex, false);
                }
                this.renderDropLine(n, true);
                this.mDropFeedbackIndex = n;
            }
        } else if (this.mDropFeedbackIndex > -1) {
            this.renderDropLine(this.mDropFeedbackIndex, false);
            this.mDropFeedbackIndex = -1;
        }
    }

    public int getDropFeedbackIndex() {
        return this.mDropFeedbackIndex;
    }

    public boolean itemInUpperHalf(Point point) {
        Rectangle rectangle;
        int n = this.locationToIndex(point);
        if (n > -1 && (rectangle = this.getCellBounds(n, n)).contains(point)) {
            int n2 = (int)(rectangle.getMinY() + rectangle.getHeight() / 2.0);
            return n2 > point.y;
        }
        return false;
    }

    public TransferData getTransferData() {
        ISpssVariable[] iSpssVariableArray = this.getSelectedValues();
        int[] nArray = this.getSelectedIndices();
        return new TransferData(iSpssVariableArray, nArray);
    }

    @Override
    public void updateUI() {
        this.removeFocusListener(this.mFocusHighlighter);
        this.removeListSelectionListener(this.mSelectionListener);
        this.removeMouseListener(this.mContextEventListener);
        this.removeKeyListener(this.mContextEventListener);
        super.updateUI();
        this.addMouseListener(this.mContextEventListener);
        this.addKeyListener(this.mContextEventListener);
        this.addFocusListener(this.mFocusHighlighter);
        this.addListSelectionListener(this.mSelectionListener);
    }

    public static void clearBorders() {
        FocusHighlighter.sTargetBorder = null;
        sFocusBorder = null;
        sNoFocusBorder = null;
    }

    public boolean isLoadFromPersistent() {
        return this.mLoadFromPersistent;
    }

    public void setLoadFromPersistent(boolean bl) {
        this.mLoadFromPersistent = bl;
    }

    public int getMaxLimitOfList() {
        return this.mMaxLimitOfList;
    }

    public void setMaxLimitOfList(int n) {
        this.mMaxLimitOfList = n;
    }

    public FocusHighlighter getFocusHighlighter() {
        return this.mFocusHighlighter;
    }

    public void addDoubleClickListener(IDoubleClickListener iDoubleClickListener) {
        if (iDoubleClickListener == null || this.mDoubleClickListener.contains(iDoubleClickListener)) {
            return;
        }
        this.mDoubleClickListener.add(iDoubleClickListener);
    }

    public void removeDoubleClickListener(IDoubleClickListener iDoubleClickListener) {
        if (iDoubleClickListener == null || !this.mDoubleClickListener.contains(iDoubleClickListener)) {
            return;
        }
        this.mDoubleClickListener.remove(iDoubleClickListener);
    }

    public void setDoubleClickEnabled(boolean bl) {
        this.mDoubleClickEnabled = bl;
    }

    public void setAdditonalMenuItems(Component[] componentArray) {
        this.mAdditionalMenuItems = componentArray;
    }

    @Override
    public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
    }

    @Override
    public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
    }

    @Override
    public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
    }

    protected void init(VarListModel varListModel) {
        varListModel.setVarListCtrl(this);
        this.mVarlistCellRenderer = new VarlistCellRenderer(this);
        this.setCellRenderer(this.mVarlistCellRenderer);
        this.setPrototypeCellValue("123-45-6789");
        int n = this.getFixedCellHeight();
        n = n < 18 ? 18 : n;
        this.setFixedCellHeight(n);
        this.updateUI();
    }

    protected void renderDropLine(int n, boolean bl) {
        boolean bl2 = n >= this.getModel().getSize();
        int n2 = !bl2 ? n : this.getModel().getSize() - 1;
        Rectangle rectangle = this.getCellBounds(n2, n2);
        int n3 = 0;
        if (rectangle != null) {
            n3 = (int)(bl2 ? rectangle.getY() + rectangle.getHeight() : rectangle.getY());
        }
        Graphics graphics = this.getGraphics();
        Color color = this.isSelectedIndex(n) ? this.getSelectionBackground() : this.getBackground();
        graphics.setColor(bl ? Color.red : color);
        graphics.drawLine(0, n3, this.getWidth(), n3);
        graphics.dispose();
    }

    protected static void loadImageIcons() {
        if (sVarIcons[0] != null && sVarIcons[17] != null) {
            return;
        }
        String[] stringArray = new String[]{"IDS_SCALE_VAR_IMAGE", "IDS_ORDINAL_VAR_IMAGE", "IDS_NOMINAL_VAR_IMAGE", "IDS_ORDINAL_STRING_VAR_IMAGE", "IDS_NOMINAL_STRING_VAR_IMAGE", "IDS_SCALE_DATE_VAR_IMAGE", "IDS_ORDINAL_DATE_VAR_IMAGE", "IDS_NOMINAL_DATE_VAR_IMAGE", "IDS_SCALE_TIME_VAR_IMAGE", "IDS_ORDINAL_TIME_VAR_IMAGE", "IDS_NOMINAL_TIME_VAR_IMAGE", "IDS_MC_SET_VAR_IMAGE", "IDS_MD_SET_VAR_IMAGE", "IDS_CALCULATED_SCALE_VAR_IMAGE", "IDS_FACTOR_IMAGE", "IDS_COVARIATE_IMAGE", "IDS_RANDOM_IMAGE", "IDS_TIME_DEPENDENT_VAR_IMAGE"};
        for (int i = 0; i < 18; ++i) {
            String string = ResUtil.getCommonDlgString(stringArray[i]);
            URL uRL = ResUtil.getCommonDlgImageResource(string);
            VariableList.sVarIcons[i] = new ImageIcon(uRL);
        }
    }

    protected JPopupMenu buildPopupMenu() {
        int n = this.getContextMenuFlags();
        if (n == 0) {
            return null;
        }
        JPopupMenu jPopupMenu = new JPopupMenu();
        this.mNamesAction = new NamesLabelsAction(true);
        this.mLabelsAction = new NamesLabelsAction(false);
        this.mAlphaSortAction = new ListSortAction(SpssVariableSortType.alpha);
        this.mFileSortAction = new ListSortAction(SpssVariableSortType.file);
        this.mMeasurementSortAction = new ListSortAction(SpssVariableSortType.measurement);
        this.mVarInfoAction = new VariableInfoAction();
        this.mNominalAction = new ItemMeasurementAction(MeasurementLevel.nominal);
        this.mOrdinalAction = new ItemMeasurementAction(MeasurementLevel.ordinal);
        this.mScaleAction = new ItemMeasurementAction(MeasurementLevel.scale);
        this.mNamesItem = new JRadioButtonMenuItem(this.mNamesAction);
        this.mLabelsItem = new JRadioButtonMenuItem(this.mLabelsAction);
        this.mAlphaSortItem = new JRadioButtonMenuItem(this.mAlphaSortAction);
        this.mFileSortItem = new JRadioButtonMenuItem(this.mFileSortAction);
        this.mMeasSortItem = new JRadioButtonMenuItem(this.mMeasurementSortAction);
        this.mNominalItem = new JRadioButtonMenuItem(this.mNominalAction);
        this.mOrdinalItem = new JRadioButtonMenuItem(this.mOrdinalAction);
        this.mScaleItem = new JRadioButtonMenuItem(this.mScaleAction);
        boolean bl = false;
        if ((n & 2) != 0) {
            jPopupMenu.add(this.mNamesItem);
            jPopupMenu.add(this.mLabelsItem);
            bl = true;
        }
        if ((n & 4) != 0) {
            if (bl) {
                jPopupMenu.addSeparator();
            }
            jPopupMenu.add(this.mAlphaSortItem);
            jPopupMenu.add(this.mFileSortItem);
            jPopupMenu.add(this.mMeasSortItem);
            bl = true;
        }
        if ((n & 1) != 0) {
            if (bl) {
                jPopupMenu.addSeparator();
            }
            jPopupMenu.add(new JMenuItem(this.mVarInfoAction));
            bl = true;
        }
        if ((n & 8) != 0) {
            if (bl) {
                jPopupMenu.addSeparator();
            }
            jPopupMenu.add(this.mNominalItem);
            jPopupMenu.add(this.mOrdinalItem);
            jPopupMenu.add(this.mScaleItem);
        }
        return jPopupMenu;
    }

    protected void createVarInfoDialog(int n) {
        BaseDialog baseDialog = this.getBaseDialogParent();
        VariableInfoWindow variableInfoWindow = new VariableInfoWindow(baseDialog);
        Rectangle rectangle = this.getCellBounds(n, n);
        rectangle = SwingUtilities.convertRectangle(this, rectangle, (Component)baseDialog);
        Point point = new Point((int)(rectangle.getMaxX() + 3.0), (int)(rectangle.getMaxY() + 3.0));
        SwingUtilities.convertPointToScreen(point, (Component)baseDialog);
        variableInfoWindow.setLocation(point);
        variableInfoWindow.setVariable(this.getModel().getElementAt(n));
        variableInfoWindow.setVisible(true);
        sVarInfoDlgMap.put(this, variableInfoWindow);
    }

    protected void initializeVarInfoWindow(int n) {
        ISpssVariable iSpssVariable;
        LocallyUniqueId locallyUniqueId = ProcedureDlgMgr.getMgr().getActiveDatasetId();
        ISpssDataSrc iSpssDataSrc = DataMgr.getDataMgr().getDataSource(locallyUniqueId);
        if (iSpssDataSrc.findVarIndex((iSpssVariable = this.getModel().getElementAt(n)).getId()) == -1) {
            String string = String.format(ComponentState.getSPSSLocale(), ResUtil.getCommonDlgString("ERR_VAR_NOT_PRESENT_IN_DATASET"), iSpssVariable.getName());
            SpssAlertOptionPane.showInformationMessageDialog(this, string, VersionInfo.getAppVersionString());
        } else if (sVarInfoDlgMap.isEmpty()) {
            this.createVarInfoDialog(n);
        } else if (!sVarInfoDlgMap.containsKey(this)) {
            this.createVarInfoDialog(n);
        } else {
            VariableInfoWindow variableInfoWindow = sVarInfoDlgMap.get(this);
            this.updateVariableInfo(n);
            variableInfoWindow.setVisible(true);
        }
    }

    protected void updateVariableInfo(int n) {
        VariableInfoWindow variableInfoWindow;
        if (!sVarInfoDlgMap.isEmpty() && sVarInfoDlgMap.containsKey(this) && (variableInfoWindow = sVarInfoDlgMap.get(this)) != null) {
            if (variableInfoWindow.isVisible()) {
                if (variableInfoWindow.getParent() != this.getBaseDialogParent()) {
                    this.initializeVarInfoWindow(n);
                } else if (n > -1 && n < this.getModel().getSize()) {
                    variableInfoWindow.setVariable(this.getModel().getElementAt(n));
                } else {
                    variableInfoWindow.setVisible(false);
                }
            }
            if (n > -1 && n < this.getModel().getSize()) {
                variableInfoWindow.setVariable(this.getModel().getElementAt(n));
            }
        }
    }

    protected BaseDialog getBaseDialogParent() {
        Container container;
        BaseDialog baseDialog = null;
        for (container = this.getParent(); container != null && !(container instanceof BaseDialog); container = container.getParent()) {
        }
        if (container != null) {
            baseDialog = (BaseDialog)container;
        }
        return baseDialog;
    }

    protected void doContextMenu() {
        int[] nArray = this.getSelectedIndices();
        if (nArray.length > 0) {
            JPopupMenu jPopupMenu = this.getContextMenu(nArray);
            if (this.mAdditionalMenuItems != null) {
                this.addContextMenuItems(this.mAdditionalMenuItems);
            }
            if (jPopupMenu != null) {
                jPopupMenu.addPopupMenuListener(this);
                int n = this.getLeadSelectionIndex();
                Rectangle rectangle = this.getCellBounds(n, n);
                int n2 = (int)rectangle.getMinX() + 18;
                int n3 = (int)rectangle.getMaxY();
                jPopupMenu.show(this, n2, n3);
            }
        }
    }

    protected void addContextMenuItems(Component[] componentArray) {
        for (Component component : componentArray) {
            this.mContextMenu.add(component);
        }
    }

    static {
        VariableList.loadImageIcons();
        sNoFocusBorder = null;
        sFocusBorder = null;
        sVarInfoDlgMap = new HashMap();
    }

    static enum VarImage {
        eScaleIdx,
        eOrdinalIdx,
        eNominalIdx,
        eStringOrdinalIdx,
        eStringNominalIdx,
        eDateScaleIdx,
        eDateOrdinalIdx,
        eDateNominalIdx,
        eTimeScaleIdx,
        eTimeOrdinalIdx,
        eTimeNominalIdx,
        eMCSetIdx,
        eMDSetIdx,
        eCalculatedScale,
        eFactor,
        eCovariate,
        eRandom,
        eTimeDependentIdx;

    }

    class SelectionAdapter
    implements ListSelectionListener {
        SelectionAdapter() {
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (listSelectionEvent.getValueIsAdjusting()) {
                return;
            }
            int n = VariableList.this.getSelectedIndex();
            if (n > -1) {
                VariableList.this.updateVariableInfo(n);
            } else {
                VariableInfoWindow variableInfoWindow = sVarInfoDlgMap.get(VariableList.this);
                if (variableInfoWindow != null) {
                    variableInfoWindow.setVisible(false);
                }
            }
        }
    }

    class ItemMeasurementAction
    extends AbstractAction {
        private int[] mItemIndices;
        private MeasurementLevel mLevel;

        public ItemMeasurementAction(MeasurementLevel measurementLevel) {
            Integer n;
            String string;
            String string2;
            this.mLevel = measurementLevel;
            if (measurementLevel.equals((Object)MeasurementLevel.nominal)) {
                string2 = "IDS_NOMINAL";
                string = "IDK_NOMINAL";
            } else if (measurementLevel.equals((Object)MeasurementLevel.ordinal)) {
                string2 = "IDS_ORDINAL";
                string = "IDK_ORDINAL";
            } else {
                string2 = "IDS_SCALE";
                string = "IDK_SCALE";
            }
            this.putValue("Name", ResUtil.getCommonDlgString(string2));
            if (OSInfo.getOSType() != OSInfo.OSType.MAC && (n = ResUtil.getCommonDlgAccessKey(string)) != null) {
                this.putValue("MnemonicKey", n);
            }
        }

        public void setItemIndices(int[] nArray) {
            this.mItemIndices = nArray;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            int[] nArray = VariableList.this.getSelectedIndices();
            for (int n : this.mItemIndices) {
                boolean bl;
                boolean bl2 = bl = n > -1 && n < VariableList.this.getModel().getSize();
                if (!bl) continue;
                try {
                    ISpssVariable iSpssVariable = VariableList.this.getModel().getElementAt(n).clone();
                    iSpssVariable.setDisplayMeasurementLevel(this.mLevel);
                    VariableList.this.getModel().setElementAt(n, iSpssVariable);
                }
                catch (CloneNotSupportedException cloneNotSupportedException) {
                    cloneNotSupportedException.printStackTrace();
                }
                if (VariableList.this.getModel().getSortType().equals((Object)SpssVariableSortType.measurement)) continue;
                VariableList.this.repaint(VariableList.this.getCellBounds(n, n));
            }
            VariableList.this.clearSelection();
            VariableList.this.setSelectedIndices(nArray);
            if (VariableList.this.getModel().getSortType().equals((Object)SpssVariableSortType.measurement)) {
                VariableList.this.getModel().sort();
            }
        }
    }

    class ListSortAction
    extends AbstractAction {
        private SpssVariableSortType mSortType;

        public ListSortAction(SpssVariableSortType spssVariableSortType) {
            Integer n;
            String string;
            String string2;
            this.mSortType = spssVariableSortType;
            if (spssVariableSortType.equals((Object)SpssVariableSortType.alpha)) {
                string2 = "IDS_ALPHA_SORT";
                string = "IDK_ALPHA_SORT";
            } else if (spssVariableSortType.equals((Object)SpssVariableSortType.measurement)) {
                string2 = "IDS_MEASUREMENT_SORT";
                string = "IDK_MEASUREMENT_SORT";
            } else {
                string2 = "IDS_FILE_SORT";
                string = "IDK_FILE_SORT";
            }
            this.putValue("Name", ResUtil.getCommonDlgString(string2));
            if (OSInfo.getOSType() != OSInfo.OSType.MAC && (n = ResUtil.getCommonDlgAccessKey(string)) != null) {
                this.putValue("MnemonicKey", n);
            }
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            VariableList.this.setSortType(this.mSortType);
        }
    }

    class NamesLabelsAction
    extends AbstractAction {
        private boolean mNames;

        public NamesLabelsAction(boolean bl) {
            Integer n;
            this.mNames = bl;
            this.putValue("Name", ResUtil.getCommonDlgString(bl ? "IDS_DISPLAY_NAMES" : "IDS_DISPLAY_LABELS"));
            if (OSInfo.getOSType() != OSInfo.OSType.MAC && (n = ResUtil.getCommonDlgAccessKey(bl ? "IDK_DISPLAY_NAMES" : "IDK_DISPLAY_LABELS")) != null) {
                this.putValue("MnemonicKey", n);
            }
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            BaseDialog baseDialog;
            if (!VariableList.this.getLockItemDisplay() && (baseDialog = VariableList.this.getBaseDialogParent()) != null) {
                if (baseDialog instanceof BaseProcedureDialog) {
                    BaseProcedureDialog baseProcedureDialog = (BaseProcedureDialog)baseDialog;
                    BaseProcedureDialog.NameLabelOption nameLabelOption = this.mNames ? BaseProcedureDialog.NameLabelOption.show_names : BaseProcedureDialog.NameLabelOption.show_labels;
                    baseProcedureDialog.setNameLabelOverride(nameLabelOption, true);
                } else if (baseDialog instanceof BaseSubDialog) {
                    BaseSubDialog baseSubDialog = (BaseSubDialog)baseDialog;
                    BaseProcedureDialog.NameLabelOption nameLabelOption = this.mNames ? BaseProcedureDialog.NameLabelOption.show_names : BaseProcedureDialog.NameLabelOption.show_labels;
                    baseSubDialog.setNameLabelOverride(nameLabelOption, true);
                } else if (baseDialog instanceof BaseWizardDialog) {
                    BaseWizardDialog baseWizardDialog = (BaseWizardDialog)baseDialog;
                    BaseProcedureDialog.NameLabelOption nameLabelOption = this.mNames ? BaseProcedureDialog.NameLabelOption.show_names : BaseProcedureDialog.NameLabelOption.show_labels;
                    baseWizardDialog.setNameLabelOverride(nameLabelOption, true);
                } else {
                    BaseProcedureDialog.NameLabelOption nameLabelOption = this.mNames ? BaseProcedureDialog.NameLabelOption.show_names : BaseProcedureDialog.NameLabelOption.show_labels;
                    BaseSpssDialog.updateListTextDisplaySetting(nameLabelOption, (Container)baseDialog, true);
                }
            }
        }
    }

    class VariableInfoAction
    extends AbstractAction {
        private int mIndex = 0;

        public VariableInfoAction() {
            Integer n;
            this.putValue("Name", ResUtil.getCommonDlgString("IDS_VARIABLE_INFO"));
            if (OSInfo.getOSType() != OSInfo.OSType.MAC && (n = ResUtil.getCommonDlgAccessKey("IDK_VARIABLE_INFO")) != null) {
                this.putValue("MnemonicKey", n);
            }
        }

        public void setItemIndex(int n) {
            this.mIndex = n;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (this.mIndex < 0) {
                return;
            }
            BaseDialog baseDialog = VariableList.this.getBaseDialogParent();
            if (baseDialog == null) {
                return;
            }
            VariableList.this.initializeVarInfoWindow(this.mIndex);
        }
    }

    class ContextEventListener
    extends MouseAdapter
    implements KeyListener {
        ContextEventListener() {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            if (mouseEvent.isConsumed()) {
                return;
            }
            if (VariableList.this.isEnabled()) {
                VariableList.this.grabFocus();
                int n = VariableList.this.locationToIndex(mouseEvent.getPoint());
                if (!(n <= -1 || this.isDiscontinuousSelectionKeyPressed(mouseEvent) || mouseEvent.isShiftDown() || VariableList.this.isSelectedIndex(n))) {
                    VariableList.this.setSelectedIndex(n);
                    VariableList.this.updateVariableInfo(n);
                }
            }
            if (mouseEvent.isPopupTrigger() && VariableList.this.isEnabled()) {
                VariableList.this.doContextMenu();
                mouseEvent.consume();
            }
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            if (mouseEvent.isConsumed()) {
                return;
            }
            if (VariableList.this.isEnabled()) {
                VariableList.this.grabFocus();
            }
            if (mouseEvent.isPopupTrigger() && VariableList.this.isEnabled()) {
                VariableList.this.doContextMenu();
                mouseEvent.consume();
            }
        }

        @Override
        public void keyPressed(KeyEvent keyEvent) {
            if (keyEvent.isConsumed()) {
                return;
            }
            if (keyEvent.getKeyCode() == 525 || keyEvent.isShiftDown() && keyEvent.getKeyCode() == 121) {
                VariableList.this.doContextMenu();
                keyEvent.consume();
            }
            if (OSInfo.getOSType() == OSInfo.OSType.MAC && keyEvent.getKeyCode() == 32) {
                VariableList.this.setSelectedIndex(VariableList.this.getLeadSelectionIndex());
            }
        }

        @Override
        public void keyReleased(KeyEvent keyEvent) {
        }

        @Override
        public void keyTyped(KeyEvent keyEvent) {
        }

        public boolean isDiscontinuousSelectionKeyPressed(MouseEvent mouseEvent) {
            boolean bl = false;
            bl = OSInfo.getOSType() == OSInfo.OSType.MAC ? mouseEvent.isMetaDown() : mouseEvent.isControlDown();
            return bl;
        }
    }

    public class TransferData
    implements Cloneable {
        private ISpssVariable[] mVars;
        private int[] mSelectedIndices;

        public TransferData(ISpssVariable[] iSpssVariableArray, int[] nArray) {
            this.mVars = iSpssVariableArray;
            this.mSelectedIndices = nArray;
        }

        public int[] getSelectedIndices() {
            return this.mSelectedIndices;
        }

        public ISpssVariable[] getVariables() {
            return this.mVars;
        }

        public Object clone() throws CloneNotSupportedException {
            TransferData transferData = (TransferData)super.clone();
            transferData.mVars = (ISpssVariable[])this.mVars.clone();
            transferData.mSelectedIndices = (int[])this.mSelectedIndices.clone();
            return transferData;
        }
    }

    class DoubleClickHandler
    extends MouseAdapter {
        DoubleClickHandler() {
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            if (VariableList.this.mDoubleClickEnabled && VariableList.this.isEnabled() && mouseEvent.getButton() == 1 && mouseEvent.getClickCount() == 2 && VariableList.this.mDoubleClickListener.size() == 1) {
                ((IDoubleClickListener)VariableList.this.mDoubleClickListener.get(0)).doDoubleClickAction();
            }
        }
    }

    public static enum VarMoveType {
        eDoNothing,
        eKeepOriginal,
        eMoveOriginal;

    }
}

