/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.controls;

import com.spss.java_client.core.common.prefs.PrefsMgr;
import com.spss.java_client.core.documents.data.dictionary.SpssVariableSortDirection;
import com.spss.java_client.core.documents.data.dictionary.SpssVariableSortType;
import com.spss.java_client.ui.controls.SpssButtonGroup;
import com.spss.java_client.ui.controls.SrcVariableList;
import com.spss.java_client.ui.dialogs.common.BaseProcedureDialog;
import com.spss.java_client.ui.dialogs.common.BaseSpssDialog;
import com.spss.java_client.ui.dialogs.common.BaseSubDialog;
import com.spss.java_client.ui.dialogs.common.BaseWizardDialog;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.actions.ComboboxAction;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.java_client.ui.resources.ResUtil;
import com.spss.uitools.dialogs.BaseDialog;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import java.util.Vector;
import java.util.prefs.Preferences;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JToggleButton;
import javax.swing.border.TitledBorder;

public class VarSourceSortingPanel
extends JPanel
implements ActionListener {
    protected BaseDialog mParent;
    protected SrcVariableList mVariableSrcList;
    protected JLabel mSortLabel;
    protected JComboBox mSortCombo;
    protected JToggleButton mOrderButton;
    private String mAsendingToolTip;
    private String mDesendingToolTip;
    protected JToggleButton mShowLabelButton;
    private String mShowLabelToolTip;
    private String mShowNameToolTip;
    private boolean mSortWithCombo;
    private JRadioButton mNaturalSort;
    private JRadioButton mNameSort;
    private JRadioButton mMeasurementSort;
    private SpssButtonGroup mSortGroup;

    public VarSourceSortingPanel(SrcVariableList srcVariableList, BaseDialog baseDialog, boolean bl) {
        this.mVariableSrcList = srcVariableList;
        this.mParent = baseDialog;
        this.mSortWithCombo = bl;
        this.initVars();
        this.createSortPanel();
        this.setupControlDefaultsFromSrcList();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (this.mSortCombo != null && object == this.mSortCombo || object == this.mShowLabelButton || object == this.mOrderButton || object instanceof JRadioButton) {
            int n = -1;
            if (this.mSortCombo != null) {
                n = this.mSortCombo.getSelectedIndex();
            } else if (this.mNaturalSort != null && this.mNameSort != null && this.mMeasurementSort != null) {
                if (this.mNaturalSort.isSelected()) {
                    n = 0;
                } else if (this.mNameSort.isSelected()) {
                    n = 1;
                } else if (this.mMeasurementSort.isSelected()) {
                    n = 2;
                }
            }
            if (n >= 0) {
                this.SortSourceList(n);
            }
        }
    }

    public Vector<Object> getTabTraversalComponent() {
        Vector<Object> vector = new Vector<Object>();
        if (this.mSortWithCombo) {
            vector.add(this.mSortCombo);
        } else {
            vector.add(this.mNaturalSort);
            vector.add(this.mNameSort);
            vector.add(this.mMeasurementSort);
        }
        vector.add(this.mOrderButton);
        vector.add(this.mShowLabelButton);
        return vector;
    }

    private void initVars() {
        Object object;
        SpssVariableSortType spssVariableSortType = this.mVariableSrcList.getSortType();
        this.mSortLabel = new JLabel(ResUtil.getCommonDlgString("IDS_SOURCE_SORT_LABEL"));
        if (this.mSortWithCombo) {
            object = ResUtil.getCommonStringArray("IDS_SOURCE_SORT_COMBO_ARRY");
            this.mSortCombo = new JComboBox<String>((E[])object);
            this.mSortCombo.setAction(new ComboboxAction(this.mParent, "IDS_SOURCE_SORT_COMBO_ARRY"));
            this.mSortCombo.addActionListener(this);
            this.mSortLabel.setLabelFor(this.mSortCombo);
        } else {
            object = new ToggleButtonAction("IDS_SOURCE_MEASURE_READIO_NONE");
            this.mNaturalSort = new JRadioButton((Action)object);
            this.mNaturalSort.addActionListener(this);
            object = new ToggleButtonAction("IDS_SOURCE_MEASURE_READIO_NAME");
            this.mNameSort = new JRadioButton((Action)object);
            this.mNameSort.addActionListener(this);
            object = new ToggleButtonAction("IDS_SOURCE_MEASURE_READIO_MEASURE");
            this.mMeasurementSort = new JRadioButton((Action)object);
            this.mMeasurementSort.addActionListener(this);
            this.mSortGroup = new SpssButtonGroup();
            this.mSortGroup.add(this.mNaturalSort);
            this.mSortGroup.add(this.mNameSort);
            this.mSortGroup.add(this.mMeasurementSort);
        }
        object = this.mVariableSrcList.getModel().getSortDirection();
        URL uRL = ResUtil.getCommonDlgImageResource(ResUtil.getCommonDlgString("IDS_SOURCE_SORT_ASCENDING_IMAGE"));
        this.mOrderButton = DialogUtil.createToggledButton(this.mParent, "", null);
        this.mOrderButton.setIcon(new ImageIcon(uRL));
        this.mOrderButton.setSelectedIcon(new ImageIcon(ResUtil.getCommonDlgImageResource(ResUtil.getCommonDlgString("IDS_SOURCE_SORT_DESCENDING_IMAGE"))));
        this.mOrderButton.setRolloverEnabled(false);
        this.mOrderButton.addActionListener(this);
        uRL = ResUtil.getCommonDlgImageResource(ResUtil.getCommonDlgString("IDS_SOURCE_SORT_SHOW_LABEL_IMAGE"));
        this.mShowLabelButton = DialogUtil.createToggledButton(this.mParent, "", null);
        this.mShowLabelButton.setIcon(new ImageIcon(uRL));
        this.mShowLabelButton.addActionListener(this);
        this.mAsendingToolTip = ResUtil.getCommonDlgString("IDS_SOURCE_SORT_ASCENDING_TOOLTIP");
        this.mDesendingToolTip = ResUtil.getCommonDlgString("IDS_SOURCE_SORT_DESCENDING_TOOLTIP");
        this.mShowLabelToolTip = ResUtil.getCommonDlgString("IDS_SOURCE_SORT_DISPLAY_LABEL_TOOLTIP");
        this.mShowNameToolTip = ResUtil.getCommonDlgString("IDS_SOURCE_SORT_DISPLAY_NAME_TOOLTIP");
    }

    private void setupControlDefaultsFromSrcList() {
        this.mOrderButton.setSelected(this.mVariableSrcList.getModel().getSortDirection() == SpssVariableSortDirection.descending);
        this.mShowLabelButton.setSelected(this.mVariableSrcList.getShowVarLabels());
        SpssVariableSortType spssVariableSortType = this.mVariableSrcList.getSortType();
        if (this.mSortWithCombo) {
            int n = this.getSortTypeIndex(spssVariableSortType);
            this.mSortCombo.setSelectedIndex(n);
        } else if (spssVariableSortType == SpssVariableSortType.alpha) {
            this.mNameSort.setSelected(true);
        } else if (spssVariableSortType == SpssVariableSortType.measurement) {
            this.mMeasurementSort.setSelected(true);
        } else {
            this.mNaturalSort.setSelected(true);
        }
    }

    private int getSortTypeIndex(SpssVariableSortType spssVariableSortType) {
        int n = 0;
        n = spssVariableSortType == SpssVariableSortType.alpha ? 1 : (spssVariableSortType == SpssVariableSortType.measurement ? 2 : 0);
        return n;
    }

    protected void createSortPanel() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        Insets insets = new Insets(0, 0, 0, 2);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        DialogUtil.addUsingGBL(this, this.mSortLabel, gridBagConstraints, 0, 0, 1, 1, n, insets);
        int n2 = 1;
        if (this.mSortWithCombo) {
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.fill = 2;
            insets.set(0, 2, 0, 2);
            DialogUtil.addUsingGBL(this, this.mSortCombo, gridBagConstraints, n2, 0, 1, 1, n, insets);
        } else {
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.fill = 0;
            insets.set(0, 2, 0, 2);
            DialogUtil.addUsingGBL(this, this.mNaturalSort, gridBagConstraints, n2, 0, 1, 1, n, insets);
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.fill = 0;
            insets.set(0, 2, 0, 2);
            DialogUtil.addUsingGBL(this, this.mNameSort, gridBagConstraints, ++n2, 0, 1, 1, n, insets);
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.fill = 0;
            insets.set(0, 2, 0, 2);
            DialogUtil.addUsingGBL(this, this.mMeasurementSort, gridBagConstraints, ++n2, 0, 1, 1, n, insets);
        }
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        insets.set(0, 2, 0, 2);
        DialogUtil.addUsingGBL(this, this.mOrderButton, gridBagConstraints, ++n2, 0, 1, 1, n, insets);
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = this.mSortWithCombo ? 0.0 : 1.0;
        insets.set(0, 2, 0, 0);
        DialogUtil.addUsingGBL(this, this.mShowLabelButton, gridBagConstraints, ++n2, 0, 1, 1, n, insets);
        this.setBorder(new TitledBorder(""));
    }

    @Override
    public void setEnabled(boolean bl) {
        if (this.mSortLabel != null) {
            this.mSortLabel.setEnabled(bl);
        }
        if (this.mSortCombo != null) {
            this.mSortCombo.setEnabled(bl);
        }
        if (this.mOrderButton != null) {
            this.mOrderButton.setEnabled(bl);
        }
        if (this.mShowLabelButton != null) {
            this.mShowLabelButton.setEnabled(bl);
        }
        if (this.mNaturalSort != null) {
            this.mNaturalSort.setEnabled(bl);
        }
        if (this.mNameSort != null) {
            this.mNameSort.setEnabled(bl);
        }
        if (this.mMeasurementSort != null) {
            this.mMeasurementSort.setEnabled(bl);
        }
    }

    private Preferences GetGeneralOptionsPrefs() {
        Preferences preferences = PrefsMgr.getPrefsMgr().getUIUserPrefs();
        Preferences preferences2 = preferences.node("options");
        Preferences preferences3 = preferences2.node("general");
        return preferences3;
    }

    private void SortSourceList(int n) {
        BaseProcedureDialog.NameLabelOption nameLabelOption;
        SpssVariableSortType spssVariableSortType;
        switch (n) {
            case 0: {
                spssVariableSortType = SpssVariableSortType.file;
                break;
            }
            case 1: {
                spssVariableSortType = SpssVariableSortType.alpha;
                break;
            }
            case 2: {
                spssVariableSortType = SpssVariableSortType.measurement;
                break;
            }
            default: {
                spssVariableSortType = SpssVariableSortType.file;
            }
        }
        this.mVariableSrcList.getModel().setSortType(spssVariableSortType);
        SpssVariableSortDirection spssVariableSortDirection = this.mOrderButton != null && this.mOrderButton.isSelected() ? SpssVariableSortDirection.descending : SpssVariableSortDirection.ascending;
        this.mVariableSrcList.getModel().setSortDirection(spssVariableSortDirection);
        if (this.mOrderButton.isSelected()) {
            this.mOrderButton.setToolTipText(this.mDesendingToolTip);
        } else {
            this.mOrderButton.setToolTipText(this.mAsendingToolTip);
        }
        boolean bl = this.mShowLabelButton.isSelected();
        if (bl) {
            this.mShowLabelButton.setToolTipText(this.mShowLabelToolTip);
        } else {
            this.mShowLabelButton.setToolTipText(this.mShowNameToolTip);
        }
        this.mVariableSrcList.getModel().setShowVarLabels(bl);
        BaseProcedureDialog.NameLabelOption nameLabelOption2 = nameLabelOption = !bl ? BaseProcedureDialog.NameLabelOption.show_names : BaseProcedureDialog.NameLabelOption.show_labels;
        if (!this.mVariableSrcList.getLockItemDisplay() && this.mParent != null) {
            if (this.mParent instanceof BaseProcedureDialog) {
                BaseProcedureDialog baseProcedureDialog = (BaseProcedureDialog)this.mParent;
                baseProcedureDialog.setNameLabelOverride(nameLabelOption, true);
            } else if (this.mParent instanceof BaseSubDialog) {
                BaseSubDialog baseSubDialog = (BaseSubDialog)this.mParent;
                baseSubDialog.setNameLabelOverride(nameLabelOption, true);
            } else if (this.mParent instanceof BaseWizardDialog) {
                BaseWizardDialog baseWizardDialog = (BaseWizardDialog)this.mParent;
                baseWizardDialog.setNameLabelOverride(nameLabelOption, true);
            } else {
                BaseSpssDialog.updateListTextDisplaySetting(nameLabelOption, (Container)this.mParent, true);
            }
        }
    }
}

