/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.controls;

import com.spss.java_client.core.common.prefs.PrefDefaults;
import com.spss.java_client.core.common.prefs.PrefsMgr;
import com.spss.java_client.core.documents.data.dictionary.ISpssVariable;
import com.spss.java_client.core.documents.data.dictionary.SpssVariableComparator;
import com.spss.java_client.core.documents.data.dictionary.SpssVariableSortDirection;
import com.spss.java_client.core.documents.data.dictionary.SpssVariableSortType;
import com.spss.java_client.core.documents.data.dictionary.TimeDependentPredictors;
import com.spss.java_client.ui.controls.SrcVariableList;
import com.spss.java_client.ui.controls.VariableList;
import com.spss.uitools.util.IOptionConstants;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Vector;
import java.util.prefs.Preferences;
import javax.swing.AbstractListModel;

public class VarListModel
extends AbstractListModel {
    protected VariableList mVarList = null;
    protected Vector<ISpssVariable> mVariables = new Vector();
    protected boolean mShowVarLabels = false;
    protected SpssVariableSortType mSortType = SpssVariableSortType.file;
    protected SpssVariableSortDirection mSortDirection = SpssVariableSortDirection.ascending;
    private ISpssVariable mMovedVar;

    protected VarListModel(VariableList variableList) {
        this.mVarList = variableList;
        this.readDisplayPrefs();
    }

    @Override
    public int getSize() {
        return this.mVariables.size();
    }

    @Override
    public ISpssVariable getElementAt(int n) {
        if (n < 0 || n >= this.mVariables.size()) {
            throw new ArrayIndexOutOfBoundsException(n);
        }
        return this.mVariables.get(n);
    }

    public void setElementAt(int n, ISpssVariable iSpssVariable) {
        if (n < 0 || n >= this.mVariables.size()) {
            throw new ArrayIndexOutOfBoundsException(n);
        }
        this.mVariables.set(n, iSpssVariable);
    }

    public ISpssVariable removeElementAt(int n) {
        this.mMovedVar = this.mVariables.get(n);
        if (n < 0 || n >= this.mVariables.size()) {
            throw new ArrayIndexOutOfBoundsException(n);
        }
        ISpssVariable iSpssVariable = this.mVariables.remove(n);
        this.fireIntervalRemoved(this, n, n);
        return iSpssVariable;
    }

    public boolean removeElement(ISpssVariable iSpssVariable) {
        this.mMovedVar = iSpssVariable;
        int n = this.mVariables.indexOf(iSpssVariable);
        boolean bl = this.mVariables.removeElement(iSpssVariable);
        if (n >= 0) {
            this.fireIntervalRemoved(this, n, n);
        }
        return bl;
    }

    public void removeAll() {
        int n = this.mVariables.size();
        this.mVariables.clear();
        if (n > 0) {
            this.fireIntervalRemoved(this, 0, n - 1);
        }
    }

    public void reset() {
        this.removeAll();
        this.readDisplayPrefs();
    }

    public boolean insertElementAt(ISpssVariable iSpssVariable, int n) {
        this.mMovedVar = iSpssVariable;
        if (!this.mVarList.canIncludeVariable(iSpssVariable)) {
            return false;
        }
        this.mVariables.insertElementAt(iSpssVariable, n);
        this.fireIntervalAdded(this, n, n);
        if (this.mVarList instanceof SrcVariableList) {
            this.sort();
        }
        return true;
    }

    public boolean addElement(ISpssVariable iSpssVariable) {
        return this.addElement(iSpssVariable, true);
    }

    public boolean addElement(ISpssVariable iSpssVariable, boolean bl) {
        this.mMovedVar = iSpssVariable;
        if (!this.mVarList.canIncludeVariable(iSpssVariable)) {
            return false;
        }
        int n = this.mVariables.size();
        this.mVariables.addElement(iSpssVariable);
        this.fireIntervalAdded(this, n, n);
        if (bl && this.mVarList instanceof SrcVariableList) {
            this.sort();
        }
        return true;
    }

    public boolean getShowVarLabels() {
        return this.mShowVarLabels;
    }

    public void setShowVarLabels(boolean bl) {
        this.mShowVarLabels = bl;
        if (this.mVarList instanceof SrcVariableList) {
            this.sort();
        }
    }

    public Integer[] findElementIndexesByName(String string) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (int i = 0; i < this.mVariables.size(); ++i) {
            ISpssVariable iSpssVariable = this.mVariables.get(i);
            if (!iSpssVariable.getName().equalsIgnoreCase(string)) continue;
            arrayList.add(new Integer(i));
        }
        return arrayList.toArray(new Integer[arrayList.size()]);
    }

    public int findElementIndex(ISpssVariable iSpssVariable) {
        int n = -1;
        for (int i = 0; i < this.mVariables.size(); ++i) {
            ISpssVariable iSpssVariable2 = this.mVariables.get(i);
            if (iSpssVariable2 instanceof TimeDependentPredictors && iSpssVariable instanceof TimeDependentPredictors) {
                if (!iSpssVariable2.getName().equals(iSpssVariable.getName())) continue;
                n = i;
                break;
            }
            if (!iSpssVariable2.getId().equals((Object)iSpssVariable.getId())) continue;
            n = i;
            break;
        }
        return n;
    }

    public SpssVariableSortType getSortType() {
        return this.mSortType;
    }

    public void setSortType(SpssVariableSortType spssVariableSortType) {
        this.mSortType = spssVariableSortType;
        if (this.mVarList instanceof SrcVariableList) {
            this.sort();
        }
    }

    public SpssVariableSortDirection getSortDirection() {
        return this.mSortDirection;
    }

    public void setSortDirection(SpssVariableSortDirection spssVariableSortDirection) {
        this.mSortDirection = spssVariableSortDirection;
        if (this.mVarList instanceof SrcVariableList) {
            this.sort();
        }
    }

    public void sort() {
        try {
            ISpssVariable[] iSpssVariableArray = this.mVarList.getSelectedValues();
            Collections.sort(this.mVariables, this.getSpssVariableComparator());
            this.mVarList.clearSelection();
            this.mVarList.setSelection(iSpssVariableArray);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public SpssVariableComparator getSpssVariableComparator() {
        return new SpssVariableComparator(this.mSortType, this.mShowVarLabels, this.mSortDirection);
    }

    public ISpssVariable getMovedVar() {
        return this.mMovedVar;
    }

    void setVarListCtrl(VariableList variableList) {
        this.mVarList = variableList;
    }

    public boolean containsAll(List list) {
        return this.mVariables != null && this.mVariables.containsAll(list);
    }

    public boolean contains(ISpssVariable iSpssVariable) {
        return this.mVariables != null && this.mVariables.contains(iSpssVariable);
    }

    private void readDisplayPrefs() {
        Preferences preferences = PrefsMgr.getPrefsMgr().getUIUserPrefs();
        Preferences preferences2 = preferences.node("options");
        Preferences preferences3 = preferences2.node("general");
        this.mShowVarLabels = preferences3.get("var_list_display", PrefDefaults.DEF_VAR_LIST_DISPLAY_LABELS).equals(IOptionConstants.VAR_LIST_DISPLAY_VALUES[0]);
        String string = preferences3.get("var_list_sort", PrefDefaults.DEF_VAR_LIST_SORT_ORDER_FILE);
        if (string.equals(IOptionConstants.VAR_LIST_SORT_VALUES[0])) {
            this.mSortType = SpssVariableSortType.alpha;
        } else if (string.equals(IOptionConstants.VAR_LIST_SORT_VALUES[1])) {
            this.mSortType = SpssVariableSortType.file;
        } else if (string.equals(IOptionConstants.VAR_LIST_SORT_VALUES[2])) {
            this.mSortType = SpssVariableSortType.measurement;
        }
    }
}

