/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.controls;

import com.spss.java_client.core.common.ComponentState;
import com.spss.java_client.core.documents.data.dictionary.FormatType;
import com.spss.java_client.core.documents.data.dictionary.ISpssVariable;
import com.spss.java_client.core.documents.data.dictionary.MeasurementLevel;
import com.spss.java_client.core.documents.data.dictionary.SpssMRVariable;
import com.spss.java_client.ui.controls.IVarFilter;
import com.spss.java_client.ui.controls.SpssVarFilter;
import com.spss.java_client.ui.controls.TargetVariableList;
import com.spss.java_client.ui.controls.VariableList;
import com.spss.java_client.ui.resources.ResUtil;

public class VarListFilterUtil {
    public static String getVarListFilterErrorMessage(VariableList variableList, ISpssVariable[] iSpssVariableArray) {
        String string = null;
        if (variableList instanceof TargetVariableList) {
            for (ISpssVariable iSpssVariable : iSpssVariableArray) {
                for (IVarFilter iVarFilter : variableList.mVarFilters) {
                    if (iVarFilter instanceof SpssVarFilter && !iVarFilter.canIncludeVariable(iSpssVariable)) {
                        boolean bl;
                        SpssVarFilter spssVarFilter = (SpssVarFilter)iVarFilter;
                        if (iSpssVariableArray.length == 1 && ((TargetVariableList)variableList).getTargetType() == TargetVariableList.TargetListType.single_item && variableList.getModel().getSize() > 0) {
                            string = String.format(ComponentState.getSPSSLocale(), ResUtil.getCommonDlgString("ERR_CANNOT_SWAP_VAR_WRONG_TYPE_MEASUREMENT"), iSpssVariable.getName());
                            break;
                        }
                        int n = spssVarFilter.getValFilter();
                        boolean bl2 = spssVarFilter.isDateInTimeFormat();
                        if (!spssVarFilter.isMultipleFilter()) {
                            bl = spssVarFilter.isExcludeFilterSet();
                            if ((n & 1) == 1) {
                                string = ResUtil.getCommonDlgString(bl ? "ERR_FILTER_ORDINAL_MSG" : "ERR_FILTER_ONLY_ORDINAL_MSG");
                            } else if ((n & 2) == 2) {
                                string = ResUtil.getCommonDlgString(bl ? "ERR_FILTER_NOMINAL_MSG" : "ERR_FILTER_ONLY_NOMINAL_MSG");
                            } else if ((n & 4) == 4) {
                                string = ResUtil.getCommonDlgString(bl ? "ERR_FILTER_SCALE_MSG" : "ERR_FILTER_ONLY_SCALE_MSG");
                            } else if ((n & 8) == 8) {
                                string = ResUtil.getCommonDlgString(bl ? "ERR_FILTER_STRING_MSG" : "ERR_FILTER_ONLY_STRING_MSG");
                            } else if ((n & 0x10) == 16) {
                                string = ResUtil.getCommonDlgString(bl ? "ERR_FILTER_INTEGER_MSG" : "ERR_FILTER_ONLY_INTEGER_MSG");
                            } else if ((n & 0x20) == 32) {
                                string = bl2 ? ResUtil.getCommonDlgString(bl ? "ERR_FILTER_ONLY_DATE_DATETIME_MSG" : "ERR_FILTER_DATE_MSG") : ResUtil.getCommonDlgString(bl ? "ERR_FILTER_DATE_MSG" : "ERR_FILTER_ONLY_DATE_MSG");
                            } else if ((n & 0x40) == 64) {
                                string = ResUtil.getCommonDlgString(bl ? "ERR_FILTER_TIME_MSG" : "ERR_FILTER_ONLY_TIME_MSG");
                            } else if ((n & 0x80) == 128) {
                                string = ResUtil.getCommonDlgString(bl ? "ERR_FILTER_ORDINAL_STRING_MSG" : "ERR_FILTER_ONLY_ORDINAL_STRING_MSG");
                            } else if ((n & 0x100) == 256) {
                                string = ResUtil.getCommonDlgString(bl ? "ERR_FILTER_ORDINAL_INTEGER_MSG" : "ERR_FILTER_ONLY_ORDINAL_INTEGER_MSG");
                            } else if ((n & 0x200) == 512) {
                                string = ResUtil.getCommonDlgString(bl ? "ERR_FILTER_ORDINAL_DATE_MSG" : "ERR_FILTER_ONLY_ORDINAL_DATE_MSG");
                            } else if ((n & 0x400) == 1024) {
                                string = ResUtil.getCommonDlgString(bl ? "ERR_FILTER_ORDINAL_TIME_MSG" : "ERR_FILTER_ONLY_ORDINAL_TIME_MSG");
                            } else if ((n & 0x800) == 2048) {
                                string = ResUtil.getCommonDlgString(bl ? "ERR_FILTER_NOMINAL_STRING_MSG" : "ERR_FILTER_ONLY_NOMINAL_STRING_MSG");
                            } else if ((n & 0x1000) == 4096) {
                                string = ResUtil.getCommonDlgString(bl ? "ERR_FILTER_NOMINAL_INTEGER_MSG" : "ERR_FILTER_ONLY_NOMINAL_INTEGER_MSG");
                            } else if ((n & 0x2000) == 8192) {
                                string = ResUtil.getCommonDlgString(bl ? "ERR_FILTER_NOMINAL_DATE_MSG" : "ERR_FILTER_ONLY_NOMINAL_DATE_MSG");
                            } else if ((n & 0x4000) == 16384) {
                                string = ResUtil.getCommonDlgString(bl ? "ERR_FILTER_NOMINAL_TIME_MSG" : "ERR_FILTER_ONLY_NOMINAL_TIME_MSG");
                            } else if ((n & 0x8000) == 32768) {
                                string = ResUtil.getCommonDlgString(bl ? "ERR_FILTER_SCALE_STRING_MSG" : "ERR_FILTER_ONLY_SCALE_STRING_MSG");
                            } else if ((n & 0x10000) == 65536) {
                                string = ResUtil.getCommonDlgString(bl ? "ERR_FILTER_SCALE_INTEGER_MSG" : "ERR_FILTER_ONLY_SCALE_INTEGER_MSG");
                            } else if ((n & 0x20000) == 131072) {
                                string = ResUtil.getCommonDlgString(bl ? "ERR_FILTER_SCALE_DATE_MSG" : "ERR_FILTER_ONLY_SCALE_DATE_MSG");
                            } else if ((n & 0x40000) == 262144) {
                                string = ResUtil.getCommonDlgString(bl ? "ERR_FILTER_SCALE_TIME_MSG" : "ERR_FILTER_ONLY_SCALE_TIME_MSG");
                            }
                        } else {
                            bl = iSpssVariable.getType() > 0;
                            FormatType formatType = iSpssVariable.getFormat().getFormatType();
                            boolean bl3 = formatType == FormatType.TIME || formatType == FormatType.MTIME || formatType == FormatType.DTIME;
                            boolean bl4 = formatType.isDateOrTimeFormat() && !bl3;
                            MeasurementLevel measurementLevel = iSpssVariable.getDisplayMeasurementLevel();
                            if (iSpssVariable instanceof SpssMRVariable) {
                                string = ResUtil.getCommonDlgString("ERR_FILTER_MR_VARS_MSG");
                            } else if (measurementLevel == MeasurementLevel.nominal) {
                                string = bl ? ResUtil.getCommonDlgString("ERR_FILTER_NOMINAL_STRING_MSG") : (bl3 ? ResUtil.getCommonDlgString("ERR_FILTER_NOMINAL_TIME_MSG") : (bl4 ? ResUtil.getCommonDlgString("ERR_FILTER_NOMINAL_DATE_MSG") : ResUtil.getCommonDlgString("ERR_FILTER_NOMINAL_INTEGER_MSG")));
                            } else if (measurementLevel == MeasurementLevel.ordinal) {
                                string = bl ? ResUtil.getCommonDlgString("ERR_FILTER_ORDINAL_STRING_MSG") : (bl3 ? ResUtil.getCommonDlgString("ERR_FILTER_ORDINAL_TIME_MSG") : (bl4 ? ResUtil.getCommonDlgString("ERR_FILTER_ORDINAL_DATE_MSG") : ResUtil.getCommonDlgString("ERR_FILTER_ORDINAL_INTEGER_MSG")));
                            } else if (measurementLevel == MeasurementLevel.scale || measurementLevel == MeasurementLevel.unknown) {
                                string = bl ? ResUtil.getCommonDlgString("ERR_FILTER_SCALE_STRING_MSG") : (bl3 ? ResUtil.getCommonDlgString("ERR_FILTER_SCALE_TIME_MSG") : (bl4 ? ResUtil.getCommonDlgString("ERR_FILTER_SCALE_DATE_MSG") : ResUtil.getCommonDlgString("ERR_FILTER_SCALE_INTEGER_MSG")));
                            }
                        }
                    }
                    if (string == null) continue;
                    break;
                }
                if (string != null) break;
            }
        }
        return string;
    }
}

