/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.controls;

import com.spss.java_client.core.common.ComponentState;
import com.spss.java_client.core.common.prefs.PrefsMgr;
import com.spss.java_client.core.documents.data.dictionary.SPSS_Format;
import com.spss.java_client.ui.controls.IRetrieveFormatCallBack;
import com.spss.java_client.ui.dialogs.base.edit.CurrencyOptionPanel;
import com.spss.uitools.util.IOptionConstants;
import java.text.DecimalFormatSymbols;
import java.util.Locale;
import java.util.prefs.Preferences;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;

public class VarFormatDocument
extends PlainDocument {
    private IRetrieveFormatCallBack mCallBack;
    private DecimalFormatSymbols mSPSSLocaleSymbol = new DecimalFormatSymbols(ComponentState.getSPSSLocale());
    private DecimalFormatSymbols mGERMANYLocaleSymbol = new DecimalFormatSymbols(Locale.GERMANY);
    private final String NUMERIC_PATTERN = "[[0-9]Ee+" + this.mSPSSLocaleSymbol.getDecimalSeparator() + this.mSPSSLocaleSymbol.getMinusSign() + "]*";
    private final String DOLLAR_PATTERN = "[[0-9]$.,Ee+" + this.mSPSSLocaleSymbol.getMinusSign() + "]*";
    private final String COMMA_PATTERN = "[[0-9].,]*";
    private final String DOT_PATTERN = "[[0-9]" + this.mGERMANYLocaleSymbol.getDecimalSeparator() + this.mGERMANYLocaleSymbol.getGroupingSeparator() + "]*";
    private final String PCT_PATTERN = "[[0-9]%" + this.mSPSSLocaleSymbol.getDecimalSeparator() + "]*";
    private String CCA_PATTERN;
    private String CCB_PATTERN;
    private String CCC_PATTERN;
    private String CCD_PATTERN;
    private String CCE_PATTERN;

    public VarFormatDocument(IRetrieveFormatCallBack iRetrieveFormatCallBack) {
        this.mCallBack = iRetrieveFormatCallBack;
        this.initCustomCurrencyPatterns();
    }

    @Override
    public void insertString(int n, String string, AttributeSet attributeSet) throws BadLocationException {
        SPSS_Format sPSS_Format = this.mCallBack.getCurrentVarFormat();
        if (sPSS_Format != null && this.isValueValid(sPSS_Format, string)) {
            super.insertString(n, string, attributeSet);
        }
    }

    private void initCustomCurrencyPatterns() {
        String[] stringArray = CurrencyOptionPanel.getCustomCurrencyFormatNames();
        Preferences preferences = PrefsMgr.getPrefsMgr().getUIUserPrefs().node("options").node("currency");
        Preferences preferences2 = preferences.node(stringArray[0].toLowerCase());
        String string = preferences2.get("all_val_prefix", "");
        String string2 = preferences2.get("all_val_suffix", "");
        String string3 = preferences2.get("neg_val_prefix", "");
        String string4 = preferences2.get("neg_val_suffix", "");
        char c = '.';
        char c2 = ',';
        if (preferences2.get("decimal_separator", "").equals(IOptionConstants.CUSTOM_OUTPUT_FORMAT_SEPARATOR_VALUES[1])) {
            c = ',';
            c2 = '.';
        }
        this.CCA_PATTERN = "[[0-9]" + c + c2 + string + string2 + string3 + string4 + "]*";
        Preferences preferences3 = preferences.node(stringArray[1].toLowerCase());
        string = preferences3.get("all_val_prefix", "");
        string2 = preferences3.get("all_val_suffix", "");
        string3 = preferences3.get("neg_val_prefix", "");
        string4 = preferences3.get("neg_val_suffix", "");
        c = '.';
        c2 = ',';
        if (preferences3.get("decimal_separator", "").equals(IOptionConstants.CUSTOM_OUTPUT_FORMAT_SEPARATOR_VALUES[1])) {
            c = ',';
            c2 = '.';
        }
        this.CCB_PATTERN = "[[0-9]" + c + c2 + string + string2 + string3 + string4 + "]*";
        Preferences preferences4 = preferences.node(stringArray[2].toLowerCase());
        string = preferences4.get("all_val_prefix", "");
        string2 = preferences4.get("all_val_suffix", "");
        string3 = preferences4.get("neg_val_prefix", "");
        string4 = preferences4.get("neg_val_suffix", "");
        c = '.';
        c2 = ',';
        if (preferences4.get("decimal_separator", "").equals(IOptionConstants.CUSTOM_OUTPUT_FORMAT_SEPARATOR_VALUES[1])) {
            c = ',';
            c2 = '.';
        }
        this.CCC_PATTERN = "[[0-9]" + c + c2 + string + string2 + string3 + string4 + "]*";
        Preferences preferences5 = preferences.node(stringArray[3].toLowerCase());
        string = preferences5.get("all_val_prefix", "");
        string2 = preferences5.get("all_val_suffix", "");
        string3 = preferences5.get("neg_val_prefix", "");
        string4 = preferences5.get("neg_val_suffix", "");
        c = '.';
        c2 = ',';
        if (preferences5.get("decimal_separator", "").equals(IOptionConstants.CUSTOM_OUTPUT_FORMAT_SEPARATOR_VALUES[1])) {
            c = ',';
            c2 = '.';
        }
        this.CCD_PATTERN = "[[0-9]" + c + c2 + string + string2 + string3 + string4 + "]*";
        Preferences preferences6 = preferences.node(stringArray[4].toLowerCase());
        string = preferences6.get("all_val_prefix", "");
        string2 = preferences6.get("all_val_suffix", "");
        string3 = preferences6.get("neg_val_prefix", "");
        string4 = preferences6.get("neg_val_suffix", "");
        c = '.';
        c2 = ',';
        if (preferences6.get("decimal_separator", "").equals(IOptionConstants.CUSTOM_OUTPUT_FORMAT_SEPARATOR_VALUES[1])) {
            c = ',';
            c2 = '.';
        }
        this.CCE_PATTERN = "[[0-9]" + c + c2 + string + string2 + string3 + string4 + "]*";
    }

    private boolean isValueValid(SPSS_Format sPSS_Format, String string) {
        boolean bl = true;
        switch (sPSS_Format.getFormatType()) {
            case A: {
                break;
            }
            case AHEX: {
                break;
            }
            case COMMA: {
                bl = string.matches("[[0-9].,]*");
                break;
            }
            case DOLLAR: {
                bl = string.matches(this.DOLLAR_PATTERN);
                break;
            }
            case F: 
            case N: 
            case E: {
                bl = string.matches(this.NUMERIC_PATTERN);
                break;
            }
            case IB: {
                break;
            }
            case PIBHEX: {
                break;
            }
            case P: {
                break;
            }
            case PIB: {
                break;
            }
            case PK: {
                break;
            }
            case RB: {
                break;
            }
            case RBHEX: {
                break;
            }
            case Z: {
                break;
            }
            case PERCENT: {
                bl = string.matches(this.PCT_PATTERN);
                break;
            }
            case DOT: {
                bl = string.matches(this.DOT_PATTERN);
                break;
            }
            case CCA: {
                bl = string.matches(this.CCA_PATTERN);
                break;
            }
            case CCB: {
                bl = string.matches(this.CCB_PATTERN);
                break;
            }
            case CCC: {
                bl = string.matches(this.CCC_PATTERN);
                break;
            }
            case CCD: {
                bl = string.matches(this.CCD_PATTERN);
                break;
            }
            case CCE: {
                bl = string.matches(this.CCE_PATTERN);
                break;
            }
        }
        return bl;
    }
}

