/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.controls;

import com.spss.java_client.ui.controls.CustomVarListCellRenderer;
import com.spss.java_client.ui.controls.IUpDownListListener;
import com.spss.java_client.ui.controls.ListKeyListener;
import com.spss.java_client.ui.controls.PlainList;
import com.spss.java_client.ui.controls.PlainListArrowButton;
import com.spss.java_client.ui.controls.SpssArrowButton;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.resources.ResUtil;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.text.MessageFormat;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class UpDownListWidget
extends JPanel
implements ListSelectionListener {
    protected JLabel mTopLabel;
    protected PlainList mItemList;
    protected Color mEnabledColor;
    protected DefaultListModel mListModel;
    protected UpDownArrowButton mUpButton;
    protected UpDownArrowButton mDnButton;
    protected ExcludeButton mExcludeButton;
    protected Vector<IUpDownListListener> mListeners = new Vector();
    protected JScrollPane mScroller;

    public UpDownListWidget(String string, int n) {
        super(new GridBagLayout(), true);
        this.init(string, n);
        this.updateListButtons();
        this.mItemList.addListSelectionListener(this);
        this.mItemList.addKeyListener(new ListKeyListener(this.mItemList));
    }

    public void addListItem(String string, Object object) {
        int n = this.mListModel.getSize();
        this.mListModel.addElement(new ListItem(string, object));
        this.mItemList.ensureIndexIsVisible(n);
        this.updateListButtons();
    }

    public void insertListItem(int n, String string, Object object) {
        int n2 = n;
        if (n2 < 0 || n2 >= this.mListModel.getSize()) {
            n2 = this.mListModel.getSize();
        }
        this.mListModel.add(n2, new ListItem(string, object));
        this.mItemList.ensureIndexIsVisible(n2);
        this.updateListButtons();
    }

    public Vector<ListItem> getListItems() {
        Vector<ListItem> vector = new Vector<ListItem>();
        for (int i = 0; i < this.mListModel.getSize(); ++i) {
            vector.add((ListItem)this.mListModel.getElementAt(i));
        }
        return vector;
    }

    public PlainList getList() {
        return this.mItemList;
    }

    public void setSelectedItem(int n) {
        if (n >= -1 && n < this.mListModel.getSize()) {
            this.mItemList.setSelectedIndex(n);
            this.mItemList.ensureIndexIsVisible(n);
        }
    }

    public void addTabTraversalComponents(Vector<Object> vector) {
        vector.add(this.mItemList);
        vector.add(this.mUpButton);
        vector.add(this.mDnButton);
        vector.add(this.mExcludeButton);
    }

    public void enableWidget(boolean bl) {
        if (bl) {
            this.mItemList.setBackground(this.mEnabledColor);
        } else {
            this.mItemList.setBackground(SystemColor.control);
        }
        this.mTopLabel.setEnabled(bl);
        this.mItemList.setEnabled(bl);
        this.mUpButton.setEnabled(bl);
        this.mDnButton.setEnabled(bl);
        this.mExcludeButton.setEnabled(bl);
        this.mScroller.setEnabled(bl);
    }

    public void clear() {
        this.mListModel.removeAllElements();
        this.updateListButtons();
    }

    public void setListSize(Dimension dimension) {
        this.mScroller.setMinimumSize(dimension);
        this.mScroller.setPreferredSize(dimension);
    }

    public void addListListener(IUpDownListListener iUpDownListListener) {
        if (!this.mListeners.contains(iUpDownListListener)) {
            this.mListeners.add(iUpDownListListener);
        }
    }

    public void removeListListener(IUpDownListListener iUpDownListListener) {
        this.mListeners.remove(iUpDownListListener);
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (listSelectionEvent.getValueIsAdjusting()) {
            return;
        }
        this.updateListButtons();
    }

    protected void fireListChangeEvent(ListChangeType listChangeType, Vector<Object> vector) {
        for (IUpDownListListener iUpDownListListener : this.mListeners) {
            iUpDownListListener.listItemChanged(listChangeType, vector);
        }
    }

    protected void excludeSelected() {
        int[] nArray = this.mItemList.getSelectedIndices();
        if (nArray.length == 0) {
            return;
        }
        Vector<Object> vector = new Vector<Object>();
        for (int i = nArray.length - 1; i >= 0; --i) {
            ListItem listItem = (ListItem)this.mListModel.getElementAt(nArray[i]);
            vector.add(listItem.getUserObject());
            this.mListModel.removeElementAt(nArray[i]);
        }
        if (nArray[0] >= this.mListModel.getSize()) {
            nArray[0] = nArray[0] - 1;
        }
        if (nArray[0] > -1) {
            this.mItemList.setSelectedIndex(nArray[0]);
        }
        this.updateListButtons();
        this.fireListChangeEvent(ListChangeType.itemDeleted, vector);
    }

    protected void updateListButtons() {
        int[] nArray = this.mItemList.getSelectedIndices();
        int n = this.mListModel.getSize();
        boolean bl = nArray.length > 0 && nArray[0] > 0;
        boolean bl2 = nArray.length > 0 && nArray[0] > -1 && nArray[nArray.length - 1] < n - 1;
        this.mUpButton.setEnabled(bl);
        this.mDnButton.setEnabled(bl2);
        this.mExcludeButton.setEnabled(nArray.length > 0);
    }

    protected void moveSelected(boolean bl) {
        boolean bl2;
        int[] nArray = this.mItemList.getSelectedIndices();
        if (nArray.length == 0) {
            return;
        }
        int n = bl ? nArray[nArray.length - 1] : nArray[0];
        int n2 = this.mItemList.getModel().getSize();
        boolean bl3 = !bl && n == 0;
        boolean bl4 = bl2 = bl && n == n2 - 1;
        if (bl3 || bl2) {
            return;
        }
        Vector<Object> vector = new Vector<Object>();
        for (int i = 0; i < n2; ++i) {
            int n3;
            int n4 = n3 = bl ? n2 - i - 1 : i;
            if (!this.mItemList.isSelectedIndex(n3)) continue;
            Object e = this.mListModel.getElementAt(n3);
            this.mListModel.removeElementAt(n3);
            n3 = bl ? n3 + 1 : n3 - 1;
            this.mListModel.insertElementAt(e, n3);
            this.mItemList.addSelectionInterval(n3, n3);
            vector.add(((ListItem)e).getUserObject());
        }
        nArray = this.mItemList.getSelectedIndices();
        this.mItemList.ensureIndexIsVisible(bl ? nArray[nArray.length - 1] : nArray[0]);
        this.fireListChangeEvent(ListChangeType.itemMoved, vector);
    }

    protected void init(String string, int n) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n2 = 23;
        int n3 = DialogUtil.getGroupBoxInnerMargin();
        Insets insets = new Insets(0, n3, 2, n3);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        int n4 = 0;
        this.mTopLabel = null;
        if (string != null && string.length() > 0) {
            this.mTopLabel = new JLabel(string);
            this.mTopLabel.setDisplayedMnemonic(n);
            DialogUtil.addUsingGBL(this, this.mTopLabel, gridBagConstraints, 0, n4++, 2, 1, n2, insets);
        }
        this.mListModel = new DefaultListModel();
        this.mItemList = new PlainList(this.mListModel, "UpDownWidget", PlainList.DragType.eAutoDragMove);
        this.mScroller = new JScrollPane(this.mItemList);
        this.mItemList.setCellRenderer(new CustomVarListCellRenderer());
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        insets = new Insets(0, n3, n3, 2);
        DialogUtil.addUsingGBL(this, this.mScroller, gridBagConstraints, 0, n4, 1, 3, n2, insets);
        this.setListSize(new Dimension(160, 80));
        if (this.mTopLabel != null) {
            this.mTopLabel.setLabelFor(this.mItemList);
        }
        this.mEnabledColor = this.mItemList.getBackground();
        Dimension dimension = new Dimension(24, 22);
        this.mUpButton = new UpDownArrowButton(SpssArrowButton.ButtonOrientation.up);
        this.mUpButton.getAccessibleContext().setAccessibleName(ResUtil.getCommonDlgString("TXT_MOVE_UP_MESSAGE"));
        this.mUpButton.setPreferredSize(dimension);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        insets = (Insets)DialogUtil.getStandardControlInsets().clone();
        insets.left -= 2;
        insets.bottom += 2;
        DialogUtil.addUsingGBL(this, this.mUpButton, gridBagConstraints, 1, n4++, 1, 1, n2, insets);
        this.mDnButton = new UpDownArrowButton(SpssArrowButton.ButtonOrientation.down);
        this.mDnButton.getAccessibleContext().setAccessibleName(ResUtil.getCommonDlgString("TXT_MOVE_DOWN_MESSAGE"));
        gridBagConstraints.weighty = 0.0;
        this.mDnButton.setPreferredSize(dimension);
        DialogUtil.addUsingGBL(this, this.mDnButton, gridBagConstraints, 1, n4++, 1, 1, n2, insets);
        this.mExcludeButton = new ExcludeButton();
        String string2 = this.mTopLabel != null ? MessageFormat.format(ResUtil.getCommonDlgString("TXT_REMOVE_MESSAGE"), this.mTopLabel.getText()) : MessageFormat.format(ResUtil.getCommonDlgString("TXT_REMOVE_MESSAGE"), "");
        this.mExcludeButton.getAccessibleContext().setAccessibleName(string2);
        this.mExcludeButton.setPreferredSize(dimension);
        insets.top += 2;
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(this, this.mExcludeButton, gridBagConstraints, 1, n4, 1, 1, n2, insets);
    }

    class ExcludeButton
    extends JButton {
        public ExcludeButton() {
            this.setAction(new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    UpDownListWidget.this.excludeSelected();
                }
            });
            String string = ResUtil.getCommonDlgString("IDS_EXCLUDE_IMAGE");
            ImageIcon imageIcon = new ImageIcon(ResUtil.getCommonDlgImageResource(string));
            this.setIcon(imageIcon);
            string = ResUtil.getCommonDlgString("IDS_EXCLUDE_DISABLED_IMAGE");
            this.setDisabledIcon(new ImageIcon(ResUtil.getCommonDlgImageResource(string)));
            Image image = imageIcon.getImage().getScaledInstance(imageIcon.getIconHeight() + 1, imageIcon.getIconHeight() + 1, 4);
            this.setRolloverIcon(new ImageIcon(image));
            image = imageIcon.getImage().getScaledInstance(imageIcon.getIconHeight() - 1, imageIcon.getIconHeight() - 1, 4);
            this.setPressedIcon(new ImageIcon(image));
        }
    }

    class UpDownArrowButton
    extends PlainListArrowButton {
        public UpDownArrowButton(SpssArrowButton.ButtonOrientation buttonOrientation) {
            super(buttonOrientation);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            UpDownListWidget.this.moveSelected(this.mArrowOrientation == SpssArrowButton.ButtonOrientation.down);
        }
    }

    public class ListItem
    extends JLabel {
        private String mLabel;
        private Object mObject;

        public ListItem(String string, Object object) {
            this.mLabel = string;
            this.mObject = object;
        }

        @Override
        public String toString() {
            return this.mLabel;
        }

        public Object getUserObject() {
            return this.mObject;
        }
    }

    public static enum ListChangeType {
        itemMoved,
        itemDeleted;

    }
}

