/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.controls;

import java.awt.Color;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultHighlighter;
import javax.swing.text.JTextComponent;

public class TextHighlighter
extends MouseAdapter
implements FocusListener {
    private Color HIGHLIGHT_COLOR;
    private Object highlightTag;
    private JTextComponent mTextComponent;

    public TextHighlighter(JTextComponent jTextComponent) {
        this.mTextComponent = jTextComponent;
        this.mTextComponent.addFocusListener(this);
        this.mTextComponent.addMouseListener(this);
        this.HIGHLIGHT_COLOR = Color.lightGray;
        this.highlightTag = null;
    }

    public TextHighlighter(JTextComponent jTextComponent, Color color) {
        this.mTextComponent = jTextComponent;
        this.mTextComponent.addFocusListener(this);
        this.mTextComponent.addMouseListener(this);
        this.HIGHLIGHT_COLOR = color;
        this.highlightTag = null;
    }

    private void highlight(int n, int n2) throws BadLocationException {
        DefaultHighlighter.DefaultHighlightPainter defaultHighlightPainter = new DefaultHighlighter.DefaultHighlightPainter(this.HIGHLIGHT_COLOR);
        if (n2 - n == 0 && this.highlightTag != null) {
            this.mTextComponent.getHighlighter().removeHighlight(this.highlightTag);
            this.highlightTag = null;
        } else if (n2 - n != 0) {
            if (this.highlightTag == null) {
                this.highlightTag = this.mTextComponent.getHighlighter().addHighlight(n, n2, defaultHighlightPainter);
            } else {
                this.mTextComponent.getHighlighter().changeHighlight(this.highlightTag, n, n2);
            }
        }
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
        this.resetHighlighting();
        int n = this.mTextComponent.getSelectionStart();
        int n2 = this.mTextComponent.getSelectionEnd();
        try {
            this.highlight(n, n2);
        }
        catch (BadLocationException badLocationException) {
            badLocationException.printStackTrace();
        }
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
        if (this.highlightTag != null) {
            this.resetHighlighting();
            this.mTextComponent.setSelectionStart(this.mTextComponent.getSelectionStart());
            this.mTextComponent.setSelectionEnd(this.mTextComponent.getSelectionEnd());
        }
    }

    public void resetHighlighting() {
        this.mTextComponent.getHighlighter().removeAllHighlights();
        this.highlightTag = null;
    }
}

