/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.controls;

import com.spss.java_client.ui.controls.ListKeyListener;
import com.spss.java_client.ui.controls.SimpleMoveList;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import java.awt.Dimension;

public class TargetMoveList
extends SimpleMoveList {
    public static final String DEFAULT_IDENTIFIER = "TargetMoveList";
    TargetListType mTargetType = TargetListType.normal;
    TargetMeasurementType mTargetMeasurementType = TargetMeasurementType.none;
    private boolean mAllowDuplicates;
    private boolean mDataSource;
    private ListKeyListener mListKeyListener;

    public TargetMoveList() {
        this(TargetListType.normal, SimpleMoveList.ListMoveType.eMoveOriginal);
    }

    public TargetMoveList(TargetListType targetListType) {
        this(targetListType, SimpleMoveList.ListMoveType.eMoveOriginal);
    }

    public TargetMoveList(TargetListType targetListType, SimpleMoveList.ListMoveType listMoveType) {
        super(listMoveType);
        this.setTargetType(targetListType);
        this.setContextMenuFlags(1);
        this.setSortDirection(true);
        this.setIdentifier(DEFAULT_IDENTIFIER);
        this.mListKeyListener = new ListKeyListener(this);
        this.addKeyListener(this.mListKeyListener);
    }

    public TargetListType getTargetType() {
        return this.mTargetType;
    }

    public void setTargetType(TargetListType targetListType) {
        if (targetListType == this.mTargetType) {
            return;
        }
        this.mTargetType = targetListType;
        int n = this.getFixedCellHeight() + 2;
        Dimension dimension = new Dimension(DialogUtil.getVarListWidth(), n);
        this.setMinimumSize(dimension);
        if (this.mTargetType == TargetListType.single_item) {
            this.setPreferredSize(dimension);
            this.setMaximumSize(dimension);
        } else {
            this.setPreferredSize(null);
            this.setMaximumSize(null);
        }
    }

    public TargetMeasurementType getTargetMeasurementType() {
        return this.mTargetMeasurementType;
    }

    public void setTargetMeasurementType(TargetMeasurementType targetMeasurementType) {
        if (targetMeasurementType == this.mTargetMeasurementType) {
            return;
        }
        this.mTargetMeasurementType = targetMeasurementType;
    }

    public String getVariablesStringList() {
        String string = "";
        int n = this.getModel().getSize();
        for (int i = 0; i < n; ++i) {
            string = string + this.getModel().getElementAt(i).toString();
            if (i >= n - 1) continue;
            string = string + " ";
        }
        return string;
    }

    public boolean canIncludeVariable(Object object) {
        boolean bl = super.canIncludeObject(object);
        if (bl && this.mTargetType == TargetListType.single_item) {
            bl = this.getModel().getSize() == 0;
        }
        return bl;
    }

    @Override
    public void updateUI() {
        this.removeKeyListener(this.mListKeyListener);
        super.updateUI();
        this.addKeyListener(this.mListKeyListener);
    }

    public void setDataSource(boolean bl) {
        this.mDataSource = bl;
    }

    public void setAllowDuplicates(boolean bl) {
        this.mAllowDuplicates = bl;
    }

    public boolean isAllowDuplicates() {
        return this.mAllowDuplicates;
    }

    public static enum TargetMeasurementType {
        none,
        scale,
        categorical;

    }

    public static enum TargetListType {
        normal,
        single_item;

    }
}

