/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.controls;

import com.spss.java_client.core.common.ComponentState;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

public class TableSorter
extends AbstractTableModel {
    public static final int DESCENDING = -1;
    public static final int NOT_SORTED = 0;
    public static final int ASCENDING = 1;
    public static final Comparator<Object> COMPARABLE_COMPARATOR = new Comparator<Object>(){

        @Override
        public int compare(Object object, Object object2) {
            return ((Comparable)object).compareTo(object2);
        }
    };
    public static final Comparator<Object> LEXICAL_COMPARATOR = new Comparator<Object>(){

        @Override
        public int compare(Object object, Object object2) {
            return object.toString().compareTo(object2.toString());
        }
    };
    public static Directive EMPTY_DIRECTIVE = new Directive(-1, 0);
    protected TableModel mTableModel;
    private JTable mTable;
    private Row[] mViewToModel;
    private int[] mModelToView;
    private JTableHeader mTableHeader;
    private MouseListener mMouseListener;
    private TableModelListener mTableModelListener;
    private Map<Class, Comparator<Object>> mColumnComparators = new HashMap<Class, Comparator<Object>>();
    private List<Directive> mSortingColumns = new ArrayList<Directive>();
    private boolean mEnableSort = true;

    public TableSorter() {
        this.mMouseListener = new MouseHandler();
        this.mTableModelListener = new TableModelHandler();
    }

    public TableSorter(TableModel tableModel) {
        this();
        this.setTableModel(tableModel);
    }

    public TableSorter(TableModel tableModel, JTableHeader jTableHeader) {
        this();
        this.setTableHeader(jTableHeader);
        this.setTableModel(tableModel);
    }

    public void setTable(JTable jTable) {
        this.mTable = jTable;
    }

    public TableModel getTableModel() {
        return this.mTableModel;
    }

    public void setTableModel(TableModel tableModel) {
        this.removeTableModelListener();
        this.mTableModel = tableModel;
        this.addTableModelListener();
        this.clearSortingState();
        this.fireTableStructureChanged();
    }

    public JTableHeader getTableHeader() {
        return this.mTableHeader;
    }

    public void addTableModelListener() {
        if (this.mTableModel != null && this.mTableModelListener != null) {
            this.mTableModel.addTableModelListener(this.mTableModelListener);
        }
    }

    public void removeTableModelListener() {
        if (this.mTableModel != null) {
            this.mTableModel.removeTableModelListener(this.mTableModelListener);
        }
    }

    public void setTableHeader(JTableHeader jTableHeader) {
        if (this.mTableHeader != null) {
            this.mTableHeader.removeMouseListener(this.mMouseListener);
            TableCellRenderer tableCellRenderer = this.mTableHeader.getDefaultRenderer();
            if (tableCellRenderer instanceof SortableHeaderRenderer) {
                this.mTableHeader.setDefaultRenderer(((SortableHeaderRenderer)tableCellRenderer).tableCellRenderer);
            }
        }
        this.mTableHeader = jTableHeader;
        if (this.mTableHeader != null) {
            this.mTableHeader.addMouseListener(this.mMouseListener);
            this.mTableHeader.setDefaultRenderer(new SortableHeaderRenderer(this.mTableHeader.getDefaultRenderer()));
        }
    }

    public SortableHeaderRenderer getSortableRenderer(TableCellRenderer tableCellRenderer) {
        return new SortableHeaderRenderer(tableCellRenderer);
    }

    public void setEnableSort(boolean bl) {
        this.mEnableSort = bl;
    }

    public boolean isSorting() {
        return this.mSortingColumns.size() != 0;
    }

    public int getSortingStatus(int n) {
        return this.getDirective(n).direction;
    }

    public void setSortingStatus(int n, int n2) {
        Directive directive = this.getDirective(n);
        if (directive != EMPTY_DIRECTIVE) {
            this.mSortingColumns.remove(directive);
        }
        if (n2 != 0) {
            this.mSortingColumns.add(new Directive(n, n2));
        }
        this.sortingStatusChanged();
    }

    public void cancelSorting() {
        this.mSortingColumns.clear();
        this.sortingStatusChanged();
    }

    public void setColumnComparator(Class<?> clazz, Comparator<Object> comparator) {
        if (comparator == null) {
            this.mColumnComparators.remove(clazz);
        } else {
            this.mColumnComparators.put(clazz, comparator);
        }
    }

    public int modelIndex(int n) {
        int n2 = -1;
        Row[] rowArray = this.getViewToModel();
        if (rowArray != null && n >= 0 && n < rowArray.length) {
            n2 = rowArray[n].modelIndex;
        }
        return n2;
    }

    @Override
    public int getRowCount() {
        return this.mTableModel == null ? 0 : this.mTableModel.getRowCount();
    }

    @Override
    public int getColumnCount() {
        return this.mTableModel == null ? 0 : this.mTableModel.getColumnCount();
    }

    @Override
    public String getColumnName(int n) {
        return this.mTableModel.getColumnName(n);
    }

    @Override
    public Class<?> getColumnClass(int n) {
        return this.mTableModel.getColumnClass(n);
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        return this.mTableModel.isCellEditable(this.modelIndex(n), n2);
    }

    @Override
    public Object getValueAt(int n, int n2) {
        return this.mTableModel.getValueAt(this.modelIndex(n), n2);
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
        this.mTableModel.setValueAt(object, this.modelIndex(n), n2);
    }

    protected Icon getHeaderRendererIcon(int n, int n2) {
        Directive directive = this.getDirective(n);
        if (directive == EMPTY_DIRECTIVE) {
            return null;
        }
        return new Arrow(directive.direction == -1, n2, this.mSortingColumns.indexOf(directive));
    }

    protected void onTableChanged(TableModelEvent tableModelEvent) {
        if (!this.isSorting()) {
            this.clearSortingState();
            this.fireTableChanged(tableModelEvent);
            return;
        }
        if (tableModelEvent.getFirstRow() == -1) {
            this.cancelSorting();
            this.fireTableChanged(tableModelEvent);
            return;
        }
        int n = tableModelEvent.getColumn();
        if (tableModelEvent.getFirstRow() == tableModelEvent.getLastRow() && n != -1 && this.getSortingStatus(n) == 0 && this.mModelToView != null) {
            int[] nArray = this.getModelToView();
            if (nArray != null) {
                int n2 = nArray[tableModelEvent.getFirstRow()];
                this.fireTableChanged(new TableModelEvent(this, n2, n2, n, tableModelEvent.getType()));
            }
            return;
        }
        this.clearSortingState();
        this.fireTableDataChanged();
    }

    protected int onMouseClickedOnHeader(MouseEvent mouseEvent) {
        int n = -1;
        if (SwingUtilities.isLeftMouseButton(mouseEvent) && mouseEvent.getClickCount() == 1) {
            int n2;
            JTableHeader jTableHeader;
            TableColumnModel tableColumnModel;
            int n3 = -1;
            if (this.mTable != null && this.mTable.getSelectedRow() > -1) {
                n3 = this.modelIndex(this.mTable.getSelectedRow());
                this.mTable.clearSelection();
            }
            if ((n = (tableColumnModel = (jTableHeader = (JTableHeader)mouseEvent.getSource()).getColumnModel()).getColumn(n2 = tableColumnModel.getColumnIndexAtX(mouseEvent.getX())).getModelIndex()) != -1 && this.canSortColumn(n)) {
                int n4 = this.getSortingStatus(n);
                if (!mouseEvent.isControlDown()) {
                    this.cancelSorting();
                }
                n4 += mouseEvent.isShiftDown() ? -1 : 1;
                n4 = (n4 + 4) % 3 - 1;
                this.setSortingStatus(n, n4);
                int n5 = this.getCurrentViewIndex(n3);
                if (n5 > -1) {
                    this.mTable.setRowSelectionInterval(n5, n5);
                }
            }
        }
        return n;
    }

    protected boolean canSortColumn(int n) {
        return true;
    }

    protected Comparator<Object> getComparator(int n) {
        Class<?> clazz = this.mTableModel.getColumnClass(n);
        Comparator<Object> comparator = this.mColumnComparators.get(clazz);
        if (comparator != null) {
            return comparator;
        }
        if (Comparable.class.isAssignableFrom(clazz)) {
            return COMPARABLE_COMPARATOR;
        }
        return LEXICAL_COMPARATOR;
    }

    private void clearSortingState() {
        this.mViewToModel = null;
        this.mModelToView = null;
    }

    private Directive getDirective(int n) {
        for (Directive directive : this.mSortingColumns) {
            if (directive.column != n) continue;
            return directive;
        }
        return EMPTY_DIRECTIVE;
    }

    private void sortingStatusChanged() {
        this.clearSortingState();
        this.fireTableDataChanged();
        if (this.mTableHeader != null) {
            this.mTableHeader.repaint();
        }
    }

    private Row[] getViewToModel() {
        int n;
        if (this.mViewToModel == null && (n = this.mTableModel.getRowCount()) > 0) {
            this.mViewToModel = new Row[n];
            for (int i = 0; i < n; ++i) {
                this.mViewToModel[i] = new Row(i);
            }
            if (this.isSorting()) {
                Arrays.sort(this.mViewToModel);
            }
        }
        return this.mViewToModel;
    }

    private int[] getModelToView() {
        Row[] rowArray;
        if (this.mModelToView == null && (rowArray = this.getViewToModel()) != null) {
            this.mModelToView = new int[rowArray.length];
            for (int i = 0; i < rowArray.length; ++i) {
                this.mModelToView[this.modelIndex((int)i)] = i;
            }
        }
        return this.mModelToView;
    }

    private int getCurrentViewIndex(int n) {
        int n2 = -1;
        for (int i = 0; i < this.getRowCount(); ++i) {
            if (this.modelIndex(i) != n) continue;
            n2 = i;
            break;
        }
        return n2;
    }

    private static class Directive {
        private int column;
        private int direction;

        public Directive(int n, int n2) {
            this.column = n;
            this.direction = n2;
        }
    }

    public class SortableHeaderRenderer
    implements TableCellRenderer {
        private TableCellRenderer tableCellRenderer;

        public SortableHeaderRenderer(TableCellRenderer tableCellRenderer) {
            this.tableCellRenderer = tableCellRenderer;
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            Component component = ComponentState.isBtdRtlOrLtr() && object != null && object instanceof String && ((String)object).length() > 0 ? this.tableCellRenderer.getTableCellRendererComponent(jTable, ComponentState.prepareStringForBidiRendering((String)((String)object)), bl, bl2, n, n2) : this.tableCellRenderer.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            if (component instanceof JLabel) {
                JLabel jLabel = (JLabel)component;
                jLabel.setHorizontalTextPosition(4);
                int n3 = jTable.convertColumnIndexToModel(n2);
                jLabel.setIcon(TableSorter.this.getHeaderRendererIcon(n3, jLabel.getFont().getSize()));
                jLabel.setIconTextGap(20);
            }
            return component;
        }
    }

    private static class Arrow
    implements Icon {
        private boolean descending;
        private int size;
        private int priority;

        public Arrow(boolean bl, int n, int n2) {
            this.descending = bl;
            this.size = n;
            this.priority = n2;
        }

        @Override
        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            Color color = component == null ? Color.GRAY : component.getBackground();
            int n3 = (int)((double)(this.size / 2) * Math.pow(0.8, this.priority));
            int n4 = this.descending ? n3 : -n3;
            n2 = n2 + 5 * this.size / 6 + (this.descending ? -n4 : 0);
            int n5 = this.descending ? 1 : -1;
            graphics.translate(n, n2);
            graphics.setColor(color.darker());
            graphics.drawLine(n3 / 2, n4, 0, 0);
            graphics.drawLine(n3 / 2, n4 + n5, 0, n5);
            graphics.setColor(color.brighter());
            graphics.drawLine(n3 / 2, n4, n3, 0);
            graphics.drawLine(n3 / 2, n4 + n5, n3, n5);
            if (this.descending) {
                graphics.setColor(color.darker().darker());
            } else {
                graphics.setColor(color.brighter().brighter());
            }
            graphics.drawLine(n3, 0, 0, 0);
            graphics.setColor(color);
            graphics.translate(-n, -n2);
        }

        @Override
        public int getIconWidth() {
            return this.size;
        }

        @Override
        public int getIconHeight() {
            return this.size;
        }
    }

    private class MouseHandler
    extends MouseAdapter {
        private MouseHandler() {
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            if (!TableSorter.this.mEnableSort) {
                return;
            }
            TableSorter.this.onMouseClickedOnHeader(mouseEvent);
        }
    }

    private class TableModelHandler
    implements TableModelListener {
        private TableModelHandler() {
        }

        @Override
        public void tableChanged(TableModelEvent tableModelEvent) {
            TableSorter.this.onTableChanged(tableModelEvent);
        }
    }

    private class Row
    implements Comparable {
        private int modelIndex;

        public Row(int n) {
            this.modelIndex = n;
        }

        public int compareTo(Object object) {
            int n = this.modelIndex;
            int n2 = ((Row)object).modelIndex;
            for (Directive directive : TableSorter.this.mSortingColumns) {
                int n3;
                int n4 = directive.column;
                Object object2 = TableSorter.this.mTableModel.getValueAt(n, n4);
                Object object3 = TableSorter.this.mTableModel.getValueAt(n2, n4);
                if (object2 == null && object3 == null) {
                    n3 = 0;
                } else if (object2 == null) {
                    n3 = -1;
                } else if (object3 == null) {
                    n3 = 1;
                } else {
                    n3 = TableSorter.this.getComparator(n4).compare(object2, object3);
                    int n5 = n3 > 0 ? 1 : (n3 = n3 < 0 ? -1 : 0);
                }
                if (n3 == 0) continue;
                return directive.direction == -1 ? -n3 : n3;
            }
            return 0;
        }
    }
}

