/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.controls;

import com.spss.java_client.core.common.CommandLine;
import com.spss.java_client.core.common.LocallyUniqueId;
import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.core.documents.DocType;
import com.spss.java_client.core.documents.data.DataMgr;
import com.spss.java_client.core.documents.data.dictionary.FormatType;
import com.spss.java_client.core.documents.data.dictionary.ISpssDataSrc;
import com.spss.java_client.core.documents.data.dictionary.ISpssVariable;
import com.spss.java_client.core.documents.data.dictionary.IVariableSet;
import com.spss.java_client.core.documents.data.dictionary.MeasurementLevel;
import com.spss.java_client.core.documents.data.dictionary.SPSS_Format;
import com.spss.java_client.core.documents.data.dictionary.SpssVariable;
import com.spss.java_client.ui.SpssFrameMgr;
import com.spss.java_client.ui.SpssMgr;
import com.spss.java_client.ui.controls.VarListModel;
import com.spss.java_client.ui.controls.VariableList;
import com.spss.java_client.ui.controls.VariableSetFilter;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.ProcedureDlgMgr;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.doc_types.SpssFrame;
import com.spss.java_client.ui.doc_types.data.DataFrame;
import com.spss.java_client.ui.resources.ResUtil;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Window;
import java.util.Map;
import java.util.Vector;

public class SrcVariableList
extends VariableList {
    public static final String DEFAULT_IDENTIFIER = "SourceVarList";
    protected boolean mAutoLoad = true;
    protected boolean mSuppressAlert = false;

    public SrcVariableList() {
        this(null, VariableList.VarMoveType.eMoveOriginal);
    }

    public SrcVariableList(VarListModel varListModel) {
        this(varListModel, VariableList.VarMoveType.eMoveOriginal);
    }

    public SrcVariableList(VariableList.VarMoveType varMoveType) {
        this(null, varMoveType);
    }

    public SrcVariableList(VarListModel varListModel, VariableList.VarMoveType varMoveType) {
        super(varListModel, varMoveType);
        Dimension dimension = new Dimension(DialogUtil.getVarListWidth(), DialogUtil.getVarListHeight());
        this.setMinimumSize(dimension);
        this.setIdentifier(DEFAULT_IDENTIFIER);
        this.setContextMenuFlags(7);
    }

    public int loadFromActiveDataset(boolean bl) {
        this.getModel().reset();
        SpssFrame spssFrame = SpssFrameMgr.getSpssFrameMgr().getDesignatedWindow(DocType.DE_DOC);
        if (spssFrame instanceof DataFrame) {
            return this.loadFromDataset(((DataFrame)spssFrame).getDatasetId(), bl);
        }
        return 0;
    }

    public IVariableSet getVariableSet(String string) {
        SpssFrame spssFrame = SpssFrameMgr.getSpssFrameMgr().getDesignatedWindow(DocType.DE_DOC);
        if (spssFrame instanceof DataFrame) {
            LocallyUniqueId locallyUniqueId = ((DataFrame)spssFrame).getDatasetId();
            if (locallyUniqueId == null || locallyUniqueId.isNull()) {
                return null;
            }
            ISpssDataSrc iSpssDataSrc = DataMgr.getDataMgr().getDataSource(locallyUniqueId);
            Map map = iSpssDataSrc.getMultiResponseVariableMap();
            return (IVariableSet)map.get(string);
        }
        return null;
    }

    public int loadFromActiveDataset() {
        return this.loadFromActiveDataset(false);
    }

    public int loadFromDataset(LocallyUniqueId locallyUniqueId, boolean bl) {
        if (locallyUniqueId == null || locallyUniqueId.isNull()) {
            this.setupDummyData(20);
            return this.getModel().getSize();
        }
        VariableSetFilter variableSetFilter = new VariableSetFilter(locallyUniqueId);
        this.addVarFilter(variableSetFilter);
        int n = 0;
        ISpssDataSrc iSpssDataSrc = DataMgr.getDataMgr().getDataSource(locallyUniqueId);
        if (iSpssDataSrc != null) {
            VarListModel varListModel = this.getModel();
            int n2 = iSpssDataSrc.columnCount();
            for (int i = 0; i < n2; ++i) {
                ISpssVariable iSpssVariable = iSpssDataSrc.getVariable(i);
                if (!varListModel.addElement(iSpssVariable, false)) continue;
                ++n;
            }
            if (bl) {
                Vector vector = iSpssDataSrc.getMRVariables();
                for (ISpssVariable iSpssVariable : vector) {
                    iSpssVariable.setDatasetIndex(n);
                    if (!varListModel.addElement(iSpssVariable, false)) continue;
                    ++n;
                }
            }
            varListModel.sort();
        }
        if (n == 0 && !CommandLine.isExternalCaller() && !this.mSuppressAlert) {
            if (ProcedureDlgMgr.getMgr().anyProcedureDialogsRunning(true)) {
                SpssAlertOptionPane.showInformationMessageDialog((Window)this.getBaseDialogParent(), ResUtil.getCommonDlgString("ERR_SOURCE_LIST_EMPTY_WARNING"), VersionInfo.getAppVersionString());
            } else {
                SpssAlertOptionPane.showInformationMessageDialog(SpssFrameMgr.getSpssFrameMgr().getDataFrame(SpssMgr.getSpssMgr().getActiveClientDatasetId()), ResUtil.getCommonDlgString("ERR_SOURCE_LIST_EMPTY_WARNING"), VersionInfo.getAppVersionString());
            }
        }
        return n;
    }

    public int loadFromDataset(LocallyUniqueId locallyUniqueId) {
        return this.loadFromDataset(locallyUniqueId, false);
    }

    @Override
    public void showDropFeedback(Point point) {
    }

    public boolean getAutoLoad() {
        return this.mAutoLoad;
    }

    public void setAutoLoad(boolean bl) {
        this.mAutoLoad = bl;
    }

    public void setSuppressAlert(boolean bl) {
        this.mSuppressAlert = bl;
    }

    protected void setupDummyData(int n) {
        int n2 = 1;
        String string = "Variable";
        String string2 = "Variable_Name_Extra_Long";
        VarListModel varListModel = this.getModel();
        for (int i = 0; i < n / 3; ++i) {
            SpssVariable spssVariable = new SpssVariable();
            SPSS_Format sPSS_Format = new SPSS_Format(FormatType.F, 10, 2);
            spssVariable.setFormat(sPSS_Format);
            spssVariable.setName(string + n2);
            spssVariable.setLabel("Variable" + n2 + " Label");
            spssVariable.setMeasurementLevel(MeasurementLevel.ordinal);
            spssVariable.setType((short)0);
            if (varListModel.addElement((ISpssVariable)spssVariable, false)) {
                ++n2;
            }
            SpssVariable spssVariable2 = new SpssVariable();
            sPSS_Format = new SPSS_Format(FormatType.A, 20, 0);
            spssVariable2.setFormat(sPSS_Format);
            spssVariable2.setName(string + n2);
            spssVariable2.setLabel("Variable" + n2 + " Label");
            spssVariable2.setMeasurementLevel(MeasurementLevel.nominal);
            spssVariable2.setType((short)20);
            if (varListModel.addElement((ISpssVariable)spssVariable2, false)) {
                ++n2;
            }
            SpssVariable spssVariable3 = new SpssVariable();
            sPSS_Format = new SPSS_Format(FormatType.PERCENT, 10, 0);
            spssVariable3.setFormat(sPSS_Format);
            spssVariable3.setName(string2 + n2);
            spssVariable3.setLabel("Variable" + n2 + " Label");
            spssVariable3.setMeasurementLevel(MeasurementLevel.scale);
            spssVariable3.setType((short)0);
            if (!varListModel.addElement((ISpssVariable)spssVariable3, false)) continue;
            ++n2;
        }
        varListModel.sort();
    }
}

