/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.controls;

import com.spss.java_client.core.common.CommandLine;
import com.spss.java_client.core.common.LocallyUniqueId;
import com.spss.java_client.core.documents.data.DataMgr;
import com.spss.java_client.core.documents.data.dictionary.ISpssDataSrc;
import com.spss.java_client.core.documents.data.dictionary.ISpssVariable;
import com.spss.java_client.ui.controls.CustomVarListModel;
import com.spss.java_client.ui.controls.ISpssVarFormatter;
import com.spss.java_client.ui.controls.TargetVariableList;
import com.spss.java_client.ui.dialogs.common.BaseProcedureDialog;
import com.spss.java_client.ui.dialogs.common.DialogDataModel;
import com.spss.shared.core_tools.utils.SerializableObject;
import java.awt.Component;
import java.awt.Container;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;

public abstract class SpssVarFormatter
implements ISpssVarFormatter {
    private static final String LOOKUP_SUFFIX = "_name_lookup";
    private TargetVariableList mVarList;
    private HashMap<Integer, Object> mVarMap = new FormatterMap<Integer, Object>();
    private boolean mUpdateNameMap = true;

    public SpssVarFormatter(TargetVariableList targetVariableList) {
        this.mVarList = targetVariableList;
    }

    @Override
    public abstract String getDisplayText(ISpssVariable var1);

    @Override
    public boolean getShowIcons() {
        return false;
    }

    public void clear() {
        this.mVarMap.clear();
    }

    @Override
    public TargetVariableList getVarList() {
        return this.mVarList;
    }

    public String getVarListId() {
        return this.mVarList.getIdentifier();
    }

    public HashMap<Integer, Object> getVarMap() {
        return this.mVarMap;
    }

    public HashMap<Integer, Object> getVarMapForSerialization() {
        LinkedHashMap<Integer, Object> linkedHashMap = new LinkedHashMap<Integer, Object>();
        linkedHashMap.putAll(this.mVarMap);
        return linkedHashMap;
    }

    public void setVarMap(HashMap<Integer, Object> hashMap) {
        if (hashMap != null) {
            hashMap = this.reconcileVarMap(hashMap);
            this.mVarMap.clear();
            Iterator<Integer> iterator = hashMap.keySet().iterator();
            if (iterator != null) {
                while (iterator.hasNext()) {
                    Integer n = iterator.next();
                    this.mVarMap.put(n, hashMap.get(n));
                }
            }
            ((CustomVarListModel)this.mVarList.getModel()).updateModel();
        }
    }

    public void setLegacyVarMap(HashMap<Integer, Object> hashMap) {
        if (hashMap != null) {
            hashMap = this.reconcileVarMap(hashMap);
            this.mVarMap.clear();
            Iterator<Integer> iterator = hashMap.keySet().iterator();
            if (iterator != null) {
                while (iterator.hasNext()) {
                    Integer n = iterator.next();
                    this.mVarMap.put(n, hashMap.get(n));
                }
            }
        }
    }

    public boolean getUpdateNameMap() {
        return this.mUpdateNameMap;
    }

    public void setUpdateNameMap(boolean bl) {
        this.mUpdateNameMap = bl;
    }

    public static HashMap<Integer, Object> updateLuids(DialogDataModel dialogDataModel, String string, HashMap<Integer, Object> hashMap) {
        HashMap<Integer, Object> hashMap2 = dialogDataModel.getMap(string + LOOKUP_SUFFIX);
        if (hashMap2 == null || hashMap2.isEmpty()) {
            return hashMap;
        }
        LocallyUniqueId locallyUniqueId = DataMgr.getDataMgr().getActiveDocumentId();
        ISpssDataSrc iSpssDataSrc = DataMgr.getDataMgr().getDataSource(locallyUniqueId);
        if (iSpssDataSrc == null) {
            return hashMap;
        }
        HashMap<Integer, Object> hashMap3 = new HashMap<Integer, Object>();
        HashMap<Integer, Object> hashMap4 = new HashMap<Integer, Object>();
        for (Map.Entry<Integer, Object> entry : hashMap.entrySet()) {
            int n;
            if (entry.getKey() < 0) {
                hashMap3.put(entry.getKey(), entry.getValue());
                hashMap4.put(entry.getKey(), "!!!");
                continue;
            }
            if (!hashMap2.containsKey(entry.getKey()) || (n = iSpssDataSrc.findVarIndex(hashMap2.get(entry.getKey()).toString())) <= -1) continue;
            ISpssVariable iSpssVariable = iSpssDataSrc.getVariable(n);
            hashMap3.put(iSpssVariable.getId().asInt(), entry.getValue());
            hashMap4.put(iSpssVariable.getId().asInt(), iSpssVariable.getName());
        }
        dialogDataModel.putMap(string + LOOKUP_SUFFIX, hashMap4);
        return hashMap3;
    }

    private HashMap<Integer, Object> reconcileVarMap(HashMap<Integer, Object> hashMap) {
        if (!CommandLine.isClementineCaller()) {
            return hashMap;
        }
        DialogDataModel dialogDataModel = this.getDDM();
        if (dialogDataModel == null) {
            return hashMap;
        }
        return SpssVarFormatter.updateLuids(dialogDataModel, this.getVarListId(), hashMap);
    }

    private static String lookupVarName(Object object) {
        LocallyUniqueId locallyUniqueId = DataMgr.getDataMgr().getActiveDocumentId();
        ISpssDataSrc iSpssDataSrc = DataMgr.getDataMgr().getDataSource(locallyUniqueId);
        if (iSpssDataSrc == null || !(object instanceof Integer) || (Integer)object < 0) {
            return null;
        }
        String string = null;
        int n = iSpssDataSrc.findVarIndex(new LocallyUniqueId(((Integer)object).intValue()));
        if (n > -1) {
            string = iSpssDataSrc.getVariable(n).getName();
        } else assert (false);
        return string;
    }

    private DialogDataModel getDDM() {
        DialogDataModel dialogDataModel = null;
        BaseProcedureDialog baseProcedureDialog = this.findParentDialog(this.mVarList);
        if (baseProcedureDialog != null) {
            dialogDataModel = baseProcedureDialog.getDialogDataModel();
        }
        return dialogDataModel;
    }

    private BaseProcedureDialog findParentDialog(Component component) {
        Container container;
        for (container = component.getParent(); container != null && !(container instanceof BaseProcedureDialog); container = container.getParent()) {
        }
        return container != null ? (BaseProcedureDialog)((Object)container) : null;
    }

    class FormatterMap<K, V>
    extends LinkedHashMap<K, V>
    implements Serializable {
        private LinkedHashMap<Integer, Object> mId2NameMap = new LinkedHashMap();
        private static final long serialVersionUID = 0xFFF00001L;

        FormatterMap() {
        }

        @Override
        public V put(K k, V v) {
            V v2 = super.put(k, v);
            try {
                String string = SpssVarFormatter.lookupVarName(k);
                if (string != null && this.mId2NameMap != null) {
                    this.mId2NameMap.put((Integer)k, string);
                    this.updateDDM();
                    boolean bl = v.getClass().getName().startsWith("java.") || v.getClass().getName().startsWith("[Ljava.");
                    boolean bl2 = v instanceof SerializableObject;
                    assert (bl || bl2);
                    bl = k.getClass().getName().startsWith("java.") || k.getClass().getName().startsWith("[Ljava.");
                    bl2 = k instanceof SerializableObject;
                    assert (bl || bl2);
                }
            }
            catch (AssertionError assertionError) {
                ((Throwable)((Object)assertionError)).printStackTrace();
            }
            return v2;
        }

        @Override
        public void putAll(Map<? extends K, ? extends V> map) {
            try {
                super.putAll(map);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }

        @Override
        public V remove(Object object) {
            this.mId2NameMap.remove(object);
            this.updateDDM();
            return super.remove(object);
        }

        @Override
        public void clear() {
            this.mId2NameMap.clear();
            this.updateDDM();
            super.clear();
        }

        private void updateDDM() {
            if (!SpssVarFormatter.this.mUpdateNameMap) {
                return;
            }
            DialogDataModel dialogDataModel = SpssVarFormatter.this.getDDM();
            if (dialogDataModel != null) {
                dialogDataModel.putMap(SpssVarFormatter.this.getVarListId() + SpssVarFormatter.LOOKUP_SUFFIX, this.mId2NameMap);
            } else assert (false);
        }

        private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
            LinkedHashMap linkedHashMap = new LinkedHashMap(this);
            objectOutputStream.writeInt(linkedHashMap.size());
            for (Object k : linkedHashMap.keySet()) {
                objectOutputStream.writeObject(k);
                Object v = linkedHashMap.get(k);
                boolean bl = v instanceof SerializableObject;
                objectOutputStream.writeBoolean(bl);
                if (bl) {
                    try {
                        DialogDataModel.writeObject(objectOutputStream, (SerializableObject)v);
                        continue;
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                        break;
                    }
                }
                objectOutputStream.writeObject(v);
            }
        }

        private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
            LinkedHashMap linkedHashMap = (LinkedHashMap)objectInputStream.readObject();
            int n = objectInputStream.readInt();
            for (int i = 0; i < n; ++i) {
                Object object;
                Object object2;
                block5: {
                    object2 = objectInputStream.readObject();
                    boolean bl = objectInputStream.readBoolean();
                    if (bl) {
                        try {
                            object = DialogDataModel.readObject(objectInputStream, DialogDataModel.getSerializeVersion());
                            break block5;
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                            break;
                        }
                    }
                    object = objectInputStream.readObject();
                }
                linkedHashMap.put(object2, object);
            }
            if (n > 0) {
                this.putAll(linkedHashMap);
            }
        }
    }
}

