/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.controls;

import com.spss.java_client.core.documents.data.dictionary.FormatType;
import com.spss.java_client.core.documents.data.dictionary.ISpssVariable;
import com.spss.java_client.core.documents.data.dictionary.MeasurementLevel;
import com.spss.java_client.core.documents.data.dictionary.SPSS_Format;
import com.spss.java_client.core.documents.data.dictionary.SpssMRVariable;
import com.spss.java_client.ui.controls.IVarFilter;

public class SpssVarFilter
implements IVarFilter {
    public static final int FILTER_ORDINAL = 1;
    public static final int FILTER_NOMINAL = 2;
    public static final int FILTER_SCALE = 4;
    public static final int FILTER_STRING = 8;
    public static final int FILTER_INTEGER = 16;
    public static final int FILTER_DATE = 32;
    public static final int FILTER_TIME = 64;
    public static final int FILTER_ORDINAL_STRING = 128;
    public static final int FILTER_ORDINAL_INTEGER = 256;
    public static final int FILTER_ORDINAL_DATE = 512;
    public static final int FILTER_ORDINAL_TIME = 1024;
    public static final int FILTER_NOMINAL_STRING = 2048;
    public static final int FILTER_NOMINAL_INTEGER = 4096;
    public static final int FILTER_NOMINAL_DATE = 8192;
    public static final int FILTER_NOMINAL_TIME = 16384;
    public static final int FILTER_SCALE_STRING = 32768;
    public static final int FILTER_SCALE_INTEGER = 65536;
    public static final int FILTER_SCALE_DATE = 131072;
    public static final int FILTER_SCALE_TIME = 262144;
    public static final int FILTER_MRVARS = 524288;
    private int mValFilter;
    private boolean mIsMultipleFilter;
    private boolean mIsExcludeFilterSet;
    private boolean mIsDateInTimeFormat = false;
    private boolean mIsIncludeOtherTypes = false;
    private boolean mIsIncludeDayWithTime = false;

    public SpssVarFilter(int n, boolean bl) {
        this(n, true, bl);
    }

    public SpssVarFilter(int n, boolean bl, boolean bl2) {
        this.mValFilter = n;
        this.mIsExcludeFilterSet = bl;
        this.mIsMultipleFilter = bl2;
    }

    public SpssVarFilter(int n, FormatType formatType, boolean bl) {
        this.mValFilter = n;
        this.mIsExcludeFilterSet = bl;
        this.mIsMultipleFilter = false;
        if (formatType == FormatType.TIME || formatType == FormatType.MTIME) {
            this.mIsDateInTimeFormat = true;
        }
    }

    public void allowDayToIncludeWithTime(boolean bl) {
        this.mIsIncludeDayWithTime = bl;
    }

    public void allowOtherTypesToInclude(boolean bl) {
        this.mIsIncludeOtherTypes = bl;
    }

    public boolean isDateInTimeFormat() {
        return this.mIsDateInTimeFormat;
    }

    public boolean isMultipleFilter() {
        return this.mIsMultipleFilter;
    }

    @Override
    public boolean canIncludeVariable(ISpssVariable iSpssVariable) {
        if (iSpssVariable instanceof SpssMRVariable && (this.mValFilter & 0x80000) == 524288) {
            return !this.mIsExcludeFilterSet;
        }
        int n = iSpssVariable.getDisplayMeasurementLevel() == MeasurementLevel.unknown ? iSpssVariable.getMeasurementLevel().value() : iSpssVariable.getDisplayMeasurementLevel().value();
        short s = iSpssVariable.getType();
        boolean bl = false;
        SPSS_Format sPSS_Format = iSpssVariable.getFormat();
        FormatType formatType = sPSS_Format.getFormatType();
        int n2 = formatType.value();
        if (this.mIsMultipleFilter) {
            switch (n) {
                case 1: {
                    bl = (this.mValFilter & 2) == 2 ? false : (s != 0 && (this.mValFilter & 0x800) == 2048 ? false : (s != 0 && (this.mValFilter & 8) == 8 ? false : (s == 0 && formatType.isNumericFormat() && (this.mValFilter & 0x1000) == 4096 ? false : (s == 0 && formatType.isNumericFormat() && (this.mValFilter & 0x10) == 16 ? false : (s == 0 && formatType.isDateOrTimeFormat() && (this.mValFilter & 0x2000) == 8192 ? false : s != 0 || !formatType.isDateOrTimeFormat() || (this.mValFilter & 0x4000) != 16384)))));
                    if (this.mIsExcludeFilterSet) {
                        return bl;
                    }
                    return !bl;
                }
                case 2: {
                    bl = (this.mValFilter & 1) == 1 ? false : (s != 0 && (this.mValFilter & 0x80) == 128 ? false : (s != 0 && (this.mValFilter & 8) == 8 ? false : (s == 0 && formatType.isNumericFormat() && (this.mValFilter & 0x100) == 256 ? false : (s == 0 && formatType.isNumericFormat() && (this.mValFilter & 0x10) == 16 ? false : (s == 0 && formatType.isDateOrTimeFormat() && (this.mValFilter & 0x200) == 512 ? false : s != 0 || !formatType.isDateOrTimeFormat() || (this.mValFilter & 0x400) != 1024)))));
                    if (this.mIsExcludeFilterSet) {
                        return bl;
                    }
                    return !bl;
                }
                case 0: 
                case 3: {
                    bl = (this.mValFilter & 4) == 4 ? false : (s != 0 && (this.mValFilter & 0x8000) == 32768 ? false : (s != 0 && (this.mValFilter & 8) == 8 ? false : (s == 0 && formatType.isNumericFormat() && (this.mValFilter & 0x10000) == 65536 ? false : (s == 0 && formatType.isNumericFormat() && (this.mValFilter & 0x10) == 16 ? false : (s == 0 && formatType.isDateOrTimeFormat() && (this.mValFilter & 0x20000) == 131072 ? false : s != 0 || !formatType.isDateOrTimeFormat() || (this.mValFilter & 0x40000) != 262144)))));
                    if (this.mIsExcludeFilterSet) {
                        return bl;
                    }
                    return !bl;
                }
            }
            bl = false;
            if (this.mIsExcludeFilterSet) {
                return bl;
            }
            return !bl;
        }
        if ((this.mValFilter & 1) == 1) {
            bl = n != 2;
        } else if ((this.mValFilter & 2) == 2) {
            bl = n != 1;
        } else if ((this.mValFilter & 4) == 4) {
            bl = n != 3;
        } else if ((this.mValFilter & 8) == 8) {
            bl = s == 0;
        } else if ((this.mValFilter & 0x10) == 16) {
            bl = s != 0 || !formatType.isNumericFormat();
        } else if ((this.mValFilter & 0x20) == 32) {
            if (this.mIsDateInTimeFormat) {
                int n3 = formatType.value();
                bl = s == 0 && formatType.isDateOrTimeFormat() ? (this.mIsIncludeDayWithTime ? formatType != FormatType.TIME && formatType != FormatType.MTIME && formatType != FormatType.DTIME : formatType != FormatType.TIME && formatType != FormatType.MTIME) : !this.mIsIncludeOtherTypes && !this.mIsExcludeFilterSet;
            } else {
                bl = s != 0 || !formatType.isDateOrTimeFormat();
            }
        } else if ((this.mValFilter & 0x40) == 64) {
            if (this.mIsDateInTimeFormat) {
                int n4 = formatType.value();
                bl = s == 0 && formatType.isDateOrTimeFormat() ? (this.mIsIncludeDayWithTime ? formatType != FormatType.TIME && formatType != FormatType.MTIME && formatType != FormatType.DTIME : formatType != FormatType.TIME && formatType != FormatType.MTIME) : !this.mIsIncludeOtherTypes && !this.mIsExcludeFilterSet;
            } else {
                bl = s != 0 || !formatType.isDateOrTimeFormat();
            }
        } else if ((this.mValFilter & 0x80) == 128) {
            bl = n != 2 || s == 0;
        } else if ((this.mValFilter & 0x100) == 256) {
            bl = n != 2 || s != 0 || !formatType.isNumericFormat();
        } else if ((this.mValFilter & 0x200) == 512) {
            bl = n != 2 || s != 0 || !formatType.isDateOrTimeFormat();
        } else if ((this.mValFilter & 0x400) == 1024) {
            bl = n != 2 || s != 0 || !formatType.isDateOrTimeFormat();
        } else if ((this.mValFilter & 0x800) == 2048) {
            bl = n != 1 || s == 0;
        } else if ((this.mValFilter & 0x1000) == 4096) {
            bl = n != 1 || s != 0 || !formatType.isNumericFormat();
        } else if ((this.mValFilter & 0x2000) == 8192) {
            bl = n != 1 || s != 0 || !formatType.isDateOrTimeFormat();
        } else if ((this.mValFilter & 0x4000) == 16384) {
            bl = n != 1 || s != 0 || !formatType.isDateOrTimeFormat();
        } else if ((this.mValFilter & 0x8000) == 32768) {
            bl = n != 3 || s == 0;
        } else if ((this.mValFilter & 0x10000) == 65536) {
            bl = n != 3 || s != 0 || !formatType.isNumericFormat();
        } else if ((this.mValFilter & 0x20000) == 131072) {
            bl = n != 3 || s != 0 || !formatType.isDateOrTimeFormat();
        } else if ((this.mValFilter & 0x40000) == 262144) {
            boolean bl2 = bl = n != 3 || s != 0 || !formatType.isDateOrTimeFormat();
        }
        if (this.mIsExcludeFilterSet) {
            return bl;
        }
        return !bl;
    }

    public boolean isExcludeFilterSet() {
        return this.mIsExcludeFilterSet;
    }

    public int getValFilter() {
        return this.mValFilter;
    }
}

