/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.controls;

import com.spss.uitools.dialogs.IProgressUIAgent;
import com.spss.uitools.res.UIToolResUtil;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;

public class SpssProgressDlg
extends JDialog
implements WindowListener,
ActionListener,
IProgressUIAgent {
    private JProgressBar mProgressBar;
    protected JLabel mMessage;
    protected JPanel mMessagePanel;
    private boolean mIsCancel = false;
    private Thread mInterruptThread;
    private boolean mWorkDoneFlag;

    public SpssProgressDlg(Window window, String string) {
        this(window, string, true);
    }

    public SpssProgressDlg(Window window, String string, boolean bl) {
        super(window, string);
        this.setModal(true);
        this.mInterruptThread = null;
        Container container = this.getContentPane();
        JPanel jPanel = new JPanel();
        jPanel.setBorder(BorderFactory.createEmptyBorder(10, 5, 10, 5));
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        this.mMessage = new JLabel("           ");
        this.mMessagePanel = new JPanel();
        this.mMessagePanel.setLayout(new BoxLayout(this.mMessagePanel, 1));
        this.mMessagePanel.add(this.mMessage);
        this.mProgressBar = new JProgressBar();
        this.mProgressBar.setPreferredSize(new Dimension(400, 20));
        this.mProgressBar.setMinimumSize(new Dimension(400, 20));
        this.mProgressBar.setIndeterminate(true);
        JButton jButton = new JButton(UIToolResUtil.getString((String)"IDS_CANCEL"));
        jButton.addActionListener(this);
        SpssProgressDlg.addUsingGBL(jPanel, this.mMessagePanel, gridBagConstraints, 0, 0, 1, 1, 23, new Insets(5, 5, 5, 5));
        SpssProgressDlg.addUsingGBL(jPanel, this.mProgressBar, gridBagConstraints, 0, 1, 1, 1, 23, new Insets(0, 5, 5, 5));
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 0;
        if (bl) {
            SpssProgressDlg.addUsingGBL(jPanel, jButton, gridBagConstraints, 0, 2, 1, 1, 10, new Insets(5, 5, 5, 5));
        }
        container.add(jPanel);
        this.addWindowListener(this);
        this.setLocationRelativeTo(null);
        this.pack();
    }

    public void setDeterminateMode() {
        this.mProgressBar.setIndeterminate(false);
        this.mProgressBar.setStringPainted(true);
        this.mProgressBar.setMinimum(0);
        this.mProgressBar.setMaximum(100);
        this.mProgressBar.setValue(0);
    }

    public void setMessage(final String string) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                SpssProgressDlg.this.mMessage.setText(string);
            }
        });
    }

    public void setValue(final int n) {
        if (n > this.mProgressBar.getValue()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    SpssProgressDlg.this.mProgressBar.setValue(n);
                }
            });
        }
    }

    public int getValue() {
        return this.mProgressBar.getValue();
    }

    @Override
    public void windowOpened(WindowEvent windowEvent) {
    }

    @Override
    public void windowClosing(WindowEvent windowEvent) {
        this.mIsCancel = true;
        this.abortThread();
        this.dispose();
    }

    @Override
    public void windowClosed(WindowEvent windowEvent) {
    }

    @Override
    public void windowIconified(WindowEvent windowEvent) {
    }

    @Override
    public void windowDeiconified(WindowEvent windowEvent) {
    }

    @Override
    public void windowActivated(WindowEvent windowEvent) {
    }

    @Override
    public void windowDeactivated(WindowEvent windowEvent) {
    }

    @Override
    public synchronized void actionPerformed(ActionEvent actionEvent) {
        this.mIsCancel = true;
        this.abortThread();
        this.dispose();
    }

    public synchronized boolean abort() {
        return this.mIsCancel;
    }

    public void setInterruptThread(Thread thread) {
        this.mInterruptThread = thread;
    }

    public void setCancel(boolean bl) {
        this.mIsCancel = bl;
    }

    public boolean isCancel() {
        return this.mIsCancel;
    }

    public void setWorkDone(boolean bl) {
        this.mWorkDoneFlag = bl;
    }

    public boolean isWorkDone() {
        return this.mWorkDoneFlag;
    }

    private void abortThread() {
        if (this.mInterruptThread != null && this.mInterruptThread.isAlive()) {
            try {
                this.mInterruptThread.interrupt();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            this.mInterruptThread = null;
        }
    }

    private static void addUsingGBL(JPanel jPanel, JComponent jComponent, GridBagConstraints gridBagConstraints, int n, int n2, int n3, int n4, int n5, Insets insets) {
        gridBagConstraints.gridx = n;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.gridwidth = n3;
        gridBagConstraints.gridheight = n4;
        gridBagConstraints.anchor = n5;
        gridBagConstraints.insets = insets == null ? new Insets(0, 0, 0, 0) : insets;
        jPanel.add((Component)jComponent, gridBagConstraints);
    }
}

