/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.controls;

import com.spss.java_client.ui.controls.LineInfo;
import com.spss.java_client.ui.controls.SpssMultiLineToggleButtonUtil;
import com.spss.shared.core_tools.system.OSInfo;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.io.Serializable;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JRadioButton;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;

public class SpssMultiLineRadioButton
extends JRadioButton {
    private int mMaxWidth;
    private Vector<LineInfo> mLines = new Vector();
    private int mIconWidth;
    private String mMnemonic = null;

    public SpssMultiLineRadioButton(Action action) {
        this(action, 220);
    }

    public SpssMultiLineRadioButton(Action action, int n) {
        super(action);
        Integer n2;
        LookAndFeel lookAndFeel = UIManager.getLookAndFeel();
        if (lookAndFeel != null && !lookAndFeel.getClass().getName().equals("com.apple.laf.AquaLookAndFeel")) {
            this.setIconTextGap(this.getIconTextGap() + 3);
        }
        this.mMaxWidth = n;
        Icon icon = UIManager.getIcon("RadioButton.icon");
        this.mIconWidth = icon != null ? icon.getIconWidth() : 15;
        if (OSInfo.getOSType() != OSInfo.OSType.MAC && (n2 = (Integer)action.getValue("MnemonicKey")) != null) {
            this.mMnemonic = "" + (char)n2.intValue();
        }
        this.setVerticalTextPosition(0);
        if (lookAndFeel != null && lookAndFeel.getName().contains("Cobalt")) {
            this.setName("CompToSkipFocusPaint");
        }
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentMoved(ComponentEvent componentEvent) {
                SpssMultiLineToggleButtonUtil.layoutControlText(SpssMultiLineRadioButton.this.getGraphics(), SpssMultiLineRadioButton.this, SpssMultiLineRadioButton.this.mLines, SpssMultiLineRadioButton.this.mMaxWidth);
            }

            @Override
            public void componentResized(ComponentEvent componentEvent) {
                SpssMultiLineToggleButtonUtil.layoutControlText(SpssMultiLineRadioButton.this.getGraphics(), SpssMultiLineRadioButton.this, SpssMultiLineRadioButton.this.mLines, SpssMultiLineRadioButton.this.mMaxWidth);
            }
        });
    }

    public int getMaxWidth() {
        return this.mMaxWidth;
    }

    public void setMaxWidth(int n) {
        this.mMaxWidth = n;
    }

    @Override
    public void setEnabled(boolean bl) {
        Color color = UIManager.getColor("textInactiveText");
        if (bl) {
            color = UIManager.getColor("textText");
        }
        this.setForeground(color);
        super.setEnabled(bl);
    }

    @Override
    public Dimension getPreferredSize() {
        if (this.mLines.size() == 0) {
            SpssMultiLineToggleButtonUtil.layoutControlText(this.getGraphics(), this, this.mLines, this.mMaxWidth);
        }
        int n = 0;
        Dimension dimension = new Dimension();
        for (LineInfo lineInfo : this.mLines) {
            dimension.width = n = Math.max(n, lineInfo.getLineSize().width);
            dimension.height += lineInfo.getLineSize().height;
        }
        dimension.width += this.mIconWidth + this.getIconTextGap();
        dimension.width += this.getMargin().left + this.getMargin().right;
        dimension.height += this.getMargin().top + this.getMargin().bottom;
        return dimension;
    }

    @Override
    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    @Override
    public Dimension getMaximumSize() {
        return this.getPreferredSize();
    }

    @Override
    public void paint(Graphics graphics) {
        super.paint(graphics);
        if (this.isFocusPainted() && this.hasFocus()) {
            if (OSInfo.getOSType() == OSInfo.OSType.MAC) {
                LookAndFeel lookAndFeel = UIManager.getLookAndFeel();
                if (lookAndFeel != null && lookAndFeel.getClass().getName().contains("SpssPlasticXPLookAndFeel")) {
                    SpssMultiLineToggleButtonUtil.renderFocusRectangle(graphics, this, this.mIconWidth);
                }
            } else {
                SpssMultiLineToggleButtonUtil.renderFocusRectangle(graphics, this, this.mIconWidth);
            }
        }
    }

    @Override
    public void paintComponent(Graphics graphics) {
        boolean bl = this.getVerticalTextPosition() == 1;
        int n = 0;
        if (bl) {
            Serializable serializable;
            Dimension dimension = this.getSize();
            if (this.isOpaque()) {
                serializable = graphics.getColor();
                graphics.setColor(this.getBackground());
                graphics.fillRect(0, 0, dimension.width, dimension.height);
                graphics.setColor((Color)serializable);
            }
            serializable = this.getMargin();
            int n2 = UIManager.getIcon("RadioButton.icon").getIconHeight();
            n = (dimension.height - n2 - ((Insets)serializable).top - ((Insets)serializable).bottom) / 2;
            graphics.translate(0, -n);
        }
        super.paintComponent(graphics);
        if (bl) {
            graphics.translate(0, n);
        }
        SpssMultiLineToggleButtonUtil.renderMultiLineText(graphics, this, this.mLines, this.mIconWidth, this.mMnemonic);
    }
}

