/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.controls;

import com.spss.java_client.ui.controls.ArrowButton;
import com.spss.java_client.ui.controls.ComponentsArrowButton;
import com.spss.java_client.ui.controls.PlainListArrowButton;
import com.spss.java_client.ui.controls.SerializableList;
import com.spss.java_client.ui.controls.SrcVariableList;
import com.spss.java_client.ui.controls.TargetVariableList;
import com.spss.java_client.ui.controls.VariableList;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.resources.ResUtil;
import com.spss.uitools.controls.ISpssArrowButtonMarker;
import java.awt.Component;
import java.awt.Image;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.io.Serializable;
import java.net.URL;
import java.text.MessageFormat;
import javax.swing.DefaultListSelectionModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultTreeSelectionModel;

public abstract class SpssArrowButton
extends JButton
implements FocusListener,
ListSelectionListener,
ActionListener,
ISpssArrowButtonMarker,
TreeSelectionListener {
    protected static ImageIcon[] sEnabledImages = new ImageIcon[4];
    protected static ImageIcon[] sDisabledImages = new ImageIcon[4];
    protected static ImageIcon[] sRolloverImages = new ImageIcon[4];
    protected static ImageIcon[] sPressedImages = new ImageIcon[4];
    protected static final String sActionCmd = "arrowPressed";
    protected ButtonOrientation mArrowOrientation = ButtonOrientation.right;
    protected SrcDestHolder[] mRegisteredContainers = new SrcDestHolder[2];
    protected boolean mUseSmallIcons = false;

    public SpssArrowButton() {
        this.mUseSmallIcons = false;
        this.init(this.mArrowOrientation);
    }

    public SpssArrowButton(boolean bl) {
        this.mUseSmallIcons = bl;
        this.init(this.mArrowOrientation);
    }

    public SpssArrowButton(ButtonOrientation buttonOrientation) {
        this.mUseSmallIcons = false;
        this.init(buttonOrientation);
    }

    public SpssArrowButton(boolean bl, ButtonOrientation buttonOrientation) {
        this.mUseSmallIcons = bl;
        this.init(buttonOrientation);
    }

    protected void init(ButtonOrientation buttonOrientation) {
        this.loadButtonImages();
        this.setActionCommand(sActionCmd);
        this.setPreferredSize(DialogUtil.getArrowButtonSize());
        this.addActionListener(this);
        this.setArrowOrientation(buttonOrientation);
        this.setDefaultCapable(true);
    }

    public ButtonOrientation getArrowOrientation() {
        return this.mArrowOrientation;
    }

    public void setArrowOrientation(ButtonOrientation buttonOrientation) {
        this.mArrowOrientation = buttonOrientation;
        this.setIcon(sEnabledImages[this.mArrowOrientation.ordinal()]);
        this.setDisabledIcon(sDisabledImages[this.mArrowOrientation.ordinal()]);
        this.setRolloverIcon(sRolloverImages[this.mArrowOrientation.ordinal()]);
        this.setRolloverSelectedIcon(sRolloverImages[this.mArrowOrientation.ordinal()]);
        this.setPressedIcon(sPressedImages[this.mArrowOrientation.ordinal()]);
        this.setSelectedIcon(sPressedImages[this.mArrowOrientation.ordinal()]);
        this.updateEnable(this.getSourceVarHolder());
        this.setAccessibleContextName();
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
        SrcDestHolder srcDestHolder;
        if (!focusEvent.isTemporary() && (srcDestHolder = this.getHolder(focusEvent.getComponent())) != null && !this.getArrowOrientation().equals((Object)srcDestHolder.mArrowOrient)) {
            boolean bl = true;
            if (srcDestHolder.getComponent() instanceof VariableList) {
                VariableList variableList = (VariableList)srcDestHolder.getComponent();
                boolean bl2 = bl = variableList.getModel().getSize() > 0;
            }
            if (bl) {
                this.setArrowOrientation(srcDestHolder.mArrowOrient);
            }
        }
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        Object object = listSelectionEvent.getSource();
        if (object instanceof Component || object instanceof DefaultListSelectionModel) {
            SrcDestHolder srcDestHolder = object instanceof Component ? this.getHolder((Component)object) : this.getSourceVarHolder();
            if (srcDestHolder != null && srcDestHolder.mArrowOrient == this.getArrowOrientation()) {
                this.updateEnable(srcDestHolder);
            }
            if (srcDestHolder != null) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        SpssArrowButton.this.setAccessibleContextName();
                    }
                });
            }
        }
    }

    @Override
    public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
        Object object = treeSelectionEvent.getSource();
        if (object instanceof Component || object instanceof DefaultTreeSelectionModel) {
            SrcDestHolder srcDestHolder = object instanceof Component ? this.getHolder((Component)object) : this.getSourceVarHolder();
            if (srcDestHolder != null && srcDestHolder.mArrowOrient == this.getArrowOrientation()) {
                this.updateEnable(srcDestHolder);
            }
            if (srcDestHolder != null) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        SpssArrowButton.this.setAccessibleContextName();
                    }
                });
            }
        }
    }

    public void setAccessibleContextName(String string) {
        this.accessibleContext.setAccessibleName(string);
    }

    protected void setAccessibleContextName() {
        this.accessibleContext = this.getAccessibleContext();
        SrcDestHolder srcDestHolder = null;
        SrcDestHolder srcDestHolder2 = null;
        if (this instanceof PlainListArrowButton) {
            srcDestHolder = this.getTargetVarHolder();
            srcDestHolder2 = this.getSourceVarHolder();
        } else if (this instanceof ArrowButton) {
            srcDestHolder = this.getTargetVarHolder();
            srcDestHolder2 = this.getSourceVarHolder();
        } else if (this instanceof ComponentsArrowButton) {
            srcDestHolder = this.getTargetVarHolder();
            srcDestHolder2 = this.getSourceVarHolder();
        }
        if (srcDestHolder2 != null && srcDestHolder != null) {
            Object object;
            if (srcDestHolder2.getComponent() instanceof SerializableList && srcDestHolder.getComponent() instanceof SerializableList) {
                Object object2;
                if (srcDestHolder2.mArrowOrient == ButtonOrientation.right) {
                    Object object3 = ((JComponent)srcDestHolder.getComponent()).getClientProperty("labeledBy");
                    if (object3 instanceof JLabel) {
                        String string = MessageFormat.format(ResUtil.getCommonDlgString("TXT_ADD_MESSAGE"), ((JLabel)object3).getText());
                        this.accessibleContext.setAccessibleName(string);
                    }
                } else if (srcDestHolder2.mArrowOrient == ButtonOrientation.left && (object2 = ((JComponent)srcDestHolder2.getComponent()).getClientProperty("labeledBy")) instanceof JLabel) {
                    String string = MessageFormat.format(ResUtil.getCommonDlgString("TXT_REMOVE_MESSAGE"), ((JLabel)object2).getText());
                    this.accessibleContext.setAccessibleName(string);
                }
            } else if (srcDestHolder2.getComponent() instanceof TargetVariableList && srcDestHolder.getComponent() instanceof TargetVariableList) {
                Object object4;
                if (srcDestHolder2.mArrowOrient == ButtonOrientation.right) {
                    Object object5 = ((JComponent)srcDestHolder.getComponent()).getClientProperty("labeledBy");
                    if (object5 instanceof JLabel) {
                        String string = MessageFormat.format(ResUtil.getCommonDlgString("TXT_ADD_MESSAGE"), ((JLabel)object5).getText());
                        this.accessibleContext.setAccessibleName(string);
                    }
                } else if (srcDestHolder2.mArrowOrient == ButtonOrientation.left && (object4 = ((JComponent)srcDestHolder2.getComponent()).getClientProperty("labeledBy")) instanceof JLabel) {
                    String string = MessageFormat.format(ResUtil.getCommonDlgString("TXT_REMOVE_MESSAGE"), ((JLabel)object4).getText());
                    this.accessibleContext.setAccessibleName(string);
                }
            } else if (srcDestHolder2.getComponent() instanceof TargetVariableList && srcDestHolder.getComponent() instanceof SrcVariableList) {
                Object object6 = ((JComponent)srcDestHolder2.getComponent()).getClientProperty("labeledBy");
                if (object6 instanceof JLabel) {
                    if (this.mArrowOrientation == ButtonOrientation.left) {
                        String string = MessageFormat.format(ResUtil.getCommonDlgString("TXT_REMOVE_MESSAGE"), ((JLabel)object6).getText());
                        this.accessibleContext.setAccessibleName(string);
                    } else {
                        String string = MessageFormat.format(ResUtil.getCommonDlgString("TXT_ADD_MESSAGE"), ((JLabel)object6).getText());
                        this.accessibleContext.setAccessibleName(string);
                    }
                }
            } else if (srcDestHolder2.getComponent() instanceof SrcVariableList && srcDestHolder.getComponent() instanceof TargetVariableList) {
                Object object7 = ((JComponent)srcDestHolder.getComponent()).getClientProperty("labeledBy");
                if (object7 instanceof JLabel) {
                    if (this.mArrowOrientation == ButtonOrientation.right) {
                        String string = MessageFormat.format(ResUtil.getCommonDlgString("TXT_ADD_MESSAGE"), ((JLabel)object7).getText());
                        this.accessibleContext.setAccessibleName(string);
                    } else {
                        String string = MessageFormat.format(ResUtil.getCommonDlgString("TXT_REMOVE_MESSAGE"), ((JLabel)object7).getText());
                        this.accessibleContext.setAccessibleName(string);
                    }
                }
            } else if (this instanceof ComponentsArrowButton && srcDestHolder2.mArrowOrient == ButtonOrientation.right) {
                Object object8 = ((JComponent)srcDestHolder.getComponent()).getClientProperty("labeledBy");
                if (object8 instanceof JLabel) {
                    String string = MessageFormat.format(ResUtil.getCommonDlgString("TXT_ADD_MESSAGE"), ((JLabel)object8).getText());
                    this.accessibleContext.setAccessibleName(string);
                }
            } else if (this instanceof ComponentsArrowButton && srcDestHolder2.mArrowOrient == ButtonOrientation.left && (object = ((JComponent)srcDestHolder2.getComponent()).getClientProperty("labeledBy")) instanceof JLabel) {
                String string = MessageFormat.format(ResUtil.getCommonDlgString("TXT_REMOVE_MESSAGE"), ((JLabel)object).getText());
                this.accessibleContext.setAccessibleName(string);
            }
        }
    }

    protected void loadButtonImages() {
        Image image;
        Serializable serializable;
        String string;
        if (sEnabledImages[0] == null) {
            if (this.mUseSmallIcons) {
                string = ResUtil.getCommonDlgString("IDS_LEFT_ARROW_IMAGE");
                serializable = ResUtil.getCommonDlgImageResource(string);
                SpssArrowButton.sEnabledImages[0] = new ImageIcon((URL)serializable);
                string = ResUtil.getCommonDlgString("IDS_SMALL_UP_ARROW_IMAGE");
                serializable = ResUtil.getCommonDlgImageResource(string);
                SpssArrowButton.sEnabledImages[1] = new ImageIcon((URL)serializable);
                string = ResUtil.getCommonDlgString("IDS_RIGHT_ARROW_IMAGE");
                serializable = ResUtil.getCommonDlgImageResource(string);
                SpssArrowButton.sEnabledImages[2] = new ImageIcon((URL)serializable);
                string = ResUtil.getCommonDlgString("IDS_SMALL_DOWN_ARROW_IMAGE");
                serializable = ResUtil.getCommonDlgImageResource(string);
                SpssArrowButton.sEnabledImages[3] = new ImageIcon((URL)serializable);
            } else {
                string = ResUtil.getCommonDlgString("IDS_LEFT_ARROW_IMAGE");
                serializable = ResUtil.getCommonDlgImageResource(string);
                SpssArrowButton.sEnabledImages[0] = new ImageIcon((URL)serializable);
                string = ResUtil.getCommonDlgString("IDS_UP_ARROW_IMAGE");
                serializable = ResUtil.getCommonDlgImageResource(string);
                SpssArrowButton.sEnabledImages[1] = new ImageIcon((URL)serializable);
                string = ResUtil.getCommonDlgString("IDS_RIGHT_ARROW_IMAGE");
                serializable = ResUtil.getCommonDlgImageResource(string);
                SpssArrowButton.sEnabledImages[2] = new ImageIcon((URL)serializable);
                string = ResUtil.getCommonDlgString("IDS_DOWN_ARROW_IMAGE");
                serializable = ResUtil.getCommonDlgImageResource(string);
                SpssArrowButton.sEnabledImages[3] = new ImageIcon((URL)serializable);
            }
        }
        if (sDisabledImages[0] == null) {
            if (this.mUseSmallIcons) {
                string = ResUtil.getCommonDlgString("IDS_LEFT_ARROW_DISABLED_IMAGE");
                serializable = ResUtil.getCommonDlgImageResource(string);
                SpssArrowButton.sDisabledImages[0] = new ImageIcon((URL)serializable);
                string = ResUtil.getCommonDlgString("IDS_SMALL_UP_ARROW_DISABLED_IMAGE");
                serializable = ResUtil.getCommonDlgImageResource(string);
                SpssArrowButton.sDisabledImages[1] = new ImageIcon((URL)serializable);
                string = ResUtil.getCommonDlgString("IDS_RIGHT_ARROW_DISABLED_IMAGE");
                serializable = ResUtil.getCommonDlgImageResource(string);
                SpssArrowButton.sDisabledImages[2] = new ImageIcon((URL)serializable);
                string = ResUtil.getCommonDlgString("IDS_SMALL_DOWN_ARROW_DISABLED_IMAGE");
                serializable = ResUtil.getCommonDlgImageResource(string);
                SpssArrowButton.sDisabledImages[3] = new ImageIcon((URL)serializable);
            } else {
                string = ResUtil.getCommonDlgString("IDS_LEFT_ARROW_DISABLED_IMAGE");
                serializable = ResUtil.getCommonDlgImageResource(string);
                SpssArrowButton.sDisabledImages[0] = new ImageIcon((URL)serializable);
                string = ResUtil.getCommonDlgString("IDS_UP_ARROW_DISABLED_IMAGE");
                serializable = ResUtil.getCommonDlgImageResource(string);
                SpssArrowButton.sDisabledImages[1] = new ImageIcon((URL)serializable);
                string = ResUtil.getCommonDlgString("IDS_RIGHT_ARROW_DISABLED_IMAGE");
                serializable = ResUtil.getCommonDlgImageResource(string);
                SpssArrowButton.sDisabledImages[2] = new ImageIcon((URL)serializable);
                string = ResUtil.getCommonDlgString("IDS_DOWN_ARROW_DISABLED_IMAGE");
                serializable = ResUtil.getCommonDlgImageResource(string);
                SpssArrowButton.sDisabledImages[3] = new ImageIcon((URL)serializable);
            }
        }
        if (sRolloverImages[0] == null) {
            for (int i = 0; i < 4; ++i) {
                serializable = sEnabledImages[i];
                image = ((ImageIcon)serializable).getImage().getScaledInstance(((ImageIcon)serializable).getIconHeight() + 1, ((ImageIcon)serializable).getIconHeight() + 1, 4);
                SpssArrowButton.sRolloverImages[i] = new ImageIcon(image);
            }
        }
        if (sPressedImages[0] == null) {
            for (int i = 0; i < 4; ++i) {
                serializable = sEnabledImages[i];
                image = ((ImageIcon)serializable).getImage().getScaledInstance(((ImageIcon)serializable).getIconHeight() - 1, ((ImageIcon)serializable).getIconHeight() - 1, 4);
                SpssArrowButton.sPressedImages[i] = new ImageIcon(image);
            }
        }
    }

    protected SrcDestHolder getHolder(Component component) {
        for (SrcDestHolder srcDestHolder : this.mRegisteredContainers) {
            if (srcDestHolder == null || srcDestHolder.getComponent() != component) continue;
            return srcDestHolder;
        }
        return null;
    }

    protected SrcDestHolder getSourceVarHolder() {
        for (SrcDestHolder srcDestHolder : this.mRegisteredContainers) {
            if (srcDestHolder == null || srcDestHolder.mArrowOrient != this.mArrowOrientation) continue;
            return srcDestHolder;
        }
        return null;
    }

    protected SrcDestHolder getTargetVarHolder() {
        for (SrcDestHolder srcDestHolder : this.mRegisteredContainers) {
            if (srcDestHolder == null || srcDestHolder.mArrowOrient == this.mArrowOrientation) continue;
            return srcDestHolder;
        }
        return null;
    }

    protected void updateTipText() {
        String string = !this.isEnabled() ? null : (this.mArrowOrientation == ButtonOrientation.left ? ResUtil.getCommonDlgString("IDS_ARROW_LEFT_DESC") : (this.mArrowOrientation == ButtonOrientation.up ? ResUtil.getCommonDlgString("IDS_ARROW_UP_DESC") : (this.mArrowOrientation == ButtonOrientation.right ? ResUtil.getCommonDlgString("IDS_ARROW_RIGHT_DESC") : ResUtil.getCommonDlgString("IDS_ARROW_DOWN_DESC"))));
        this.setToolTipText(string);
    }

    protected abstract void updateEnable(SrcDestHolder var1);

    protected abstract class SrcDestHolder {
        public ButtonOrientation mArrowOrient;

        protected SrcDestHolder(ButtonOrientation buttonOrientation) {
            this.mArrowOrient = buttonOrientation;
        }

        protected abstract Component getComponent();
    }

    public static enum ButtonOrientation {
        left,
        up,
        right,
        down;

    }
}

