/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.controls;

import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.resources.ResUtil;
import java.awt.Component;
import java.awt.Image;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.io.Serializable;
import java.net.URL;
import java.text.MessageFormat;
import javax.swing.DefaultListSelectionModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public abstract class SpssAddDeleteButtons
extends JButton
implements FocusListener,
ListSelectionListener,
ActionListener {
    protected static ImageIcon[] sEnabledImages = new ImageIcon[2];
    protected static ImageIcon[] sDisabledImages = new ImageIcon[2];
    protected static ImageIcon[] sRolloverImages = new ImageIcon[2];
    protected static ImageIcon[] sPressedImages = new ImageIcon[2];
    protected static final String sActionCmd = "addDeletePressed";
    protected ButtonType mButtonType = ButtonType.add;
    protected SrcDestHolder[] mRegisteredContainers = new SrcDestHolder[1];

    public SpssAddDeleteButtons() {
        this.init(this.mButtonType);
    }

    public SpssAddDeleteButtons(ButtonType buttonType) {
        this.init(buttonType);
    }

    protected void init(ButtonType buttonType) {
        this.loadButtonImages();
        this.setActionCommand(sActionCmd);
        this.setPreferredSize(DialogUtil.getArrowButtonSize());
        this.addActionListener(this);
        this.setButtonType(buttonType);
        this.setDefaultCapable(true);
    }

    public ButtonType getButtonType() {
        return this.mButtonType;
    }

    public void setButtonType(ButtonType buttonType) {
        this.mButtonType = buttonType;
        this.setIcon(sEnabledImages[this.mButtonType.ordinal()]);
        this.setDisabledIcon(sDisabledImages[this.mButtonType.ordinal()]);
        this.setRolloverIcon(sRolloverImages[this.mButtonType.ordinal()]);
        this.setRolloverSelectedIcon(sRolloverImages[this.mButtonType.ordinal()]);
        this.setPressedIcon(sPressedImages[this.mButtonType.ordinal()]);
        this.setSelectedIcon(sPressedImages[this.mButtonType.ordinal()]);
        this.updateEnable(this.getSourceVarHolder());
        this.setAccessibleContextName();
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
        SrcDestHolder srcDestHolder;
        if (focusEvent.isTemporary() || (srcDestHolder = this.getHolder(focusEvent.getComponent())) != null) {
            // empty if block
        }
    }

    protected SrcDestHolder getHolder(Component component) {
        for (SrcDestHolder srcDestHolder : this.mRegisteredContainers) {
            if (srcDestHolder == null || srcDestHolder.getComponent() != component) continue;
            return srcDestHolder;
        }
        return null;
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        SrcDestHolder srcDestHolder;
        Object object = listSelectionEvent.getSource();
        if ((object instanceof JList || object instanceof DefaultListSelectionModel) && (srcDestHolder = this.getSourceVarHolder()) != null) {
            this.updateEnable(srcDestHolder);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    SpssAddDeleteButtons.this.setAccessibleContextName();
                }
            });
        }
    }

    public void setAccessibleContextName(String string) {
        this.accessibleContext.setAccessibleName(string);
    }

    protected void setAccessibleContextName() {
        this.accessibleContext = this.getAccessibleContext();
        SrcDestHolder srcDestHolder = this.getSourceVarHolder();
        if (srcDestHolder != null) {
            if (this.mButtonType == ButtonType.add) {
                Object object = ((JComponent)srcDestHolder.getComponent()).getClientProperty("labeledBy");
                if (object instanceof JLabel) {
                    String string = MessageFormat.format(ResUtil.getCommonDlgString("TXT_ADD_TO_MESSAGE"), ((JLabel)object).getText());
                    this.accessibleContext.setAccessibleName(string);
                }
            } else {
                Object object = ((JComponent)srcDestHolder.getComponent()).getClientProperty("labeledBy");
                if (object instanceof JLabel) {
                    String string = MessageFormat.format(ResUtil.getCommonDlgString("TXT_REMOVE_FROM_MESSAGE"), ((JLabel)object).getText());
                    this.accessibleContext.setAccessibleName(string);
                }
            }
        }
    }

    protected SrcDestHolder getSourceVarHolder() {
        for (SrcDestHolder srcDestHolder : this.mRegisteredContainers) {
            if (srcDestHolder == null) continue;
            return srcDestHolder;
        }
        return null;
    }

    protected void loadButtonImages() {
        Image image;
        Serializable serializable;
        String string;
        if (sEnabledImages[0] == null) {
            string = ResUtil.getCommonDlgString("IDS_SMALL_PLUS_IMAGE");
            serializable = ResUtil.getCommonDlgImageResource(string);
            SpssAddDeleteButtons.sEnabledImages[0] = new ImageIcon((URL)serializable);
            string = ResUtil.getCommonDlgString("IDS_SMALL_DELETE_IMAGE");
            serializable = ResUtil.getCommonDlgImageResource(string);
            SpssAddDeleteButtons.sEnabledImages[1] = new ImageIcon((URL)serializable);
        }
        if (sDisabledImages[0] == null) {
            string = ResUtil.getCommonDlgString("IDS_SMALL_PLUS_DISABLED_IMAGE");
            serializable = ResUtil.getCommonDlgImageResource(string);
            SpssAddDeleteButtons.sDisabledImages[0] = new ImageIcon((URL)serializable);
            string = ResUtil.getCommonDlgString("IDS_SMALL_DELETE_DISABLED_IMAGE");
            serializable = ResUtil.getCommonDlgImageResource(string);
            SpssAddDeleteButtons.sDisabledImages[1] = new ImageIcon((URL)serializable);
        }
        if (sRolloverImages[0] == null) {
            for (int i = 0; i < 2; ++i) {
                serializable = sEnabledImages[i];
                image = ((ImageIcon)serializable).getImage().getScaledInstance(((ImageIcon)serializable).getIconHeight() + 1, ((ImageIcon)serializable).getIconHeight() + 1, 4);
                SpssAddDeleteButtons.sRolloverImages[i] = new ImageIcon(image);
            }
        }
        if (sPressedImages[0] == null) {
            for (int i = 0; i < 2; ++i) {
                serializable = sEnabledImages[i];
                image = ((ImageIcon)serializable).getImage().getScaledInstance(((ImageIcon)serializable).getIconHeight() - 1, ((ImageIcon)serializable).getIconHeight() - 1, 4);
                SpssAddDeleteButtons.sPressedImages[i] = new ImageIcon(image);
            }
        }
    }

    protected void updateTipText() {
        String string = "";
        if (!this.isEnabled()) {
            string = null;
        } else if (this.mButtonType == ButtonType.add) {
            string = ResUtil.getCommonDlgString("IDS_ARROW_LEFT_DESC");
        } else if (this.mButtonType == ButtonType.delete) {
            string = ResUtil.getCommonDlgString("IDS_ARROW_UP_DESC");
        }
        this.setToolTipText(string);
    }

    protected abstract void updateEnable(SrcDestHolder var1);

    protected abstract class SrcDestHolder {
        public ButtonType mButtonType;

        protected SrcDestHolder(ButtonType buttonType) {
            this.mButtonType = buttonType;
        }

        protected abstract Component getComponent();
    }

    public static enum ButtonType {
        add,
        delete;

    }
}

