/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.controls;

import com.spss.java_client.core.common.ComponentState;
import com.spss.java_client.core.documents.data.dictionary.ISpssVariable;
import com.spss.java_client.ui.controls.BaseDataList;
import com.spss.java_client.ui.controls.BaseMoveListModel;
import com.spss.java_client.ui.controls.FocusHighlighter;
import com.spss.java_client.ui.controls.IDoubleClickListener;
import com.spss.java_client.ui.controls.IVarFilter;
import com.spss.java_client.ui.dialogs.common.BaseProcedureDialog;
import com.spss.java_client.ui.dialogs.common.BaseSpssDialog;
import com.spss.java_client.ui.dialogs.common.BaseSubDialog;
import com.spss.java_client.ui.dialogs.common.BaseWizardDialog;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.VariableInfoWindow;
import com.spss.java_client.ui.resources.ResUtil;
import com.spss.shared.core_tools.system.OSInfo;
import com.spss.uitools.dialogs.BaseDialog;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.net.URL;
import java.text.Bidi;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.ListSelectionModel;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;

public class SimpleMoveList
extends BaseDataList
implements PopupMenuListener {
    public static final int CONTEXT_MENU_VARIABLE_INFO = 1;
    public static final int CONTEXT_MENU_NAMES_LABELS = 2;
    public static final int CONTEXT_MENU_ITEM_SORT = 4;
    public static final int CONTEXT_MENU_MEASUREMENT_LEVEL = 8;
    protected static final int NUM_VAR_ICONS = 18;
    protected static final int MIN_LIST_ITEM_HEIGHT = 18;
    protected static Icon[] sVarIcons = new Icon[18];
    protected static Border sNoFocusBorder;
    protected static Border sFocusBorder;
    protected static HashMap<SimpleMoveList, VariableInfoWindow> sVarInfoDlgMap;
    public Vector<IVarFilter> mVarFilters;
    protected String mIdentifier;
    protected JPopupMenu mContextMenu;
    protected int mContextMenuFlags;
    protected VariableInfoAction mVarInfoAction;
    protected ListMoveType mDragType;
    protected int mDropFeedbackIndex;
    protected boolean mLockSelections;
    protected FocusHighlighter mFocusHighlighter;
    protected ContextEventListener mContextEventListener;
    protected SelectionAdapter mSelectionListener;
    protected boolean mShowIcon;
    protected boolean mLockTextDisplay;
    protected Component[] mAdditionalMenuItems;
    private boolean mLoadFromPersistent;
    private Vector<IDoubleClickListener> mDoubleClickListener;
    private boolean mDoubleClickEnabled;
    private boolean mDragSupported;
    public int mMaxLimitOfList;

    public SimpleMoveList() {
        this(null, ListMoveType.eDoNothing);
    }

    public SimpleMoveList(ListMoveType listMoveType) {
        this(null, listMoveType);
    }

    public SimpleMoveList(BaseMoveListModel baseMoveListModel, ListMoveType listMoveType) {
        baseMoveListModel = baseMoveListModel == null ? new BaseMoveListModel(null) : baseMoveListModel;
        super((ListModel)baseMoveListModel);
        this.mVarFilters = new Vector(1);
        this.mIdentifier = "VarList";
        this.mContextMenu = null;
        this.mContextMenuFlags = 0;
        this.mVarInfoAction = null;
        this.mDragType = ListMoveType.eDoNothing;
        this.mDropFeedbackIndex = -1;
        this.mLockSelections = false;
        this.mFocusHighlighter = new FocusHighlighter(this);
        this.mContextEventListener = new ContextEventListener();
        this.mSelectionListener = new SelectionAdapter();
        this.mShowIcon = true;
        this.mLockTextDisplay = false;
        this.mAdditionalMenuItems = null;
        this.mLoadFromPersistent = true;
        this.mDoubleClickListener = new Vector();
        this.mDoubleClickEnabled = true;
        this.mDragSupported = true;
        this.mMaxLimitOfList = -1;
        this.init(baseMoveListModel);
        this.setDragType(listMoveType);
        this.addMouseListener(new DoubleClickHandler());
        Dimension dimension = new Dimension(DialogUtil.getVarListWidth(), 10);
        this.setMinimumSize(dimension);
    }

    @Override
    public void setEnabled(boolean bl) {
        JViewport jViewport;
        Container container;
        super.setEnabled(bl);
        this.setOpaque(bl);
        Container container2 = this.getParent();
        if (container2 instanceof JViewport && (container = (jViewport = (JViewport)container2).getParent()) instanceof JScrollPane) {
            JScrollPane jScrollPane = (JScrollPane)container;
            jScrollPane.getVerticalScrollBar().setEnabled(bl);
            jScrollPane.getHorizontalScrollBar().setEnabled(bl);
            jScrollPane.setWheelScrollingEnabled(bl);
        }
    }

    @Override
    public void setSelectedIndex(int n) {
        super.setSelectedIndex(n);
        this.ensureIndexIsVisible(n);
    }

    public String getIdentifier() {
        return this.mIdentifier;
    }

    public void setIdentifier(String string) {
        this.mIdentifier = string;
    }

    public boolean canIncludeObject(Object object) {
        return true;
    }

    public final ListMoveType getDragType() {
        return this.mDragType;
    }

    public void setDragType(ListMoveType listMoveType) {
        this.mDragType = listMoveType;
        this.setDragEnabled(false);
    }

    public void setDragSupported(boolean bl) {
        this.mDragSupported = bl;
    }

    public boolean isDragSupported() {
        return this.mDragSupported;
    }

    public BaseMoveListModel getModel() {
        return (BaseMoveListModel)super.getModel();
    }

    public void setSelection(Object[] objectArray) {
        this.setSelection(objectArray, false);
    }

    public void setSelection(Object[] objectArray, boolean bl) {
        this.clearSelection();
        int n = -1;
        BaseMoveListModel baseMoveListModel = this.getModel();
        for (Object object : objectArray) {
            int n2;
            Integer[] integerArray = bl ? baseMoveListModel.findElementIndexesByName(object.toString()) : ((n2 = baseMoveListModel.findElementIndex(object)) > -1 ? new Integer[]{n2} : new Integer[]{});
            Integer[] integerArray2 = integerArray;
            int n3 = integerArray2.length;
            for (int i = 0; i < n3; ++i) {
                int n4 = integerArray2[i];
                this.addSelectionInterval(n4, n4);
                if (n != -1) continue;
                n = n4;
            }
        }
        if (n > -1) {
            this.ensureIndexIsVisible(n);
        }
    }

    public int getContextMenuFlags() {
        return this.mContextMenuFlags;
    }

    public void setContextMenuFlags(int n) {
        this.mContextMenuFlags = n;
    }

    public ArrayList<Object> getAllListObjects() {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (int i = 0; i < this.getModel().getSize(); ++i) {
            arrayList.add(this.getModel().getElementAt(i));
        }
        return arrayList;
    }

    @Override
    public Object[] getSelectedValues() {
        ListSelectionModel listSelectionModel = this.getSelectionModel();
        BaseMoveListModel baseMoveListModel = this.getModel();
        int n = listSelectionModel.getMinSelectionIndex();
        int n2 = listSelectionModel.getMaxSelectionIndex();
        if (n2 >= baseMoveListModel.getSize()) {
            n2 = baseMoveListModel.getSize() - 1;
        }
        if (n < 0 || n2 < 0) {
            return new Object[0];
        }
        if (n > n2) {
            int n3 = n;
            n = n2;
            n2 = n3;
        }
        Object[] objectArray = new Object[1 + (n2 - n)];
        int n4 = 0;
        for (int i = n; i <= n2 && i < baseMoveListModel.getSize(); ++i) {
            if (!listSelectionModel.isSelectedIndex(i)) continue;
            objectArray[n4++] = baseMoveListModel.getElementAt(i);
        }
        Object[] objectArray2 = new Object[n4];
        System.arraycopy(objectArray, 0, objectArray2, 0, n4);
        return objectArray2;
    }

    @Override
    public void removeAll() {
        this.getModel().removeAll();
        this.repaint();
    }

    @Override
    public void setSelectionInterval(int n, int n2) {
        if (this.mLockSelections) {
            return;
        }
        super.setSelectionInterval(n, n2);
    }

    @Override
    public void addSelectionInterval(int n, int n2) {
        if (this.mLockSelections) {
            return;
        }
        super.addSelectionInterval(n, n2);
    }

    @Override
    public void removeSelectionInterval(int n, int n2) {
        if (this.mLockSelections) {
            return;
        }
        super.removeSelectionInterval(n, n2);
    }

    public void setShowIcon(boolean bl) {
        this.mShowIcon = bl;
        if (this.isVisible()) {
            this.repaint();
        }
    }

    public boolean getShowIcon() {
        return this.mShowIcon;
    }

    public void setSortDirection(boolean bl) {
        this.getModel().setSortDirection(bl);
        if (this.isVisible()) {
            this.repaint();
        }
    }

    public boolean isSortAscending() {
        return this.getModel().isSortAscending();
    }

    public void setShowVarLabels(boolean bl, boolean bl2) {
        Object object = null;
        int n = this.getLeadSelectionIndex();
        if (n > -1 && n < this.getModel().getSize()) {
            object = this.getModel().getElementAt(n);
        }
        this.getModel().setShowVarLabels(bl);
        this.mLockTextDisplay = bl2;
        if (this.isVisible()) {
            if (object != null) {
                this.ensureIndexIsVisible(this.getModel().findElementIndex(object));
            }
            this.repaint();
        }
    }

    public boolean containsAll(List list) {
        return this.getModel().containsAll(list);
    }

    public boolean getShowVarLabels() {
        return this.getModel().getShowVarLabels();
    }

    public boolean getLockItemDisplay() {
        return this.mLockTextDisplay;
    }

    public boolean getLockSelections() {
        return this.mLockSelections;
    }

    public void setLockSelections(boolean bl) {
        this.mLockSelections = bl;
    }

    public void showDropFeedback(Point point) {
        if (point != null && this.getModel().getSize() > 0) {
            int n = this.locationToIndex(point);
            if (!this.itemInUpperHalf(point)) {
                ++n;
            }
            if (n > -1) {
                if (n != this.mDropFeedbackIndex && this.mDropFeedbackIndex > -1) {
                    this.renderDropLine(this.mDropFeedbackIndex, false);
                }
                this.renderDropLine(n, true);
                this.mDropFeedbackIndex = n;
            }
        } else if (this.mDropFeedbackIndex > -1) {
            this.renderDropLine(this.mDropFeedbackIndex, false);
            this.mDropFeedbackIndex = -1;
        }
    }

    public int getDropFeedbackIndex() {
        return this.mDropFeedbackIndex;
    }

    public boolean itemInUpperHalf(Point point) {
        Rectangle rectangle;
        int n = this.locationToIndex(point);
        if (n > -1 && (rectangle = this.getCellBounds(n, n)).contains(point)) {
            int n2 = (int)(rectangle.getMinY() + rectangle.getHeight() / 2.0);
            return n2 > point.y;
        }
        return false;
    }

    public TransferData getTransferData() {
        Object[] objectArray = this.getSelectedValues();
        int[] nArray = this.getSelectedIndices();
        return new TransferData(objectArray, nArray);
    }

    @Override
    public void updateUI() {
        this.removeFocusListener(this.mFocusHighlighter);
        this.removeListSelectionListener(this.mSelectionListener);
        this.removeMouseListener(this.mContextEventListener);
        this.removeKeyListener(this.mContextEventListener);
        super.updateUI();
        this.addMouseListener(this.mContextEventListener);
        this.addKeyListener(this.mContextEventListener);
        this.addFocusListener(this.mFocusHighlighter);
        this.addListSelectionListener(this.mSelectionListener);
    }

    public static void clearBorders() {
        FocusHighlighter.sTargetBorder = null;
        sFocusBorder = null;
        sNoFocusBorder = null;
    }

    public boolean isLoadFromPersistent() {
        return this.mLoadFromPersistent;
    }

    public void setLoadFromPersistent(boolean bl) {
        this.mLoadFromPersistent = bl;
    }

    public int getMaxLimitOfList() {
        return this.mMaxLimitOfList;
    }

    public void setMaxLimitOfList(int n) {
        this.mMaxLimitOfList = n;
    }

    public FocusHighlighter getFocusHighlighter() {
        return this.mFocusHighlighter;
    }

    public void addDoubleClickListener(IDoubleClickListener iDoubleClickListener) {
        if (iDoubleClickListener == null || this.mDoubleClickListener.contains(iDoubleClickListener)) {
            return;
        }
        this.mDoubleClickListener.add(iDoubleClickListener);
    }

    public void removeDoubleClickListener(IDoubleClickListener iDoubleClickListener) {
        if (iDoubleClickListener == null || !this.mDoubleClickListener.contains(iDoubleClickListener)) {
            return;
        }
        this.mDoubleClickListener.remove(iDoubleClickListener);
    }

    public void setDoubleClickEnabled(boolean bl) {
        this.mDoubleClickEnabled = bl;
    }

    public void setAdditonalMenuItems(Component[] componentArray) {
        this.mAdditionalMenuItems = componentArray;
    }

    @Override
    public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
    }

    @Override
    public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
    }

    @Override
    public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
    }

    protected void init(BaseMoveListModel baseMoveListModel) {
        baseMoveListModel.setListCtrl(this);
        this.setCellRenderer(new VarlistCellRenderer());
        this.setPrototypeCellValue("123-45-6789");
        int n = this.getFixedCellHeight();
        n = n < 18 ? 18 : n;
        this.setFixedCellHeight(n);
        this.updateUI();
    }

    protected void renderDropLine(int n, boolean bl) {
        boolean bl2 = n >= this.getModel().getSize();
        int n2 = !bl2 ? n : this.getModel().getSize() - 1;
        Rectangle rectangle = this.getCellBounds(n2, n2);
        int n3 = 0;
        if (rectangle != null) {
            n3 = (int)(bl2 ? rectangle.getY() + rectangle.getHeight() : rectangle.getY());
        }
        Graphics graphics = this.getGraphics();
        Color color = this.isSelectedIndex(n) ? this.getSelectionBackground() : this.getBackground();
        graphics.setColor(bl ? Color.red : color);
        graphics.drawLine(0, n3, this.getWidth(), n3);
        graphics.dispose();
    }

    protected static void loadImageIcons() {
        if (sVarIcons[0] != null && sVarIcons[17] != null) {
            return;
        }
        String[] stringArray = new String[]{"IDS_SCALE_VAR_IMAGE", "IDS_ORDINAL_VAR_IMAGE", "IDS_NOMINAL_VAR_IMAGE", "IDS_ORDINAL_STRING_VAR_IMAGE", "IDS_NOMINAL_STRING_VAR_IMAGE", "IDS_SCALE_DATE_VAR_IMAGE", "IDS_ORDINAL_DATE_VAR_IMAGE", "IDS_NOMINAL_DATE_VAR_IMAGE", "IDS_SCALE_TIME_VAR_IMAGE", "IDS_ORDINAL_TIME_VAR_IMAGE", "IDS_NOMINAL_TIME_VAR_IMAGE", "IDS_MC_SET_VAR_IMAGE", "IDS_MD_SET_VAR_IMAGE", "IDS_CALCULATED_SCALE_VAR_IMAGE", "IDS_FACTOR_IMAGE", "IDS_COVARIATE_IMAGE", "IDS_RANDOM_IMAGE", "IDS_TIME_DEPENDENT_VAR_IMAGE"};
        for (int i = 0; i < 18; ++i) {
            String string = ResUtil.getCommonDlgString(stringArray[i]);
            URL uRL = ResUtil.getCommonDlgImageResource(string);
            SimpleMoveList.sVarIcons[i] = new ImageIcon(uRL);
        }
    }

    protected BaseDialog getBaseDialogParent() {
        Container container;
        BaseDialog baseDialog = null;
        for (container = this.getParent(); container != null && !(container instanceof BaseDialog); container = container.getParent()) {
        }
        if (container != null) {
            baseDialog = (BaseDialog)container;
        }
        return baseDialog;
    }

    protected void addContextMenuItems(Component[] componentArray) {
        for (Component component : componentArray) {
            this.mContextMenu.add(component);
        }
    }

    static {
        SimpleMoveList.loadImageIcons();
        sNoFocusBorder = null;
        sFocusBorder = null;
        sVarInfoDlgMap = new HashMap();
    }

    static enum VarImage {
        eScaleIdx,
        eOrdinalIdx,
        eNominalIdx,
        eStringOrdinalIdx,
        eStringNominalIdx,
        eDateScaleIdx,
        eDateOrdinalIdx,
        eDateNominalIdx,
        eTimeScaleIdx,
        eTimeOrdinalIdx,
        eTimeNominalIdx,
        eMCSetIdx,
        eMDSetIdx,
        eCalculatedScale,
        eFactor,
        eCovariate,
        eRandom,
        eTimeDependentIdx;

    }

    class SelectionAdapter
    implements ListSelectionListener {
        SelectionAdapter() {
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            VariableInfoWindow variableInfoWindow;
            if (listSelectionEvent.getValueIsAdjusting()) {
                return;
            }
            int n = SimpleMoveList.this.getSelectedIndex();
            if (n <= -1 && (variableInfoWindow = sVarInfoDlgMap.get(SimpleMoveList.this)) != null) {
                variableInfoWindow.setVisible(false);
            }
        }
    }

    class NamesLabelsAction
    extends AbstractAction {
        private boolean mNames;

        public NamesLabelsAction(boolean bl) {
            Integer n;
            this.mNames = bl;
            this.putValue("Name", ResUtil.getCommonDlgString(bl ? "IDS_DISPLAY_NAMES" : "IDS_DISPLAY_LABELS"));
            if (OSInfo.getOSType() != OSInfo.OSType.MAC && (n = ResUtil.getCommonDlgAccessKey(bl ? "IDK_DISPLAY_NAMES" : "IDK_DISPLAY_LABELS")) != null) {
                this.putValue("MnemonicKey", n);
            }
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            BaseDialog baseDialog;
            if (!SimpleMoveList.this.getLockItemDisplay() && (baseDialog = SimpleMoveList.this.getBaseDialogParent()) != null) {
                if (baseDialog instanceof BaseProcedureDialog) {
                    BaseProcedureDialog baseProcedureDialog = (BaseProcedureDialog)baseDialog;
                    BaseProcedureDialog.NameLabelOption nameLabelOption = this.mNames ? BaseProcedureDialog.NameLabelOption.show_names : BaseProcedureDialog.NameLabelOption.show_labels;
                    baseProcedureDialog.setNameLabelOverride(nameLabelOption, true);
                } else if (baseDialog instanceof BaseSubDialog) {
                    BaseSubDialog baseSubDialog = (BaseSubDialog)baseDialog;
                    BaseProcedureDialog.NameLabelOption nameLabelOption = this.mNames ? BaseProcedureDialog.NameLabelOption.show_names : BaseProcedureDialog.NameLabelOption.show_labels;
                    baseSubDialog.setNameLabelOverride(nameLabelOption, true);
                } else if (baseDialog instanceof BaseWizardDialog) {
                    BaseWizardDialog baseWizardDialog = (BaseWizardDialog)baseDialog;
                    BaseProcedureDialog.NameLabelOption nameLabelOption = this.mNames ? BaseProcedureDialog.NameLabelOption.show_names : BaseProcedureDialog.NameLabelOption.show_labels;
                    baseWizardDialog.setNameLabelOverride(nameLabelOption, true);
                } else {
                    BaseProcedureDialog.NameLabelOption nameLabelOption = this.mNames ? BaseProcedureDialog.NameLabelOption.show_names : BaseProcedureDialog.NameLabelOption.show_labels;
                    BaseSpssDialog.updateListTextDisplaySetting(nameLabelOption, (Container)baseDialog, true);
                }
            }
        }
    }

    class VariableInfoAction
    extends AbstractAction {
        private int mIndex = 0;

        public VariableInfoAction() {
            Integer n;
            this.putValue("Name", ResUtil.getCommonDlgString("IDS_VARIABLE_INFO"));
            if (OSInfo.getOSType() != OSInfo.OSType.MAC && (n = ResUtil.getCommonDlgAccessKey("IDK_VARIABLE_INFO")) != null) {
                this.putValue("MnemonicKey", n);
            }
        }

        public void setItemIndex(int n) {
            this.mIndex = n;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (this.mIndex < 0) {
                return;
            }
            BaseDialog baseDialog = SimpleMoveList.this.getBaseDialogParent();
            if (baseDialog == null) {
                return;
            }
        }
    }

    class ContextEventListener
    extends MouseAdapter
    implements KeyListener {
        ContextEventListener() {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            if (mouseEvent.isConsumed()) {
                return;
            }
            if (SimpleMoveList.this.isEnabled()) {
                SimpleMoveList.this.grabFocus();
                int n = SimpleMoveList.this.locationToIndex(mouseEvent.getPoint());
                if (!(n <= -1 || this.isDiscontinuousSelectionKeyPressed(mouseEvent) || mouseEvent.isShiftDown() || SimpleMoveList.this.isSelectedIndex(n))) {
                    SimpleMoveList.this.setSelectedIndex(n);
                }
            }
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            if (mouseEvent.isConsumed()) {
                return;
            }
            if (SimpleMoveList.this.isEnabled()) {
                SimpleMoveList.this.grabFocus();
            }
        }

        @Override
        public void keyPressed(KeyEvent keyEvent) {
            if (keyEvent.isConsumed()) {
                return;
            }
            if (OSInfo.getOSType() == OSInfo.OSType.MAC && keyEvent.getKeyCode() == 32) {
                SimpleMoveList.this.setSelectedIndex(SimpleMoveList.this.getLeadSelectionIndex());
            }
        }

        @Override
        public void keyReleased(KeyEvent keyEvent) {
        }

        @Override
        public void keyTyped(KeyEvent keyEvent) {
        }

        public boolean isDiscontinuousSelectionKeyPressed(MouseEvent mouseEvent) {
            boolean bl = false;
            bl = OSInfo.getOSType() == OSInfo.OSType.MAC ? mouseEvent.isMetaDown() : mouseEvent.isControlDown();
            return bl;
        }
    }

    class VarlistCellRenderer
    extends JLabel
    implements ListCellRenderer {
        VarlistCellRenderer() {
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            boolean bl3 = object instanceof ISpssVariable;
            boolean bl4 = SimpleMoveList.this.getShowVarLabels();
            boolean bl5 = false;
            this.setText(object != null ? object.toString() : "");
            if (jList.isEnabled()) {
                this.setOpaque(true);
                if (bl) {
                    if (SimpleMoveList.this.hasFocus()) {
                        this.setBackground(jList.getSelectionBackground());
                        this.setForeground(jList.getSelectionForeground());
                    } else {
                        this.setBackground(Color.lightGray);
                        this.setForeground(Color.black);
                    }
                } else {
                    this.setBackground(jList.getBackground());
                    this.setForeground(jList.getForeground());
                }
                if (bl5) {
                    this.setForeground(Color.RED);
                }
            } else {
                this.setOpaque(false);
            }
            this.setEnabled(jList.isEnabled());
            this.setFont(jList.getFont());
            this.handleBorder(jList, bl2);
            return this;
        }

        private String concatLabelNameForBidiDispaly(String string, String string2) {
            String string3 = null;
            if (string == null && string2 == null) {
                return string3;
            }
            string3 = string != null && string.length() > 0 ? (ComponentState.getBTD() == 1 && !new Bidi(Character.toString(string.charAt(0)), 1).isRightToLeft() ? '\u200f' + string + " [" + string2 + "]" : (ComponentState.getBTD() == 2 && new Bidi(Character.toString(string.charAt(0)), 1).isRightToLeft() ? '\u200e' + string + " [" + string2 + "]" : string + " [" + string2 + "]")) : (ComponentState.getBTD() == 1 && !new Bidi(Character.toString(string2.charAt(0)), 1).isRightToLeft() ? '\u200f' + string2 : (ComponentState.getBTD() == 2 && new Bidi(Character.toString(string2.charAt(0)), 1).isRightToLeft() ? '\u200e' + string2 : string2));
            return string3;
        }

        private void handleBorder(JList jList, boolean bl) {
            if (sNoFocusBorder == null || sFocusBorder == null) {
                this.createBorders();
            }
            Border border = bl && jList.isEnabled() ? sFocusBorder : sNoFocusBorder;
            this.setBorder(border);
        }

        private void createBorders() {
            Border border = BorderFactory.createEmptyBorder(0, 2, 0, 0);
            Border border2 = UIManager.getBorder("List.focusCellHighlightBorder");
            sFocusBorder = BorderFactory.createCompoundBorder(border2, border);
            border2 = BorderFactory.createEmptyBorder(1, 1, 1, 1);
            sNoFocusBorder = BorderFactory.createCompoundBorder(border2, border);
        }
    }

    public class TransferData
    implements Cloneable {
        private Object[] mVars;
        private int[] mSelectedIndices;

        public TransferData(Object[] objectArray, int[] nArray) {
            this.mVars = objectArray;
            this.mSelectedIndices = nArray;
        }

        public int[] getSelectedIndices() {
            return this.mSelectedIndices;
        }

        public Object[] getVariables() {
            return this.mVars;
        }

        public Object clone() throws CloneNotSupportedException {
            TransferData transferData = (TransferData)super.clone();
            transferData.mVars = (Object[])this.mVars.clone();
            transferData.mSelectedIndices = (int[])this.mSelectedIndices.clone();
            return transferData;
        }
    }

    class DoubleClickHandler
    extends MouseAdapter {
        DoubleClickHandler() {
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            if (SimpleMoveList.this.mDoubleClickEnabled && SimpleMoveList.this.isEnabled() && mouseEvent.getButton() == 1 && mouseEvent.getClickCount() == 2 && SimpleMoveList.this.mDoubleClickListener.size() == 1) {
                ((IDoubleClickListener)SimpleMoveList.this.mDoubleClickListener.get(0)).doDoubleClickAction();
            }
        }
    }

    public static enum ListMoveType {
        eDoNothing,
        eKeepOriginal,
        eMoveOriginal;

    }
}

