/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.controls;

import com.spss.java_client.core.common.ComponentState;
import com.spss.java_client.ui.controls.DefaultEditableListModel;
import com.spss.java_client.ui.controls.DefaultListCellEditor;
import com.spss.java_client.ui.controls.EditableList;
import com.spss.java_client.ui.controls.FocusHighlighter;
import com.spss.java_client.ui.controls.ListKeyListener;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JViewport;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.UIManager;
import javax.swing.border.Border;

public class SerializableEditableList
extends EditableList {
    private String mActionKey;
    private boolean mIsSerializable;
    protected FocusHighlighter mFocusHighlighter = new FocusHighlighter(this);
    private int mMaxLimitOfList = -1;
    private ListKeyListener mListKeyListener;
    private JTextField mCellTextField = new JTextField();
    private DefaultListCellEditor mCellEditor = new DefaultListCellEditor(this.mCellTextField);

    public SerializableEditableList(String string) {
        super((ListModel)new DefaultEditableListModel());
        this.setListCellEditor(this.mCellEditor);
        if (ComponentState.isBtdRtlOrLtr()) {
            this.setCellRenderer(new SerializableEdutableListCellRenderer());
        }
        this.updateUI();
        this.mActionKey = string;
        this.mIsSerializable = true;
        this.mListKeyListener = new ListKeyListener(this);
        this.addKeyListener(this.mListKeyListener);
    }

    @Override
    public void setEnabled(boolean bl) {
        JViewport jViewport;
        Container container;
        super.setEnabled(bl);
        this.setOpaque(bl);
        Container container2 = this.getParent();
        if (container2 instanceof JViewport && (container = (jViewport = (JViewport)container2).getParent()) instanceof JScrollPane) {
            JScrollPane jScrollPane = (JScrollPane)container;
            jScrollPane.getVerticalScrollBar().setEnabled(bl);
            jScrollPane.getHorizontalScrollBar().setEnabled(bl);
            jScrollPane.setWheelScrollingEnabled(bl);
        }
    }

    @Override
    public void setSelectedIndex(int n) {
        super.setSelectedIndex(n);
        this.ensureIndexIsVisible(n);
    }

    @Override
    public void updateUI() {
        this.removeFocusListener(this.mFocusHighlighter);
        this.removeKeyListener(this.mListKeyListener);
        super.updateUI();
        this.addKeyListener(this.mListKeyListener);
        FocusHighlighter.sTargetBorder = null;
        this.addFocusListener(this.mFocusHighlighter);
    }

    public String getActionKey() {
        return this.mIsSerializable ? this.mActionKey : "";
    }

    public void setActionKey(String string) {
        this.mActionKey = string;
    }

    public FocusHighlighter getFocusHighlighter() {
        return this.mFocusHighlighter;
    }

    public boolean isSerializable() {
        return this.mIsSerializable;
    }

    public void setSerializable(boolean bl) {
        this.mIsSerializable = bl;
    }

    public int getMaxLimitOfList() {
        return this.mMaxLimitOfList;
    }

    public void setMaxLimitOfList(int n) {
        this.mMaxLimitOfList = n;
    }

    class SerializableEdutableListCellRenderer
    extends JLabel
    implements ListCellRenderer {
        SerializableEdutableListCellRenderer() {
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            if (object != null) {
                if (ComponentState.isBtdRtlOrLtr()) {
                    if (ComponentState.isDirOrFilePath((String)object.toString())) {
                        this.setText(ComponentState.preparePathForBidiDisplay((String)object.toString()));
                    } else {
                        this.setText(ComponentState.prepareStringForBidiRendering((String)object.toString()));
                    }
                } else {
                    this.setText(object.toString());
                }
                this.getAccessibleContext().setAccessibleName(object.toString());
            }
            if (jList.isEnabled()) {
                this.setOpaque(true);
                if (bl) {
                    if (jList.hasFocus()) {
                        this.setBackground(jList.getSelectionBackground());
                        this.setForeground(jList.getSelectionForeground());
                    } else {
                        this.setBackground(Color.lightGray);
                        this.setForeground(Color.black);
                    }
                } else {
                    this.setBackground(jList.getBackground());
                    this.setForeground(jList.getForeground());
                }
            } else {
                this.setOpaque(false);
            }
            this.setEnabled(jList.isEnabled());
            this.setFont(jList.getFont());
            Border border = null;
            if (bl2 && jList.isEnabled()) {
                if (bl) {
                    border = UIManager.getBorder("List.focusSelectedCellHighlightBorder");
                }
                if (border == null) {
                    border = UIManager.getBorder("List.focusCellHighlightBorder");
                }
            }
            this.setBorder(border);
            return this;
        }
    }
}

