/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.controls;

import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreePath;

public class PlainTree
extends JTree {
    Insets autoscrollInsets = new Insets(20, 20, 20, 20);
    private boolean mDragSupported = true;

    public PlainTree() {
        this.getSelectionModel().setSelectionMode(4);
        this.setEditable(false);
    }

    public boolean isDragSupported() {
        return this.mDragSupported;
    }

    public void setDragSupported(boolean bl) {
        this.mDragSupported = bl;
    }

    public void autoscroll(Point point) {
        Insets insets = this.getAutoscrollInsets();
        Rectangle rectangle = this.getVisibleRect();
        Rectangle rectangle2 = new Rectangle(rectangle.x + insets.left, rectangle.y + insets.top, rectangle.width - (insets.left + insets.right), rectangle.height - (insets.top + insets.bottom));
        if (!rectangle2.contains(point)) {
            Rectangle rectangle3 = new Rectangle(point.x - insets.left, point.y - insets.top, insets.left + insets.right, insets.top + insets.bottom);
            this.scrollRectToVisible(rectangle3);
        }
    }

    public Insets getAutoscrollInsets() {
        return this.autoscrollInsets;
    }

    public TransferData getTransferData() {
        return new TransferData(this.getSelectedNodes(), this);
    }

    public Vector<Object> getSelectedValues() {
        TreePath[] treePathArray;
        Vector<Object> vector = new Vector<Object>();
        for (TreePath treePath : treePathArray = this.getSelectionPaths()) {
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
            vector.addElement(defaultMutableTreeNode.getUserObject());
        }
        return vector;
    }

    public Vector<DefaultMutableTreeNode> getSelectedNodes() {
        Vector<DefaultMutableTreeNode> vector = new Vector<DefaultMutableTreeNode>();
        TreePath[] treePathArray = this.getSelectionPaths();
        if (treePathArray != null) {
            for (TreePath treePath : treePathArray) {
                DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
                vector.addElement(defaultMutableTreeNode);
            }
        }
        return vector;
    }

    public TreePath selectNode(DefaultMutableTreeNode defaultMutableTreeNode, boolean bl) {
        TreePath treePath = new TreePath(defaultMutableTreeNode.getPath());
        if (bl) {
            this.addSelectionPath(treePath);
        } else {
            this.setSelectionPath(treePath);
        }
        return treePath;
    }

    public void removeNode(DefaultMutableTreeNode defaultMutableTreeNode, boolean bl) {
        if (defaultMutableTreeNode == null) {
            return;
        }
        MutableTreeNode mutableTreeNode = (MutableTreeNode)defaultMutableTreeNode.getParent();
        if (mutableTreeNode == null) {
            return;
        }
        if (bl) {
            MutableTreeNode mutableTreeNode2 = this.getSibling(defaultMutableTreeNode);
            if (mutableTreeNode2 == null) {
                mutableTreeNode2 = mutableTreeNode;
            }
            Object[] objectArray = ((DefaultTreeModel)this.getModel()).getPathToRoot(mutableTreeNode2);
            TreePath treePath = new TreePath(objectArray);
            this.scrollPathToVisible(treePath);
            this.setSelectionPath(treePath);
        }
        ((DefaultTreeModel)this.getModel()).removeNodeFromParent(defaultMutableTreeNode);
    }

    private MutableTreeNode getSibling(DefaultMutableTreeNode defaultMutableTreeNode) {
        DefaultMutableTreeNode defaultMutableTreeNode2 = defaultMutableTreeNode.getPreviousSibling();
        if (defaultMutableTreeNode2 == null) {
            defaultMutableTreeNode2 = defaultMutableTreeNode.getNextSibling();
        }
        return defaultMutableTreeNode2;
    }

    public class TransferData
    implements Cloneable {
        private Vector<DefaultMutableTreeNode> mVectorNodes;
        private JComponent mSource;

        public TransferData(Vector<DefaultMutableTreeNode> vector, JComponent jComponent) {
            this.mVectorNodes = vector;
            this.mSource = jComponent;
        }

        public Vector<Object> getVectorData() {
            Vector<Object> vector = new Vector<Object>();
            for (DefaultMutableTreeNode defaultMutableTreeNode : this.mVectorNodes) {
                vector.add(defaultMutableTreeNode.getUserObject());
            }
            return vector;
        }

        public Vector<DefaultMutableTreeNode> getVectorNodes() {
            return this.mVectorNodes;
        }

        public JComponent getSource() {
            return this.mSource;
        }

        public void setSource(JComponent jComponent) {
            this.mSource = jComponent;
        }

        public Object clone() throws CloneNotSupportedException {
            TransferData transferData = (TransferData)super.clone();
            transferData.mVectorNodes = (Vector)this.mVectorNodes.clone();
            return transferData;
        }
    }
}

