/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.controls;

import com.spss.java_client.core.comp_util.OSCheck;
import com.spss.java_client.ui.controls.FocusHighlighter;
import com.spss.java_client.ui.controls.TableSorter;
import com.spss.shared.core_tools.system.OSInfo;
import java.awt.Color;
import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.EventObject;
import java.util.Vector;
import javax.swing.ComboBoxEditor;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableModel;

public class PlainTable
extends JTable {
    protected int mDropFeedbackIndex = -1;
    protected FocusHighlighter mFocusHighlighter = new FocusHighlighter(this);
    private boolean mDragSupported = true;
    protected boolean mLockSelections = false;

    public PlainTable() {
        this.init();
    }

    public PlainTable(Object[][] objectArray, Object[] objectArray2) {
        super(objectArray, objectArray2);
        this.init();
    }

    public PlainTable(Vector<?> vector, Vector<String> vector2) {
        super(vector, vector2);
        this.init();
    }

    public PlainTable(TableModel tableModel) {
        super(tableModel);
        this.init();
    }

    private void init() {
        this.putClientProperty("terminateEditOnFocusLost", Boolean.TRUE);
        this.setFocusTraversalKeys(0, null);
        this.setFocusTraversalKeys(1, null);
        if (OSCheck.getOSType() == OSInfo.OSType.MAC) {
            this.setGridColor(this.getGridColor().darker());
        }
        this.selectFirstCell();
    }

    public void setAnchorSelectionCell(int n, int n2) throws IllegalArgumentException {
        if (n2 < 0 || n2 >= this.getRowCount()) {
            throw new IllegalArgumentException("Row index out of range");
        }
        if (n < 0 || n >= this.getColumnCount()) {
            throw new IllegalArgumentException("Column index out of range");
        }
        this.getColumnModel().getSelectionModel().setAnchorSelectionIndex(n);
        this.getSelectionModel().setAnchorSelectionIndex(n2);
    }

    public void setAnchorSelectionCell(Point point) {
        this.setAnchorSelectionCell(point.x, point.y);
    }

    public void setLeadSelectionCell(int n, int n2) throws IllegalArgumentException {
        if (n2 < 0 || n2 >= this.getRowCount()) {
            throw new IllegalArgumentException("Row index out of range");
        }
        if (n < 0 || n >= this.getColumnCount()) {
            throw new IllegalArgumentException("Column index out of range");
        }
        this.getColumnModel().getSelectionModel().setLeadSelectionIndex(n);
        this.getSelectionModel().setLeadSelectionIndex(n2);
    }

    public void setLeadSelectionCell(Point point) {
        this.setLeadSelectionCell(point.x, point.y);
    }

    @Override
    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        JTableHeader jTableHeader = this.getTableHeader();
        if (jTableHeader != null) {
            jTableHeader.setForeground(bl ? this.getForeground() : Color.gray);
        }
    }

    @Override
    public void setModel(TableModel tableModel) {
        super.setModel(tableModel);
        this.selectFirstCell();
    }

    @Override
    protected JTableHeader createDefaultTableHeader() {
        return new JTableHeader(this.columnModel){

            @Override
            public String getToolTipText(MouseEvent mouseEvent) {
                Point point = mouseEvent.getPoint();
                int n = this.columnModel.getColumnIndexAtX(point.x);
                if (n < 0) {
                    return null;
                }
                int n2 = this.columnModel.getColumn(n).getModelIndex();
                return PlainTable.this.getHeaderTooltip(n2);
            }
        };
    }

    protected String getHeaderTooltip(int n) {
        String string = null;
        String string2 = this.getColumnName(n);
        double d = this.getTableHeader().getHeaderRect(n).getWidth();
        FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
        double d2 = fontMetrics.getStringBounds(string2, this.getGraphics()).getWidth();
        if (d2 + 6.0 >= d) {
            string = string2;
        }
        return string;
    }

    @Override
    public boolean editCellAt(int n, int n2, EventObject eventObject) {
        if (!super.editCellAt(n, n2, eventObject)) {
            return false;
        }
        Component component = this.getEditorComponent();
        if (component instanceof JComboBox) {
            component.requestFocus();
            final ComboBoxEditor comboBoxEditor = ((JComboBox)component).getEditor();
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ((JTextField)comboBoxEditor.getEditorComponent()).selectAll();
                }
            });
        }
        return true;
    }

    @Override
    public void addRowSelectionInterval(int n, int n2) {
        super.addRowSelectionInterval(n, n2);
        if (this.getCellSelectionEnabled() && this.getColumnCount() > 0) {
            super.addColumnSelectionInterval(this.getColumnCount() - 1, this.getColumnCount() - 1);
        }
    }

    public boolean getLockSelections() {
        return this.mLockSelections;
    }

    @Override
    public void setRowSelectionInterval(int n, int n2) {
        if (this.mLockSelections) {
            return;
        }
        super.setRowSelectionInterval(n, n2);
        if (this.getCellSelectionEnabled() && this.getColumnCount() > 0) {
            super.setColumnSelectionInterval(this.getColumnCount() - 1, this.getColumnCount() - 1);
        }
    }

    public void setRowSelectionInterval(int n, int n2, int n3) {
        if (this.mLockSelections) {
            return;
        }
        super.setRowSelectionInterval(n, n2);
        if (this.getCellSelectionEnabled() && n3 >= 0) {
            super.setColumnSelectionInterval(n3, n3);
        }
    }

    public void addSelectionRows(int[] nArray) {
        if (this.mLockSelections) {
            return;
        }
        if (nArray != null) {
            for (int n : nArray) {
                this.getSelectionModel().addSelectionInterval(n, n);
                if (!this.getCellSelectionEnabled() || this.getColumnCount() <= 0) continue;
                super.addColumnSelectionInterval(this.getColumnCount() - 1, this.getColumnCount() - 1);
            }
        }
    }

    public void setLockSelections(boolean bl) {
        this.mLockSelections = bl;
    }

    public TransferData getTransferData() {
        int[] nArray = this.getSelectedRows();
        Vector<Object[]> vector = this.getSelectedValues();
        return new TransferData(vector, nArray, this);
    }

    public void showDropFeedback(Point point) {
        if (point != null && this.getModel().getRowCount() > 0) {
            int n = this.rowAtPoint(point);
            if (n == -1) {
                Rectangle rectangle = this.getVisibleRect();
                if (point.y < rectangle.y) {
                    n = -1;
                } else if ((double)point.y > rectangle.getMaxY()) {
                    n = this.getModel().getRowCount() - 1;
                }
            }
            if (!this.itemInUpperHalf(point)) {
                ++n;
            }
            if (n > -1) {
                if (n != this.mDropFeedbackIndex && this.mDropFeedbackIndex > -1) {
                    this.renderDropLine(this.mDropFeedbackIndex, false);
                }
                this.renderDropLine(n, true);
                this.mDropFeedbackIndex = n;
            }
        } else if (this.mDropFeedbackIndex > -1) {
            this.renderDropLine(this.mDropFeedbackIndex, false);
            this.mDropFeedbackIndex = -1;
        }
    }

    public boolean itemInUpperHalf(Point point) {
        Rectangle rectangle;
        int n = this.rowAtPoint(point);
        if (n > -1 && (rectangle = this.getCellRect(n, n, false)).contains(point)) {
            int n2 = (int)(rectangle.getMinY() + rectangle.getHeight() / 2.0);
            return n2 > point.y;
        }
        return false;
    }

    protected void renderDropLine(int n, boolean bl) {
        boolean bl2 = n >= this.getModel().getRowCount();
        int n2 = !bl2 ? n : this.getModel().getRowCount() - 1;
        Rectangle rectangle = this.getCellRect(n2, n2, false);
        int n3 = 0;
        if (rectangle != null) {
            n3 = (int)(bl2 ? rectangle.getY() + rectangle.getHeight() : rectangle.getY());
        }
        Graphics graphics = this.getGraphics();
        Color color = this.isRowSelected(n) ? this.getSelectionBackground() : this.getBackground();
        graphics.setColor(bl ? Color.red : color);
        graphics.drawLine(0, n3, this.getWidth(), n3);
        graphics.dispose();
    }

    public int getDropFeedbackIndex() {
        return this.mDropFeedbackIndex;
    }

    public FocusHighlighter getFocusHighlighter() {
        return this.mFocusHighlighter;
    }

    public boolean isDragSupported() {
        return this.mDragSupported;
    }

    public void setDragSupported(boolean bl) {
        this.mDragSupported = bl;
    }

    public Point getFocusCell() {
        Point point = null;
        Point point2 = this.getLeadSelectionCell();
        if (point2 != null) {
            boolean bl = this.getSelectionModel().isSelectedIndex(point2.y);
            boolean bl2 = this.getColumnModel().getSelectionModel().isSelectedIndex(point2.x);
            if (bl2 && bl) {
                point = new Point(point2);
            }
        }
        return point;
    }

    public Point getLeadSelectionCell() {
        Point point = null;
        int n = this.getSelectionModel().getLeadSelectionIndex();
        int n2 = this.getColumnModel().getSelectionModel().getLeadSelectionIndex();
        if (n2 > -1 && n > -1) {
            point = new Point(n2, n);
        }
        return point;
    }

    public Vector<Object[]> getSelectedValues() {
        Vector<Object[]> vector = new Vector<Object[]>();
        DefaultTableModel defaultTableModel = this.getDefaultTableModel();
        if (defaultTableModel != null) {
            int[] nArray;
            for (int n : nArray = this.getSelectedRows()) {
                Object[] objectArray = new Object[this.getColumnCount()];
                for (int i = 0; i < this.getColumnCount(); ++i) {
                    objectArray[i] = defaultTableModel.getValueAt(n, i);
                }
                vector.add(objectArray);
            }
        }
        return vector;
    }

    public DefaultTableModel getDefaultTableModel() {
        TableModel tableModel;
        DefaultTableModel defaultTableModel = null;
        TableModel tableModel2 = this.getModel();
        if (tableModel2 instanceof DefaultTableModel) {
            defaultTableModel = (DefaultTableModel)tableModel2;
        }
        if (tableModel2 instanceof TableSorter && (tableModel = ((TableSorter)tableModel2).getTableModel()) instanceof DefaultTableModel) {
            defaultTableModel = (DefaultTableModel)tableModel;
        }
        return defaultTableModel;
    }

    public void pushOrderFromViewToModel() {
        int[] nArray;
        if (!(this.getModel() instanceof TableSorter)) {
            return;
        }
        TableSorter tableSorter = (TableSorter)this.getModel();
        int n = this.getDefaultTableModel().getRowCount();
        int[] nArray2 = nArray = n > 0 ? new int[n] : null;
        if (nArray != null && nArray.length > 0) {
            for (int i = 0; i < nArray.length; ++i) {
                nArray[i] = tableSorter.modelIndex(i);
            }
            Vector<Vector> vector = this.getDefaultTableModel().getDataVector();
            Vector<Vector> vector2 = new Vector<Vector>();
            for (int n2 : nArray) {
                vector2.add(vector.get(n2));
            }
            for (int i = 0; i < n; ++i) {
                this.getDefaultTableModel().removeRow(0);
            }
            for (Vector vector3 : vector2) {
                this.getDefaultTableModel().addRow(vector3);
            }
        }
    }

    public void selectFirstCell() {
        this.getSelectionModel().setSelectionInterval(0, 0);
        this.getColumnModel().getSelectionModel().setSelectionInterval(0, 0);
    }

    public class TransferData
    implements Cloneable {
        private Vector<Object[]> mVectorData;
        private int[] mSelectedRows;
        private JComponent mSource;

        public TransferData(Vector<Object[]> vector, int[] nArray, JComponent jComponent) {
            this.mVectorData = vector;
            this.mSelectedRows = nArray;
            this.mSource = jComponent;
        }

        public int[] getSelectedRows() {
            return this.mSelectedRows;
        }

        public Vector<Object[]> getVectorData() {
            return this.mVectorData;
        }

        public JComponent getSource() {
            return this.mSource;
        }

        public void setSource(JComponent jComponent) {
            this.mSource = jComponent;
        }

        public Object clone() throws CloneNotSupportedException {
            TransferData transferData = (TransferData)super.clone();
            transferData.mVectorData = (Vector)this.mVectorData.clone();
            transferData.mSelectedRows = (int[])this.mSelectedRows.clone();
            return transferData;
        }
    }
}

