/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.controls;

import com.spss.java_client.core.common.ComponentState;
import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.ui.controls.IDoubleClickListener;
import com.spss.java_client.ui.controls.PlainList;
import com.spss.java_client.ui.controls.SpssArrowButton;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.resources.ResUtil;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.DefaultListModel;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;

public class PlainListArrowButton
extends SpssArrowButton
implements IDoubleClickListener {
    public PlainListArrowButton() {
    }

    public PlainListArrowButton(SpssArrowButton.ButtonOrientation buttonOrientation) {
        super(buttonOrientation);
    }

    public boolean registerVariableList(PlainList plainList, SpssArrowButton.ButtonOrientation buttonOrientation) {
        plainList.addDoubleClickListener(this);
        boolean bl = false;
        for (int i = 0; i < 2; ++i) {
            if (this.mRegisteredContainers[i] != null) continue;
            this.mRegisteredContainers[i] = new VarListHolder(plainList, buttonOrientation);
            bl = true;
            break;
        }
        if (!bl) {
            return false;
        }
        this.setAccessibleContextName();
        plainList.addFocusListener(this);
        plainList.addListSelectionListener(this);
        return true;
    }

    public void unRegisterVariableList(PlainList plainList) {
        for (int i = 0; i < 2; ++i) {
            if (this.mRegisteredContainers[i] == null || ((VarListHolder)this.mRegisteredContainers[i]).mVarList != plainList) continue;
            this.mRegisteredContainers[i] = null;
            plainList.removeFocusListener(this);
            plainList.removeListSelectionListener(this);
            break;
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if ("arrowPressed".equals(actionEvent.getActionCommand())) {
            VarListHolder varListHolder = (VarListHolder)this.getSourceVarHolder();
            VarListHolder varListHolder2 = (VarListHolder)this.getTargetVarHolder();
            if (varListHolder != null && varListHolder2 != null) {
                Object object3;
                int n;
                Object[] objectArray = varListHolder.mVarList.getSelectedValues();
                if (!varListHolder2.mVarList.isDataSource()) {
                    for (int i = 0; i < objectArray.length; ++i) {
                        Object object2 = objectArray[i];
                        if (!varListHolder2.mVarList.isAllowDuplicates() && ((DefaultListModel)varListHolder2.mVarList.getModel()).indexOf(object2) != -1) continue;
                        if (varListHolder2.mVarList.getMaxLimitOfList() != -1) {
                            if (varListHolder2.mVarList.getMaxLimitOfList() >= objectArray.length - i + varListHolder2.mVarList.getModel().getSize()) {
                                ((DefaultListModel)varListHolder2.mVarList.getModel()).addElement(object2);
                                continue;
                            }
                            String string = String.format(ComponentState.getSPSSLocale(), ResUtil.getCommonDlgString("ERR_LIST_MAX_LIMIT_EXCEEDED_WARNING"), varListHolder2.mVarList.getMaxLimitOfList());
                            SpssAlertOptionPane.showInformationMessageDialog(this, string, VersionInfo.getAppVersionString());
                            varListHolder.mVarList.setSelection(objectArray);
                            final PlainList plainList = varListHolder.mVarList;
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    plainList.requestFocus();
                                }
                            });
                            return;
                        }
                        ((DefaultListModel)varListHolder2.mVarList.getModel()).addElement(object2);
                    }
                } else if (varListHolder.mVarList.getDragType() != PlainList.DragType.eAutoDragCopy) {
                    Object[] objectArray2 = objectArray;
                    int n2 = objectArray2.length;
                    for (n = 0; n < n2; ++n) {
                        object3 = objectArray2[n];
                        ((DefaultListModel)varListHolder2.mVarList.getModel()).addElement(object3);
                    }
                }
                varListHolder2.mVarList.setSelection(objectArray);
                if (!varListHolder.mVarList.isDataSource()) {
                    Object[] objectArray3 = objectArray;
                    int n3 = objectArray3.length;
                    for (n = 0; n < n3; ++n) {
                        object3 = objectArray3[n];
                        ((DefaultListModel)varListHolder.mVarList.getModel()).removeElement(object3);
                    }
                }
                if (varListHolder2.mVarList.getDragType() != PlainList.DragType.eAutoDragCopy) {
                    for (Object object3 : objectArray) {
                        ((DefaultListModel)varListHolder.mVarList.getModel()).removeElement(object3);
                    }
                }
                final PlainList plainList = varListHolder2.mVarList;
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        plainList.requestFocus();
                    }
                });
            }
        }
    }

    @Override
    public void doDoubleClickAction() {
        VarListHolder varListHolder = (VarListHolder)this.getTargetVarHolder();
        final PlainList plainList = varListHolder.mVarList;
        final Object[] objectArray = ((VarListHolder)this.getSourceVarHolder()).mVarList.getSelectedValues();
        final ActionEvent actionEvent = new ActionEvent(this, 1234567890, "arrowPressed");
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ActionListener[] actionListenerArray = PlainListArrowButton.this.getActionListeners();
                if (PlainListArrowButton.this.canMoveVars(plainList, objectArray)) {
                    for (ActionListener actionListener : actionListenerArray) {
                        actionListener.actionPerformed(actionEvent);
                    }
                }
            }
        });
    }

    @Override
    protected void updateEnable(SpssArrowButton.SrcDestHolder srcDestHolder) {
        boolean bl;
        VarListHolder varListHolder = (VarListHolder)srcDestHolder;
        if (varListHolder == null) {
            return;
        }
        ListSelectionModel listSelectionModel = varListHolder.mVarList.getSelectionModel();
        int n = listSelectionModel.getMinSelectionIndex();
        int n2 = listSelectionModel.getMaxSelectionIndex();
        boolean bl2 = bl = n >= 0 && n2 >= 0;
        if (bl) {
            VarListHolder varListHolder2 = (VarListHolder)this.getTargetVarHolder();
            Object[] objectArray = varListHolder.mVarList.getSelectedValues();
            bl = objectArray.length > 0 ? this.canMoveVars(varListHolder2.mVarList, objectArray) : false;
        }
        this.setEnabled(bl);
    }

    protected boolean canMoveVars(PlainList plainList, Object[] objectArray) {
        if (plainList.getListType() == PlainList.ListType.single_item && objectArray.length > 1) {
            return false;
        }
        return plainList.getListType() != PlainList.ListType.single_item || plainList.getModel().getSize() != 1;
    }

    protected class VarListHolder
    extends SpssArrowButton.SrcDestHolder {
        private PlainList mVarList;

        VarListHolder(PlainList plainList, SpssArrowButton.ButtonOrientation buttonOrientation) {
            super(PlainListArrowButton.this, buttonOrientation);
            this.mVarList = plainList;
        }

        @Override
        protected Component getComponent() {
            return this.mVarList;
        }
    }
}

