/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.controls;

import com.spss.java_client.core.common.ComponentState;
import com.spss.java_client.ui.controls.ExpressionBuilderTextArea;
import com.spss.java_client.ui.controls.SerializableList;
import com.spss.java_client.ui.controls.SpssArrowButton;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Vector;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;

public class PlainList
extends SerializableList {
    protected static Border sNoFocusBorder = new EmptyBorder(1, 1, 1, 1);
    protected boolean mLockSelections = false;
    protected int mDropFeedbackIndex = -1;
    protected static final int MIN_LIST_ITEM_HEIGHT = 18;
    private DragType mDragType;
    private ListType mListType;
    private boolean mAllowDuplicates;
    private boolean mDataSource;
    private boolean mDragSupported = true;
    private Vector<SpssArrowButton> mRegisteredArrowButtons = new Vector();

    public PlainList(String string) {
        this(new DefaultListModel(), string, DragType.eAutoDragMove);
    }

    public PlainList(String string, DragType dragType) {
        this(new DefaultListModel(), string, dragType);
    }

    public PlainList(DefaultListModel defaultListModel, String string, DragType dragType) {
        super(string);
        this.setModel(defaultListModel);
        this.mDragType = dragType;
        this.setCellRenderer(new PlainListCellRenderer());
        Dimension dimension = new Dimension(DialogUtil.getVarListWidth(), DialogUtil.getVarListHeight());
        this.setMinimumSize(dimension);
        int n = this.getFixedCellHeight();
        n = n < 18 ? 18 : n;
        this.setFixedCellHeight(n);
    }

    public void setDragType(DragType dragType) {
        this.mDragType = dragType;
    }

    public void setListType(ListType listType) {
        this.mListType = listType;
        int n = 20;
        Dimension dimension = new Dimension(DialogUtil.getVarListWidth(), n);
        this.setMinimumSize(dimension);
        if (this.mListType == ListType.single_item) {
            this.setPreferredSize(dimension);
            this.setMaximumSize(dimension);
        } else {
            this.setPreferredSize(null);
            this.setMaximumSize(null);
        }
    }

    public DragType getDragType() {
        return this.mDragType;
    }

    public boolean isDragSupported() {
        return this.mDragSupported;
    }

    public ListType getListType() {
        return this.mListType;
    }

    public void setDataSource(boolean bl) {
        this.mDataSource = bl;
    }

    public boolean isDataSource() {
        return this.mDataSource;
    }

    public void setAllowDuplicates(boolean bl) {
        this.mAllowDuplicates = bl;
    }

    public boolean isAllowDuplicates() {
        return this.mAllowDuplicates;
    }

    public void setSelection(Object[] objectArray) {
        this.clearSelection();
        int n = -1;
        int n2 = -1;
        DefaultListModel defaultListModel = (DefaultListModel)this.getModel();
        for (Object object : objectArray) {
            n = defaultListModel.indexOf(object);
            if (n <= -1) continue;
            this.addSelectionInterval(n, n);
            n2 = n;
        }
        if (n2 > -1) {
            this.ensureIndexIsVisible(n2);
        }
    }

    @Override
    public void addSelectionInterval(int n, int n2) {
        if (this.mLockSelections) {
            return;
        }
        super.addSelectionInterval(n, n2);
    }

    public boolean getLockSelections() {
        return this.mLockSelections;
    }

    @Override
    public void removeSelectionInterval(int n, int n2) {
        if (this.mLockSelections) {
            return;
        }
        super.removeSelectionInterval(n, n2);
    }

    @Override
    public void setSelectionInterval(int n, int n2) {
        if (this.mLockSelections) {
            return;
        }
        super.setSelectionInterval(n, n2);
    }

    public void setLockSelections(boolean bl) {
        this.mLockSelections = bl;
    }

    public void showDropFeedback(Point point) {
        if (point != null && this.getModel().getSize() > 0) {
            int n = this.locationToIndex(point);
            if (!this.itemInUpperHalf(point)) {
                ++n;
            }
            if (n > -1) {
                if (n != this.mDropFeedbackIndex && this.mDropFeedbackIndex > -1) {
                    this.renderDropLine(this.mDropFeedbackIndex, false);
                }
                this.renderDropLine(n, true);
                this.mDropFeedbackIndex = n;
            }
        } else if (this.mDropFeedbackIndex > -1) {
            this.renderDropLine(this.mDropFeedbackIndex, false);
            this.mDropFeedbackIndex = -1;
        }
    }

    public int getDropFeedbackIndex() {
        return this.mDropFeedbackIndex;
    }

    public boolean itemInUpperHalf(Point point) {
        Rectangle rectangle;
        int n = this.locationToIndex(point);
        if (n > -1 && (rectangle = this.getCellBounds(n, n)).contains(point)) {
            int n2 = (int)(rectangle.getMinY() + rectangle.getHeight() / 2.0);
            return n2 > point.y;
        }
        return false;
    }

    public TransferData getTransferData() {
        Object[] objectArray = this.getSelectedValues();
        int[] nArray = this.getSelectedIndices();
        return new TransferData(objectArray, nArray, this);
    }

    public void addRegisteredArrowButton(SpssArrowButton spssArrowButton) {
        this.mRegisteredArrowButtons.add(spssArrowButton);
    }

    public void removeRegisteredArrowButton(SpssArrowButton spssArrowButton) {
        if (this.mRegisteredArrowButtons.contains(spssArrowButton)) {
            this.mRegisteredArrowButtons.remove(spssArrowButton);
        }
    }

    public Vector<SpssArrowButton> getRegisteredArrowButtons() {
        return this.mRegisteredArrowButtons;
    }

    protected void renderDropLine(int n, boolean bl) {
        boolean bl2 = n >= this.getModel().getSize();
        int n2 = !bl2 ? n : this.getModel().getSize() - 1;
        Rectangle rectangle = this.getCellBounds(n2, n2);
        int n3 = 0;
        if (rectangle != null) {
            n3 = (int)(bl2 ? rectangle.getY() + rectangle.getHeight() : rectangle.getY());
        }
        Graphics graphics = this.getGraphics();
        Color color = this.isSelectedIndex(n) ? this.getSelectionBackground() : this.getBackground();
        graphics.setColor(bl ? Color.red : color);
        graphics.drawLine(0, n3, this.getWidth(), n3);
        graphics.dispose();
    }

    public static class PlainListCellRenderer
    extends JLabel
    implements ListCellRenderer {
        private boolean mForTooltip;

        public PlainListCellRenderer() {
            this.setBorder(sNoFocusBorder);
        }

        public PlainListCellRenderer(boolean bl) {
            this();
            this.mForTooltip = bl;
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            if (object != null) {
                if (object instanceof IconItem) {
                    this.setIcon(((IconItem)object).getIcon());
                    if (ComponentState.isBtdRtlOrLtr()) {
                        if (ComponentState.isDirOrFilePath((String)object.toString())) {
                            this.setText(this.mForTooltip ? ComponentState.preparePathForBidiDisplay((String)object.toString()) : ComponentState.preparePathForBidiDisplay((String)((IconItem)object).getRenderingString(jList)));
                        } else {
                            this.setText(this.mForTooltip ? ComponentState.prepareStringForBidiRendering((String)object.toString()) : ComponentState.preparePathForBidiDisplay((String)((IconItem)object).getRenderingString(jList)));
                        }
                    } else {
                        this.setText(this.mForTooltip ? object.toString() : ((IconItem)object).getRenderingString(jList));
                    }
                } else if (ComponentState.isBtdRtlOrLtr()) {
                    if (ComponentState.isDirOrFilePath((String)object.toString())) {
                        this.setText(ComponentState.preparePathForBidiDisplay((String)object.toString()));
                    } else {
                        this.setText(ExpressionBuilderTextArea.prepareTextForBidiDisplay(object.toString()));
                    }
                } else if (ComponentState.containsBidiLetter((String)object.toString())) {
                    this.setText(ExpressionBuilderTextArea.prepareTextForBidiDisplay(object.toString()));
                } else {
                    this.setText(object.toString());
                }
                this.getAccessibleContext().setAccessibleName(object.toString());
            }
            if (jList.isEnabled()) {
                this.setOpaque(true);
                if (bl) {
                    if (jList.hasFocus()) {
                        this.setBackground(jList.getSelectionBackground());
                        this.setForeground(jList.getSelectionForeground());
                    } else {
                        this.setBackground(Color.lightGray);
                        this.setForeground(Color.black);
                    }
                } else {
                    this.setBackground(jList.getBackground());
                    this.setForeground(jList.getForeground());
                }
            } else {
                this.setOpaque(false);
            }
            this.setEnabled(jList.isEnabled());
            this.setFont(jList.getFont());
            Border border = null;
            if (bl2 && jList.isEnabled()) {
                if (bl) {
                    border = UIManager.getBorder("List.focusSelectedCellHighlightBorder");
                }
                if (border == null) {
                    border = UIManager.getBorder("List.focusCellHighlightBorder");
                }
            } else {
                border = sNoFocusBorder;
            }
            this.setBorder(border);
            return this;
        }
    }

    public static abstract class IconItem {
        public abstract Icon getIcon();

        public String getRenderingString(JList jList) {
            return this.toString();
        }
    }

    public class TransferData
    implements Cloneable {
        private Object[] mVars;
        private int[] mSelectedIndices;
        private JComponent mSource;

        public TransferData(Object[] objectArray, int[] nArray, JComponent jComponent) {
            this.mVars = objectArray;
            this.mSelectedIndices = nArray;
            this.mSource = jComponent;
        }

        public int[] getSelectedIndices() {
            return this.mSelectedIndices;
        }

        public Object[] getVariables() {
            return this.mVars;
        }

        public JComponent getSource() {
            return this.mSource;
        }

        public void setSource(JComponent jComponent) {
            this.mSource = jComponent;
        }

        public Object clone() throws CloneNotSupportedException {
            TransferData transferData = null;
            transferData = (TransferData)super.clone();
            transferData.mVars = (Object[])this.mVars.clone();
            transferData.mSelectedIndices = (int[])this.mSelectedIndices.clone();
            return transferData;
        }
    }

    public static enum ListType {
        normal,
        single_item;

    }

    public static enum DragType {
        eNoAutoDrag,
        eAutoDragCopy,
        eAutoDragMove,
        eAutoDragCopyOrMove;

    }
}

