/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.controls;

import com.spss.java_client.ui.controls.SpssMultiLineLabel;
import com.spss.java_client.ui.controls.VariableList;
import com.spss.java_client.ui.dialogs.base.graphs.MatrixImage;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.border.TitledBorder;

public class PanelFactory {
    private static final Insets controlInsets = DialogUtil.getStandardControlInsets();

    public static JPanel getBasicPanel(JComponent[] jComponentArray, PanelType panelType, String string) {
        return PanelFactory.getBasicPanel(jComponentArray, panelType, string, false);
    }

    public static JPanel getBasicPanel(JComponent[] jComponentArray, PanelType panelType, String string, boolean bl) {
        JPanel jPanel = PanelFactory.getEmptyPanel(string);
        switch (panelType) {
            case xaxis: {
                jPanel = PanelFactory.getGridPanel(jComponentArray, string, 1, bl);
                break;
            }
            case yaxis: {
                jPanel = PanelFactory.getGridPanel(jComponentArray, string, jComponentArray.length, bl);
            }
        }
        return jPanel;
    }

    public static JPanel getGridPanel(JComponent[] jComponentArray, String string, int n) {
        return PanelFactory.getGridPanel(jComponentArray, string, n, false, 1);
    }

    public static JPanel getGridPanel(JComponent[] jComponentArray, String string, int n, boolean bl) {
        return PanelFactory.getGridPanel(jComponentArray, string, n, bl, 1);
    }

    public static JPanel getGridPanel(JComponent[] jComponentArray, String string, int n, boolean bl, int n2) {
        JPanel jPanel = PanelFactory.getEmptyPanel(string);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n3 = 23;
        int n4 = 0;
        int n5 = 0;
        Insets insets = (Insets)controlInsets.clone();
        while (n4 < jComponentArray.length) {
            for (int i = 0; n4 < jComponentArray.length && i < n; ++n4, ++i) {
                gridBagConstraints.fill = 0;
                if (n4 == jComponentArray.length - 1) {
                    gridBagConstraints.weightx = 1.0;
                }
                if (i == n - 1) {
                    gridBagConstraints.weighty = 1.0;
                }
                if (n5 > 0 && n2 != 1) {
                    insets.set(PanelFactory.controlInsets.top, PanelFactory.controlInsets.left * n2, PanelFactory.controlInsets.bottom, PanelFactory.controlInsets.right);
                }
                if (jComponentArray[n4] instanceof JSeparator) {
                    gridBagConstraints.fill = 2;
                }
                if (bl) {
                    DialogUtil.addUsingGBLOnSpssTab(jPanel, jComponentArray[n4], gridBagConstraints, n5, i, 1, 1, n3, insets);
                } else {
                    DialogUtil.addUsingGBL(jPanel, jComponentArray[n4], gridBagConstraints, n5, i, 1, 1, n3, insets);
                }
                gridBagConstraints.weightx = 0.0;
                gridBagConstraints.weighty = 0.0;
            }
            ++n5;
        }
        return jPanel;
    }

    public static JPanel getEmptyPanel(String string) {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        if (string != null && !string.equals("")) {
            TitledBorder titledBorder = new TitledBorder(string);
            jPanel.setBorder(titledBorder);
        }
        return jPanel;
    }

    public static JPanel setupMnemonickey(JPanel jPanel, JLabel jLabel) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        int n2 = DialogUtil.getGroupBoxInnerMargin();
        int n3 = DialogUtil.getComponentGroupGap();
        Insets insets = new Insets(n2, n3 - 3, 0, 0);
        gridBagConstraints.fill = 0;
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        JPanel jPanel3 = new JPanel(new GridBagLayout());
        TitledBorder titledBorder = new TitledBorder(" ");
        jLabel.setOpaque(true);
        jLabel.setFont(titledBorder.getTitleFont());
        jLabel.setForeground(titledBorder.getTitleColor());
        jPanel3.setBorder(titledBorder);
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.fill = 1;
        gridBagConstraints2.weightx = 1.0;
        gridBagConstraints2.weighty = 1.0;
        Insets insets2 = new Insets(0, 3, 0, 0);
        DialogUtil.addUsingGBL(jPanel3, jPanel, gridBagConstraints2, 0, 0, 1, 1, n, insets2);
        DialogUtil.addUsingGBL(jPanel2, jLabel, gridBagConstraints, 0, 0, 1, 1, n, insets);
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 1;
        n = 19;
        insets = new Insets(n2, 0, 0, 0);
        DialogUtil.addUsingGBL(jPanel2, jPanel3, gridBagConstraints, 0, 0, 1, 1, n, insets);
        return jPanel2;
    }

    public static JPanel getGraphsPanelByPanel(JComponent[] jComponentArray, String string) {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createTitledBorder(string));
        jComponentArray[2].setMinimumSize(new Dimension(DialogUtil.getVarListWidth(), ((VariableList)jComponentArray[2]).getFixedCellHeight() * 3 + 2));
        jComponentArray[6].setMinimumSize(new Dimension(DialogUtil.getVarListWidth(), ((VariableList)jComponentArray[6]).getFixedCellHeight() * 3 + 2));
        JScrollPane jScrollPane = new JScrollPane(jComponentArray[2]);
        jScrollPane.setPreferredSize(jComponentArray[2].getMinimumSize());
        JScrollPane jScrollPane2 = new JScrollPane(jComponentArray[6]);
        jScrollPane2.setPreferredSize(jComponentArray[6].getMinimumSize());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        Insets insets = DialogUtil.getStandardControlInsets();
        DialogUtil.addUsingGBL(jPanel, jComponentArray[0], gridBagConstraints, 1, 0, 1, 1, 23, insets);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        Insets insets2 = DialogUtil.getArrowButtonInsets();
        Insets insets3 = new Insets(0, DialogUtil.getGroupBoxInnerMargin(), insets2.bottom, insets2.right);
        DialogUtil.addUsingGBL(jPanel, jComponentArray[1], gridBagConstraints, 0, 1, 1, 1, 10, insets3);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        Insets insets4 = new Insets(0, 3, 1, DialogUtil.getGroupBoxInnerMargin());
        DialogUtil.addUsingGBL(jPanel, jScrollPane, gridBagConstraints, 1, 1, 1, 1, 23, insets4);
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, jComponentArray[3], gridBagConstraints, 1, 2, 1, 1, 23, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, jComponentArray[4], gridBagConstraints, 1, 3, 1, 1, 23, insets);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, jComponentArray[5], gridBagConstraints, 0, 4, 1, 1, 10, insets3);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        DialogUtil.addUsingGBL(jPanel, jScrollPane2, gridBagConstraints, 1, 4, 1, 1, 23, insets4);
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, jComponentArray[7], gridBagConstraints, 1, 5, 1, 1, 23, insets);
        return jPanel;
    }

    public static JPanel getGraphsChartTemplatePanel(JComponent[] jComponentArray, String string) {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createTitledBorder(string));
        Insets insets = DialogUtil.getStandardControlInsets();
        int n = DialogUtil.getGroupBoxInnerMargin();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        Insets insets2 = new Insets(0, n, 0, 0);
        DialogUtil.addUsingGBL(jPanel, jComponentArray[0], gridBagConstraints, 0, 0, 2, 1, 23, insets2);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        insets2.set(insets.top, n * 4, n, 0);
        DialogUtil.addUsingGBL(jPanel, jComponentArray[1], gridBagConstraints, 0, 1, 1, 1, 23, insets2);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, jComponentArray[2], gridBagConstraints, 1, 1, 1, 1, 23, new Insets(4, n * 2, 0, 3));
        return jPanel;
    }

    public static JPanel getGraphsLabelPanel(JComponent[] jComponentArray, String string) {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createTitledBorder(string));
        JScrollPane jScrollPane = new JScrollPane(jComponentArray[0]);
        jScrollPane.setPreferredSize(jComponentArray[0].getMinimumSize());
        jScrollPane.setVerticalScrollBarPolicy(21);
        jScrollPane.setHorizontalScrollBarPolicy(31);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        DialogUtil.addUsingGBL(jPanel, jComponentArray[2], gridBagConstraints, 0, 0, 2, 1, 23, controlInsets);
        DialogUtil.addUsingGBL(jPanel, jComponentArray[3], gridBagConstraints, 0, 1, 2, 1, 23, controlInsets);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        int n = DialogUtil.getGroupBoxInnerMargin();
        int n2 = DialogUtil.getComponentGroupGap();
        Insets insets = new Insets(0, n, n, DialogUtil.getArrowButtonInsets().right);
        DialogUtil.addUsingGBL(jPanel, jComponentArray[1], gridBagConstraints, 0, 3, 1, 1, 10, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        insets.set(n2, 3, n, n);
        DialogUtil.addUsingGBL(jPanel, jScrollPane, gridBagConstraints, 1, 3, 1, 1, 23, insets);
        return jPanel;
    }

    public static JPanel getPanelForImageLabels(JComponent[] jComponentArray, String string, int n) {
        JPanel jPanel = PanelFactory.getEmptyPanel(string);
        Insets insets = DialogUtil.getStandardControlInsets();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n2 = 23;
        int n3 = 0;
        int n4 = 0;
        while (n3 < jComponentArray.length) {
            for (int i = 0; n3 < jComponentArray.length && i < n; ++n3, ++i) {
                Insets insets2;
                if (jComponentArray[n3] instanceof MatrixImage) {
                    if (i == n - 1) {
                        gridBagConstraints.weighty = 1.0;
                    }
                    insets2 = DialogUtil.getStandardControlInsets();
                    insets = new Insets(insets2.top, insets2.left, 5 * insets2.bottom, insets2.right);
                } else if (jComponentArray[n3] instanceof JLabel) {
                    if (i == n - 1 && n3 == jComponentArray.length - 1 || n3 == jComponentArray.length - 1) {
                        gridBagConstraints.weightx = 1.0;
                        gridBagConstraints.fill = 0;
                    }
                    insets2 = DialogUtil.getStandardControlInsets();
                    insets = jComponentArray[n3] instanceof SpssMultiLineLabel ? new Insets(4 * insets2.left, insets2.left, insets2.bottom, 4 * insets2.right) : new Insets(8 * insets2.left, insets2.left, insets2.bottom, 4 * insets2.right);
                }
                DialogUtil.addUsingGBL(jPanel, jComponentArray[n3], gridBagConstraints, n4, i, 1, 1, n2, insets);
                gridBagConstraints.weightx = 0.0;
                gridBagConstraints.weighty = 0.0;
            }
            ++n4;
        }
        return jPanel;
    }

    public static enum PanelType {
        xaxis,
        yaxis;

    }
}

