/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.controls;

import com.spss.java_client.core.documents.data.dictionary.ISpssVariable;
import com.spss.java_client.ui.controls.MeasurementLevelButtonType;
import com.spss.java_client.ui.controls.SrcVariableList;
import com.spss.java_client.ui.controls.VarListModel;
import com.spss.java_client.ui.controls.VarSourceSortingPanel;
import com.spss.java_client.ui.controls.VariableList;
import com.spss.java_client.ui.controls.VariableSelectorPanel;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.uitools.dialogs.BaseDialog;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Vector;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class MultiFieldChooserPanel
extends JPanel {
    private BaseDialog mParent;
    static String SRC_VAR_LIST = "IDS_COMMON_MULTIFIELD_SOURCE_LIST";
    protected SrcVariableList mVariableSrcList;
    protected JScrollPane mSrcScrollPane;
    private VariableSelectorPanel mSelectorPanel;
    private VarSourceSortingPanel mSortPanel;
    private Vector<ISpssVariable> mSourceVars;

    public MultiFieldChooserPanel(BaseDialog baseDialog, Vector<ISpssVariable> vector) {
        this(baseDialog, vector, null, 2);
    }

    public MultiFieldChooserPanel(BaseDialog baseDialog, Vector<ISpssVariable> vector, MeasurementLevelButtonType[] measurementLevelButtonTypeArray, int n) {
        this.mParent = baseDialog;
        this.mSourceVars = vector;
        this.initVars(measurementLevelButtonTypeArray);
        this.createPanel();
        this.setDefault();
        this.mVariableSrcList.setSelectionMode(n);
        if (this.mVariableSrcList.getModel().getSize() > 0) {
            this.mVariableSrcList.getSelectionModel().setSelectionInterval(0, 0);
        }
    }

    public void setDefaultFocus() {
        this.mVariableSrcList.requestFocusInWindow();
    }

    public Vector<Object> setTabTraversal() {
        Vector<Object> vector = new Vector<Object>();
        vector.addAll(this.mSortPanel.getTabTraversalComponent());
        vector.add(this.mVariableSrcList);
        vector.addAll(this.mSelectorPanel.getTabTraversalComponent());
        return vector;
    }

    public void selectVarNames(Vector<String> vector) {
        for (String string : vector) {
            Integer[] integerArray = this.mVariableSrcList.getModel().findElementIndexesByName(string);
            if (integerArray == null || integerArray.length <= 0) continue;
            for (Integer n : integerArray) {
                this.mVariableSrcList.getSelectionModel().addSelectionInterval(n, n);
            }
        }
    }

    public ISpssVariable[] getSelectedFields() {
        return this.mVariableSrcList.getSelectedValues();
    }

    private void initVars(MeasurementLevelButtonType[] measurementLevelButtonTypeArray) {
        this.mVariableSrcList = new SrcVariableList(VariableList.VarMoveType.eMoveOriginal);
        this.mVariableSrcList.setIdentifier(SRC_VAR_LIST);
        this.mVariableSrcList.setContextMenuFlags(this.mVariableSrcList.getContextMenuFlags() | 8);
        this.mVariableSrcList.setSelectionMode(0);
        this.mSrcScrollPane = new JScrollPane(this.mVariableSrcList);
        this.mSrcScrollPane.setPreferredSize(this.mVariableSrcList.getMinimumSize());
        this.mSrcScrollPane.setHorizontalScrollBarPolicy(30);
        this.mSrcScrollPane.setVerticalScrollBarPolicy(20);
        this.mSelectorPanel = new VariableSelectorPanel(this.mVariableSrcList, this.mParent, measurementLevelButtonTypeArray);
        this.mSortPanel = new VarSourceSortingPanel(this.mVariableSrcList, this.mParent, false);
    }

    private void createPanel() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        int n2 = DialogUtil.getGroupBoxInnerMargin();
        Insets insets = new Insets(0, n2, n2, n2);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        insets.set(0, n2, n2, n2);
        DialogUtil.addUsingGBL(this, this.mSortPanel, gridBagConstraints, 0, 0, 1, 1, n, null);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 1;
        insets.set(0, 0, 0, 0);
        DialogUtil.addUsingGBL(this, this.mSrcScrollPane, gridBagConstraints, 0, 1, 1, 1, n, null);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 2;
        insets.set(0, 0, 0, 0);
        DialogUtil.addUsingGBL(this, this.mSelectorPanel, gridBagConstraints, 0, 2, 1, 1, n, null);
    }

    private void setDefault() {
        if (this.mSourceVars == null) {
            this.mVariableSrcList.loadFromActiveDataset();
        } else {
            this.mVariableSrcList.removeAll();
            VarListModel varListModel = this.mVariableSrcList.getModel();
            for (ISpssVariable iSpssVariable : this.mSourceVars) {
                varListModel.addElement(iSpssVariable);
            }
            this.mVariableSrcList.setModel(varListModel);
        }
    }
}

