/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.controls;

import com.spss.java_client.core.common.ComponentState;
import com.spss.java_client.core.common.LocallyUniqueId;
import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.core.documents.data.DataMgr;
import com.spss.java_client.core.documents.data.dictionary.ISpssDataSrc;
import com.spss.java_client.core.documents.data.dictionary.ISpssVariable;
import com.spss.java_client.ui.controls.SerializableList;
import com.spss.java_client.ui.controls.SpssArrowButton;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.ProcedureDlgMgr;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.dialogs.common.VariableInfoWindow;
import com.spss.java_client.ui.resources.ResUtil;
import com.spss.shared.core_tools.system.OSInfo;
import com.spss.uitools.dialogs.BaseDialog;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.DefaultListModel;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class ModelTermsList
extends SerializableList
implements KeyListener {
    protected static final int MIN_LIST_ITEM_HEIGHT = 18;
    protected static Border sNoFocusBorder = new EmptyBorder(1, 1, 1, 1);
    protected Border mOriginalBorder = null;
    protected String mIdentifier = "VarList";
    protected int mDropFeedbackIndex = -1;
    protected boolean mLockSelections = false;
    protected boolean mLockTextDisplay = false;
    protected ContextEventListener mContextEventListener = new ContextEventListener();
    private DragType mDragType;
    private boolean mDataSource;
    private Vector<SpssArrowButton> mRegisteredArrowButtons = new Vector();
    private ListType mListType;
    protected JPopupMenu mContextMenu = null;
    protected VariableInfoAction mVarInfoAction = null;
    protected static HashMap<SerializableList, VariableInfoWindow> sVarInfoDlgMap = new HashMap();
    protected SelectionAdapter mSelectionListener = new SelectionAdapter();

    public ModelTermsList(String string) {
        super(string);
        this.init();
        this.setDragEnabled(false);
        this.addKeyListener(this);
        this.addMouseListener(this.mContextEventListener);
        this.addListSelectionListener(this.mSelectionListener);
        this.setCellRenderer(new TermsCellRenderer());
        Dimension dimension = new Dimension(DialogUtil.getVarListWidth(), 10);
        this.setMinimumSize(dimension);
    }

    public String getIdentifier() {
        return this.mIdentifier;
    }

    public void setIdentifier(String string) {
        this.mIdentifier = string;
    }

    public String[] getSelectedValues() {
        ListSelectionModel listSelectionModel = this.getSelectionModel();
        ListModel listModel = this.getModel();
        int n = listSelectionModel.getMinSelectionIndex();
        int n2 = listSelectionModel.getMaxSelectionIndex();
        if (n < 0 || n2 < 0) {
            return new String[0];
        }
        if (n > n2) {
            int n3 = n;
            n = n2;
            n2 = n3;
        }
        String[] stringArray = new String[1 + (n2 - n)];
        int n4 = 0;
        for (int i = n; i <= n2; ++i) {
            if (!listSelectionModel.isSelectedIndex(i)) continue;
            stringArray[n4++] = (String)listModel.getElementAt(i);
        }
        String[] stringArray2 = new String[n4];
        System.arraycopy(stringArray, 0, stringArray2, 0, n4);
        return stringArray2;
    }

    @Override
    public void setSelectionInterval(int n, int n2) {
        if (this.mLockSelections) {
            return;
        }
        super.setSelectionInterval(n, n2);
    }

    public void setDragType(DragType dragType) {
        this.mDragType = dragType;
    }

    public DragType getDragType() {
        return this.mDragType;
    }

    @Override
    public void addSelectionInterval(int n, int n2) {
        if (this.mLockSelections) {
            return;
        }
        super.addSelectionInterval(n, n2);
    }

    @Override
    public void removeSelectionInterval(int n, int n2) {
        if (this.mLockSelections) {
            return;
        }
        super.removeSelectionInterval(n, n2);
    }

    public boolean getLockItemDisplay() {
        return this.mLockTextDisplay;
    }

    public boolean getLockSelections() {
        return this.mLockSelections;
    }

    public void setLockSelections(boolean bl) {
        this.mLockSelections = bl;
    }

    public void showDropFeedback(Point point) {
        if (point != null && this.getModel().getSize() > 0) {
            int n = this.locationToIndex(point);
            if (!this.itemInUpperHalf(point)) {
                ++n;
            }
            if (n > -1) {
                if (n != this.mDropFeedbackIndex && this.mDropFeedbackIndex > -1) {
                    this.renderDropLine(this.mDropFeedbackIndex, false);
                }
                this.renderDropLine(n, true);
                this.mDropFeedbackIndex = n;
            }
        } else if (this.mDropFeedbackIndex > -1) {
            this.renderDropLine(this.mDropFeedbackIndex, false);
            this.mDropFeedbackIndex = -1;
        }
    }

    public int getDropFeedbackIndex() {
        return this.mDropFeedbackIndex;
    }

    public boolean itemInUpperHalf(Point point) {
        Rectangle rectangle;
        int n = this.locationToIndex(point);
        if (n > -1 && (rectangle = this.getCellBounds(n, n)).contains(point)) {
            int n2 = (int)(rectangle.getMinY() + rectangle.getHeight() / 2.0);
            return n2 > point.y;
        }
        return false;
    }

    public TermsTransferData getTransferData() {
        String[] stringArray = this.getSelectedValues();
        int[] nArray = this.getSelectedIndices();
        return new TermsTransferData(stringArray, nArray);
    }

    protected void init() {
        int n = this.getFixedCellHeight();
        n = n < 18 ? 18 : n;
        this.setFixedCellHeight(n);
    }

    protected void updateVariableInfo(int n) {
        if (!sVarInfoDlgMap.isEmpty() && sVarInfoDlgMap.containsKey(this)) {
            LocallyUniqueId locallyUniqueId = ProcedureDlgMgr.getMgr().getActiveDatasetId();
            ISpssDataSrc iSpssDataSrc = DataMgr.getDataMgr().getDataSource(locallyUniqueId);
            VariableInfoWindow variableInfoWindow = sVarInfoDlgMap.get(this);
            if (variableInfoWindow != null) {
                String string;
                if (variableInfoWindow.isVisible()) {
                    if (variableInfoWindow.getParent() != this.getBaseDialogParent()) {
                        this.initializeVarInfoWindow(n);
                    } else if (n > -1 && n < this.getModel().getSize()) {
                        string = this.getModel().getElementAt(n).toString();
                        if (string.contains("*")) {
                            string = string.substring(0, string.indexOf("*"));
                        }
                        variableInfoWindow.setVariable(iSpssDataSrc.getVariable(iSpssDataSrc.findVarIndex(string)));
                    } else {
                        variableInfoWindow.setVisible(false);
                    }
                }
                if (n > -1 && n < this.getModel().getSize()) {
                    string = this.getModel().getElementAt(n).toString();
                    if (string.contains("*")) {
                        string = string.substring(0, string.indexOf("*"));
                    }
                    variableInfoWindow.setVariable(iSpssDataSrc.getVariable(iSpssDataSrc.findVarIndex(string)));
                }
            }
        }
    }

    protected void doContextMenu() {
        JPopupMenu jPopupMenu;
        int[] nArray = this.getSelectedIndices();
        if (nArray.length > 0 && (jPopupMenu = this.getContextMenu(nArray)) != null) {
            int n = this.getLeadSelectionIndex();
            Rectangle rectangle = this.getCellBounds(n, n);
            int n2 = (int)rectangle.getMinX() + 18;
            int n3 = (int)rectangle.getMaxY();
            jPopupMenu.show(this, n2, n3);
        }
    }

    protected BaseDialog getBaseDialogParent() {
        Container container;
        BaseDialog baseDialog = null;
        for (container = this.getParent(); container != null && !(container instanceof BaseDialog); container = container.getParent()) {
        }
        if (container != null) {
            baseDialog = (BaseDialog)container;
        }
        return baseDialog;
    }

    protected void createVarInfoDialog(int n) {
        BaseDialog baseDialog = this.getBaseDialogParent();
        VariableInfoWindow variableInfoWindow = new VariableInfoWindow(baseDialog);
        Rectangle rectangle = this.getCellBounds(n, n);
        rectangle = SwingUtilities.convertRectangle(this, rectangle, (Component)baseDialog);
        Point point = new Point((int)(rectangle.getMaxX() + 3.0), (int)(rectangle.getMaxY() + 3.0));
        SwingUtilities.convertPointToScreen(point, (Component)baseDialog);
        variableInfoWindow.setLocation(point);
        LocallyUniqueId locallyUniqueId = ProcedureDlgMgr.getMgr().getActiveDatasetId();
        ISpssDataSrc iSpssDataSrc = DataMgr.getDataMgr().getDataSource(locallyUniqueId);
        String string = this.getModel().getElementAt(n).toString();
        if (string.contains("*")) {
            string = string.substring(0, string.indexOf("*"));
        }
        variableInfoWindow.setVariable(iSpssDataSrc.getVariable(iSpssDataSrc.findVarIndex(string)));
        variableInfoWindow.setVisible(true);
        sVarInfoDlgMap.put(this, variableInfoWindow);
    }

    protected void initializeVarInfoWindow(int n) {
        ISpssVariable iSpssVariable;
        String string = this.getModel().getElementAt(n).toString();
        if (string.contains("*")) {
            string = string.substring(0, string.indexOf("*"));
        }
        LocallyUniqueId locallyUniqueId = ProcedureDlgMgr.getMgr().getActiveDatasetId();
        ISpssDataSrc iSpssDataSrc = DataMgr.getDataMgr().getDataSource(locallyUniqueId);
        if (iSpssDataSrc.findVarIndex((iSpssVariable = iSpssDataSrc.getVariable(iSpssDataSrc.findVarIndex(string))).getId()) == -1) {
            String string2 = String.format(ComponentState.getSPSSLocale(), ResUtil.getCommonDlgString("ERR_VAR_NOT_PRESENT_IN_DATASET"), iSpssVariable.getName());
            SpssAlertOptionPane.showInformationMessageDialog(this, string2, VersionInfo.getAppVersionString());
        } else if (sVarInfoDlgMap.isEmpty()) {
            this.createVarInfoDialog(n);
        } else if (!sVarInfoDlgMap.containsKey(this)) {
            this.createVarInfoDialog(n);
        } else {
            VariableInfoWindow variableInfoWindow = sVarInfoDlgMap.get(this);
            this.updateVariableInfo(n);
            variableInfoWindow.setVisible(true);
        }
    }

    protected JPopupMenu buildPopupMenu() {
        JPopupMenu jPopupMenu = new JPopupMenu();
        this.mVarInfoAction = new VariableInfoAction();
        jPopupMenu.add(new JMenuItem(this.mVarInfoAction));
        return jPopupMenu;
    }

    public JPopupMenu getContextMenu(int[] nArray) {
        if (nArray == null || nArray.length == 0) {
            return null;
        }
        if (this.mContextMenu == null || this.mVarInfoAction == null) {
            this.mContextMenu = this.buildPopupMenu();
        }
        if (this.mContextMenu == null) {
            return null;
        }
        this.mVarInfoAction.setItemIndex(nArray[0]);
        return this.mContextMenu;
    }

    public void setSelection(String[] stringArray) {
        this.clearSelection();
        int n = -1;
        int n2 = -1;
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        DefaultListModel defaultListModel = (DefaultListModel)this.getModel();
        String[] objectArray = stringArray;
        int n3 = objectArray.length;
        for (int i = 0; i < n3; ++i) {
            String string = objectArray[i];
            n = defaultListModel.indexOf(string);
            if (n <= -1) continue;
            arrayList.add(n);
            n2 = n;
        }
        int[] nArray = new int[arrayList.size()];
        for (n3 = 0; n3 < arrayList.size(); ++n3) {
            nArray[n3] = (Integer)arrayList.get(n3);
        }
        this.setSelectedIndices(nArray);
        if (n2 > -1) {
            this.ensureIndexIsVisible(n2);
        }
    }

    protected void renderDropLine(int n, boolean bl) {
        boolean bl2 = n >= this.getModel().getSize();
        int n2 = !bl2 ? n : this.getModel().getSize() - 1;
        Rectangle rectangle = this.getCellBounds(n2, n2);
        int n3 = 0;
        if (rectangle != null) {
            n3 = (int)(bl2 ? rectangle.getY() + rectangle.getHeight() : rectangle.getY());
        }
        Graphics graphics = this.getGraphics();
        Color color = this.isSelectedIndex(n) ? this.getSelectionBackground() : this.getBackground();
        graphics.setColor(bl ? Color.red : color);
        graphics.drawLine(0, n3, this.getWidth(), n3);
        graphics.dispose();
    }

    private void moveSelected(boolean bl) {
        boolean bl2;
        int[] nArray = this.getSelectedIndices();
        if (nArray.length == 0) {
            return;
        }
        int n = bl ? nArray[nArray.length - 1] : nArray[0];
        int n2 = this.getModel().getSize();
        boolean bl3 = !bl && n == 0;
        boolean bl4 = bl2 = bl && n == n2 - 1;
        if (bl3 || bl2) {
            return;
        }
        DefaultListModel defaultListModel = (DefaultListModel)this.getModel();
        for (int i = 0; i < n2; ++i) {
            int n3;
            int n4 = n3 = bl ? n2 - i - 1 : i;
            if (!this.isSelectedIndex(n3)) continue;
            String string = (String)defaultListModel.getElementAt(n3);
            defaultListModel.removeElementAt(n3);
            n3 = bl ? n3 + 1 : n3 - 1;
            defaultListModel.insertElementAt(string, n3);
            this.addSelectionInterval(n3, n3);
        }
        nArray = this.getSelectedIndices();
        this.ensureIndexIsVisible(bl ? nArray[nArray.length - 1] : nArray[0]);
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        if (keyEvent.isControlDown()) {
            if (keyEvent.getKeyCode() == 38) {
                this.moveSelected(false);
            } else if (keyEvent.getKeyCode() == 40) {
                this.moveSelected(true);
            }
        }
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
    }

    public void setDataSource(boolean bl) {
        this.mDataSource = bl;
    }

    public boolean isDataSource() {
        return this.mDataSource;
    }

    public void setSelection(Object[] objectArray) {
        this.clearSelection();
        int n = -1;
        DefaultListModel defaultListModel = (DefaultListModel)this.getModel();
        int[] nArray = new int[objectArray.length];
        int n2 = 0;
        for (Object object : objectArray) {
            n = defaultListModel.indexOf(object);
            if (n <= -1) continue;
            nArray[n2++] = n;
        }
        this.setSelectedIndices(nArray);
    }

    public void addRegisteredArrowButton(SpssArrowButton spssArrowButton) {
        this.mRegisteredArrowButtons.add(spssArrowButton);
    }

    public void removeRegisteredArrowButton(SpssArrowButton spssArrowButton) {
        if (this.mRegisteredArrowButtons.contains(spssArrowButton)) {
            this.mRegisteredArrowButtons.remove(spssArrowButton);
        }
    }

    public Vector<SpssArrowButton> getRegisteredArrowButtons() {
        return this.mRegisteredArrowButtons;
    }

    public void setListType(ListType listType) {
        this.mListType = listType;
        int n = 20;
        Dimension dimension = new Dimension(DialogUtil.getVarListWidth(), n);
        this.setMinimumSize(dimension);
        if (this.mListType == ListType.single_item) {
            this.setPreferredSize(dimension);
            this.setMaximumSize(dimension);
        } else {
            this.setPreferredSize(null);
            this.setMaximumSize(null);
        }
    }

    public ListType getListType() {
        return this.mListType;
    }

    class SelectionAdapter
    implements ListSelectionListener {
        SelectionAdapter() {
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (listSelectionEvent.getValueIsAdjusting()) {
                return;
            }
            int n = ModelTermsList.this.getSelectedIndex();
            if (n > -1) {
                ModelTermsList.this.updateVariableInfo(n);
            } else {
                VariableInfoWindow variableInfoWindow = sVarInfoDlgMap.get(ModelTermsList.this);
                if (variableInfoWindow != null) {
                    variableInfoWindow.setVisible(false);
                }
            }
        }
    }

    class VariableInfoAction
    extends AbstractAction {
        private int mIndex = 0;

        public VariableInfoAction() {
            Integer n;
            this.putValue("Name", ResUtil.getCommonDlgString("IDS_VARIABLE_INFO"));
            if (OSInfo.getOSType() != OSInfo.OSType.MAC && (n = ResUtil.getCommonDlgAccessKey("IDK_VARIABLE_INFO")) != null) {
                this.putValue("MnemonicKey", n);
            }
        }

        public void setItemIndex(int n) {
            this.mIndex = n;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (this.mIndex < 0) {
                return;
            }
            BaseDialog baseDialog = ModelTermsList.this.getBaseDialogParent();
            if (baseDialog == null) {
                return;
            }
            ModelTermsList.this.initializeVarInfoWindow(this.mIndex);
        }
    }

    class ContextEventListener
    extends MouseAdapter {
        ContextEventListener() {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            int n;
            if (mouseEvent.isConsumed()) {
                return;
            }
            if (ModelTermsList.this.isEnabled()) {
                ModelTermsList.this.grabFocus();
            }
            if (!((n = ModelTermsList.this.locationToIndex(mouseEvent.getPoint())) <= -1 || mouseEvent.isControlDown() || mouseEvent.isShiftDown() || ModelTermsList.this.isSelectedIndex(n))) {
                ModelTermsList.this.setSelectedIndex(n);
                ModelTermsList.this.updateVariableInfo(n);
            }
            if (mouseEvent.isPopupTrigger() && ModelTermsList.this.isEnabled()) {
                ModelTermsList.this.doContextMenu();
                mouseEvent.consume();
            }
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            if (mouseEvent.isConsumed()) {
                return;
            }
            if (ModelTermsList.this.isEnabled()) {
                ModelTermsList.this.grabFocus();
            }
            if (mouseEvent.isPopupTrigger() && ModelTermsList.this.isEnabled()) {
                ModelTermsList.this.doContextMenu();
                mouseEvent.consume();
            }
        }
    }

    class TermsCellRenderer
    extends JLabel
    implements ListCellRenderer {
        TermsCellRenderer() {
            this.setBorder(sNoFocusBorder);
            this.setOpaque(true);
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            if (ComponentState.isBtdRtlOrLtr() && object != null && ((String)object).length() > 0) {
                this.setText(ComponentState.prepareStringForBidiRendering((String)object.toString()));
            } else {
                this.setText(object.toString());
            }
            if (bl) {
                if (ModelTermsList.this.hasFocus()) {
                    this.setBackground(jList.getSelectionBackground());
                    this.setForeground(jList.getSelectionForeground());
                } else {
                    this.setBackground(Color.lightGray);
                    this.setForeground(Color.black);
                }
            } else {
                this.setBackground(jList.getBackground());
                this.setForeground(jList.getForeground());
            }
            this.setEnabled(jList.isEnabled());
            this.setFont(jList.getFont());
            Border border = null;
            if (bl2) {
                if (bl) {
                    border = UIManager.getBorder("List.focusSelectedCellHighlightBorder");
                }
                if (border == null) {
                    border = UIManager.getBorder("List.focusCellHighlightBorder");
                }
            } else {
                border = sNoFocusBorder;
            }
            this.setBorder(border);
            return this;
        }
    }

    public class TermsTransferData
    implements Cloneable {
        private String[] mVars;
        private int[] mSelectedIndices;

        public TermsTransferData(String[] stringArray, int[] nArray) {
            this.mVars = stringArray;
            this.mSelectedIndices = nArray;
        }

        public int[] getSelectedIndices() {
            return this.mSelectedIndices;
        }

        public String[] getVariables() {
            return this.mVars;
        }

        public TermsTransferData clone() throws CloneNotSupportedException {
            TermsTransferData termsTransferData = null;
            termsTransferData = (TermsTransferData)super.clone();
            termsTransferData.mVars = (String[])this.mVars.clone();
            termsTransferData.mSelectedIndices = (int[])this.mSelectedIndices.clone();
            return termsTransferData;
        }
    }

    public static enum ListType {
        normal,
        single_item;

    }

    public static enum DragType {
        eNoAutoDrag,
        eAutoDragCopy,
        eAutoDragMove,
        eAutoDragCopyOrMove;

    }
}

