/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.controls;

import com.spss.java_client.core.documents.data.dictionary.ISpssVariable;
import com.spss.java_client.ui.controls.ArrowButton;
import com.spss.java_client.ui.controls.ListFocusTraversalPolicy;
import com.spss.java_client.ui.controls.ListTravArrowButtonGroup;
import com.spss.java_client.ui.controls.SpssArrowButton;
import com.spss.java_client.ui.controls.VarListModel;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.resources.ResUtil;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class ListTravArrowButtonFactory
implements ActionListener,
ListSelectionListener {
    private JList mList;
    private boolean mSideWays;
    private ArrowButton mUpArrowButton;
    private ArrowButton mDownArrowButton;
    private GridBagConstraints mConstraints;
    private Insets mInsets;

    public ListTravArrowButtonFactory(JList jList, boolean bl) {
        this.mList = jList;
        this.mList.addListSelectionListener(this);
        this.mSideWays = bl;
        this.initVars();
    }

    public JPanel getArrowButtonPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setLayout(new GridBagLayout());
        int n = 23;
        int n2 = DialogUtil.getGroupBoxInnerMargin();
        Insets insets = DialogUtil.getStandardControlInsets();
        if (this.mSideWays) {
            this.mInsets.set(n2, n2, n2, 0);
            DialogUtil.addUsingGBL(jPanel, this.mUpArrowButton, this.mConstraints, 0, 0, 1, 1, n, this.mInsets);
            this.mConstraints.weighty = 1.0;
            this.mInsets.set(n2, insets.left, n2, n2);
            DialogUtil.addUsingGBL(jPanel, this.mDownArrowButton, this.mConstraints, 1, 0, 1, 1, n, this.mInsets);
        } else {
            this.mInsets.set(n2, n2, 0, n2);
            DialogUtil.addUsingGBL(jPanel, this.mUpArrowButton, this.mConstraints, 0, 0, 1, 1, n, this.mInsets);
            this.mConstraints.weighty = 1.0;
            this.mInsets.set(n2, n2, n2, n2);
            DialogUtil.addUsingGBL(jPanel, this.mDownArrowButton, this.mConstraints, 0, 1, 1, 1, n, this.mInsets);
        }
        return jPanel;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        ListFocusTraversalPolicy.setSourceButton((JButton)actionEvent.getSource());
        ArrowButton arrowButton = (ArrowButton)actionEvent.getSource();
        int[] nArray = this.mList.getSelectedIndices();
        if (arrowButton.getArrowOrientation() == SpssArrowButton.ButtonOrientation.up) {
            this.manipulateUpList(nArray);
        } else if (arrowButton.getArrowOrientation() == SpssArrowButton.ButtonOrientation.down) {
            this.manipulateDownList(nArray);
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ListFocusTraversalPolicy.setSourceButton(null);
            }
        });
    }

    public ArrowButton getUpArrowButton() {
        return this.mUpArrowButton;
    }

    public ArrowButton getDownArrowButton() {
        return this.mDownArrowButton;
    }

    public JList getList() {
        return this.mList;
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        int[] nArray = this.mList.getSelectedIndices();
        if (nArray.length == 0) {
            this.mUpArrowButton.setEnabled(false);
            this.mDownArrowButton.setEnabled(false);
            return;
        }
        this.mUpArrowButton.setEnabled(true);
        this.mDownArrowButton.setEnabled(true);
        if (this.isSelectedIndexInSequence()) {
            int n;
            if (this.mList.getSelectedIndex() == 0) {
                this.mUpArrowButton.setEnabled(false);
            }
            if (nArray[nArray.length - 1] == (n = this.mList.getModel().getSize()) - 1) {
                this.mDownArrowButton.setEnabled(false);
            }
        } else {
            this.mUpArrowButton.setEnabled(false);
            this.mDownArrowButton.setEnabled(false);
        }
    }

    private void manipulateDownList(int[] nArray) {
        Object[] objectArray;
        int n = nArray[0] + nArray.length + 1;
        int n2 = nArray[0];
        ListModel listModel = this.mList.getModel();
        for (Object object : objectArray = this.mList.getSelectedValues()) {
            if (listModel instanceof VarListModel) {
                ((VarListModel)listModel).insertElementAt((ISpssVariable)object, n);
                ((VarListModel)listModel).removeElementAt(n2);
                continue;
            }
            ((DefaultListModel)listModel).insertElementAt(object, n);
            ((DefaultListModel)listModel).removeElementAt(n2);
        }
        this.setSelectedIndices(nArray, n);
        this.mList.ensureIndexIsVisible(nArray[nArray.length - 1]);
    }

    private void manipulateUpList(int[] nArray) {
        Object[] objectArray;
        int n = nArray[0] - 1;
        int n2 = nArray[0];
        ListModel listModel = this.mList.getModel();
        for (Object object : objectArray = this.mList.getSelectedValues()) {
            if (listModel instanceof VarListModel) {
                ((VarListModel)listModel).insertElementAt((ISpssVariable)object, n++);
                ((VarListModel)listModel).removeElementAt(++n2);
                continue;
            }
            ((DefaultListModel)listModel).insertElementAt(object, n++);
            ((DefaultListModel)listModel).removeElementAt(++n2);
        }
        this.setSelectedIndices(nArray, n);
        this.mList.ensureIndexIsVisible(nArray[0]);
    }

    private void setSelectedIndices(int[] nArray, int n) {
        for (int i = nArray.length - 1; i > -1; --i) {
            nArray[i] = --n;
        }
        this.mList.setSelectedIndices(nArray);
    }

    private void initVars() {
        this.mUpArrowButton = new ArrowButton();
        this.mUpArrowButton.setArrowOrientation(SpssArrowButton.ButtonOrientation.up);
        this.mUpArrowButton.addActionListener(this);
        this.mUpArrowButton.setEnabled(false);
        this.mDownArrowButton = new ArrowButton();
        this.mDownArrowButton.setArrowOrientation(SpssArrowButton.ButtonOrientation.down);
        this.mDownArrowButton.addActionListener(this);
        this.mDownArrowButton.setEnabled(false);
        this.mUpArrowButton.getAccessibleContext().setAccessibleDescription(ResUtil.getCommonDlgString("TXT_MOVE_UP_MESSAGE"));
        this.mUpArrowButton.setToolTipText(ResUtil.getCommonDlgString("MOVE_UP_IMAGE_TOOLTIP"));
        this.mDownArrowButton.setToolTipText(ResUtil.getCommonDlgString("MOVE_DOWN_IMAGE_TOOLTIP"));
        this.mDownArrowButton.getAccessibleContext().setAccessibleDescription(ResUtil.getCommonDlgString("TXT_MOVE_DOWN_MESSAGE"));
        this.mConstraints = new GridBagConstraints();
        this.mConstraints.weightx = 1.0;
        this.mConstraints.weighty = 0.0;
        this.mInsets = new Insets(0, 0, 0, 0);
        ListTravArrowButtonGroup listTravArrowButtonGroup = new ListTravArrowButtonGroup();
        listTravArrowButtonGroup.add(this.mUpArrowButton);
        listTravArrowButtonGroup.add(this.mDownArrowButton);
    }

    private boolean isSelectedIndexInSequence() {
        int[] nArray = this.mList.getSelectedIndices();
        for (int i = 0; i < nArray.length - 1; ++i) {
            if (nArray[i] + 1 == nArray[i + 1]) continue;
            return false;
        }
        return true;
    }
}

