/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.controls;

import com.spss.java_client.core.common.CommandLine;
import com.spss.java_client.core.common.ComponentState;
import com.spss.java_client.core.common.LocallyUniqueId;
import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.core.documents.data.DataMgr;
import com.spss.java_client.core.documents.data.dictionary.ISpssDataSrc;
import com.spss.java_client.core.documents.data.dictionary.ISpssVariable;
import com.spss.java_client.core.documents.data.dictionary.IVariableSet;
import com.spss.java_client.core.documents.data.dictionary.SpssCalculatedScaleVar;
import com.spss.java_client.core.documents.data.dictionary.SpssVariable;
import com.spss.java_client.ui.controls.ArrowButton;
import com.spss.java_client.ui.controls.ILayeredList;
import com.spss.java_client.ui.controls.MultiVarListAccessor;
import com.spss.java_client.ui.controls.SpssArrowButton;
import com.spss.java_client.ui.controls.SrcVariableList;
import com.spss.java_client.ui.controls.TargetVariableList;
import com.spss.java_client.ui.controls.VarListModel;
import com.spss.java_client.ui.controls.VariableList;
import com.spss.java_client.ui.dialogs.base.graphs.interactive.SpssIGraphVariable;
import com.spss.java_client.ui.dialogs.common.DialogDataModel;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.IVarMoveHandler;
import com.spss.java_client.ui.dialogs.common.ProcedureDlgMgr;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.resources.ResUtil;
import com.spss.shared.core_tools.system.OSInfo;
import com.spss.uitools.dialogs.UIToolDialogUtil;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Scanner;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

public class LayeredListWidget
extends JPanel
implements ListDataListener,
ILayeredList,
MultiVarListAccessor {
    static final String PREVIOUS_BUTTON = "IDS_LAYER_WIDGET_PREVIOUS_BUTTON";
    static final String NEXT_BUTTON = "IDS_LAYER_WIDGET_NEXT_BUTTON";
    static final String LUID_MAP = "IDS_LAYER_WIDGET_LUID_MAP";
    static final String VAR_NAME_MAP = "IDS_LAYER_WIDGET_VARNAME_MAP";
    static final String CURRENT_LAYER = "IDS_CURRENT_LAYER";
    static final String TOTAL_LAYERS = "IDS_TOTAL_LAYERS";
    public int mNoOfLayers;
    public Action mPreviousAction;
    public Action mNextAction;
    protected TargetVariableList mVarList;
    protected ArrowButton mArrow;
    protected JPanel mLayeredListPanel;
    protected String mBorderTitle;
    protected JLabel mIndependentListLabel;
    private JScrollPane mScrollPane;
    private JButton mPreviousButton;
    private JButton mNextButton;
    private int mCurrentLayer;
    private VarListModel mListModel;
    private boolean mFirstPreviousClick;
    private ArrayList<VarListModel> mArrayList = new ArrayList(20);
    private int mTotalItems;
    private int MAX_NO_OF_LAYERS = -1;
    private int MAX_NO_OF_ITEMS_IN_LAYER = -1;
    private int MAX_NO_OF_ITEMS_PER_LAYER = -1;
    private String mListLabel;
    private int mNoOfItemInCurrentLayer;
    private ListDataListener mListListener;

    public LayeredListWidget(String string, ListDataListener listDataListener) {
        super(true);
        this.mListListener = listDataListener;
        if (string == null) {
            string = "";
        }
        this.mListLabel = string;
        this.init();
    }

    @Override
    public ArrayList<VarListModel> getVarListModels() {
        ArrayList arrayList = (ArrayList)this.mArrayList.clone();
        if (this.mListModel.getSize() > 0 && this.findArrayList(this.mListModel) == null) {
            arrayList.add(this.mListModel);
        }
        return arrayList;
    }

    @Override
    public void intervalAdded(ListDataEvent listDataEvent) {
        this.canEnableNext();
        ++this.mTotalItems;
        ++this.mNoOfItemInCurrentLayer;
    }

    @Override
    public void intervalRemoved(ListDataEvent listDataEvent) {
        this.mNextButton.setEnabled(this.mVarList.getModel().getSize() > 0 || this.mNoOfLayers > this.mCurrentLayer);
        --this.mTotalItems;
        --this.mNoOfItemInCurrentLayer;
    }

    @Override
    public void contentsChanged(ListDataEvent listDataEvent) {
        this.mNextButton.setEnabled(this.mVarList.getModel().getSize() > 0 || this.mNoOfLayers > this.mCurrentLayer);
    }

    public void setMaxNoOfLayers(int n) {
        this.MAX_NO_OF_LAYERS = n - 1;
    }

    @Override
    public int getMaxNoOfLayers() {
        return this.MAX_NO_OF_LAYERS;
    }

    public void setMaxNoOfItemsInLayers(int n) {
        this.MAX_NO_OF_ITEMS_IN_LAYER = n + 1;
    }

    public void setMaxNoOfItemsPerLayers(int n) {
        this.MAX_NO_OF_ITEMS_PER_LAYER = n + 1;
    }

    public void setPreviousMnemonic(int n) {
        if (n != 0 && OSInfo.getOSType() != OSInfo.OSType.MAC) {
            this.mPreviousAction.putValue("MnemonicKey", n);
        }
    }

    public void setNextMnemonic(int n) {
        if (n != 0 && OSInfo.getOSType() != OSInfo.OSType.MAC) {
            this.mNextAction.putValue("MnemonicKey", n);
        }
    }

    public void setVarListListMnemonic(int n) {
        if (n != 0 && OSInfo.getOSType() != OSInfo.OSType.MAC) {
            this.mIndependentListLabel.setDisplayedMnemonic(n);
        }
    }

    public int getNoOfLayers() {
        return this.mNoOfLayers;
    }

    public IVarMoveHandler getVarMoveHandler() {
        return new LayeredVarMoveHandler();
    }

    public int getCurrentLayer() {
        return this.mCurrentLayer;
    }

    public void saveListState(DialogDataModel dialogDataModel) {
        if (this.mVarList.getModel().getSize() > 0 && this.mCurrentLayer == this.mNoOfLayers && this.mNoOfLayers == this.mArrayList.size()) {
            this.mListModel = this.mVarList.getModel();
            if (this.mNoOfLayers == this.mCurrentLayer && this.mNoOfLayers == 0) {
                this.mArrayList.add(this.mCurrentLayer, this.mListModel);
                this.mListModel = new VarListModel(this.mVarList);
            } else if (this.mArrayList.size() == this.mCurrentLayer) {
                this.mArrayList.add(this.mCurrentLayer, this.mListModel);
            } else {
                this.mArrayList.set(this.mCurrentLayer, this.mListModel);
            }
        }
        HashMap<Integer, Object> hashMap = new HashMap<Integer, Object>();
        HashMap<Integer, Object> hashMap2 = new HashMap<Integer, Object>();
        for (int i = 0; i < this.mArrayList.size(); ++i) {
            TargetVariableList targetVariableList = new TargetVariableList();
            targetVariableList.setModel(this.mArrayList.get(i));
            int n = targetVariableList.getModel().getSize();
            ArrayList<Integer> arrayList = new ArrayList<Integer>();
            ArrayList<String> arrayList2 = new ArrayList<String>();
            for (int j = 0; j < n; ++j) {
                ISpssVariable iSpssVariable = targetVariableList.getModel().getElementAt(j);
                arrayList.add(iSpssVariable.getId().asInt());
                arrayList2.add(iSpssVariable.getName());
            }
            hashMap.put(i, arrayList);
            hashMap2.put(i, arrayList2);
        }
        dialogDataModel.putMap(LUID_MAP, hashMap);
        dialogDataModel.putMap(VAR_NAME_MAP, hashMap2);
        dialogDataModel.putInteger(CURRENT_LAYER, this.mCurrentLayer);
        dialogDataModel.putInteger(TOTAL_LAYERS, this.mNoOfLayers);
    }

    private ArrayList<LocallyUniqueId> recreateLuids(ArrayList<Integer> arrayList) {
        ArrayList<LocallyUniqueId> arrayList2 = new ArrayList<LocallyUniqueId>(arrayList.size());
        for (Integer n : arrayList) {
            arrayList2.add(new LocallyUniqueId(n.intValue()));
        }
        return arrayList2;
    }

    public void loadListState(DialogDataModel dialogDataModel) {
        LocallyUniqueId locallyUniqueId = ProcedureDlgMgr.getMgr().getActiveDatasetId();
        ISpssDataSrc iSpssDataSrc = DataMgr.getDataMgr().getDataSource(locallyUniqueId);
        if (iSpssDataSrc == null || !this.mVarList.isLoadFromPersistent()) {
            return;
        }
        HashMap<Integer, Object> hashMap = dialogDataModel.getMap(LUID_MAP);
        HashMap<Integer, Object> hashMap2 = dialogDataModel.getMap(VAR_NAME_MAP);
        if (hashMap == null || hashMap2 == null) {
            return;
        }
        int n = 0;
        boolean bl = CommandLine.isClementineCaller();
        while (hashMap.get(n) != null) {
            ArrayList<LocallyUniqueId> arrayList = this.recreateLuids((ArrayList)hashMap.get(n));
            ArrayList arrayList2 = (ArrayList)hashMap2.get(n);
            VarListModel varListModel = new VarListModel(this.mVarList);
            for (int i = 0; i < arrayList.size(); ++i) {
                ISpssVariable iSpssVariable;
                String string = (String)arrayList2.get(i);
                int n2 = bl ? iSpssDataSrc.findVarIndex(string) : iSpssDataSrc.findVarIndex(arrayList.get(i));
                if (n2 > -1) {
                    iSpssVariable = iSpssDataSrc.getVariable(n2);
                    try {
                        iSpssVariable = iSpssVariable.clone();
                        if (bl) {
                            arrayList.set(i, iSpssVariable.getId());
                        }
                    }
                    catch (CloneNotSupportedException cloneNotSupportedException) {
                        cloneNotSupportedException.printStackTrace();
                    }
                    varListModel.addElement(iSpssVariable, false);
                    continue;
                }
                iSpssVariable = new SpssVariable();
                iSpssVariable.setName(string);
                iSpssVariable.setLabel(string);
                varListModel.addElement(iSpssVariable, false);
            }
            this.mArrayList.add(n, varListModel);
            ++n;
        }
        this.mCurrentLayer = dialogDataModel.getInteger(CURRENT_LAYER);
        this.mPreviousButton.setEnabled(this.mCurrentLayer > 0);
        this.mNoOfLayers = dialogDataModel.getInteger(TOTAL_LAYERS);
        this.mLayeredListPanel.setBorder(new TitledBorder(this.mBorderTitle + (this.mCurrentLayer + 1) + ResUtil.getCommonDlgString("IDS_LAYER_WIDGET_INDEPENDENT_LAYER_TITLE2") + (this.mNoOfLayers + 1)));
        this.validateLayeredLists(new Vector<ISpssVariable>());
        this.mVarList.getModel().addListDataListener(this);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                LayeredListWidget.this.mNextButton.setEnabled(LayeredListWidget.this.mVarList.getModel().getSize() > 0);
            }
        });
    }

    public void setSrcList(SrcVariableList srcVariableList) {
        this.mArrow.registerVariableList(srcVariableList, SpssArrowButton.ButtonOrientation.right);
    }

    @Override
    public TargetVariableList getTargetVariableList() {
        return this.mVarList;
    }

    public void setLayeredList(TargetVariableList targetVariableList) {
        this.mVarList = targetVariableList;
    }

    public void addListener(ListDataListener listDataListener) {
        this.mVarList.getModel().addListDataListener(listDataListener);
    }

    public void resetLayeredListWidget() {
        this.mVarList.removeAll();
        this.mNextButton.setEnabled(false);
        this.mPreviousButton.setEnabled(false);
        this.mArrayList.clear();
        this.mNoOfLayers = 0;
        this.mCurrentLayer = 0;
        this.setIndependentBorder();
        this.mTotalItems = 0;
        this.mNoOfItemInCurrentLayer = 0;
    }

    public Vector<Object> getTraversalComponent() {
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mArrow);
        vector.add(this.mVarList);
        vector.add(this.mPreviousButton);
        vector.add(this.mNextButton);
        return vector;
    }

    public void validateLayeredLists(Vector<ISpssVariable> vector) {
        ArrayList<VarListModel> arrayList = this.mArrayList;
        int n = this.getCurrentLayer();
        if (arrayList.size() == n) {
            arrayList.add(n, this.mListModel);
        }
        for (int i = arrayList.size() - 1; i >= 0; --i) {
            VarListModel varListModel = arrayList.get(i);
            if (varListModel == null) continue;
            this.validateTargetListVars(vector, varListModel);
            if (varListModel.getSize() != 0) continue;
            if (this.mCurrentLayer != 0 && this.mCurrentLayer == arrayList.size() - 1) {
                --this.mCurrentLayer;
            }
            arrayList.remove(varListModel);
            if (this.mNoOfLayers <= 0) continue;
            --this.mNoOfLayers;
        }
        if (this.mCurrentLayer < arrayList.size()) {
            VarListModel varListModel = arrayList.get(this.mCurrentLayer);
            if (varListModel != null) {
                this.mVarList.setModel(varListModel);
            }
        } else if (arrayList.size() != 0) {
            this.mNextButton.setEnabled(true);
            VarListModel varListModel = arrayList.get(arrayList.size() - 1);
            if (varListModel != null) {
                this.mVarList.setModel(varListModel);
            }
        }
        if (this.mCurrentLayer == 0) {
            this.mPreviousButton.setEnabled(false);
        }
        this.setIndependentBorder();
    }

    public JScrollPane getScrollPane() {
        return this.mScrollPane;
    }

    protected void setIndependentBorder() {
        String string = this.mBorderTitle + (this.mCurrentLayer + 1) + ResUtil.getCommonDlgString("IDS_LAYER_WIDGET_INDEPENDENT_LAYER_TITLE2") + (this.mNoOfLayers + 1);
        this.mLayeredListPanel.setBorder(new TitledBorder(string));
        this.mIndependentListLabel.setText(string);
    }

    protected void moreOperationOnNext() {
    }

    protected void moreOperationOnPrevious() {
    }

    protected JPanel setupIndependentPanel() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        int n = 23;
        Insets insets = new Insets(DialogUtil.getStandardControlInsets().top + 2, DialogUtil.getStandardControlInsets().left + 5, DialogUtil.getStandardControlInsets().bottom + 2, 0);
        this.mLayeredListPanel = new JPanel(new GridBagLayout());
        this.mLayeredListPanel.setBorder(new TitledBorder(this.mBorderTitle + (this.mCurrentLayer + 1) + ResUtil.getCommonDlgString("IDS_LAYER_WIDGET_INDEPENDENT_LAYER_TITLE2") + (this.mNoOfLayers + 1)));
        DialogUtil.addUsingGBL(this.mLayeredListPanel, this.setupButtonPanel(), gridBagConstraints, 0, 0, 2, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        this.mIndependentListLabel = new JLabel(this.mListLabel, 10);
        insets = new Insets(DialogUtil.getStandardControlInsets().top + 5, DialogUtil.getStandardControlInsets().left + 5, DialogUtil.getStandardControlInsets().bottom + 2, DialogUtil.getStandardControlInsets().right + 5);
        this.mIndependentListLabel.setLabelFor(this.mVarList);
        DialogUtil.addUsingGBL(this.mLayeredListPanel, this.mIndependentListLabel, gridBagConstraints, 1, 1, 1, 1, n, insets);
        n = 10;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        Insets insets2 = DialogUtil.getArrowButtonInsets();
        DialogUtil.addUsingGBL(this.mLayeredListPanel, this.mArrow, gridBagConstraints, 0, 2, 1, 1, n, insets2);
        this.mVarList.setDragType(VariableList.VarMoveType.eMoveOriginal);
        gridBagConstraints.weighty = 1.0;
        n = 23;
        gridBagConstraints.fill = 1;
        this.mScrollPane = new JScrollPane(this.mVarList);
        this.mVarList.setMinimumSize(new Dimension(DialogUtil.getVarListWidth(), this.mVarList.getFixedCellHeight() * 2 + 2));
        this.mScrollPane.setPreferredSize(this.mVarList.getMinimumSize());
        insets = new Insets(0, DialogUtil.getStandardControlInsets().left + 5, DialogUtil.getStandardControlInsets().bottom + 10, DialogUtil.getStandardControlInsets().right + 5);
        DialogUtil.addUsingGBL(this.mLayeredListPanel, this.mScrollPane, gridBagConstraints, 1, 2, 1, 1, n, insets);
        this.mArrow.registerVariableList(this.mVarList, SpssArrowButton.ButtonOrientation.left);
        return this.mLayeredListPanel;
    }

    protected JPanel setupButtonPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 0;
        int n = 23;
        Insets insets = new Insets(DialogUtil.getStandardControlInsets().top + 2, DialogUtil.getStandardControlInsets().left, 0, 0);
        DialogUtil.addUsingGBL(jPanel, this.mPreviousButton, gridBagConstraints, 0, 0, 1, 1, n, insets);
        n = 24;
        gridBagConstraints.weightx = 1.0;
        insets = new Insets(DialogUtil.getStandardControlInsets().top + 2, DialogUtil.getStandardControlInsets().left + 5, 0, DialogUtil.getStandardControlInsets().right + 5);
        DialogUtil.addUsingGBL(jPanel, this.mNextButton, gridBagConstraints, 1, 0, 1, 1, n, insets);
        UIToolDialogUtil.normalizeButtonWidths((JPanel)jPanel);
        return jPanel;
    }

    private void validateTargetListVars(Vector<ISpssVariable> vector, VarListModel varListModel) {
        if (varListModel != null) {
            for (int i = varListModel.getSize() - 1; i >= 0; --i) {
                LocallyUniqueId locallyUniqueId = ProcedureDlgMgr.getMgr().getActiveDatasetId();
                ISpssDataSrc iSpssDataSrc = DataMgr.getDataMgr().getDataSource(locallyUniqueId);
                ISpssVariable iSpssVariable = varListModel.getElementAt(i);
                if (iSpssVariable instanceof SpssIGraphVariable || iSpssVariable instanceof SpssCalculatedScaleVar) continue;
                if (iSpssDataSrc.isVariableInCurrentSet(iSpssVariable)) {
                    if (this.mVarList.getDragType() != VariableList.VarMoveType.eMoveOriginal || vector.contains(iSpssVariable)) continue;
                    vector.add(iSpssVariable);
                    continue;
                }
                if (iSpssVariable.getName().contains("*")) {
                    if (!this.isAllVarsExistInDataSource(iSpssVariable)) {
                        varListModel.removeElement(iSpssVariable);
                    }
                } else if (!iSpssVariable.getName().contains("T_COV_")) {
                    varListModel.removeElement(iSpssVariable);
                }
                --this.mNoOfItemInCurrentLayer;
            }
        }
    }

    private boolean isAllVarsExistInDataSource(ISpssVariable iSpssVariable) {
        if (iSpssVariable.getName().contains("*")) {
            String string = "(Cat)";
            String string2 = iSpssVariable.getName();
            Scanner scanner = new Scanner(string2);
            scanner.useDelimiter("\\*");
            while (scanner.hasNext()) {
                String string3 = scanner.next();
                if (string3.contains(string)) {
                    string3 = string3.replace(string, "");
                }
                if (string3.equals("T_COV_") || this.isVarExistInDataSource(string3)) continue;
                return false;
            }
        }
        return true;
    }

    private boolean isVarExistInDataSource(String string) {
        LocallyUniqueId locallyUniqueId = ProcedureDlgMgr.getMgr().getActiveDatasetId();
        ISpssDataSrc iSpssDataSrc = DataMgr.getDataMgr().getDataSource(locallyUniqueId);
        int n = iSpssDataSrc.findVarIndex(string);
        if (n == -1) {
            return false;
        }
        IVariableSet iVariableSet = iSpssDataSrc.getALLVARIABLES();
        for (String string2 : iVariableSet.getVariableNames()) {
            if (!string2.equalsIgnoreCase(string)) continue;
            return true;
        }
        return false;
    }

    private void init() {
        this.mTotalItems = 0;
        this.mCurrentLayer = 0;
        this.mNoOfLayers = 0;
        this.mNoOfItemInCurrentLayer = 0;
        this.mFirstPreviousClick = true;
        this.mBorderTitle = ResUtil.getCommonDlgString("IDS_LAYER_WIDGET_INDEPENDENT_LAYER_TITLE1");
        this.mVarList = new TargetVariableList();
        this.mListModel = this.mVarList.getModel();
        this.mVarList.getModel().addListDataListener(this);
        if (this.mListListener != null) {
            this.mVarList.getModel().addListDataListener(this.mListListener);
        }
        this.setLayout(new GridBagLayout());
        this.mPreviousAction = new AbstractAction(ResUtil.getCommonDlgString("IDS_LAYER_WIDGET_PREVIOUS")){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                LayeredListWidget.this.previousAction();
                LayeredListWidget.this.moreOperationOnPrevious();
            }
        };
        this.mNextAction = new AbstractAction(ResUtil.getCommonDlgString("IDS_LAYER_WIDGET_NEXT")){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                LayeredListWidget.this.nextAction();
                LayeredListWidget.this.moreOperationOnNext();
            }
        };
        this.mPreviousButton = new JButton(this.mPreviousAction);
        this.mNextButton = new JButton(this.mNextAction);
        if (OSInfo.getOSType() != OSInfo.OSType.MAC) {
            this.mPreviousAction.putValue("MnemonicKey", ResUtil.getCommonDlgAccessKey("IDK_LAYER_WIDGET_PREVIOUS"));
            this.mNextAction.putValue("MnemonicKey", ResUtil.getCommonDlgAccessKey("IDK_LAYER_WIDGET_NEXT"));
        }
        this.mArrow = new ArrowButton(SpssArrowButton.ButtonOrientation.right);
        this.mScrollPane = new JScrollPane(this.mVarList);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        Insets insets = DialogUtil.getStandardButtonInsets();
        DialogUtil.addUsingGBL(this, this.setupIndependentPanel(), gridBagConstraints, 0, 0, 1, 1, n, insets);
        this.mArrow.setVarMoveHandler(new LayeredVarMoveHandler());
        this.setDefaults();
    }

    private void previousAction() {
        if (this.mVarList.getModel().getSize() > 0 && this.mCurrentLayer == this.mNoOfLayers && this.mFirstPreviousClick) {
            this.mListModel = this.mVarList.getModel();
            if (this.mArrayList.size() == this.mCurrentLayer) {
                this.mArrayList.add(this.mCurrentLayer, this.mListModel);
            } else {
                this.mArrayList.set(this.mCurrentLayer, this.mListModel);
            }
            ListDataListener[] listDataListenerArray = this.mArrayList.get(this.mCurrentLayer - 1).getListDataListeners();
            this.mVarList.setModel(this.mArrayList.get(this.mCurrentLayer - 1));
            if (listDataListenerArray.length == 0) {
                this.mVarList.getModel().addListDataListener(this);
                if (this.mListListener != null) {
                    this.mVarList.getModel().addListDataListener(this.mListListener);
                }
            }
            this.mFirstPreviousClick = false;
            --this.mCurrentLayer;
            this.mPreviousButton.setEnabled(this.mCurrentLayer > 0);
            this.mNextButton.setEnabled(this.mVarList.getModel().getSize() > 0 || this.mNoOfLayers > this.mCurrentLayer);
            this.setIndependentBorder();
        } else {
            this.checkForEmptyModel();
            --this.mCurrentLayer;
            this.setIndependentBorder();
            this.mPreviousButton.setEnabled(this.mCurrentLayer > 0);
            this.mNextButton.setEnabled(this.mNoOfLayers > this.mCurrentLayer || this.mArrayList.get(this.mCurrentLayer).getSize() > 0);
            ListDataListener[] listDataListenerArray = this.mArrayList.get(this.mCurrentLayer).getListDataListeners();
            this.mVarList.setModel(this.mArrayList.get(this.mCurrentLayer));
            if (listDataListenerArray.length == 0) {
                this.mVarList.getModel().addListDataListener(this);
                if (this.mListListener != null) {
                    this.mVarList.getModel().addListDataListener(this.mListListener);
                }
            }
        }
    }

    private void nextAction() {
        this.mNoOfItemInCurrentLayer = 0;
        if (this.checkForEmptyModel()) {
            --this.mCurrentLayer;
        }
        this.mFirstPreviousClick = true;
        if (this.mCurrentLayer >= this.mNoOfLayers) {
            if (this.mNoOfLayers <= this.MAX_NO_OF_LAYERS - 1) {
                this.createLayer();
            } else {
                this.mNextButton.setEnabled(false);
            }
        } else {
            ++this.mCurrentLayer;
            if (this.mCurrentLayer > this.mNoOfLayers) {
                if (this.mNoOfLayers <= this.MAX_NO_OF_LAYERS - 1) {
                    this.createLayer();
                } else {
                    this.mNextButton.setEnabled(false);
                }
            } else {
                this.mPreviousButton.setEnabled(this.mCurrentLayer > 0);
                this.mNextButton.setEnabled(this.mNoOfLayers != this.mCurrentLayer || this.mNoOfLayers != this.MAX_NO_OF_LAYERS);
                this.mVarList.setModel(this.mArrayList.get(this.mCurrentLayer));
                this.setIndependentBorder();
            }
        }
    }

    private VarListModel findArrayList(VarListModel varListModel) {
        VarListModel varListModel2 = null;
        for (VarListModel varListModel3 : this.mArrayList) {
            if (varListModel3 != varListModel) continue;
            varListModel2 = varListModel3;
            break;
        }
        return varListModel2;
    }

    private void createLayer() {
        if (this.mCurrentLayer == 0) {
            this.mListModel = this.mVarList.getModel();
            if (this.mArrayList.size() == this.mCurrentLayer) {
                this.mArrayList.add(this.mCurrentLayer, this.mListModel);
            } else {
                this.mArrayList.set(this.mCurrentLayer, this.mListModel);
            }
            this.mListModel = new VarListModel(this.mVarList);
            this.mVarList.setModel(this.mListModel);
            this.mVarList.getModel().addListDataListener(this);
            if (this.mListListener != null) {
                this.mVarList.getModel().addListDataListener(this.mListListener);
            }
            ++this.mCurrentLayer;
            ++this.mNoOfLayers;
            this.mPreviousButton.setEnabled(true);
            this.canEnableNext();
            this.setIndependentBorder();
        } else {
            this.mListModel = this.mVarList.getModel();
            if (this.mArrayList.size() == this.mCurrentLayer + 1) {
                this.mArrayList.set(this.mCurrentLayer, this.mListModel);
            } else {
                this.mArrayList.add(this.mCurrentLayer, this.mListModel);
            }
            this.mListModel = new VarListModel(this.mVarList);
            this.mVarList.setModel(this.mListModel);
            this.mVarList.getModel().addListDataListener(this);
            if (this.mListListener != null) {
                this.mVarList.getModel().addListDataListener(this.mListListener);
            }
            ++this.mCurrentLayer;
            this.mPreviousButton.setEnabled(this.mCurrentLayer > 0);
            this.mNoOfLayers = this.mCurrentLayer;
            this.mNextButton.setEnabled((this.mVarList.getModel().getSize() > 0 || this.mNoOfLayers > this.mCurrentLayer) && this.mCurrentLayer < this.MAX_NO_OF_LAYERS);
            String string = this.mBorderTitle + (this.mCurrentLayer + 1) + ResUtil.getCommonDlgString("IDS_LAYER_WIDGET_INDEPENDENT_LAYER_TITLE2") + (this.mNoOfLayers + 1);
            this.mLayeredListPanel.setBorder(new TitledBorder(string));
            this.mIndependentListLabel.setText(string);
        }
    }

    private void setDefaults() {
        this.mPreviousButton.setEnabled(false);
        this.mNextButton.setEnabled(false);
    }

    private void canEnableNext() {
        this.mNextButton.setEnabled((this.mVarList.getModel().getSize() > 0 || this.mNoOfLayers > this.mCurrentLayer) && this.mArrayList.size() < this.MAX_NO_OF_LAYERS);
    }

    private boolean checkForEmptyModel() {
        if (this.mVarList.getModel().getSize() == 0) {
            if (this.mNoOfLayers != this.mCurrentLayer) {
                this.mArrayList.remove(this.mCurrentLayer);
            }
            if (this.mNoOfLayers < this.mArrayList.size()) {
                this.mArrayList.remove(this.mArrayList.size() - 1);
            }
            --this.mNoOfLayers;
            return true;
        }
        return false;
    }

    class LayeredVarMoveHandler
    implements IVarMoveHandler {
        LayeredVarMoveHandler() {
        }

        @Override
        public boolean preMoveVariables(ISpssVariable[] iSpssVariableArray, VariableList variableList) {
            if (LayeredListWidget.this.MAX_NO_OF_LAYERS != -1 && LayeredListWidget.this.MAX_NO_OF_ITEMS_IN_LAYER != -1 && LayeredListWidget.this.MAX_NO_OF_ITEMS_PER_LAYER != -1 && variableList.equals(LayeredListWidget.this.mVarList) && (iSpssVariableArray.length + LayeredListWidget.this.mVarList.getModel().getSize() > LayeredListWidget.this.MAX_NO_OF_ITEMS_PER_LAYER - 1 || iSpssVariableArray.length + LayeredListWidget.this.mVarList.getModel().getSize() > LayeredListWidget.this.MAX_NO_OF_ITEMS_IN_LAYER - 1)) {
                String string = String.format(ComponentState.getSPSSLocale(), ResUtil.getCommonDlgString("ERR_LIST_MAX_LIMIT_EXCEEDED_WARNING"), LayeredListWidget.this.MAX_NO_OF_ITEMS_PER_LAYER - 1);
                SpssAlertOptionPane.showInformationMessageDialog(LayeredListWidget.this.getRootPane(), string, VersionInfo.getAppVersionString());
                return false;
            }
            return true;
        }
    }
}

