/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.controls;

import com.spss.java_client.core.common.ComponentState;
import com.spss.java_client.ui.laf.SpssPlasticXPLookAndFeel;
import com.spss.java_client.ui.resources.IconTextResources;
import java.awt.Color;
import java.awt.Component;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JTable;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.table.TableCellRenderer;

public abstract class IconTextRenderer
extends JLabel
implements ListCellRenderer,
TableCellRenderer {
    private IconTextResources mResources;

    public IconTextRenderer(IconTextResources iconTextResources) {
        this.mResources = iconTextResources;
    }

    @Override
    public void setText(String string) {
        if (ComponentState.isBtdRtlOrLtr() && string != null && string.length() > 0) {
            super.setText(ComponentState.prepareStringForBidiRendering((String)string));
        } else {
            super.setText(string);
        }
    }

    private void prepRendererComponent(Component component, Object object, boolean bl, boolean bl2) {
        this.setText(this.mResources.getText(object));
        this.setIcon(this.mResources.getIcon(object));
        if (UIManager.getLookAndFeel() instanceof SpssPlasticXPLookAndFeel) {
            component.setBackground(Color.white);
        }
        this.setOpaque(true);
        this.setEnabled(component.isEnabled());
        this.setFont(component.getFont());
        if (bl) {
            if (component instanceof JTable) {
                this.setBackground(((JTable)component).getSelectionBackground());
                this.setForeground(((JTable)component).getSelectionForeground());
            } else if (component instanceof JList) {
                this.setBackground(((JList)component).getSelectionBackground());
                this.setForeground(((JList)component).getSelectionForeground());
            }
        } else if (component instanceof JTable) {
            this.setBackground(component.getBackground());
            this.setForeground(component.getForeground());
        } else {
            this.setBackground(component.getBackground());
            this.setForeground(component.getForeground());
        }
        Border border = null;
        if (bl2) {
            String string = component.getClass().getCanonicalName();
            if (string == null) {
                string = component.getName();
            }
            String string2 = string != null && string.toLowerCase().endsWith(".list") ? "List" : "Table";
            if (bl) {
                border = UIManager.getBorder(string2 + ".focusSelectedCellHighlightBorder");
            }
            if (border == null) {
                border = UIManager.getBorder(string2 + ".focusCellHighlightBorder");
            }
        } else {
            border = new EmptyBorder(1, 1, 1, 1);
        }
        this.setBorder(border);
    }

    public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
        this.prepRendererComponent(jList, object, bl, bl2);
        return this;
    }

    @Override
    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        this.prepRendererComponent(jTable, object, bl, bl2);
        return this;
    }

    public void updateTextResources() {
        this.mResources.updateTextResources();
    }
}

