/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.controls;

import com.spss.java_client.ui.controls.ArrowButton;
import com.spss.java_client.ui.controls.ExpressionBuilderDescArea;
import com.spss.java_client.ui.controls.FunctionList;
import com.spss.java_client.ui.controls.FunctionObject;
import com.spss.java_client.ui.controls.PlainList;
import com.spss.java_client.ui.controls.SpssArrowButton;
import com.spss.java_client.ui.controls.SrcVariableList;
import com.spss.java_client.ui.controls.TextHighlighter;
import com.spss.java_client.ui.dialogs.common.DialogDataModel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Comparator;
import java.util.Hashtable;
import java.util.List;
import java.util.TreeSet;
import java.util.Vector;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.JTextArea;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class FunctionListControls
implements ListSelectionListener,
ActionListener {
    private PlainList mFunctionGroupList;
    private PlainList mFunctionsList;
    private ArrowButton mFunctionArrow = new ArrowButton(SpssArrowButton.ButtonOrientation.up);
    private JTextArea mFunctionDescArea;
    private TextHighlighter mHighlightHelper;
    private SrcVariableList mSrcList;
    private JTextArea mExpressionArea;
    private String mFunctionListIdentifier = "IDS_FUNCTION_LIST_INDEX";
    private String mFunctionGroupIdentifier = "IDS_FUNCTION_GROUP_INDEX";
    private Comparator mSortComparator;
    private Vector<String> mSupportedFunctions = null;
    private Hashtable<Integer, Integer> mIndexMap = null;

    public FunctionListControls(boolean bl, boolean bl2) {
        this(bl, bl2, null, null);
    }

    public FunctionListControls(boolean bl, boolean bl2, Vector<Integer> vector, Vector<String> vector2) {
        ActionListener[] actionListenerArray;
        this.mFunctionArrow.setEnabled(false);
        this.mSupportedFunctions = vector2;
        if (vector != null) {
            this.setupIndexMap(vector);
        }
        this.mFunctionsList = new PlainList("FUNCTION_LIST");
        this.mFunctionsList.setModel(new DefaultListModel());
        this.mFunctionsList.addListSelectionListener(this);
        this.mFunctionsList.addMouseListener(new FunctionListDoubleClickHandler());
        this.mFunctionsList.setSelectionMode(0);
        if (bl) {
            this.mFunctionGroupList = new PlainList("FUNCTION_GROUP_LIST");
            this.mFunctionGroupList.setSelectionMode(1);
            this.mFunctionGroupList.setModel(FunctionList.getInstance().getFunctionGroupListModel(vector));
            this.mFunctionGroupList.addListSelectionListener(this);
        } else {
            this.mFunctionsList.setModel(FunctionList.getInstance().getFunctionsListModel());
        }
        if (bl2) {
            this.mFunctionDescArea = new ExpressionBuilderDescArea(6, 10);
        }
        for (ActionListener actionListener : actionListenerArray = this.mFunctionArrow.getActionListeners()) {
            this.mFunctionArrow.removeActionListener(actionListener);
        }
        this.mFunctionArrow.addActionListener(this);
        this.setComparator(new FunctionComparator());
    }

    public void setArrowButtonOrientation(SpssArrowButton.ButtonOrientation buttonOrientation) {
        this.mFunctionArrow.setArrowOrientation(buttonOrientation);
    }

    public void setSrcList(SrcVariableList srcVariableList) {
        this.mSrcList = srcVariableList;
    }

    public void setExpressionArea(JTextArea jTextArea) {
        this.mExpressionArea = jTextArea;
        this.mHighlightHelper = new TextHighlighter(jTextArea);
    }

    public JTextArea getFunctionDescArea() {
        return this.mFunctionDescArea;
    }

    public ArrowButton getFunctionArrow() {
        return this.mFunctionArrow;
    }

    public JList getFunctionList() {
        return this.mFunctionsList;
    }

    public JList getFunctionGroupList() {
        return this.mFunctionGroupList;
    }

    public void setFunctionListIdentifier(String string) {
        this.mFunctionListIdentifier = string;
    }

    public String getFunctionListIdentifier() {
        return this.mFunctionListIdentifier;
    }

    public void setFunctionGroupIdentifier(String string) {
        this.mFunctionGroupIdentifier = string;
    }

    public String getFunctionGroupIdentifier() {
        return this.mFunctionGroupIdentifier;
    }

    public void setComparator(Comparator comparator) {
        this.mSortComparator = comparator;
    }

    public Comparator getComparator() {
        return this.mSortComparator;
    }

    public void saveFunctionState(DialogDataModel dialogDataModel) {
        if (this.mFunctionGroupList != null) {
            dialogDataModel.putInteger(this.mFunctionGroupIdentifier, this.mFunctionGroupList.getSelectedIndex());
        }
        dialogDataModel.putInteger(this.mFunctionListIdentifier, this.mFunctionsList.getSelectedIndex());
    }

    public void loadFunctionState(DialogDataModel dialogDataModel) {
        Integer n = null;
        if (this.mFunctionGroupList != null && (n = dialogDataModel.getInteger(this.mFunctionGroupIdentifier)) != null) {
            this.mFunctionGroupList.setSelectedIndex(n);
        }
        if ((n = dialogDataModel.getInteger(this.mFunctionListIdentifier)) != null) {
            this.mFunctionsList.setSelectedIndex(n);
            this.mFunctionArrow.setEnabled(this.mFunctionsList.isEnabled());
        }
    }

    public void reset() {
        if (this.mFunctionGroupList == null) {
            this.mFunctionsList.clearSelection();
        } else {
            this.mFunctionGroupList.clearSelection();
            ((DefaultListModel)this.mFunctionsList.getModel()).clear();
        }
    }

    public void setFuctionGruouListEnabled(boolean bl) {
        this.mFunctionGroupList.setEnabled(bl);
    }

    public void setFunctionListEnabled(boolean bl) {
        if (bl) {
            if (this.mFunctionsList.getSelectedIndex() > -1) {
                this.mFunctionArrow.setEnabled(bl);
            }
        } else {
            this.mFunctionArrow.setEnabled(bl);
        }
        this.mFunctionsList.setEnabled(bl);
    }

    public void setFunctionDescAreaEnabled(boolean bl) {
        this.mFunctionDescArea.setEnabled(bl);
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        try {
            if (listSelectionEvent.getSource() == this.mFunctionGroupList) {
                int n = this.mFunctionGroupList.getSelectedIndex();
                if (n != -1) {
                    if (this.mIndexMap != null) {
                        n = this.mIndexMap.get(n);
                    }
                    this.updateFunctionListModel(n);
                }
                if (this.mFunctionDescArea != null) {
                    this.mFunctionDescArea.setText("");
                }
                this.mFunctionArrow.setEnabled(false);
            } else if (listSelectionEvent.getSource() == this.mFunctionsList) {
                FunctionObject functionObject = (FunctionObject)this.mFunctionsList.getSelectedValue();
                if (functionObject != null) {
                    if (this.mFunctionDescArea != null) {
                        this.mFunctionDescArea.setText(functionObject.getDesciption());
                        this.mFunctionDescArea.setCaretPosition(0);
                    }
                    this.mFunctionArrow.setEnabled(true);
                } else {
                    this.mFunctionArrow.setEnabled(false);
                    if (this.mFunctionDescArea != null) {
                        this.mFunctionDescArea.setText("");
                    }
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.mFunctionArrow) {
            int n = this.mExpressionArea.getCaretPosition();
            String string = this.mExpressionArea.getSelectedText();
            String string2 = ((FunctionObject)this.mFunctionsList.getSelectedValue()).getInsertString();
            StringBuffer stringBuffer = new StringBuffer(string2);
            int n2 = string2.indexOf(63);
            if (string != null && n2 != -1) {
                stringBuffer.replace(n2, n2 + 1, string);
            }
            int n3 = this.mExpressionArea.getSelectionStart();
            int n4 = this.mExpressionArea.getSelectionEnd();
            if (n == n4) {
                n = n3;
            }
            this.mHighlightHelper.resetHighlighting();
            this.mExpressionArea.replaceRange(stringBuffer.toString(), n3, n4);
            n2 = stringBuffer.toString().indexOf(63);
            this.mExpressionArea.select(n + n2, n + n2 + 1);
            if (n2 == -1) {
                this.mExpressionArea.setCaretPosition(this.mExpressionArea.getText().length());
            }
            this.mExpressionArea.requestFocus();
        }
    }

    public DefaultListModel updateFunctionListModel(int n) {
        DefaultListModel defaultListModel = (DefaultListModel)this.mFunctionsList.getModel();
        defaultListModel.clear();
        List<FunctionObject> list = FunctionList.getInstance().getFunctionList(n);
        TreeSet<FunctionObject> treeSet = new TreeSet<FunctionObject>(this.mSortComparator);
        for (FunctionObject functionObject : list) {
            treeSet.add(functionObject);
        }
        list.clear();
        for (FunctionObject functionObject : treeSet) {
            list.add(functionObject);
        }
        for (FunctionObject functionObject : list) {
            if (this.mSupportedFunctions != null) {
                if (!this.mSupportedFunctions.contains(functionObject.getName())) continue;
                defaultListModel.addElement(functionObject);
                continue;
            }
            defaultListModel.addElement(functionObject);
        }
        return defaultListModel;
    }

    private void setupIndexMap(Vector<Integer> vector) {
        this.mIndexMap = new Hashtable();
        for (int i = 0; i < vector.size(); ++i) {
            this.mIndexMap.put(i, vector.get(i));
        }
    }

    class FunctionComparator
    implements Comparator<FunctionObject> {
        FunctionComparator() {
        }

        @Override
        public int compare(FunctionObject functionObject, FunctionObject functionObject2) {
            String string = functionObject.getName();
            String string2 = functionObject2.getName();
            return string.compareTo(string2);
        }
    }

    class FunctionListDoubleClickHandler
    extends MouseAdapter {
        FunctionListDoubleClickHandler() {
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            if (mouseEvent.getSource() == FunctionListControls.this.mFunctionsList && FunctionListControls.this.mFunctionsList.isEnabled() && mouseEvent.getButton() == 1 && mouseEvent.getClickCount() == 2) {
                FunctionListControls.this.mFunctionArrow.doClick(0);
            }
        }
    }
}

