/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.controls;

import com.spss.java_client.core.common.ComponentState;
import com.spss.java_client.ui.controls.FunctionObject;
import com.spss.java_client.ui.resources.ResUtil;
import com.spss.uitools.util.IniHandler;
import com.spss.uitools.util.TraceSettings;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.Vector;
import javax.swing.DefaultListModel;

public class FunctionList {
    private static FunctionList sInstance;
    private static final String FUNCTION_HELP = "FunctionHelp";
    private HashMap<Integer, List<FunctionObject>> mFunctionMap;
    private List<String> mFunctionGroupList;
    private DefaultListModel mFunctionsListModel;
    private DefaultListModel mFunctionGroupListModel;
    private ArrayList<String> mGroupList;
    private TreeSet<String> mProfileSectionName;
    private Vector<Integer> mIndexToGroupId;

    private FunctionList() {
        this.init();
    }

    public static synchronized FunctionList getInstance() {
        if (sInstance == null) {
            sInstance = new FunctionList();
        }
        return sInstance;
    }

    public static void reset() {
        sInstance = null;
    }

    public List<String> getFunctionGroups() {
        return this.mFunctionGroupList;
    }

    public List<FunctionObject> getFunctionList(int n) {
        List<FunctionObject> list = null;
        try {
            if (n == 0) {
                list = new ArrayList<FunctionObject>();
                Set<Integer> set = this.mFunctionMap.keySet();
                for (Integer n2 : set) {
                    list.addAll((Collection<FunctionObject>)this.mFunctionMap.get(n2));
                }
            } else {
                list = this.mFunctionMap.get(this.mIndexToGroupId.get(n));
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DefaultListModel getFunctionsListModel() {
        if (this.mFunctionsListModel != null) {
            return this.mFunctionsListModel;
        }
        FunctionList functionList = this;
        synchronized (functionList) {
            if (this.mFunctionsListModel == null) {
                this.mFunctionsListModel = new DefaultListModel();
                try {
                    for (String string : this.mProfileSectionName) {
                        int n;
                        String string2 = string.toString();
                        String[] stringArray = string2.split("@");
                        String string3 = "";
                        String string4 = "";
                        String string5 = "";
                        if (stringArray.length > 2) {
                            string3 = stringArray[2];
                        }
                        if (stringArray.length > 3) {
                            string4 = stringArray[3];
                        }
                        if ((n = string4.indexOf(". ")) > -1) {
                            string5 = string4.substring(0, n);
                        }
                        this.mFunctionsListModel.addElement(new FunctionObject(string5, "", string3));
                    }
                }
                catch (Exception exception) {
                    TraceSettings.trace1((String)exception.getMessage(), (int)15);
                }
            }
        }
        return this.mFunctionsListModel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DefaultListModel getFunctionGroupListModel(Vector<Integer> vector) {
        if (this.mFunctionGroupListModel != null) {
            return this.mFunctionGroupListModel;
        }
        FunctionList functionList = this;
        synchronized (functionList) {
            if (this.mFunctionGroupListModel == null) {
                try {
                    this.mFunctionGroupListModel = new DefaultListModel();
                    for (int i = 0; i < this.mGroupList.size(); ++i) {
                        if (vector == null) {
                            this.mFunctionGroupListModel.addElement(this.mGroupList.get(this.mIndexToGroupId.get(i)));
                            continue;
                        }
                        if (!vector.contains(i)) continue;
                        this.mFunctionGroupListModel.addElement(this.mGroupList.get(this.mIndexToGroupId.get(i)));
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
        return this.mFunctionGroupListModel;
    }

    private void init() {
        try {
            IniHandler iniHandler;
            String string;
            File file;
            String string2 = System.getProperty("application.home");
            String string3 = ComponentState.getILangLocale().toString();
            if (!string3.startsWith("zh_")) {
                string3 = string3.substring(0, 2);
            }
            if (!(file = new File(string = string2 + File.separator + "lang" + File.separator + string3 + File.separator + "functions.ini")).exists()) {
                string3 = "en";
                string = string2 + File.separator + "lang" + File.separator + string3 + File.separator + "functions.ini";
            }
            if ((iniHandler = IniHandler.loadIniFile((String)string, (boolean)true, (String)"UTF-16")) == null) {
                return;
            }
            this.mProfileSectionName = iniHandler.getAllValues(FUNCTION_HELP);
            this.mGroupList = new ArrayList();
            this.mGroupList.add(0, ResUtil.getCommonDlgString("IDS_COMP_GROUP_ALL"));
            this.mGroupList.add(1, ResUtil.getCommonDlgString("IDS_COMP_GROUP_ARITH"));
            this.mGroupList.add(2, ResUtil.getCommonDlgString("IDS_COMP_GROUP_CDF"));
            this.mGroupList.add(3, ResUtil.getCommonDlgString("IDS_COMP_GROUP_CONVERT"));
            this.mGroupList.add(4, ResUtil.getCommonDlgString("IDS_COMP_GROUP_DATE_TIME"));
            this.mGroupList.add(5, ResUtil.getCommonDlgString("IDS_COMP_GROUP_DATE_ARITH"));
            this.mGroupList.add(6, ResUtil.getCommonDlgString("IDS_COMP_GROUP_DATE_CREATE"));
            this.mGroupList.add(7, ResUtil.getCommonDlgString("IDS_COMP_GROUP_DATE_EXTRACT"));
            this.mGroupList.add(8, ResUtil.getCommonDlgString("IDS_COMP_GROUP_INVERSE_DF"));
            this.mGroupList.add(9, ResUtil.getCommonDlgString("IDS_COMP_GROUP_MISC"));
            this.mGroupList.add(10, ResUtil.getCommonDlgString("IDS_COMP_GROUP_MISSING"));
            this.mGroupList.add(11, ResUtil.getCommonDlgString("IDS_COMP_GROUP_PDF"));
            this.mGroupList.add(12, ResUtil.getCommonDlgString("IDS_COMP_GROUP_RANDOM"));
            this.mGroupList.add(13, ResUtil.getCommonDlgString("IDS_COMP_GROUP_SEARCH"));
            this.mGroupList.add(14, ResUtil.getCommonDlgString("IDS_COMP_GROUP_SIG"));
            this.mGroupList.add(15, ResUtil.getCommonDlgString("IDS_COMP_GROUP_STATS"));
            this.mGroupList.add(16, ResUtil.getCommonDlgString("IDS_COMP_GROUP_STRING"));
            this.mGroupList.add(17, ResUtil.getCommonDlgString("IDS_COMP_GROUP_TIME_CREATE"));
            this.mGroupList.add(18, ResUtil.getCommonDlgString("IDS_COMP_GROUP_TIME_EXTRACT"));
            this.mIndexToGroupId = new Vector();
            for (int i = 0; i < this.mGroupList.size(); ++i) {
                this.mIndexToGroupId.add(i);
            }
            this.mGroupList.add(19, ResUtil.getCommonDlgString("IDS_COMP_GROUP_SERVER"));
            this.mIndexToGroupId.insertElementAt(19, 16);
            this.mFunctionGroupList = new ArrayList<String>();
            for (String object : this.mGroupList) {
                this.mFunctionGroupList.add(object);
            }
            this.mFunctionMap = new HashMap();
            for (int i = 0; i < this.mFunctionGroupList.size(); ++i) {
                ArrayList<FunctionObject> arrayList = new ArrayList<FunctionObject>();
                for (String string4 : this.mProfileSectionName) {
                    String string5 = string4.toString();
                    String[] stringArray = string5.split("@");
                    String string6 = stringArray[0];
                    if (Integer.parseInt(string6) != i) continue;
                    String string7 = "";
                    String string8 = "";
                    String string9 = "";
                    if (stringArray.length > 2) {
                        string7 = stringArray[2];
                    }
                    if (stringArray.length > 1) {
                        string8 = stringArray[1];
                    }
                    if (stringArray.length > 3) {
                        string9 = stringArray[3];
                    }
                    arrayList.add(this.createFunctionObject(string9, string8, string7));
                }
                this.mFunctionMap.put(i, arrayList);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private FunctionObject createFunctionObject(String string, String string2, String string3) {
        return new FunctionObject(string2, string, string3);
    }
}

