/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.controls;

import com.spss.java_client.core.common.ComponentState;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.UIManager;
import javax.swing.plaf.basic.BasicGraphicsUtils;

public class FocusableTextArea
extends JPanel {
    private JTextArea mInfoDesc;
    private JLabel mIconLabel;
    private String mImageToolTip;

    public FocusableTextArea(String string) {
        this(string, null, null);
    }

    public FocusableTextArea(String string, ImageIcon imageIcon) {
        this(string, imageIcon, null);
    }

    public FocusableTextArea(String string, ImageIcon imageIcon, String string2) {
        this.setLayout(new GridBagLayout());
        this.initLayout(string, imageIcon, string2);
        this.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
                FocusableTextArea.this.repaint();
            }

            @Override
            public void focusLost(FocusEvent focusEvent) {
                FocusableTextArea.this.repaint();
            }
        });
        this.setFocusable(true);
    }

    public Dimension doAutoSize() {
        Dimension dimension = this.getStringDimension(this, this.getText());
        this.setPreferredSize(dimension);
        return dimension;
    }

    private Dimension getStringDimension(JComponent jComponent, String string) {
        FontMetrics fontMetrics = jComponent.getFontMetrics(jComponent.getFont());
        String[] stringArray = string.split("\n");
        int n = 0;
        int n2 = 0;
        for (String string2 : stringArray) {
            n2 = fontMetrics.stringWidth(string2);
            n = n2 > n ? n2 : n;
        }
        return new Dimension(n + 10, fontMetrics.getHeight() * stringArray.length + 2);
    }

    protected void initLayout(String string, ImageIcon imageIcon, String string2) {
        this.mInfoDesc = new JTextArea();
        this.mInfoDesc.setOpaque(false);
        this.mInfoDesc.setLineWrap(true);
        this.mInfoDesc.setWrapStyleWord(true);
        this.mInfoDesc.setText("");
        this.mInfoDesc.setFocusable(false);
        this.mInfoDesc.setBorder(null);
        String string3 = this.mImageToolTip = imageIcon == null || string2 == null ? string2 : "";
        if (imageIcon != null) {
            this.mIconLabel = new JLabel(imageIcon);
            if (this.mImageToolTip != null) {
                this.mIconLabel.setToolTipText(this.mImageToolTip);
            }
        }
        this.setText(string);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        int n2 = DialogUtil.getGroupBoxInnerMargin();
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        Insets insets = new Insets(1, 1, 1, 1);
        int n3 = 0;
        if (this.mIconLabel != null) {
            DialogUtil.addUsingGBL(this, this.mIconLabel, gridBagConstraints, 0, 0, 1, 1, n, insets);
            ++n3;
        }
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        DialogUtil.addUsingGBL(this, this.mInfoDesc, gridBagConstraints, n3, 0, 1, 1, n, insets);
    }

    public void setText(String string) {
        if (ComponentState.isBtdRtlOrLtr() && string != null && string.length() > 0) {
            this.mInfoDesc.setText(ComponentState.prepareStringForBidiRendering((String)string));
        } else {
            this.mInfoDesc.setText(string);
        }
        Object object = this.mInfoDesc.getClientProperty("labeledBy");
        String string2 = "";
        if (object instanceof JLabel) {
            string2 = ComponentState.isBtdRtlOrLtr() && ((JLabel)object).getText() != null && ((JLabel)object).getText().length() > 0 ? ComponentState.removeBidiDirectionMarks((String)((JLabel)object).getText()) : ((JLabel)object).getText();
        }
        if (ComponentState.isBtdRtlOrLtr() && this.mInfoDesc.getText() != null && this.mInfoDesc.getText().length() > 0) {
            if (this.mImageToolTip != null) {
                this.getAccessibleContext().setAccessibleName(string2 + this.mImageToolTip + " " + ComponentState.removeBidiDirectionMarks((String)this.mInfoDesc.getText()));
            } else {
                this.getAccessibleContext().setAccessibleName(string2 + ComponentState.removeBidiDirectionMarks((String)this.mInfoDesc.getText()));
            }
        } else if (this.mImageToolTip != null) {
            this.getAccessibleContext().setAccessibleName(string2 + this.mImageToolTip + " " + this.mInfoDesc.getText());
        } else {
            this.getAccessibleContext().setAccessibleName(string2 + this.mInfoDesc.getText());
        }
    }

    public void setRows(int n) {
        this.mInfoDesc.setRows(n);
    }

    public String getText() {
        if (ComponentState.isBtdRtlOrLtr() && this.mInfoDesc.getText() != null && this.mInfoDesc.getText().length() > 0) {
            return ComponentState.removeBidiDirectionMarks((String)this.mInfoDesc.getText());
        }
        return this.mInfoDesc.getText();
    }

    @Override
    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        if (this.mInfoDesc != null) {
            this.mInfoDesc.setEnabled(bl);
        }
    }

    public void setLineWrap(boolean bl) {
        this.mInfoDesc.setLineWrap(bl);
    }

    public void setLabel(JLabel jLabel) {
        jLabel.setLabelFor(this.mInfoDesc);
    }

    @Override
    public void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        if (this.hasFocus()) {
            this.paintFocus(graphics);
        }
    }

    public void paintFocus(Graphics graphics) {
        Color color = UIManager.getColor("ToggleButton.focus");
        graphics.setColor(color);
        Rectangle rectangle = new Rectangle(0, 0, this.getBounds().width, this.getBounds().height);
        BasicGraphicsUtils.drawDashedRect(graphics, rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    @Override
    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleFocusableTextArea();
        }
        return this.accessibleContext;
    }

    protected class AccessibleFocusableTextArea
    extends JComponent.AccessibleJComponent {
        protected AccessibleFocusableTextArea() {
            super(FocusableTextArea.this);
        }

        @Override
        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.TEXT;
        }
    }
}

