/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.controls;

import com.spss.java_client.ui.controls.VariableList;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import java.awt.Container;
import java.awt.Insets;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.border.Border;

public class FocusHighlighter
extends FocusAdapter {
    protected static Border sTargetBorder;
    protected JComponent mComponent;
    protected boolean mHighlightBorder;
    protected Border mOriginalBorder;

    public FocusHighlighter(JComponent jComponent) {
        this.mComponent = jComponent;
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
        this.setHighlightBorder(true);
        if (this.mComponent instanceof VariableList) {
            ((VariableList)this.mComponent).updateVariableInfo(((JList)this.mComponent).getLeadSelectionIndex());
        }
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
        this.setHighlightBorder(false);
    }

    public void setHighlightBorder(boolean bl) {
        if (this.mHighlightBorder != bl) {
            Container container;
            JComponent jComponent = this.mComponent;
            Container container2 = container = this.mComponent.getParent() != null ? this.mComponent.getParent().getParent() : null;
            if (container instanceof JScrollPane) {
                jComponent = (JScrollPane)container;
            }
            this.mHighlightBorder = bl;
            if (this.mHighlightBorder && this.mOriginalBorder == null) {
                this.mOriginalBorder = jComponent.getBorder();
            }
            if (sTargetBorder == null) {
                this.buildHighlightBorder();
            }
            jComponent.setBorder(this.mHighlightBorder ? sTargetBorder : this.mOriginalBorder);
        }
    }

    protected void buildHighlightBorder() {
        Insets insets = new Insets(1, 1, 1, 1);
        if (this.mOriginalBorder != null) {
            insets = this.mOriginalBorder.getBorderInsets(this.mComponent);
        }
        Insets insets2 = (Insets)insets.clone();
        insets2.top = insets2.top > 0 ? insets2.top - 1 : insets2.top;
        insets2.left = insets2.left > 0 ? insets2.left - 1 : insets2.left;
        insets2.bottom = insets2.bottom > 0 ? insets2.bottom - 1 : insets2.bottom;
        int n = insets2.right = insets2.right > 0 ? insets2.right - 1 : insets2.right;
        if (insets2.top == 0 && insets2.left == 0 && insets2.bottom == 0 && insets2.right == 0) {
            sTargetBorder = BorderFactory.createLineBorder(DialogUtil.getFocusBorderColor(), insets.left);
        } else {
            Border border = BorderFactory.createLineBorder(DialogUtil.getFocusBorderColor(), 1);
            Border border2 = BorderFactory.createEmptyBorder(insets2.top, insets2.left, insets2.bottom, insets2.right);
            sTargetBorder = BorderFactory.createCompoundBorder(border, border2);
        }
    }
}

