/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.controls;

import com.spss.java_client.core.common.ComponentState;
import com.spss.java_client.ui.controls.FocusHighlighter;
import com.spss.uitools.controls.ContextEnabledTextArea;
import com.spss.uitools.controls.TextCompUndoManager;
import com.spss.uitools.controls.TextCompUndoManagerHolder;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.font.TextAttribute;
import java.text.Bidi;
import javax.swing.JComponent;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultCaret;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.undo.CompoundEdit;

public class ExpressionBuilderTextArea
extends ContextEnabledTextArea
implements TextCompUndoManagerHolder {
    private KeyListener processKeyEvent = new KeyListener(){

        @Override
        public void keyPressed(KeyEvent keyEvent) {
            String string = ExpressionBuilderTextArea.this.getText();
            int n = ExpressionBuilderTextArea.this.getCaretPosition();
            if (ExpressionBuilderTextArea.this.getDocument().getProperty(TextAttribute.RUN_DIRECTION) == TextAttribute.RUN_DIRECTION_RTL) {
                ExpressionBuilderTextArea.this.getDocument().putProperty(TextAttribute.RUN_DIRECTION, TextAttribute.RUN_DIRECTION_LTR);
            }
        }

        @Override
        public void keyTyped(KeyEvent keyEvent) {
        }

        @Override
        public void keyReleased(KeyEvent keyEvent) {
            String string = ExpressionBuilderTextArea.this.getText();
            int n = ExpressionBuilderTextArea.this.getCaretPosition();
            if (keyEvent.getKeyCode() != 17 && keyEvent.getKeyCode() != 16 && keyEvent.getKeyCode() != 37 && keyEvent.getKeyCode() != 39 && string != null && string.length() > 0 && ComponentState.containsBidiLetter((String)string)) {
                string = ExpressionBuilderTextArea.prepareTextForBidiDisplay(string);
                ExpressionBuilderTextArea.this.selectAll();
                ExpressionBuilderTextArea.this.replaceSelection(string);
            }
        }
    };
    private FocusHighlighter mFocusHighlighter = new FocusHighlighter((JComponent)((Object)this));
    private TextCompUndoManager mUndoManager = new TextCompUndoManager((JTextComponent)((Object)this));

    public ExpressionBuilderTextArea() {
        this(null, null, 0, 0);
    }

    public ExpressionBuilderTextArea(int n, int n2) {
        this(null, null, n, n2);
    }

    public ExpressionBuilderTextArea(Document document, String string, int n, int n2) {
        super(document, string, n, n2, ComponentState.getCurrentCharset());
        super.setPermBTDVal(2);
        this.init();
        this.getDocument().addUndoableEditListener((UndoableEditListener)this.mUndoManager);
        this.setCaret(new VerticalBarCaret());
        this.registerKeyListener();
    }

    public void setDocument(Document document) {
        super.setDocument(document);
        this.getDocument().addUndoableEditListener((UndoableEditListener)this.mUndoManager);
    }

    public void replaceSelection(String string) {
        String string2 = this.getSelectedText();
        if (string2 != null && string2.length() > 0 && string != null && string.length() > 0) {
            Document document = this.getDocument();
            document.removeUndoableEditListener((UndoableEditListener)this.mUndoManager);
            final CompoundEdit compoundEdit = new CompoundEdit();
            document.addUndoableEditListener(new UndoableEditListener(){

                @Override
                public void undoableEditHappened(UndoableEditEvent undoableEditEvent) {
                    compoundEdit.addEdit(undoableEditEvent.getEdit());
                }
            });
            super.replaceSelection(string);
            compoundEdit.end();
            this.mUndoManager.startStopCurrentAddNewEdit(compoundEdit);
            document.addUndoableEditListener((UndoableEditListener)this.mUndoManager);
        } else {
            if (string != null && string.length() > 1 && ComponentState.containsBidiLetter((String)string)) {
                string = ExpressionBuilderTextArea.prepareTextForBidiDisplay(string);
            }
            super.replaceSelection(string);
        }
    }

    public static String prepareTextForBidiDisplay(String string) {
        if (string == null || string.length() == 0 || !ComponentState.containsBidiLetter((String)string)) {
            return string;
        }
        String string2 = new String();
        if (ComponentState.containsBidiDirectionMarks((String)string)) {
            String string3;
            string = string3 = ComponentState.removeBidiDirectionMarks((String)string);
        }
        int n = -1;
        int n2 = string.indexOf(92, 0);
        for (int i = 0; i < string.length(); ++i) {
            int n3;
            int n4 = -1;
            if (n2 != -1) {
                n4 = string.indexOf(92, i);
            }
            int n5 = string.indexOf(92, i);
            if (n4 != -1 && n4 < n5) {
                String string4 = ComponentState.preparePathForBidiDisplay((String)string.substring(i, n5));
                string2 = string2 + string4 + "\n";
                i = n5 + 1;
                continue;
            }
            if (new Bidi(Character.toString(string.charAt(i)), 1).isRightToLeft() && (Character.isLetter(string.charAt(i)) || string.charAt(i) == '\u05b9')) {
                int n6;
                int n7 = -1;
                n3 = -1;
                for (n6 = i - 1; n6 >= 0; --n6) {
                    if (Character.isLetterOrDigit(string.charAt(n6)) || string.charAt(n6) == '\u05b9' || string.charAt(n6) == '_') continue;
                    n7 = n6 + 1;
                    break;
                }
                if (n6 < 0) {
                    n7 = 0;
                }
                if (i + 1 >= string.length()) {
                    n3 = i;
                } else {
                    for (n6 = i + 1; n6 < string.length(); ++n6) {
                        if (Character.isLetterOrDigit(string.charAt(n6)) || string.charAt(n6) == '\u05b9' || string.charAt(n6) == '_') continue;
                        n3 = n6 - 1;
                        break;
                    }
                    if (n6 >= string.length()) {
                        n3 = string.length() - 1;
                    }
                }
                string2 = n > 0 ? string2 + string.substring(n + 1, n7) : string.substring(0, n7);
                string2 = ComponentState.getBTD() == 1 || ComponentState.getBTD() == 0 && (ComponentState.isBidiLetter((char)string.charAt(n7)) || string.charAt(n7) == '\u05b9') ? string2 + '\u200e' + '\u202b' + string.substring(n7, n3 + 1) + '\u202c' : string2 + '\u200e' + '\u202a' + string.substring(n7, n3 + 1) + '\u202c';
                n = n3;
                i = n3;
                n3 = -1;
                n7 = -1;
                continue;
            }
            if (!Character.isDigit(string.charAt(i)) || i <= 0) continue;
            int n8 = i;
            for (n3 = i + 1; n3 < string.length() && Character.isDigit(string.charAt(n3)); ++n3) {
            }
            string2 = n > 0 ? string2 + string.substring(n + 1, n8) : string.substring(0, n8);
            string2 = n3 > i + 1 ? string2 + '\u200e' + '\u202a' + string.substring(n8, n3) + '\u202c' : string2 + '\u200e' + '\u202a' + string.charAt(i) + '\u202c';
            n = n3 - 1;
            i = n3;
            n3 = -1;
            n8 = -1;
        }
        if (n > -1 && n < string.length() - 1) {
            string2 = string2 + string.substring(n + 1);
        }
        if (string2.length() == 0) {
            string2 = string;
        }
        return string2;
    }

    public String getText() {
        String string = super.getText();
        if (ComponentState.isBtdRtlOrLtr() || string != null && string.length() > 0 && ComponentState.containsBidiLetter((String)string)) {
            string = ComponentState.removeBidiDirectionMarks((String)string);
        }
        return string;
    }

    public void setText(String string) {
        if (ComponentState.isBtdRtlOrLtr() || string != null && string.length() > 0 && ComponentState.containsBidiLetter((String)string)) {
            string = ExpressionBuilderTextArea.prepareTextForBidiDisplay(string);
        }
        super.setText(string);
    }

    private void registerKeyListener() {
        this.addKeyListener(this.processKeyEvent);
    }

    public void updateUI() {
        this.removeFocusListener(this.mFocusHighlighter);
        super.updateUI();
        this.addFocusListener(this.mFocusHighlighter);
    }

    public FocusHighlighter getFocusHighlighter() {
        return this.mFocusHighlighter;
    }

    public TextCompUndoManager getUndoManger() {
        return this.mUndoManager;
    }

    private void init() {
        this.updateUI();
    }

    class VerticalBarCaret
    extends DefaultCaret {
        private boolean mWasFocussed = false;

        public VerticalBarCaret() {
            this.setUpdatePolicy(2);
            this.setBlinkRate(500);
        }

        @Override
        public void paint(Graphics graphics) {
            Rectangle rectangle;
            JTextComponent jTextComponent = this.getComponent();
            if (jTextComponent == null) {
                return;
            }
            try {
                rectangle = jTextComponent.modelToView(this.getDot());
                if (rectangle == null) {
                    return;
                }
            }
            catch (BadLocationException badLocationException) {
                return;
            }
            if (this.x != rectangle.x || this.y != rectangle.y) {
                this.x = rectangle.x;
                this.y = rectangle.y;
                this.height = rectangle.height;
                this.damage(rectangle);
            }
            if (!this.isActive() && this.mWasFocussed) {
                graphics.setColor(jTextComponent.getCaretColor());
                this.width = 1;
                if (!this.isVisible()) {
                    graphics.fillRect(rectangle.x, rectangle.y, this.width, rectangle.height);
                }
            } else {
                super.paint(graphics);
            }
        }

        @Override
        public void focusGained(FocusEvent focusEvent) {
            this.mWasFocussed = true;
            super.focusGained(focusEvent);
        }

        @Override
        public boolean isSelectionVisible() {
            return ExpressionBuilderTextArea.this.isEnabled();
        }
    }
}

