/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.controls;

import com.spss.java_client.core.documents.data.dictionary.ISpssVariable;
import com.spss.java_client.ui.controls.ComponentsArrowButton;
import com.spss.java_client.ui.controls.SpssArrowButton;
import com.spss.java_client.ui.dialogs.pro_stats.nonlinear_reg.RegressionParam;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.text.JTextComponent;

public class ExpressionAreaArrowButton
extends ComponentsArrowButton
implements CaretListener {
    public ExpressionAreaArrowButton() {
    }

    public ExpressionAreaArrowButton(SpssArrowButton.ButtonOrientation buttonOrientation) {
        super(buttonOrientation);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        super.actionPerformed(actionEvent);
        JComponent jComponent = this.getSrcHolderComponent();
        JComponent jComponent2 = this.getTargetHolderComponent();
        if (jComponent instanceof JList && jComponent2 instanceof JTextComponent) {
            JList jList = (JList)jComponent;
            JTextComponent jTextComponent = (JTextComponent)jComponent2;
            Object e = jList.getSelectedValue();
            this.insertTextIntoTargetArea(jTextComponent, e);
        } else if (jComponent instanceof JTextComponent && jComponent2 instanceof JList) {
            JTextComponent jTextComponent = (JTextComponent)jComponent;
            jTextComponent.replaceSelection("");
        }
    }

    @Override
    public void caretUpdate(CaretEvent caretEvent) {
        Object object = caretEvent.getSource();
        if (object instanceof JTextComponent && object == this.getSrcHolderComponent()) {
            this.updateEnable(this.getSourceVarHolder());
        }
    }

    @Override
    public boolean registerComponents(JComponent jComponent, SpssArrowButton.ButtonOrientation buttonOrientation) {
        boolean bl = super.registerComponents(jComponent, buttonOrientation);
        if (bl) {
            if (jComponent instanceof JTextComponent) {
                ((JTextComponent)jComponent).addCaretListener(this);
            } else if (jComponent instanceof JList) {
                ((JList)jComponent).addFocusListener(this);
                this.updateEnable(this.getSourceVarHolder());
            }
        }
        return bl;
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
        SpssArrowButton.SrcDestHolder srcDestHolder;
        if (!focusEvent.isTemporary() && (srcDestHolder = this.getHolder(focusEvent.getComponent())) != null && !this.getArrowOrientation().equals((Object)srcDestHolder.mArrowOrient)) {
            this.setArrowOrientation(srcDestHolder.mArrowOrient);
        }
    }

    @Override
    public void unRegisterVariableList(JComponent jComponent) {
        super.unRegisterVariableList(jComponent);
    }

    public void insertTextIntoTargetArea(JTextComponent jTextComponent, Object object) {
        if (object instanceof ISpssVariable) {
            ISpssVariable iSpssVariable = (ISpssVariable)object;
            jTextComponent.getHighlighter().removeAllHighlights();
            jTextComponent.replaceSelection(iSpssVariable.getName());
            jTextComponent.requestFocus();
        } else if (object instanceof RegressionParam) {
            RegressionParam regressionParam = (RegressionParam)object;
            jTextComponent.getHighlighter().removeAllHighlights();
            jTextComponent.replaceSelection(regressionParam.getParamName());
            jTextComponent.requestFocus();
        }
    }

    @Override
    protected void updateEnable(SpssArrowButton.SrcDestHolder srcDestHolder) {
        if (srcDestHolder == null) {
            return;
        }
        Component component = srcDestHolder.getComponent();
        boolean bl = false;
        if (component instanceof JList) {
            JList jList = (JList)component;
            Object[] objectArray = jList.getSelectedValues();
            bl = objectArray.length == 1;
        } else if (component instanceof JTextComponent) {
            String string = ((JTextComponent)component).getSelectedText();
            bl = string != null && string.length() > 0;
        }
        this.setEnabled(bl);
    }
}

