/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.controls;

import com.spss.java_client.ui.controls.BaseDataList;
import com.spss.java_client.ui.controls.IEditableListModel;
import com.spss.java_client.ui.controls.IListCellEditor;
import java.awt.Component;
import java.awt.KeyboardFocusManager;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.EventObject;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import javax.swing.ListModel;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.text.JTextComponent;

public class EditableList
extends BaseDataList
implements CellEditorListener {
    protected IListCellEditor editor = null;
    protected Component editorComp = null;
    private PropertyChangeListener cellEditorRemover = null;
    protected int editingIndex = -1;

    public EditableList(ListModel listModel) {
        super(listModel);
        this.init();
    }

    public EditableList(Object[] objectArray) {
        super(objectArray);
        this.init();
    }

    public EditableList(Vector<?> vector) {
        super(vector);
        this.init();
    }

    public EditableList() {
        this.init();
    }

    private void init() {
        this.getActionMap().put("startEditing", new StartEditingAction());
        this.getActionMap().put("cancel", new CancelEditingAction());
        this.addMouseListener(new MouseListener());
        this.getInputMap().put(KeyStroke.getKeyStroke(113, 0), "startEditing");
        this.getInputMap(1).put(KeyStroke.getKeyStroke(27, 0), "cancel");
        this.putClientProperty("terminateEditOnFocusLost", Boolean.TRUE);
    }

    public IListCellEditor getListCellEditor() {
        return this.editor;
    }

    public void setListCellEditor(IListCellEditor iListCellEditor) {
        this.editor = iListCellEditor;
    }

    public Component getEditorComponent() {
        return this.editorComp;
    }

    public boolean isEditing() {
        return this.editorComp != null;
    }

    public int getEditingIndex() {
        return this.editingIndex;
    }

    public void removeEditor() {
        KeyboardFocusManager.getCurrentKeyboardFocusManager().removePropertyChangeListener("permanentFocusOwner", this.cellEditorRemover);
        this.cellEditorRemover = null;
        if (this.editor != null) {
            this.editor.removeCellEditorListener(this);
            if (this.editorComp != null) {
                this.remove(this.editorComp);
            }
            this.editorComp = null;
            if (this.editingIndex != -1) {
                Rectangle rectangle = this.getCellBounds(this.editingIndex, this.editingIndex);
                this.editingIndex = -1;
                this.repaint(rectangle);
            }
        }
    }

    public Component prepareEditor(int n) {
        JComponent jComponent;
        boolean bl;
        Object e = this.getModel().getElementAt(n);
        Component component = this.editor.getListCellEditorComponent(this, e, bl = this.isSelectedIndex(n), n);
        if (component instanceof JComponent && (jComponent = (JComponent)component).getNextFocusableComponent() == null) {
            jComponent.setNextFocusableComponent(this);
        }
        return component;
    }

    public boolean editCellAt(int n, EventObject eventObject) {
        boolean bl = false;
        if (this.editor != null && !this.editor.stopCellEditing()) {
            return bl;
        }
        if (n < 0 || n >= this.getModel().getSize()) {
            return bl;
        }
        if (!this.isCellEditable(n)) {
            return bl;
        }
        if (this.cellEditorRemover == null) {
            KeyboardFocusManager keyboardFocusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
            this.cellEditorRemover = new CellEditorRemover(keyboardFocusManager);
            keyboardFocusManager.addPropertyChangeListener("permanentFocusOwner", this.cellEditorRemover);
        }
        if (this.editor != null && this.editor.isCellEditable(eventObject)) {
            this.editorComp = this.prepareEditor(n);
            if (this.editorComp == null) {
                this.removeEditor();
            } else {
                this.editorComp.setBounds(this.getCellBounds(n, n));
                this.add(this.editorComp);
                this.editorComp.validate();
                this.editingIndex = n;
                this.editor.addCellEditorListener(this);
                bl = true;
            }
        }
        return bl;
    }

    @Override
    public void removeNotify() {
        KeyboardFocusManager.getCurrentKeyboardFocusManager().removePropertyChangeListener("permanentFocusOwner", this.cellEditorRemover);
        super.removeNotify();
    }

    @Override
    public void editingCanceled(ChangeEvent changeEvent) {
        this.removeEditor();
    }

    @Override
    public void editingStopped(ChangeEvent changeEvent) {
        if (this.editor != null) {
            Object object = this.editor.getCellEditorValue();
            this.setValueAt(object, this.editingIndex);
            this.removeEditor();
        }
    }

    public boolean isCellEditable(int n) {
        return this.getModel() instanceof IEditableListModel && ((IEditableListModel)this.getModel()).isCellEditable(n);
    }

    public void setValueAt(Object object, int n) {
        ((IEditableListModel)this.getModel()).setValueAt(object, n);
    }

    private class CancelEditingAction
    extends AbstractAction {
        private CancelEditingAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            EditableList editableList = (EditableList)actionEvent.getSource();
            editableList.removeEditor();
        }

        @Override
        public boolean isEnabled() {
            return EditableList.this.isEditing();
        }
    }

    private static class StartEditingAction
    extends AbstractAction {
        private StartEditingAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            EditableList editableList = (EditableList)actionEvent.getSource();
            if (!editableList.hasFocus()) {
                IListCellEditor iListCellEditor = editableList.getListCellEditor();
                if (iListCellEditor != null && !iListCellEditor.stopCellEditing()) {
                    return;
                }
                editableList.requestFocusInWindow();
                return;
            }
            ListSelectionModel listSelectionModel = editableList.getSelectionModel();
            int n = listSelectionModel.getLeadSelectionIndex();
            editableList.editCellAt(n, null);
            Component component = editableList.getEditorComponent();
            if (component instanceof JTextComponent) {
                ((JTextComponent)component).selectAll();
            }
            if (component != null) {
                component.requestFocusInWindow();
            }
        }
    }

    class CellEditorRemover
    implements PropertyChangeListener {
        KeyboardFocusManager focusManager;

        public CellEditorRemover(KeyboardFocusManager keyboardFocusManager) {
            this.focusManager = keyboardFocusManager;
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (EditableList.this.isEditing() && EditableList.this.getClientProperty("terminateEditOnFocusLost") == Boolean.TRUE) {
                for (Component component = this.focusManager.getPermanentFocusOwner(); component != null; component = component.getParent()) {
                    if (component == EditableList.this) {
                        if (propertyChangeEvent.getNewValue() == EditableList.this) {
                            if (EditableList.this.isEditing() && !EditableList.this.getListCellEditor().stopCellEditing()) {
                                EditableList.this.getListCellEditor().cancelCellEditing();
                            }
                            EditableList.this.setSelectedIndex(EditableList.this.getEditingIndex());
                        }
                        return;
                    }
                    if (!(component instanceof Window)) continue;
                    if (component != SwingUtilities.getRoot(EditableList.this) || EditableList.this.getListCellEditor().stopCellEditing()) break;
                    EditableList.this.getListCellEditor().cancelCellEditing();
                    break;
                }
            }
        }
    }

    private class MouseListener
    extends MouseAdapter {
        private MouseListener() {
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            if (EditableList.this.isEnabled() && mouseEvent.getButton() == 1 && mouseEvent.getClickCount() == 2) {
                mouseEvent.consume();
                ListSelectionModel listSelectionModel = EditableList.this.getSelectionModel();
                int n = listSelectionModel.getLeadSelectionIndex();
                if (n != -1) {
                    try {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                KeyEvent keyEvent = new KeyEvent(EditableList.this, 401, System.currentTimeMillis(), 0, 113, 'q', 1);
                                EditableList.this.dispatchEvent(keyEvent);
                            }
                        });
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
            }
        }
    }
}

