/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.controls;

import com.spss.java_client.core.documents.data.dictionary.FormatType;
import com.spss.java_client.core.documents.data.dictionary.OBS;
import com.spss.java_client.core.documents.data.dictionary.SPSS_Format;
import com.spss.java_client.ui.resources.ResUtil;
import com.spss.shared.core_tools.format.CellValueFormatter;
import com.spss.shared.core_tools.format.DlgEditFieldFormatter;
import com.spss.shared.core_tools.format.ValueFormatter;
import com.spss.shared.core_tools.system.OSInfo;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import javax.swing.AbstractAction;
import javax.swing.JFormattedTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.text.DefaultFormatterFactory;
import javax.swing.text.Document;
import javax.swing.text.InternationalFormatter;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoManager;

public class DlgEditField
extends JFormattedTextField
implements DocumentListener {
    private static final String SYSMIS_STRING = ResUtil.getComponentString("IDS_MISSING_OBS");
    private static final double DATE_MINIMUM = 86400.0;
    private double mSysmisDouble = -1.7976931348623157E308;
    protected SPSS_Format mSpssFormat = null;
    protected InternationalFormatter mFormatter = new InternationalFormatter();
    protected DlgEditFieldFormatter mDlgEditFieldFormat = new DlgEditFieldFormatter();
    protected UndoManager undoManager;
    protected int mMaxStringWidth = -1;
    protected Object mOldValue = null;

    public DlgEditField() {
        this((SPSS_Format)null);
    }

    public DlgEditField(SPSS_Format sPSS_Format) {
        String string;
        this.setFormatterFactory(new TextFieldFormatterFactory());
        this.setFormat(sPSS_Format);
        this.getDocument().addDocumentListener(this);
        this.setupUndo();
        if (OSInfo.getOSType() == OSInfo.OSType.MAC && ((string = System.getProperty("java.version")).equals("1.5.0_24") || string.equals("1.6.0_20"))) {
            this.getInputMap().put(KeyStroke.getKeyStroke(8, 0), "none");
        }
    }

    protected void setupUndo() {
        this.undoManager = new UndoManager();
        Document document = this.getDocument();
        document.addUndoableEditListener(new UndoableEditListener(){

            @Override
            public void undoableEditHappened(UndoableEditEvent undoableEditEvent) {
                DlgEditField.this.undoManager.addEdit(undoableEditEvent.getEdit());
            }
        });
        this.getActionMap().put("Undo", new AbstractAction("Undo"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    if (DlgEditField.this.undoManager.canUndo()) {
                        DlgEditField.this.undoManager.undo();
                    }
                }
                catch (CannotUndoException cannotUndoException) {
                    // empty catch block
                }
            }
        });
        this.getInputMap(0).put(KeyStroke.getKeyStroke("control Z"), "Undo");
        this.getActionMap().put("Redo", new AbstractAction("Redo"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    if (DlgEditField.this.undoManager.canRedo()) {
                        DlgEditField.this.undoManager.redo();
                    }
                }
                catch (CannotRedoException cannotRedoException) {
                    // empty catch block
                }
            }
        });
        this.getInputMap(0).put(KeyStroke.getKeyStroke("control Y"), "Redo");
    }

    public void clearUndoStack() {
        if (this.undoManager != null) {
            this.undoManager.discardAllEdits();
        }
    }

    public void setFormat(SPSS_Format sPSS_Format) {
        int n = this.mMaxStringWidth = sPSS_Format != null && sPSS_Format.getFormatType().isStringFormat() ? (int)sPSS_Format.getWidth() : -1;
        if (sPSS_Format == null) {
            this.mSpssFormat = new SPSS_Format();
            this.buildFormatter();
        } else if (this.mSpssFormat != null && !this.mSpssFormat.equals((Object)sPSS_Format)) {
            this.mSpssFormat = sPSS_Format;
            this.buildFormatter();
        }
    }

    public SPSS_Format getFormat() {
        return this.mSpssFormat;
    }

    public String getUnformattedText() {
        return super.getText();
    }

    public String getText(boolean bl) {
        String string;
        try {
            String string2 = this.getUnformattedText();
            if (string2.length() == 0) {
                return "";
            }
            string = this.getText();
            if (bl && string.length() == 0 && string2 != null && string2.length() > 0) {
                string = null;
            }
        }
        catch (NullPointerException nullPointerException) {
            string = bl ? null : "";
        }
        return string;
    }

    @Override
    public String getText() {
        String string;
        try {
            string = this.getUnformattedText();
        }
        catch (NullPointerException nullPointerException) {
            string = "";
        }
        if (string == null || string.length() == 0) {
            string = "";
        } else {
            OBS oBS = new OBS();
            if (CellValueFormatter.stringToObs((String)string, (SPSS_Format)this.mSpssFormat, (OBS)oBS)) {
                string = CellValueFormatter.obsToString((OBS)oBS, (SPSS_Format)this.mSpssFormat);
                if (string == null || string.length() == 0) {
                    string = "";
                }
            } else {
                string = "";
            }
        }
        this.mOldValue = string;
        return string;
    }

    public boolean isFormattedCorrectly() {
        boolean bl = true;
        if (this.getText(true) == null) {
            bl = false;
        }
        return bl;
    }

    public void setMaxStringWidth(int n) {
        this.mMaxStringWidth = n;
    }

    public int getMaxStringWidth() {
        return this.mMaxStringWidth;
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        this.checkStringLength();
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        this.checkStringLength();
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
        this.checkStringLength();
    }

    private void checkStringLength() {
        if (this.mMaxStringWidth > -1) {
            String string;
            String string2 = string = this.mOldValue == null ? "" : this.mOldValue.toString();
            if (this.getText().length() > this.mMaxStringWidth) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        Toolkit.getDefaultToolkit().beep();
                        if (DlgEditField.this.mOldValue instanceof String) {
                            int n = DlgEditField.this.getSelectionStart() - 1 < 0 ? 0 : DlgEditField.this.getSelectionStart() - 1;
                            DlgEditField.this.getDocument().removeDocumentListener(DlgEditField.this);
                            int n2 = Math.min(string.length(), DlgEditField.this.mMaxStringWidth);
                            DlgEditField.this.setText(string.substring(0, n2));
                            DlgEditField.this.getDocument().addDocumentListener(DlgEditField.this);
                            DlgEditField.this.select(n, n);
                            DlgEditField.this.mOldValue = string;
                        }
                    }
                });
            }
        }
    }

    protected void buildFormatter() {
        this.mFormatter.setFormat(this.mDlgEditFieldFormat.buildFormatter(this.mSpssFormat));
    }

    private boolean convertToOBS(Object object, OBS oBS, SPSS_Format sPSS_Format) {
        boolean bl = true;
        boolean bl2 = object instanceof Double;
        try {
            if (object == null || object.toString().length() == 0 || bl2 && object.toString().equals(SYSMIS_STRING)) {
                if (bl2) {
                    oBS.set(new OBS(this.mSysmisDouble));
                } else {
                    oBS.set(new OBS(""));
                }
            } else if (bl2) {
                if (object instanceof Date) {
                    Date date = (Date)object;
                    FormatType formatType = sPSS_Format.getFormatType();
                    if (formatType == FormatType.WKDAY) {
                        Calendar calendar = Calendar.getInstance(TimeZone.getTimeZone("GMT-00:00"));
                        calendar.setTime(date);
                        oBS.set(new OBS((double)calendar.get(7)));
                    } else if (formatType == FormatType.MONTH) {
                        Calendar calendar = Calendar.getInstance(TimeZone.getTimeZone("GMT-00:00"));
                        calendar.setTime(date);
                        oBS.set(new OBS((double)(calendar.get(2) + 1)));
                    } else {
                        long l = date.getTime();
                        double d = ValueFormatter.convertJavaDateLongToDouble((long)l);
                        if (!this.legalDateValue(d, sPSS_Format)) {
                            bl = false;
                        } else {
                            oBS.set(new OBS(d));
                        }
                    }
                } else {
                    bl = CellValueFormatter.stringToObs((String)object.toString(), (SPSS_Format)sPSS_Format, (OBS)oBS);
                }
            } else {
                oBS.set(new OBS(object.toString()));
            }
        }
        catch (NumberFormatException numberFormatException) {
            oBS.set(new OBS(this.mSysmisDouble));
        }
        if (!bl) {
            Toolkit.getDefaultToolkit().beep();
        }
        return bl;
    }

    private boolean legalDateValue(double d, SPSS_Format sPSS_Format) {
        if (sPSS_Format == null) {
            return false;
        }
        FormatType formatType = sPSS_Format.getFormatType();
        boolean bl = formatType == FormatType.TIME || formatType == FormatType.MTIME || formatType == FormatType.DTIME || formatType == FormatType.WKDAY || formatType == FormatType.MONTH;
        double d2 = bl ? 0.0 : 86400.0;
        return d == this.mSysmisDouble || d >= d2;
    }

    public class TextFieldFormatterFactory
    extends DefaultFormatterFactory {
        @Override
        public JFormattedTextField.AbstractFormatter getFormatter(JFormattedTextField jFormattedTextField) {
            if (DlgEditField.this.mFormatter != null) {
                return DlgEditField.this.mFormatter;
            }
            return super.getFormatter(jFormattedTextField);
        }
    }
}

