/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.controls;

import com.spss.java_client.core.common.LocallyUniqueId;
import com.spss.java_client.core.documents.data.DataMgr;
import com.spss.java_client.core.documents.data.dictionary.ISpssDataSrc;
import com.spss.java_client.core.documents.data.dictionary.ISpssVariable;
import com.spss.java_client.core.documents.data.dictionary.ITrendsInfo;
import com.spss.java_client.ui.controls.SrcVariableList;
import com.spss.java_client.ui.controls.VarListModel;
import com.spss.java_client.ui.dialogs.common.DialogDataModel;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.res.CommonDlgResBundle;
import com.spss.java_client.ui.resources.ResUtil;
import com.spss.uitools.controls.IntTextField;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;

public final class DateFactory {
    private static final String PERIOD = "period";
    private static final String NOT_PERIODIC = "not periodic";
    private static HashMap<String, String> sDateMap;
    private static Vector<String> sOrderedDateTypes;
    private static EnumMap<ITrendsInfo.DateVarTypes, String> sSyntaxDateMap;
    private static Hashtable<String, ITrendsInfo.DateVarTypes> sDateAndTypeMap;
    private static ResourceBundle sResourceBundle;

    private DateFactory() {
    }

    public static List<String> getDateVariableNames(SrcVariableList srcVariableList) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string : sOrderedDateTypes) {
            ISpssVariable iSpssVariable = DateFactory.getVarListVar(srcVariableList, string);
            if (iSpssVariable == null) continue;
            arrayList.add(iSpssVariable.getName());
        }
        return arrayList;
    }

    public static List<String> getDateVariableLabels(SrcVariableList srcVariableList) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string : sOrderedDateTypes) {
            if (!DateFactory.varListContains(srcVariableList, string)) continue;
            arrayList.add(ResUtil.getString(sResourceBundle, sDateMap.get(string)));
        }
        if (arrayList.size() == 0) {
            arrayList.add(ResUtil.getString(sResourceBundle, "IDS_OBSERVATIONS"));
        }
        return arrayList;
    }

    public static List<String> getDateSyntaxString(SrcVariableList srcVariableList) {
        ArrayList<String> arrayList = new ArrayList<String>();
        Object object = sOrderedDateTypes.iterator();
        while (object.hasNext()) {
            String string;
            ITrendsInfo.DateVarTypes dateVarTypes;
            String string2 = object.next();
            if (!DateFactory.varListContains(srcVariableList, string2) || (dateVarTypes = sDateAndTypeMap.get(string2)) == null || (string = sSyntaxDateMap.get(dateVarTypes)) == null) continue;
            arrayList.add(string);
        }
        if (arrayList.size() == 0 && (object = sSyntaxDateMap.get(ITrendsInfo.DateVarTypes.e_OBSKEY)) != null) {
            arrayList.add((String)object);
        }
        return arrayList;
    }

    public static Hashtable<ITrendsInfo.DateVarTypes, String> getDateVariableSyntax() {
        LocallyUniqueId locallyUniqueId = DataMgr.getDataMgr().getActiveDocumentId();
        ISpssDataSrc iSpssDataSrc = DataMgr.getDataMgr().getDataSource(locallyUniqueId);
        ITrendsInfo iTrendsInfo = iSpssDataSrc.getTrendsInfo();
        Hashtable<ITrendsInfo.DateVarTypes, String> hashtable = new Hashtable<ITrendsInfo.DateVarTypes, String>(3);
        Vector<ITrendsInfo.DateVarTypes> vector = new Vector<ITrendsInfo.DateVarTypes>();
        int n = iTrendsInfo.getNDateVars();
        for (int i = 0; i < n; ++i) {
            ITrendsInfo.DateVarTypes object = iTrendsInfo.getDateVarType(i);
            vector.add(object);
        }
        if (vector.size() == 0) {
            hashtable.put(ITrendsInfo.DateVarTypes.e_NONE, "Observation");
        } else {
            for (String string : sOrderedDateTypes) {
                ITrendsInfo.DateVarTypes dateVarTypes = sDateAndTypeMap.get(string);
                if (!vector.contains(dateVarTypes)) continue;
                hashtable.put(dateVarTypes, sSyntaxDateMap.get(dateVarTypes));
            }
        }
        return hashtable;
    }

    public static List<Integer> getPeriodicity(SrcVariableList srcVariableList) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (String string : sOrderedDateTypes) {
            ISpssVariable iSpssVariable = DateFactory.getVarListVar(srcVariableList, string);
            if (iSpssVariable == null) continue;
            String string2 = iSpssVariable.getLabel();
            if (string2.indexOf(NOT_PERIODIC) == -1 && string2.indexOf(PERIOD) != -1) {
                int n = string2.indexOf(PERIOD);
                arrayList.add(Integer.parseInt(string2.substring(n + 6, string2.length()).trim()));
                continue;
            }
            arrayList.add(0);
        }
        if (arrayList.size() == 0) {
            arrayList.add(0);
        }
        return arrayList;
    }

    public static DatePanel getPanel(SrcVariableList srcVariableList) {
        List<String> list = DateFactory.getDateVariableLabels(srcVariableList);
        int n = list.size();
        DatePanel datePanel = new DatePanel(n, list);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        int n2 = DialogUtil.getComponentGroupGap();
        Insets insets = DialogUtil.getStandardControlInsets();
        Insets insets2 = new Insets(0, n2, insets.right, insets.right);
        IntTextField[] intTextFieldArray = datePanel.getFields();
        JLabel[] jLabelArray = datePanel.getLabels();
        for (int i = 0; i < jLabelArray.length; ++i) {
            jLabelArray[i].setText(list.get(i));
            jLabelArray[i].setEnabled(false);
            intTextFieldArray[i].setColumns(4);
            int n3 = 24;
            insets2.left = n2;
            DialogUtil.addUsingGBL(datePanel, jLabelArray[i], gridBagConstraints, 0, i, 1, 1, n3, insets2);
            insets2.left = insets.left;
            n3 = 23;
            DialogUtil.addUsingGBL(datePanel, (JComponent)intTextFieldArray[i], gridBagConstraints, 1, i, 1, 1, n3, insets2);
        }
        return datePanel;
    }

    public static boolean hasDateFormatChanged(DialogDataModel dialogDataModel, String string, SrcVariableList srcVariableList) {
        boolean bl = false;
        Object[] objectArray = dialogDataModel.getArray(string);
        if (objectArray != null) {
            List<String> list = DateFactory.getDateVariableNames(srcVariableList);
            if (objectArray.length == list.size()) {
                for (int i = 0; !bl && i < objectArray.length; ++i) {
                    if (list.get(i).equals(objectArray[i].toString())) continue;
                    bl = true;
                }
            } else {
                bl = true;
            }
        } else {
            bl = true;
        }
        return bl;
    }

    private static ISpssVariable getVarListVar(SrcVariableList srcVariableList, String string) {
        VarListModel varListModel = srcVariableList.getModel();
        for (int i = 0; i < varListModel.getSize(); ++i) {
            ISpssVariable iSpssVariable = varListModel.getElementAt(i);
            if (!iSpssVariable.getName().toUpperCase().equals(string)) continue;
            return iSpssVariable;
        }
        return null;
    }

    private static boolean varListContains(SrcVariableList srcVariableList, String string) {
        VarListModel varListModel = srcVariableList.getModel();
        for (int i = 0; i < varListModel.getSize(); ++i) {
            ISpssVariable iSpssVariable = varListModel.getElementAt(i);
            if (!iSpssVariable.getName().toUpperCase().equals(string)) continue;
            return true;
        }
        return false;
    }

    private static void initDateMaps() {
        sDateMap = new HashMap();
        sDateMap.put("CYCLE_", "IDS_CYCLE");
        sDateMap.put("YEAR_", "IDS_YEARS");
        sDateMap.put("QUARTER_", "IDS_QUARTERS");
        sDateMap.put("MONTH_", "IDS_MONTHS");
        sDateMap.put("DAY_", "IDS_DAYS");
        sDateMap.put("WEEK_", "IDS_WEEKS");
        sDateMap.put("HOUR_", "IDS_HOURS");
        sDateMap.put("MINUTE_", "IDS_MINUTES");
        sDateMap.put("SECOND_", "IDS_SECONDS");
        sDateMap.put("OBS_", "IDS_OBSERVATIONS");
        sOrderedDateTypes = new Vector();
        sOrderedDateTypes.add("CYCLE_");
        sOrderedDateTypes.add("YEAR_");
        sOrderedDateTypes.add("QUARTER_");
        sOrderedDateTypes.add("MONTH_");
        sOrderedDateTypes.add("DAY_");
        sOrderedDateTypes.add("WEEK_");
        sOrderedDateTypes.add("HOUR_");
        sOrderedDateTypes.add("MINUTE_");
        sOrderedDateTypes.add("SECOND_");
        sOrderedDateTypes.add("OBS_");
        sSyntaxDateMap = new EnumMap(ITrendsInfo.DateVarTypes.class);
        sSyntaxDateMap.put(ITrendsInfo.DateVarTypes.e_CYCKEY, "Cycle");
        sSyntaxDateMap.put(ITrendsInfo.DateVarTypes.e_YRKEY, "Year");
        sSyntaxDateMap.put(ITrendsInfo.DateVarTypes.e_QTRKEY, "Quarter");
        sSyntaxDateMap.put(ITrendsInfo.DateVarTypes.e_MONKEY, "Month");
        sSyntaxDateMap.put(ITrendsInfo.DateVarTypes.e_DAYKEY, "Day");
        sSyntaxDateMap.put(ITrendsInfo.DateVarTypes.e_WKKEY, "Week");
        sSyntaxDateMap.put(ITrendsInfo.DateVarTypes.e_HRKEY, "Hour");
        sSyntaxDateMap.put(ITrendsInfo.DateVarTypes.e_MINKEY, "Minute");
        sSyntaxDateMap.put(ITrendsInfo.DateVarTypes.e_SECKEY, "Second");
        sSyntaxDateMap.put(ITrendsInfo.DateVarTypes.e_OBSKEY, "Observation");
        sDateAndTypeMap = new Hashtable();
        sDateAndTypeMap.put("CYCLE_", ITrendsInfo.DateVarTypes.e_CYCKEY);
        sDateAndTypeMap.put("YEAR_", ITrendsInfo.DateVarTypes.e_YRKEY);
        sDateAndTypeMap.put("QUARTER_", ITrendsInfo.DateVarTypes.e_QTRKEY);
        sDateAndTypeMap.put("MONTH_", ITrendsInfo.DateVarTypes.e_MONKEY);
        sDateAndTypeMap.put("DAY_", ITrendsInfo.DateVarTypes.e_DAYKEY);
        sDateAndTypeMap.put("WEEK_", ITrendsInfo.DateVarTypes.e_WKKEY);
        sDateAndTypeMap.put("HOUR_", ITrendsInfo.DateVarTypes.e_HRKEY);
        sDateAndTypeMap.put("MINUTE_", ITrendsInfo.DateVarTypes.e_MINKEY);
        sDateAndTypeMap.put("SECOND_", ITrendsInfo.DateVarTypes.e_SECKEY);
        sDateAndTypeMap.put("OBS_", ITrendsInfo.DateVarTypes.e_OBSKEY);
    }

    public static int getPeriodMinVal(ITrendsInfo.DateVarTypes dateVarTypes) {
        int n = 0;
        switch (dateVarTypes) {
            case e_CYCKEY: 
            case e_DATKEY: 
            case e_DAYKEY: 
            case e_MONKEY: 
            case e_NONE: 
            case e_OBSKEY: 
            case e_QTRKEY: 
            case e_WKKEY: 
            case e_YRKEY: {
                n = 1;
                break;
            }
            case e_HRKEY: 
            case e_MINKEY: 
            case e_SECKEY: {
                n = 0;
            }
        }
        return n;
    }

    static {
        sResourceBundle = ResUtil.getBundle(CommonDlgResBundle.getDefaultResourceBundleName(), ResUtil.getLocale());
        DateFactory.initDateMaps();
    }

    public static class DatePanel
    extends JPanel {
        IntTextField[] mFields;
        JLabel[] mLabels;

        public DatePanel(int n, List<String> list) {
            super(new GridBagLayout());
            this.mFields = new IntTextField[n];
            this.mLabels = new JLabel[n];
            if (n == 1 && list.contains(ResUtil.getString(sResourceBundle, "IDS_OBSERVATIONS"))) {
                this.mFields[0] = new IntTextField(1, 999999999);
                this.mLabels[0] = new JLabel();
            } else {
                for (int i = 0; i < n; ++i) {
                    if (list.get(i).equals(ResUtil.getString(sResourceBundle, "IDS_HOURS")) || list.get(i).equals(ResUtil.getString(sResourceBundle, "IDS_MINUTES")) || list.get(i).equals(ResUtil.getString(sResourceBundle, "IDS_SECONDS"))) {
                        this.mFields[i] = new IntTextField(0, 9999);
                        this.mLabels[i] = new JLabel();
                        continue;
                    }
                    this.mFields[i] = new IntTextField(1, 9999);
                    this.mLabels[i] = new JLabel();
                }
            }
        }

        public IntTextField[] getFields() {
            return this.mFields;
        }

        public JLabel[] getLabels() {
            return this.mLabels;
        }

        public List<Integer> getValues() {
            int n = this.getFields().length;
            ArrayList<Integer> arrayList = new ArrayList<Integer>();
            for (int i = 0; i < n; ++i) {
                arrayList.add(Integer.parseInt(this.getFields()[i].getText()));
            }
            return arrayList;
        }

        public void loadState(DialogDataModel dialogDataModel, String string) {
            Object[] objectArray = dialogDataModel.getArray(string);
            if (objectArray != null) {
                for (int i = 0; i < objectArray.length; ++i) {
                    this.mFields[i].setText(objectArray[i].toString());
                }
            }
        }

        public void saveState(DialogDataModel dialogDataModel, String string, String string2, SrcVariableList srcVariableList) {
            int n = this.mFields.length;
            Object[] objectArray = new String[n];
            for (int i = 0; i < n; ++i) {
                objectArray[i] = this.mFields[i].getText();
            }
            dialogDataModel.putArray(string, objectArray);
            dialogDataModel.putArray(string2, DateFactory.getDateVariableNames(srcVariableList).toArray());
        }
    }
}

