/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.controls;

import com.spss.java_client.core.common.LocallyUniqueId;
import com.spss.java_client.core.documents.data.DataMgr;
import com.spss.java_client.core.documents.data.dictionary.ISpssDataSrc;
import com.spss.java_client.core.documents.data.dictionary.ISpssVariable;
import com.spss.java_client.ui.controls.SpssVarFormatter;
import com.spss.java_client.ui.controls.VarListModel;
import com.spss.java_client.ui.dialogs.common.ProcedureDlgMgr;
import java.util.Iterator;
import java.util.Set;

public class CustomVarListModel
extends VarListModel {
    protected SpssVarFormatter mVarFormatter;

    public CustomVarListModel(SpssVarFormatter spssVarFormatter) {
        super(spssVarFormatter.getVarList());
        this.mVarFormatter = spssVarFormatter;
    }

    @Override
    public ISpssVariable removeElementAt(int n) {
        if (n < 0 || n >= this.mVariables.size()) {
            throw new ArrayIndexOutOfBoundsException(n);
        }
        ISpssVariable iSpssVariable = (ISpssVariable)this.mVariables.get(n);
        if (this.mVariables.indexOf(iSpssVariable) == n && this.mVariables.indexOf(iSpssVariable, n + 1) == -1) {
            this.mVarFormatter.getVarMap().remove(iSpssVariable.getId().asInt());
        }
        return super.removeElementAt(n);
    }

    @Override
    public boolean removeElement(ISpssVariable iSpssVariable) {
        int n = this.mVariables.indexOf(iSpssVariable);
        if (n != -1) {
            this.mVarFormatter.getVarMap().remove(iSpssVariable.getId().asInt());
        }
        return super.removeElement(iSpssVariable);
    }

    public void updateModel() {
        LocallyUniqueId locallyUniqueId = ProcedureDlgMgr.getMgr().getActiveDatasetId();
        ISpssDataSrc iSpssDataSrc = DataMgr.getDataMgr().getDataSource(locallyUniqueId);
        if (iSpssDataSrc == null) {
            return;
        }
        Set<Integer> set = this.mVarFormatter.getVarMap().keySet();
        Iterator<Integer> iterator = set.iterator();
        int n = -1;
        while (iterator.hasNext()) {
            n = iSpssDataSrc.findVarIndex(new LocallyUniqueId(iterator.next().intValue()));
            if (n <= -1) continue;
            ISpssVariable iSpssVariable = iSpssDataSrc.getVariable(n);
            try {
                iSpssVariable = iSpssVariable.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                cloneNotSupportedException.printStackTrace();
            }
            super.addElement(iSpssVariable, false);
        }
    }
}

